<?php
/**
 * ClearPoints Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     ClearPoints Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * ClearPoints
 *
 * @desc Display a clickable image that will clear all points from map
 */
class ClearPoints extends CWCWidget
{

    /**
     * ClearPoints
     *
     * Constructor for the ClearPointsWidget
     */
    function ClearPoints( )
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ClearPoints widget allows the user to clear all user created points
and refresh the current page without performing any other navigation.
EOT;

        $this->moButton = new CWCButton($this);
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick( "clickClearPoints" );
    }
    
    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }
    /**
     * ParseURL
     *
     * Look for the CLEAR_POINTS command and if found clear all
     * user created points.
     */
    function  ParseURL()
    {
        parent::ParseURL();

        if ($this->isVarSet("CLEAR_POINTS") && 
            $this->getVar("CLEAR_POINTS") == "1")
        {
            $oMap = $this->moMapObject->oMap;

            // First step, clearr all point from shape file
            if (file_exists($_SESSION['gszTmpPath'].session_id().".dbf"))
            {
                unlink($_SESSION['gszTmpPath'].session_id().".dbf");
            }

            // Then, clear point layer from current map file
            $oLayer = @$oMap->getlayerbyname("cwc_tmp_point");
  
            if ($oLayer !== false)
            {
                $oLayer->set("status", MS_DELETE);

                $_SESSION["gszCurrentState"] = $this->moMapObject->saveState();
            }
            // Then, clear point layer from current map file
            $oLayer = @$oMap->getlayerbyname("cwc_tmp_line");
  
            if ($oLayer !== false)
            {
                $oLayer->set("status", MS_DELETE);

                $_SESSION["gszCurrentState"] = $this->moMapObject->saveState();
            }
            
        }
        
        // return success
        return true;
    }

    /**
     * GetHTMLHiddenVariables
     *
     * Return HTML hidden variables.
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szVariable = "CLEAR_POINTS";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"0\">";
        $aReturn[$szVariable] = $szValue;
        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Return the Javacriptfunctions needed by the widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $szJsFunctionName = "clickClearPoints";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the user clicks the ClearPoints icon
 */
function {$szJsFunctionName}()
{
    {$this->mszHTMLForm}.CLEAR_POINTS.value = "1";
    {$this->mszHTMLForm}.submit();
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- ClearPoints widget hidden -->";
        return $this->moButton->DrawPublish();
    }
}
?>
