<?php
/**
 * CatalogSearch Widget Class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     Display a catalog search dialog box.
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");
include_once(dirname(__FILE__)."/../Label.php");
/**
 * CatalogSearch
 *
 * Display a widget that pops up a projection selection widget.
 */
class CatalogSearch extends CWCWidget
{
    var $moButton;
    var $moPopup;
    var $moLabel;

    var $mszLink = "/widgets/CatalogSearch/CatalogSearch.phtml";
    var $mszParam = "&szCallbackFunc=catalogSearchCB";

    /**
     * CatalogSearch
     *
     * Constctor method for the CatalogSearchWidget
     */
    function CatalogSearch()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The catalog search width allows a user to search a catalog of WMS layers
based on an entered keyword and select one or more layers from the results
to add to the current context.
EOT;

        $this->moButton = new CWCButton( $this );

        $this->moPopup = new CWCPopup( $this );

        $this->moLabel = new CWCLabel( $this );
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick("clickCatalogSearch");
        $this->moPopup->mszLink = $this->mszLink;
        $this->moPopup->mszParam = $this->mszParam;
        $this->moPopup->InitDefaults();
    }

    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }
    
    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/CatalogSearch/CatalogSearchPopup.phtml?";
        $szJsFunctionName = "clickCatalogSearch";

        $this->moPopup->mszParam .= (($this->getValue("EMBEDED", 0) == 0) ? "" : "&bSearch=1&szSearchString='+{$this->mszHTMLForm}.szSearchString.value+'");

        $szButtonJS = $this->moPopup->DrawPublish();

        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a Projection Selector dialog
 */
function {$szJsFunctionName}()
{
    {$szButtonJS}
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "catalogSearchCB";
        $szFunction = <<<EOF

function {$szJsFunctionName}(actionID, wh)
{
    if (actionID == 0)
    {
        // Here we should handle the load mapcontext
        {$this->mszHTMLForm}.LAYER_TITLE.value = wh.LayerTitle;
        {$this->mszHTMLForm}.LAYER_ALT_TITLE.value = wh.LayerAltTitle;
        {$this->mszHTMLForm}.LAYER_SERVER_VERSION.value = wh.LayerServerVersion;
        {$this->mszHTMLForm}.LAYER_CONNECT_STRING.value = wh.LayerConnectString;
        {$this->mszHTMLForm}.LAYER_ABSTRACT.value = wh.LayerAbstract;
        {$this->mszHTMLForm}.LAYER_LLBB.value = wh.LayerLLBB;
        {$this->mszHTMLForm}.LAYER_STYLES.value = wh.LayerStyles;
        {$this->mszHTMLForm}.LAYER_FORMATS.value = wh.LayerFormats;
        {$this->mszHTMLForm}.LAYER_SRSS.value = wh.LayerSRSs;

        wh.close();
        {$this->mszHTMLForm}.submit();
    }
    else
    if (actionID == 1) // apply
    {
        // Here we should handle the load mapcontext
        {$this->mszHTMLForm}.LAYER_TITLE.value = wh.LayerTitle;
        {$this->mszHTMLForm}.LAYER_ALT_TITLE.value = wh.LayerAltTitle;
        {$this->mszHTMLForm}.LAYER_SERVER_VERSION.value = wh.LayerServerVersion;
        {$this->mszHTMLForm}.LAYER_CONNECT_STRING.value = wh.LayerConnectString;
        {$this->mszHTMLForm}.LAYER_ABSTRACT.value = wh.LayerAbstract;
        {$this->mszHTMLForm}.LAYER_LLBB.value = wh.LayerLLBB;
        {$this->mszHTMLForm}.LAYER_STYLES.value = wh.LayerStyles;
        {$this->mszHTMLForm}.LAYER_FORMATS.value = wh.LayerFormats;
        {$this->mszHTMLForm}.LAYER_SRSS.value = wh.LayerSRSs;

        {$this->mszHTMLForm}.submit();
    }
    if (actionID == 2) // cancel
    {
        wh.close();
    }

    return;
}

EOF;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetHTMLHiddenVariables
     *
     * Return HTML hidden variables.
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szVal = "";

        $szVariable = "LAYER_TITLE";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_ALT_TITLE";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_SERVER_VERSION";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_CONNECT_STRING";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_ABSTRACT";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_LLBB";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_STYLES";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_FORMATS";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "LAYER_SRSS";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;
        return $aReturn;
    }

    /**
     * ParseURL
     *
     */
    function  ParseURL()
    {
        $oMap = $this->moMapObject->oMap;
        
        $szOriginalExtents = trim($oMap->getMetaData( "original_extents" ));
        if ($szOriginalExtents == "")
        {
            $szOriginalExtents = $oMap->extent->minx;
            $szOriginalExtents .= ",".$oMap->extent->miny;
            $szOriginalExtents .= ",".$oMap->extent->maxx;
            $szOriginalExtents .= ",".$oMap->extent->maxy;
            $oMap->setMetaData( "original_extents", $szOriginalExtents );
        }

        if ($this->isVarSet("LAYER_ALT_TITLE") &&
            $this->getVar("LAYER_ALT_TITLE") != "")
        {
            // set the WMS layer name (replace spaces with "_")
            $szWMSName = trim($this->getVar("LAYER_ALT_TITLE") );
            $szWMSName = ereg_replace(" ", "_", $szWMSName);

            // set type
            $nWMSType = MS_LAYER_RASTER;

            // metadata item - title
            $szWMSMetaData = "wms_title=".trim( $this->getVar("LAYER_TITLE") );

            // name
            $szWMSMetaData .= "|wms_name=".trim( $this->getVar("LAYER_ALT_TITLE") );

            // metadata item - server version
            $szWMSMetaData .= "|wms_server_version=".trim( $this->getVar("LAYER_SERVER_VERSION") );

            // map url
            $szWMSMetaData .= "|wms_onlineresource=".urlencode(trim( $this->getVar("LAYER_CONNECT_STRING") ));

            // queriable fixed to false
            $szWMSMetaData .= "|wms_queriable=0";

            // check for the wms_srs metadata
            $szWMSMetaData .= "|wms_srs=".$this->getVar("LAYER_SRSS");

            // check for the wms_abstract metadata
            $szWMSMetaData .= "|wms_abstract=".str_replace("\"", "'", $this->getVar("LAYER_ABSTRACT"));

            // check for the wms_stylelist metadata
            $aszStyle = explode(">;<", $this->getVar("LAYER_STYLES"));

            $bFirst=true;
            $szStyleList = "";
            foreach ($aszStyle as $oStyle)
            {
              $aStyle = explode(">,<", $oStyle);
              $szStyleList .= $aStyle[0].",";

              if ($bFirst)
              {
                  $szWMSMetaData .= "|wms_style=".$aStyle[0];
                  $bFirst=false;
              }

              $szWMSMetaData .= "|wms_style_".$aStyle[0]."_title=".$aStyle[0];
              $szWMSMetaData .= "|wms_style_".$aStyle[0]."_legendurl=".urlencode($aStyle[1]);
            }

            $szWMSMetaData .= "|wms_stylelist=".substr($szStyleList, 0, -1);

            // check for the wms_extents metadata
            $szWMSMetaData .= "|wms_latlonboundingbox=".$this->getVar("LAYER_LLBB");

            // check for BBOX
            $szWMSMetaData .= "|wms_boundingbox=".$this->getVar("LAYER_LLBB");

            // fixed to false
            $szWMSMetaData .= "|wms_extractable=0";

            // get the mapscript and WMS versions
            $szVersion = ms_GetVersion();
            $szWMSVersion = trim( $this->getVar("LAYER_SERVER_VERSION") );

            // Find an image format recognized by both this client and the remote svr
            // First replace any commas with spaces
            $aszFormats = explode(",", trim( $this->getVar("LAYER_FORMATS") ) );
            $szFormat = "";

            // Try to match formats in this order: GIF, PNG, JPEG
            foreach( array("GIF", "PNG", "JPEG") as $szFmt)
            {
                // Does MapScript support this format?
                if (strpos($szVersion, "OUTPUT=".$szFmt) > 0)
                {
                    // Yes... so does the remote server support it as well?
                    foreach( $aszFormats as $thisFormat )
                    {
                        if ( strtoupper(trim($thisFormat)) == $szFmt ||
                             strtoupper(trim($thisFormat)) == "IMAGE/".$szFmt )
                        {
                            // Found a match!
                            $szFormat = $thisFormat;
                            break 2;  // Get out of 2 loops
                        }
                    }
                }
            }

            // metadata item - server format list
            $szWMSMetaData .= "|wms_formatlist=".trim(str_replace(" ", ",", $this->getVar("LAYER_FORMATS")));

            // metadata item - server format
            $szWMSMetaData .= "|wms_format=".$szFormat;

            // update the query string
            $szQueryLayers = "";

            // set connection string
            //printf("usrl = %s <br>", $aszLayer["URL"]);
            $szURL = trim( $this->getVar("LAYER_CONNECT_STRING") );
            $nLength = strlen( $szURL );
            if (strstr($szURL, '?') !== false)
            {
                if (substr($szURL, -1) != "?" && substr($szURL, -1) != "&")
                    $szQuestionMark = "&";
                else
                    $szQuestionMark = "";
            }
            else
                $szQuestionMark ="?";

            // build connection string
            $szConnection = $szURL.$szQuestionMark
              ."SERVICE=WMS&VERSION=".$szWMSVersion
              ."&LAYERS=".urlencode( trim( $this->getVar("LAYER_ALT_TITLE") ) )
              .$szQueryLayers
              ."&FORMAT=".$szFormat."&TRANSPARENT=TRUE";

            // only add the layer if format is set
            if ($szFormat != "")
            {
                // build an array of layerparameters
                $axParams["metadata"] =  $szWMSMetaData;
                $axParams["connectiontype"] = MS_WMS;
                $axParams["connection"] = $szConnection;

                // create the layer
                $this->addLayer( $this->moMapObject->oMap, $szWMSName, $nWMSType, $axParams, $_SESSION['gErrorManager'] );

                // get the current map projection
                $szTempMapProj = $this->moMapObject->oMap->getprojection();

                // only set the projection if it's set in the map
                if ( strlen( trim( $szTempMapProj ) ) > 0 )
                {
                    // set layer projection
                    $oLayer = $this->moMapObject->oMap->getlayerbyname( $szWMSName );
                    $oLayer->setprojection( $szTempMapProj );
                }

                $_SESSION['gszCurrentState'] = $this->moMapObject->saveState();
            }
            else
            {
              echo "Acceptable image format not found";
            }
        }
        
        // return success
        return true;
    }

/**
 * This function adds a new layer to the given mapscript map object.  The
 * layer will NOT be added if the name is already in use.
 *
 * @param $oMap object - Mapscript map object.
 * @param $szName string - New layer name.
 * @param $nType integer - The layer type.
 * @param $axParams array - Mixed associative array of optional layer
 *              properties:
 *              $axParams["status"] - layer status (default = MS_ON)
 *              $axParams["metadata"] - comma de-limited list of metadata
 *                                      items separated by "metadivider".
 *              $axParams["metadivider"] - metadata divider that separates
 *                                      metadata name from value (default = "=")
 *              $axParams["connectiontype"] - connection type
 *              $axParams["connection"] - the connection string
 *              $axParams["group"] - the group name for the layer
 *              $axParams["data"] - the data string
 *              $axParams["scalemin"] - the minimum scale for the layer
 *              $axParams["scalemax"] - the maximum scale for the layer
 *
 * @param $oLog object - The logger object to log events.
 * @return boolean - True if successful, false if not.
 **/
    function addLayer( $oMap, $szName, $nType, $axParams, $oErrorManager )
    {
        // get an array of all layer names already present in the map
        $aszLayers = $oMap->getAllLayerNames();

        // initialize the variable
        $bLayerFound = false;

        // Check if anything was returned
        if ( is_array( $aszLayers ) )
        {
            // loop through all the layers and determine if name is found
            foreach ( $aszLayers as $szLayer )
            {
                // check for a match
                if ( strtoupper($szLayer) == strtoupper($szName) )
                {
                    // set flag
                    $bLayerFound = true;

                    // exit loop
                    break;
                }
                // end foreach
            }
        }

        // only add the layer if the layer is not already present
        if (!$bLayerFound)
        {
            // create the layer object
            $oNewLayer = ms_newLayerObj($oMap);

            // set name
            $oNewLayer->set("name",$szName);

            // set type
            $oNewLayer->set("type",$nType);

            // set status
            if ( isset( $axParams["status"] ) )
                $oNewLayer->set( "status", $axParams["status"] );
            else
                $oNewLayer->set( "status", MS_ON );

            // set group name
            if ( isset( $axParams["group"] ) )
                $oNewLayer->set( "group", $axParams["group"] );

            // set the data tag
            if ( isset( $axParams["data"] ) )
                $oNewLayer->set( "data", $axParams["data"] );

            // set the min scale
            if ( isset( $axParams["scalemin"] ) &&
                 is_numeric( $axParams["scalemin"] ) &&
                 $axParams["scalemin"] > 0 )
                $oNewLayer->set( "minscale", $axParams["scalemin"] );

            // set the max scale
            if ( isset( $axParams["scalemax"] ) &&
                 is_numeric( $axParams["scalemax"] ) &&
                 $axParams["scalemax"] >= $axParams["scalemin"] )
                $oNewLayer->set( "maxscale", $axParams["scalemax"] );

            // set metadata
            if ( isset( $axParams["metadata"] ) )
            {
                // determine the metadata divider
                if ( isset( $axParams["metadivider"] ) )
                    $sz_meta_div_str = $axParams["metadivider"];
                else
                    $sz_meta_div_str = "=";

                // create an array of metadata
                $aszMetaData1 = explode( "|", $axParams["metadata"] );

                // loop and add metadata
                foreach ($aszMetaData1 as $MetaData)
                {
                    // separate the value from the label
                    $aszMetaData2 = explode( $sz_meta_div_str, $MetaData );

                    // add
                    if (trim($aszMetaData2[0]) != "")
                        $oNewLayer->setMetaData(trim($aszMetaData2[0]),
                                            urldecode(trim($aszMetaData2[1])));
                }
            }

            // set connecttion
            if ( isset( $axParams["connectiontype"] ) )
                $oNewLayer->set( "connectiontype",$axParams["connectiontype"] );

            // set connection string
            if ( isset( $axParams["connection"] ) )
                $oNewLayer->set( "connection", $axParams["connection"] );

            // return success
            $bReturn = true;
        }
        // otherwise the layer exists
        else
        {
            // return failure
            $bReturn = false;
        }

        // return status
        return $bReturn;

        // end addLayer function
    }
/************************************************************************/
/*                               DrawPublish                            */
/*                                                                      */
/*      Return the HTML code using the name in the map file and the     */
/*      parameters of the CWC tag.                                      */
/************************************************************************/
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- Catalog Search popup widget hidden -->";


        $szResult = $this->moButton->DrawPublish();

        if ($this->getValue("EMBEDED", 0) == 1)
          $szResult .= "<INPUT TYPE='TEXT' NAME=szSearchString>";

        return $szResult;
    }
}
?>
