<?php
/**
 * handle a cache of CWC2 buttons and provide convenience functions for accessing them.
 */
include_once("session.inc.php");
include_once( COMMON."buttonizer/buttonizer.php" );

/**
 * create a button based on a graphic, a label, and some parameters.  The
 * button is cached so it is only actually created once.
 */
function makeButton( $szJSCallback, $szJSParam, $szClassName, $szGraphic, $szLabel, $szAltText, $aExtraParams = array() )
{
    $aExtraParams['graphic'] = findFile( $szGraphic );
    $aExtraParams['label'] = $szLabel;
    $szResourceName = strtoupper( $szClassName.'PopupStyleResource' );
    
    $bButtonize = false;
    if(isset($_SESSION[$szResourceName]) &&
       isset($_SESSION[$_SESSION[$szResourceName]]))
    {
        $aResource = $_SESSION[$_SESSION[$szResourceName]];
        $bButtonize = true;
    }
    if ($szJSParam == "")
        $szJSParam = "null";
    elseif ($szJSParam == "true" || $szJSParam === true)
        $szJSParam = "true";
    elseif ($szJSParam == "false" || $szJSParam === false)
        $szJSParam = "false";
    elseif (!is_numeric( $szJSParam ))
        $szJSParam = '"'.$szJSParam.'"';
 
    if ($bButtonize)
    {
        $szImageID = "b".md5($szJSCallback.$szJSParam.$szClassName.$szGraphic.$szLabel);

        $szNormalImage = 'null';
        $nNormalWidth = '';
        $nNormalHeight = '';
        if (isset($aResource['normal']))
        {
             $aResource['normal'] = array_merge( $aResource['normal'], $aExtraParams );
             $szNormalImage = '"'.GetImage( $szImageID, $aResource['normal'] ).'"';
             $nNormalWidth = $aResource['normal']['width'];
             $nNormalHeight = $aResource['normal']['height'];
        }
        $szSelectedImage = 'null';
        if (isset($aResource['selected']))
        {
             $aResource['selected'] = array_merge( $aResource['selected'], $aExtraParams );
             $szSelectedImage = '"'.GetImage( $szImageID, $aResource['selected']).'"';
        }
        $szHoverImage = 'null';
        if (isset($aResource['hover']))
        {
             $aResource['hover'] = array_merge( $aResource['hover'], $aExtraParams );
             $szHoverImage = '"'.GetImage( $szImageID, $aResource['hover']).'"';
        }
        $szDisabledImage = 'null';
        if (isset($aResource['disabled']))
        {
             $aResource['disabled'] = array_merge( $aResource['disabled'], $aExtraParams );
            $szDisabledImage = '"'.GetImage( $szImageID, $aResource['disabled']).'"';
        }


        $szReturn = <<<EOT
<img name="{$szImageID}" id="{$szImageID}" src={$szNormalImage} width="{$nNormalWidth}" height="{$nNormalHeight}" ALT="{$szAltText}" TITLE="{$szAltText}" BORDER="0">
<script language="Javascript">
goCWCButtonManager.AddButton( new CWCButton("{$szImageID}", 0, "null", $szJSCallback, $szJSParam, $szNormalImage, $szHoverImage, $szSelectedImage, $szDisabledImage) );
</script>
EOT;
    }
    else
    {
        //none-buttonized-version :)
        $szReturn = <<<EOT
<input type="button" onclick='$szJSCallback(null, $szJSParam);' value="$szLabel">
EOT;
    }
    
    return $szReturn;
}

/**
 * GetImage returns the name of an image to use for a particular resource and state
 */
function GetImage( $szImageID, $aParams )
{
        //TODO: figure out an effective caching mechanism for this?
        //using $szImageID
        
        //load platform specific behaviours
        $aParams["gd_module"] = "gd2";
        $aParams["freetype"] = "FreeType";
        
        //generate the cached image.
        $szImageFile = md5( implode( "", $aParams ) ).".png";
        
        $szImagePath = $_SESSION['gszButtonCachePath'].$szImageFile;

        $szImageWebPath = $_SESSION['gszButtonCacheWebPath'].$szImageFile;
        
        //fix relative paths if necessary
        $aPaths = array( 'graphic', 
                         'border_tl_image',
                         'border_t_image',
                         'border_tr_image',
                         'border_r_image',
                         'border_br_image',
                         'border_b_image',
                         'border_bl_image',
                         'border_l_image',
                         'backgroundimage',
                         'labelfont'
                        );
        
        foreach ($aPaths as $aPath)
            if (isset($aParams[$aPath]))
            {
                $aParams[$aPath] = findFile( $aParams[$aPath] );
            }
        //cache the URL and generate the image, if required.
        if (!isset($aParams['usecache']) || (isset($aParams['usecache']) && $aParams['usecache']))
        {
            //TODO: can we effectively cache this?
            //$_SESSION[$szCacheName] = $szImageWebPath;
            if (!is_file( $szImagePath ))
            {
                buttonize( $szImagePath, $aParams );
            }
        }
        else
        {
            buttonize( $szImagePath, $aParams );
        }
        
        return $szImageWebPath;
}

/**
 * this function attempts to locate a file in one of
 * (possibly) several locations.  If the original file
 * path is absolute, it will be returned as is.  If it
 * is relative, the it will be looked for in four possible
 * cases.
 * 
 * 1. relative to app path in skin search paths
 * 2. relative to app path
 * 3. relative to chameleon in skin search paths
 * 4. relative to chameleon
 *
 * @param szFilePath an absolute or relative path and file
 *        name to locate
 * @return an absolute path to the file or false if the file
 *         could not be found.
 */
function findFile( $szFilePath )
{
    /* case 1 - skin search path relative to app */
    foreach( array_reverse($_SESSION['gaszSkinSearchPath']) as $szPath )
    {
        $szTempPath = resolvePath2( $szFilePath, $_SESSION['gszAppPath'].'/'.$szPath."/" );
        if ($szTempPath != "" && file_exists($szTempPath))
        {
            return $szTempPath;
        }
    }

    /* case 2 - relative to app */
    $szTempPath = resolvePath2( $szFilePath, $_SESSION['gszAppPath'] );
    if ($szTempPath != "" && file_exists($szTempPath))
    {
        return $szTempPath;
    }

    /* case 3 - skin search path relative to chameleon */
    foreach( array_reverse($_SESSION['gaszSkinSearchPath']) as $szPath )
    {
        $szTempPath = resolvePath2( $szFilePath, $_SESSION['gszCorePath'].'/'.$szPath.'/' );
        if ($szTempPath != "" && file_exists($szTempPath))
        {
            return $szTempPath;
        }
    }

    /* case 4 - relative to chameleon */
    $szTempPath = resolvePath2( $szFilePath, $_SESSION['gszCorePath'] );
    if ($szTempPath != "" && file_exists($szTempPath))
    {
        return $szTempPath;
    }

    return false;
}

function fileSystemToURL( $szFileSystemPath )
{
    if (strncmp( $szFileSystemPath, $_SESSION['gszAppPath'], strlen($_SESSION['gszAppPath']) ) == 0)
        return $_SESSION['gszAppWebPath'].'/'.substr( $szFileSystemPath, strlen($_SESSION['gszAppPath']));

    if (strncmp( $szFileSystemPath, $_SESSION['gszCorePath'], strlen($_SESSION['gszCorePath']) ) == 0)
        return $_SESSION['gszCoreWebPath'].'/'.substr($szFileSystemPath,strlen($_SESSION['gszCorePath']));

    return $szFileSystemPath;
}

/**
 * this function determines if a path represents an absolute path and returns
 * true if it is, and false if it is not
 * @param szPath the path to test
 * @result boolean, true if the path is absolute, false otherwise
 */
function isAbsolutePath( $szPath )
{
    if ($szPath == "") return false;
    if ($szDestPath[0] == "/" || preg_match('/^(\w:)/', $szDestPath)) 
    {
        return true;
    }
    else
    {
        return false;
    }
}

/**
 * This function translate $szDestPath (relative or absolute)
 * to a absolute path based on $szOrigPath.
 *
 * @param $szDestPath Destination path to translate
 * @param $szOrigPath Refenrece path
 */
function resolvePath2 ($szDestPath, $szOrigPath)
{
    // If one or other path is missing or absolute, return it.
    if ($szDestPath == "") return $szOrigPath;
    if ($szOrigPath == "") return $szDestPath;
    if ($szDestPath[0] == "/" || preg_match('/^(\w:)/', $szDestPath))
    {
        return $szDestPath;
    }

    // If windows prefix (eg: c:) get it
    $szPrefix = "";
    if ($szOrigPath[0] != "/")
    {
        if (preg_match('/^(\w:)(.*)/i', $szOrigPath, $aMatch))
        {
            $szPrefix = $aMatch[1];
            $szOrigPath = $aMatch[2];
        }
        else
        {
            $szOrigPath = "/".$szOrigPath;
        }
    }

    // Make sure path finishing with "/"
    if ($szOrigPath[strlen($szOrigPath)-1] != "/" &&
        !is_dir($szOrigPath))
        $szOrigPath = dirname($szOrigPath)."/";
    if ($szOrigPath[strlen($szOrigPath)-1] != "/")
        $szOrigPath = $szOrigPath."/";

    $szPath = $szOrigPath.$szDestPath;

    // Remove repetitive "/"
    $szPath = ereg_replace ("/+", "/", $szPath);

    $szPath = iterate_ereg_replace ("/\./", "/", $szPath);
    $szPath = iterate_ereg_replace ("/[^(/|\.)]+/\.\./", "/", $szPath);

    //Rest of the function
    return $szPrefix.$szPath;
}

/**
 * Recursive ereg_replace
 */
function iterate_ereg_replace ( $szPattern, $szReplacement, $szString)
{
    $szResult = $szString;
    do
    {
        $szString = $szResult;
        $szResult = ereg_replace ($szPattern, $szReplacement, $szString);
    }
    while ($szResult != $szString);

    return $szResult;
}

?>
