<?php
/**
 * BoundingBoxPopup Widget Class
 *
 * @project     CWC2
 * @revision    $Id: BoundingBoxPopup.widget.php,v 1.6 2004/07/08 17:49:06 pspencer Exp $
 * @purpose     Display a dialog box to type in coordinates to zoom to
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");
include_once ( COMMON."wrapper/map_navigator.php" );

/**
 * BoundingBoxPopup
 *
 * @desc Display a widget that pops up a projection selection widget.
 */
class BoundingBoxPopup extends CWCWidget
{
    var $moButton;
    var $moPopup;
    var $moMapNavigator;

    /**
     * BoundingBoxPopup
     *
     * Constctor method for the BoundingBoxPopup
     */
    function BoundingBoxPopup()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/BoundingBoxPopup.dbf";
        parent::CWCWidget();

        $this->moButton = new CWCButton( $this );
        
        $this->moPopup = new CWCPopup( $this );
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/BoundingBoxPopup/BoundingBoxPopup.phtml";

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The BoundingBoxPopupWidget displays a popup dialog box that allows the user
to enter bounding box coordinates to zoom to (either rectangle or point)
EOT;

    }

    function InitDefaults()
    {
        parent::InitDefaults();
        
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('clickBoundingBoxPopup');
    }

    /**
     * SetMap
     *
     * Set the map session and create a navigation tool.
     */
    function SetMap($oMapSession)
    {
        $this->moMapObject = $oMapSession;

        $this->moMapNavigator = new MapNavigator( $oMapSession );
    }


    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    /**
     * GetHTMLHiddenVariables
     *
     * return the NAV_CMD varaiable.
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szCmd = '';
        if ($this->isVarSet('NAV_CMD'))
            $szCmd = $this->getVar('NAV_CMD');
        $szVariable = "NAV_CMD";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "NAV_INPUT_TYPE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "NAV_INPUT_COORDINATES";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "NAV_INPUT_SRS";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * ParseURL
     *
     * Look for the COMPASS_POINT command and if found, recenter
     * the image in the appropriate direction.
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        $szCmd = "";
        if ($this->isVarSet("NAV_CMD"))
            $szCmd = $this->getVar("NAV_CMD");

        if ($szCmd == "ZOOM_BBOX")
        {
            //process navigation here
            $szInputCoords = "";
            $szInputCoords = $this->getVar("NAV_INPUT_COORDINATES");
            $szInputType = $this->getVar("NAV_INPUT_TYPE");

            if(strlen($szInputCoords) <= 0)
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                   trim($this->moMLT->get("7", "ERROR: No input coordinates specified in BoundingBoxPopup.php.")));
                return;
            }
            if (strlen($szInputType) <= 0)
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                  trim($this->moMLT->get("8", "ERROR: No input type specified in BoundingBoxPopup.php.")));
                return;
            }
            
            $aPixPos = explode(",", $szInputCoords);
            
            $szSRS = '';
            if ($this->isVarSet('NAV_INPUT_SRS') && $this->getVar('NAV_INPUT_SRS') != "")
            {
                $szSRS = trim($this->getVar('NAV_INPUT_SRS'));
                if (strcasecmp( substr( $szSRS, 0, 4 ), 'epsg') == 0)
                {
                    $szSRS = "init=".strtolower($szSRS);
                }
                echo "here: ".$szSRS."<BR>";
                $oProjIn = ms_newProjectionObj( $szSRS );
                $oProjOut = ms_newProjectionObj( $this->moMapObject->oMap->getProjection() );
                if ($szInputType == "POINT")
                {
                    $oPoint = ms_newPointObj();
                    $oPoint->setXY( $aPixPos[0], $aPixPos[1] );
                    $oPoint->project( $oProjIn, $oProjOut );
                    $aPixPos[0] = $oPoint->x;
                    $aPixPos[1] = $oPoint->y;
                }
                else
                {
                    $oRect = ms_newRectObj();
                    $oRect->setExtent( $aPixPos[0], $aPixPos[1], $aPixPos[2], $aPixPos[3] );
                    $oRect->project( $oProjIn, $oProjOut );
                    $aPixPos[0] = $oRect->minx;
                    $aPixPos[1] = $oRect->miny;
                    $aPixPos[2] = $oRect->maxx;
                    $aPixPos[3] = $oRect->maxy;
                }
            }

            if ($szInputType == "POINT")
            {
              //echo "zooming to ".$aPixPos[0].",". $aPixPos[1]."<BR>";
                $oRect = $this->moMapObject->oMap->extent;
                $nX = $oRect->minx + ($oRect->maxx - $oRect->minx)/2;
                $nY = $oRect->miny + ($oRect->maxy - $oRect->miny)/2;
                $nOffX = $aPixPos[0] - $nX;
                $nOffY = $aPixPos[1] - $nY;
                
                $this->moMapObject->oMap->setextent( $oRect->minx + $nOffX,
                                                     $oRect->miny + $nOffY,
                                                     $oRect->maxx + $nOffX,
                                                     $oRect->maxy + $nOffY );
            }
            else
            {
                $this->moMapObject->oMap->setextent( $aPixPos[0], $aPixPos[1], $aPixPos[2], $aPixPos[3] );
            }
/* -------------------------------------------------------------------- */
/*      Call the reporjectauto function in case the map projection      */
/*      is set to AUTO:XXX. If it is not, the function will do          */
/*      nothing.                                                        */
/* -------------------------------------------------------------------- */
            $this->ReprojectAuto();

        }
        
        // return success
        return true;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $aReturn = $this->moButton->GetJavascriptFunctions();//array();
        $szJsFunctionName = "clickBoundingBoxPopup";
        $szButtonJS = $this->moPopup->DrawPublish();
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a Bounding Box dialog
 */
function {$szJsFunctionName}()
{
    {$szButtonJS}
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "applyBoundingBox";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a Bounding Box dialog
 */
function {$szJsFunctionName}(nMinX, nMinY, nMaxX, nMaxY)
{
    szCoords = "" + nMinX + "," + nMinY;
    if (nMaxX != "" && nMaxY != "")
    {
        szType = "RECTANGLE";
        szCoords = szCoords + "," + nMaxX + "," + nMaxY;
    }
    else
    {
        szType = "POINT";
    }
    {$this->mszHTMLForm}.NAV_CMD.value="ZOOM_BBOX";
    {$this->mszHTMLForm}.NAV_INPUT_TYPE.value=szType;
    {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value=szCoords;
    
    if (arguments.length == 5)
    {
        {$this->mszHTMLForm}.NAV_INPUT_SRS.value=arguments[4];    
    }

    if ({$bCWCJSAPI})
    {
        goCWCJSAPI.NAV_CMD="ZOOM_BBOX";
        goCWCJSAPI.NAV_INPUT_TYPE = szType;
        goCWCJSAPI.NAV_INPUT_COORDINATES=szCoords;
        if (arguments.length == 5)
        {
            goCWCJSAPI.NAV_INPUT_SRS=arguments[4];
        }
        goCWCJSAPI.UpdateNavTools();
    }
    else
    {
        {$this->mszHTMLForm}.submit();
    }
     return;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        if (is_object($this->moMapObject))
        {
            $nPixWidth = $this->moMapObject->oMap->width;
            $nGeoWidth = $this->moMapObject->oMap->extent->minx -
                         $this->moMapObject->oMap->extent->maxx;

            $nPixelWidth = abs($nPixWidth / $nGeoWidth);

            if ($nPixelWidth > 1)
                $nNbDecimal = abs(log($nPixelWidth))/log(10)+1;
            else
                $nNbDecimal = 0;

            $nMinX = number_format($this->moMapObject->oMap->extent->minx, $nNbDecimal, ".", "");
            $nMinY = number_format($this->moMapObject->oMap->extent->miny, $nNbDecimal, ".", "");
            $nMaxX = number_format($this->moMapObject->oMap->extent->maxx, $nNbDecimal, ".", "");
            $nMaxY = number_format($this->moMapObject->oMap->extent->maxy, $nNbDecimal, ".", "");
        }
        else
        {
            $nMinX = 0;
            $nMinY = 0;
            $nMaxX = 1;
            $nMaxY = 1;
        }

        $szJsFunctionName = "getMapExtents";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * return the current extents as an array (minx, miny, maxx, maxy)
 */
function {$szJsFunctionName}()
{
    return new Array( {$nMinX}, {$nMinY}, {$nMaxX}, {$nMaxY} );
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- BoundingBox popup widget hidden -->";
        
        $szResult = $this->moButton->DrawPublish();

        return $szResult;
    }
}
?>
