<?php
/******************************************************************************
 * $Id: treemenu.php,v 1.47 2003/06/18 02:18:50 pspencer Exp $
 *
 * File:    treemenu.php
 * Project: NHSI Public Health Map Generator
 * Purpose: generic HTML tree menu
 * Author:  Paul Spencer, spencer@dmsolutions.ca
 *
 ******************************************************************************
 * Copyright (c) 2001, DM Solutions Group Inc
 *
 * Original release information:
 */
  /*********************************************/
  /*  PHP TreeMenu 1.1                         */
  /*                                           */
  /*  Author: Bjorge Dijkstra                  */
  /*  email : bjorge@gmx.net                   */
  /*                                           */
  /*  Placed in Public Domain                  */
  /*                                           */
  /* - Multiple root node fix by Dan Howard    */
  /*                                           */
  /*********************************************/
/*
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 *****************************************************************************/

/******************************************************************************
 *
 * Using the treemenu.
 *
 * treemenu displays a tree menu using standard html and maintains the state
 * of the various nodes through the use of http get variables. Treemenu
 * requires several components in order to work.  First, it is driven by a
 * treemenu file that describes each of the nodes.  The file contains one line
 * per node with each line formatted as follows:
 *
 *   <level>|<node image>|<node text>|<node link>|<node target>
 *
 *   - level is a series of periods (.) that indicate the level
 *   of the current node.
 *   - node image is a path to an image file to display for the node
 *   - node text is the text displayed for the node
 *   - node link is an optional hyperlink for the node text
 *   - node target is an optional target for the hyperlink
 *   - Node prog id is optional. Used by security services.
 *
 *
 *
 *****************************************************************************/

/**
 * Check for a defined COMMON variable containing the absolute path.  If not
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON )- 1, 1 ) == "/" )
        include_once( COMMON."logger/logger.php");
    else
        include_once( COMMON."/logger/logger.php");
}
elseif (file_exists("../logger/logger.php"))
{
    include_once("../logger/logger.php");
}
else
{
    include_once("./logger/logger.php");
}

/*
 * Defines for treemenu mandatory images
 */
define("img_error", 0);
define("img_expand_split", 1);
define("img_collapse_split", 2);
define("img_expand_end", 3);
define("img_collapse_end", 4);
define("img_line", 5);
define("img_split", 6);
define("img_end", 7);
define("img_spc", 8);


/**
 * This class manage images used byt tree menu class.
 * There is no need to define this object when creating
 * TreeMenu object. TreeMenu class create one by default
 * with default values.
 */
class TreeMenuImages extends Logger
{
    var $m_aszImages;
    var $m_nWidth, $m_nHeight;
    var $m_szBasePath;

    /**
     * Tree menu images constructor. Called by TreeMenu or by user.
     *
     * @param $nWidth  - Width used when generating IMG tag.
     * @param $nHeight - Height used when generating IMG tag.
     *
     * @return true if of or false if, for example, a default image dont exist.
     **/
    function TreeMenuImages($nWidth=20, $nHeight=20, $szBasePath="")
    {
        //init logging context
        $this->Logger( "TreeMenuImages" );

    if ($szBasePath == "")
      $szBasePath = dirname($_SERVER['PHP_SELF']);

/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "TreeMenuImages($nWidth, $nHeight) called."); #STRIPED_LOG# */

        $this->m_aszImages = array();
        $this->m_nWidth = $nWidth;
        $this->m_nHeight= $nHeight;
    $this->m_szBasePath = $szBasePath;

        //this will be collapsed into a class
        // use small icons
        $this->m_aszImages[img_error] = "$szBasePath/images/error.gif";
        $res1 = $this->set(img_error, "$szBasePath/images/error.gif");
        $res2 = $this->set(img_expand_split, "$szBasePath/images/tree_plus_split.gif");
        $res3 = $this->set(img_collapse_split, "$szBasePath/images/tree_minus_split.gif");
        $res4 = $this->set(img_expand_end, "$szBasePath/images/tree_plus_end.gif");
        $res5 = $this->set(img_collapse_end, "$szBasePath/images/tree_minus_end.gif");
        $res6 = $this->set(img_line, "$szBasePath/images/tree_line.gif");
        $res7 = $this->set(img_split, "$szBasePath/images/tree_split.gif");
        $res8 = $this->set(img_end, "$szBasePath/images/tree_end.gif");
        $res9 = $this->set(img_spc, "$szBasePath/images/tree_space.gif");

        if ($res1 && $res2 && $res3 && $res4 && $res5 &&
            $res6 && $res7 && $res8 && $res9)
          $res = true;
        else
          $res = false;

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_VERBOSE, "TreeMenuImages() returning."); #STRIPED_LOG# */

        return $res;
    }

    /**
     * This function set a full image path into m_aszImages
     * at nImageIndex position.
     *
     * @param $nImageIndex     - Full image path index position.
     * @param $szFullImagePath - Full Image path to set.
     *
     * @return true.
     **/
    function set($nImageIndex, $szFullImagePath)
    {
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "set($nImageIndex, $szFullImagePath) called."); #STRIPED_LOG# */

        $this->m_aszImages[$nImageIndex] = $szFullImagePath;
        $res = true;

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_VERBOSE, "set() returning $res."); #STRIPED_LOG# */

        return $res;
    }

    /**
     * This function return a HTML img tag from nImageIndex.
     *
     * @param $nImageIndex - Full image path index position.
     *
     * @return the pre formated HTML IMG tag.
     **/
    function imgTag($nImageIndex)
    {
        $szImageTag = "<IMG SRC=\"".$this->m_aszImages[$nImageIndex]."\"";
        $szImageTag .=" TITLE=\"\""; //".$this->m_aszImages[$nImageIndex]."\"";
        $szImageTag .=" ALT=\"\" BORDER=\"0\""; //.$this->m_aszImages[$nImageIndex]."\" BORDER=\"0\"";
        $szImageTag .=" WIDTH=\"".$this->m_nWidth."\" HEIGHT=\"".$this->m_nHeight."\">";

        return $szImageTag;
    }
}

/**
 * This class represent a node in the main treeMenu object.
 * Each nodes had their own propertys and can be controled
 * individualy.
 */
class TreeMenuNode extends Logger
{
    var $m_bExpand;
    var $m_bVisible;

    var $m_nTreeLevel;
    var $m_szImage;
    var $m_szText;
    var $m_szLink;
    var $m_szTarget;
    var $m_bLeaf; /// Set to true if this is a last node
    var $m_oLastNode; // used ?

    var $m_szProgId;


   /**
     * TreeMenuNode constructor.
     *
     * @param $nTreeLevel - Node level in the tree.
     * @param $szImage    - Image displayed beside text node on the tree.
     * @param $szText     - Text displayed in tree for this node.
     * @param $szLink     - Hyper link called when node clicked.
     * @param $szTarget   - Frame target.
     * @param $oLastNode  - Used ????.
     * @param $szProgId   - Optional. Represent a progId for security.
     *
     * @return NOTHING.
     **/
    function TreeMenuNode($nTreeLevel, $szImage, $szText, $szLink, $szTarget, $oLastNode, $szProgId="")
    {
        //init logging context
        $this->Logger( "TreeMenuNode" );
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "TreeMenuNode($nTreeLevel, $szImage, $szText, $szLink, $szTarget, $oLastNode, $szProgId) called"); #STRIPED_LOG# */

        $this->m_nTreeLevel = $nTreeLevel;
        $this->m_szImage    = $szImage;
        $this->m_szText     = $szText;
        $this->m_szLink     = $szLink;
        $this->m_szTarget   = $szTarget;
        $this->m_oLastNode  = $oLastNode;

        /**
         * If this value is set, a user connection
         * must be set in TreeMenu object. If not
         * this param is ignored.
         */
        $this->m_szProgId   = $szProgId;

        /**
         * By default, node is not expanded and not visible and a leaf.
         */
        $this->m_bExpand  = 0;
        $this->m_bVisible = 0;
        $this->m_bLeaf    = 1;

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_VERBOSE, "TreeMenuNode() returning."); #STRIPED_LOG# */
    }
}

/**
 * Main TreeMenu class.
 *
 * This class takes a TreeMenu structure stored in a string
 * array. Each line represent a node in the tree. See comments
 * on top of this document for node line structure.
 *
 * Images used by TreeMenu can be overrided. You mus specify a
 * new TreeMenuImages object before displaying it. If you dont
 * specify it, it use default images.
 *
 */
class TreeMenu extends Logger
{
    /**
     * an array of tree nodes
     */
    var $m_aoNode;

    /**
     * Represent the highest level in the tree
     */
    var $m_nMaxLevel;

    /**
     * TreeMenu memory structore
     */
    var $m_aszTreeStructure;

    /*
     * Object that contain all images
     * needed by TreeMenu.
     */
    var $m_oTreeMenuImages;

    var $m_szDepth;
    var $m_szTitle;
    var $m_szFont;
    var $m_szFontClose;
    var $m_szCallBack;
    var $m_szScript;
    var $m_szScriptEnd;


    var $m_iMaxNodeNameLength = -1;

    /**
     * Additional param to add to URL
     * for all nodes.
     */
    var $m_szParams;

    /**
     * This variable must be set if the treemenu
     * have to check node access for a user connection.
     * Node prog id must be set.
     *
     * If not set, not security check is done.
     */
    var $m_oUserConnection;



   /**
     * TreeMenu constructor.
     *
     * @param $oUserConnection - Represent a user connection in security services context.
     *
     * @return NOTHING.
     **/
    function TreeMenu($oUserConnection=false)
    {
        global $HTTP_SERVER_VARS;

        $szURI = "http://".$HTTP_SERVER_VARS['HTTP_HOST'].
                  $HTTP_SERVER_VARS['PHP_SELF'];

        //init logging context
        $this->Logger( "TreeMenu" );
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "TreeMenu::TreeMenu() called."); #STRIPED_LOG# */

        $this->m_aoNode = array();
        $this->m_aszTreeStructure = array();

        $this->m_oUserConnection = $oUserConnection;

//        $this->szDepth    = $szDepth;
        $this->m_szTitle     = "Treemenu";
        $this->m_szFont      = "";
        $this->m_szFontClose = "";
        $this->m_szCallBack  = "";
        $this->m_szScript    = "$szURI";
        $this->m_szScriptEnd = "";

        $this->m_szParams    = "";

        $this->m_oTreeMenuImages = new TreeMenuImages();
        $this->m_oTreeMenuImages->setLogFile($this->szLogFile);

/* #STRIPED_LOG#         $this->log( LOG_ALL, "szScript=".$this->m_szScript); #STRIPED_LOG# */

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_VERBOSE, "TreeMenu::TreeMenu() returning."); #STRIPED_LOG# */
    }

    function setMaxNodeNameLength($nLength)
    {
        $this->m_iMaxNodeNameLength = $nLength;
    }

   /**
     * Set the treemenu additional CGI parameters
     *
     * @param $szParams
     * @return none
     **/
    function setParams($szParams)
    {
/* #STRIPED_LOG#         $this->log(LOG_ALL, "setParams( $szParams )"); #STRIPED_LOG# */
        $this->m_szParams = $szParams;
    }

    /**
     * Set the treemenu title
     *
     * @param $szTitle
     * @return none
     **/
    function setTitle($szTitle)
    {
/* #STRIPED_LOG#         $this->log(LOG_ALL, "setTitle( $szTitle )"); #STRIPED_LOG# */
        $this->m_szTitle = $szTitle;
    }

    /**
     * set the font to be used in the tree (expects an HTML font tag)
     *
     * @param $szFont
     * @return
     **/
    function setFont($szFont)
    {
/* #STRIPED_LOG#         $this->log(LOG_ALL, "setFont($szFont)"); #STRIPED_LOG# */
        if($szFont == "")
        {
            $this->m_szFont = "";
            $this->m_szFontClose = "";
        }
        else
        {
            $this->m_szFont = $szFont;
            $this->m_szFontClose = "</FONT>";
        }
    }

    /**
     * configure the treemenu to use a javascript function to process node
     * opening and closing instead of using <A> tags.
     *
     * @param $szScript
     * @return
     **/
    function setScript($szScript)
    {
        global $HTTP_SERVER_VARS;

        $szURI = "http://".$HTTP_SERVER_VARS['HTTP_HOST'].
                  $HTTP_SERVER_VARS['PHP_SELF'];

/* #STRIPED_LOG#         $this->log(LOG_ALL, "setScript($szScript)"); #STRIPED_LOG# */
        if($szScript == "")
        {
            $this->m_szScript = $szURI;
            $this->m_szScriptEnd = "";
        }
        else
        {
            $this->m_szScript = "javascript:".$szScript."('";
            $this->m_szScriptEnd = "')";
        }
    }

    /**
     * set the callback function to be used by nodes that want to be
     * configured by a callback rather than the standard Treemenu format.
     *
     * @param $szCallback
     * @return
     **/
    function setCallback($szCallback)
    {
/* #STRIPED_LOG#         $this->log(LOG_ALL, "setCallback($szCallback)"); #STRIPED_LOG# */
        $this->m_szCallBack = $szCallback;
    }


    /**
     * Load Tree structure from memory. m_aszTreeStrcture
     * must be set.
     *
     **/
    function loadTreeStructure()
    {
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "TreeMenu::loadTreeStructure() called."); #STRIPED_LOG# */

        $this->m_nMaxLevel=0;
        $cnt=0;

        for($i=0; $i<count($this->m_aszTreeStructure);$i++)
        {
            //skip empty lines
            if(trim($this->m_aszTreeStructure[$i]) == "")
                continue;

            $node=explode("|",$this->m_aszTreeStructure[$i]);
            $node = array_pad($node, 6, 0 );
            /**
             * If this member is set, there should be a ProdId
             */
            if ($this->m_oUserConnection != false)
            {
              $oNode = new TreeMenuNode(strspn(trim($node[0]),"."), trim($node[1]), trim($node[2]), trim($node[3]), trim($node[4]), 0, trim($node[5]));
            }
            else
              $oNode = new TreeMenuNode(strspn(trim($node[0]),"."), trim($node[1]), trim($node[2]), trim($node[3]), trim($node[4]), 0);

            $this->addNode($oNode);

            if ($oNode->m_nTreeLevel > $this->m_nMaxLevel)
            {
               $this->m_nMaxLevel = $oNode->m_nTreeLevel;
            }
        }

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_VERBOSE, "TreeMenu::loadTreeStructure() returning true."); #STRIPED_LOG# */
    }

    /**
     * Simply add a node to tree structure.
     *
     * @param $oNode - Node to add
     * @return NOTHING
     **/
    function addNode($oNode)
    {
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "TreeMenu::addNode($oNode) called."); #STRIPED_LOG# */

/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->bExpand    = $oNode->m_bExpand"); #STRIPED_LOG# */
/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->bVisible   = $oNode->m_bVisible"); #STRIPED_LOG# */
/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->nTreeLevel = $oNode->m_nTreeLevel"); #STRIPED_LOG# */
/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->szImage    = $oNode->m_szImage"); #STRIPED_LOG# */
/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->szText     = $oNode->m_szText"); #STRIPED_LOG# */
/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->szLink     = $oNode->m_szLink"); #STRIPED_LOG# */
/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->szTarget   = $oNode->m_szTarget"); #STRIPED_LOG# */
/* #STRIPED_LOG#         $this->log(LOG_ALL, "oNode->szProgId   = $oNode->m_szProgId"); #STRIPED_LOG# */

        $oNode->setLogFile($this->szLogFile);

        array_push($this->m_aoNode, $oNode);

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_ALL, "TreeMenu::addNode() returning."); #STRIPED_LOG# */
    }


    /**
     * Restore states parse tree menu nodes and does a few
     * things:
     *
     * - Find nodes to expand
     * - Find eache last nodes
     * - If security is used, remove Nodes that user dont have access
     * - Determin if a node is visible or not.
     *
     * @param $aszNodeNum - Represent a list of nodes number seperated by "|"
     *
     * @return NOTHING
     **/
    function restoreStates($aszNodeNum, $bExpandColapse="")
    {
        $anLevel = array();
        $aszProgId = array();

        /*********************************************/
        /*  Get Node numbers to expand               */
        /*********************************************/
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "TreeMenu::restoreStates($aszNodeNum) called."); #STRIPED_LOG# */

        if ($bExpandColapse != "")
        {
            $nStatus = 0;
            if ($bExpandColapse == true) // expand all
                $nStatus = 1;

            foreach (array_keys($this->m_aoNode) as $szKey)
            {
                $this->m_aoNode[$szKey]->m_bExpand = $nStatus;
                $this->m_aoNode[$szKey]->m_bVisible = $nStatus;
            }
        }
        else
        {
            if ($aszNodeNum != "")
            {
                $explevels = explode("|",$aszNodeNum);
                sort($explevels);
                reset($explevels);
            }
            else
                $explevels = array();

            $i=0;
            while($i<count($explevels))
            {
                if (isset($this->m_aoNode[$explevels[$i]]))
                {
                    $this->m_aoNode[$explevels[$i]]->m_bExpand = 1;
/* #STRIPED_LOG#                     $this->log(LOG_ALL, "Node ".$explevels[$i]." is set expand."); #STRIPED_LOG# */
                }

                $i++;
            }
        }
        /*********************************************/
        /*  Find last nodes of subtrees              */
        /*********************************************/
        $lastlevel = $this->m_nMaxLevel;

        for ($i=0; $i<=$this->m_nMaxLevel; $i++)
        {
            $anLevel[$i] = 0;
        }

        for ($i=count($this->m_aoNode)-1; $i>=0; $i--)
        {
            if ($this->m_aoNode[$i]->m_nTreeLevel < $lastlevel )
            {
                for ($j=$this->m_aoNode[$i]->m_nTreeLevel+1; $j <= $this->m_nMaxLevel; $j++)
                {
                    $anLevel[$j] = 0;
                }
            }
            if ($anLevel[$this->m_aoNode[$i]->m_nTreeLevel] == 0)
            {
                $anLevel[$this->m_aoNode[$i]->m_nTreeLevel] = 1;
                $this->m_aoNode[$i]->m_bleaf = 1;
            }
            else
                $this->m_aoNode[$i]->m_bLeaf = 0;

            $lastlevel = $this->m_aoNode[$i]->m_nTreeLevel;
        }

        /*********************************************/
        /*  Remove Nodes we dont have access         */
        /*********************************************/
        $lastlevel = $this->m_nMaxLevel;

        for ($i=0; $i<=$this->m_nMaxLevel; $i++)
        {
            $aszProgId[$i] = "";
        }

        for ($i=0; $i<count($this->m_aoNode); $i++)
        {
            if ($this->m_oUserConnection)
            {
                for ($j=$this->m_aoNode[$i]->m_nTreeLevel; $j <= $this->m_nMaxLevel; $j++)
                {
                    $aszProgId[$this->m_aoNode[$j]->m_nTreeLevel] = $this->m_aoNode[$i]->m_szProgId;
                }
            }

            if ($this->m_aoNode[$i]->m_szProgId == "")
                $this->m_aoNode[$i]->m_szProgId =  $aszProgId[$this->m_aoNode[$i]->m_nTreeLevel-1];
        }


        /*********************************************/
        /*  Determine visible nodes                  */
        /*********************************************/

        // all root nodes are always visible
        for ($i=0; $i < count($this->m_aoNode); $i++)
        {
            if ($this->m_aoNode[$i]->m_nTreeLevel == 1)
            {
                $this->m_aoNode[$i]->m_bVisible = 1;
            }
        }

        if ($bExpandColapse == "")
        for ($i=0; $i < count($explevels); $i++)
        {
            $n=$explevels[$i];
            if ( !isset($this->m_aoNode[$n]) )
                continue;

            if ( ($this->m_aoNode[$n]->m_bVisible == 1) &&
                    ($this->m_aoNode[$n]->m_bExpand == 1) )
            {
                $j=$n+1;
                while ( $j < count($this->m_aoNode) &&
                        $this->m_aoNode[$j]->m_nTreeLevel >
                        $this->m_aoNode[$n]->m_nTreeLevel )
                {
                    if ($this->m_aoNode[$j]->m_nTreeLevel ==
                        $this->m_aoNode[$n]->m_nTreeLevel+1)
                      $this->m_aoNode[$j]->m_bVisible = 1;

                    $j++;
                }
            }
        }

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_ALL, "TreeMenu::restoreStates() returning."); #STRIPED_LOG# */
    }

    /**
     * return a | separated list of visible node numbers
     */
    function getTreeParams()
    {
        $szParams = "";
        $szSep = "";
        for ($i=0;$i<count($this->m_aoNode);$i++)
        {
            if ($this->m_aoNode[$i]->m_bExpand)
            {
                $szParams .= "$szSep$i";
                $szSep = "|";
            }
        }
        return $szParams;
    }

    /**
     * Display TreeMenu.
     *
     * @param $szVarName - Represent the variable that TreeMenu used in href.
     *
     * @return the tree menu in HTML.
     **/
    function displayTreeMenu($szVarName="p", $bStartEndTable=true)
    {
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "TreeMenu::DisplayTreeMenu() called."); #STRIPED_LOG# */

        /**
         * variable that will contain HTML output.
         */
        $szTreeMenu = "";

        $anLevel = array();

        for ($i=0; $i<$this->m_nMaxLevel; $i++)
          $anLevel[$i] = 1;

        $this->m_nMaxLevel++;

        $width = 0;

        for ($i=0;$i<count($this->m_aoNode);$i++)
        {
            if ($this->m_aoNode[$i]->m_bVisible)
            {
                $width = max($width, $this->m_aoNode[$i]->m_nTreeLevel);
            }
        }

        $width ++;
        $width ++;     //add a spacing column under the names

        //
        // process callbacks
        //
        $table = array(); //2D array of table contents
        $cnt = 0; //index through $tree contents
        $row = 0; //number of actual table rows
        $maxwidth = 0; //the widest row
        $table[$row++] = array(); //row for title (fill in later)

        while($cnt<count($this->m_aoNode))
        {
            $hasChild = 1;

            if ($this->m_oUserConnection && $this->m_aoNode[$cnt]->m_szProgId != "")
            {
                if (!$this->m_oUserConnection->HasAccessTo($this->m_aoNode[$cnt]->m_szProgId))
                {
                    $this->m_aoNode[$cnt]->m_bVisible = false;
                }
            }

            if ($this->m_aoNode[$cnt]->m_bVisible) //only output visible ones
            {

                $col = 0; //start in first column.
                $table[$row] = array(); //each row is an array
                //first column is a spacer.
                //$table[$row][$col++] =  $this->m_oTreeMenuImages->imgTag(img_spc);
                //vertical lines from higher levels
                $i=0;
                while ($i<$this->m_aoNode[$cnt]->m_nTreeLevel-1)
                {
                    if ($anLevel[$i] == 1)
                      $table[$row][$col++] = "<a name=\"$cnt\"></a>".$this->m_oTreeMenuImages->imgTag(img_line);
                    else
                      $table[$row][$col++] = "<a name=\"$cnt\"></a>".$this->m_oTreeMenuImages->imgTag(img_spc);
                    $i++;
                }

                //corner at end of subtree or t-split
                if ($this->m_aoNode[$cnt]->m_bLeaf == 1)
                {
                    $anLevel[$this->m_aoNode[$cnt]->m_nTreeLevel-1] = 0;
                    $img_expand   = img_expand_end;
                    $img_collapse = img_collapse_end;
                    $img_leaf     = img_end;
                }
                else
                {
                    $anLevel[$this->m_aoNode[$cnt]->m_nTreeLevel-1] = 1;
                    $img_expand   = img_expand_split;
                    $img_collapse = img_collapse_split;
                    $img_leaf     = img_split;
                }

                //Node (with subtree) or Leaf (no subtree)
                if (isset($this->m_aoNode[$cnt+1]) && $this->m_aoNode[$cnt+1]->m_nTreeLevel > $this->m_aoNode[$cnt]->m_nTreeLevel)
                {
                    // Create expand/collapse parameters
                    $i=0;
                    if ($this->m_szParams != "")
                        $states="?$this->m_szParams&".$szVarName."=";
                    else
                        $states="?".$szVarName."=";

                    $lastNode = $cnt;

                    while($i<count($this->m_aoNode))
                    {
                        if ( ($this->m_aoNode[$i]->m_bExpand == 1) && ($cnt != $i) || ($this->m_aoNode[$i]->m_bExpand == 0 && $cnt == $i))
                        {
                            $states .= $i;
                            $states .= "|";
                        }
                        $i++;
                    }
                    $states .= "#$cnt";

                    if ($this->m_aoNode[$cnt]->m_bExpand == 0)
                    {
                        $table[$row][$col++] = "<a name=\"$cnt\"></a>".
                        "<a href=\"".$this->m_szScript.$states.
                        $this->m_szScriptEnd."\">".$this->m_oTreeMenuImages->imgTag($img_expand)."</a>";
                    }
                    else
                    {
                        $table[$row][$col++] = "<a name=\"$cnt\"></a>".
                        "<a href=\"".$this->m_szScript.$states.
                        $this->m_szScriptEnd."\">".$this->m_oTreeMenuImages->imgTag($img_collapse)."</a>";
                    }
                }
                else
                {
                    // Tree Leaf
                    $table[$row][$col++] = $this->m_oTreeMenuImages->imgTag($img_leaf);
                    $hasChild = 0;

                    if (strstr($states, "|$lastNode|") == false)
                        $states .= $lastNode."|";
                }

                //the item image
                if ( $this->m_aoNode[$cnt]->m_szImage != "" )
                {
                    $table[$row][$col++] = "<IMG SRC=\"".$this->m_aoNode[$cnt]->m_szImage."\"".
                                           " ALT=\"\"".
                                           //" ALT=\"".$this->m_aoNode[$cnt]->m_szImage."\"".
                                           //" TITLE=\"".$this->m_aoNode[$cnt]->m_szImage."\"".
                                           //" WIDTH=\"".$this->m_oTreeMenuImages->m_nWidth."\"".
                                           //" HEIGHT=\"".$this->m_oTreeMenuImages->m_nHeight."\">";
                                           " BORDER=\"0\">";
                }
                //else
                //  $table[$row][$col++] = $this->m_oTreeMenuImages->imgTag(img_spc);

                //ouput item text using callback if necessary
                if ( substr( $this->m_aoNode[$cnt]->m_szText, 0, 1 ) == "@" && $this->m_szCallBack != "")
                {
                    if ($this->m_iMaxNodeNameLength != -1 &&
                strlen($this->m_aoNode[$cnt]->m_szText) >
                        $this->m_iMaxNodeNameLength)
            {
                $this->m_aoNode[$cnt]->m_szText =
                                   substr($this->m_aoNode[$cnt]->m_szText, 0, $this->m_iMaxNodeNameLength)."...";
            }

                    $table = call_user_func( $this->m_szCallBack,
                                             $this->m_aoNode[$cnt]->m_szText,
                                             $cnt,
                                             $table,
                                             $row,
                                             $col,
                                             $width,
                                             $states,
                                             $hasChild,
                                             $this->m_aoNode[$cnt]->m_bExpand );
                }
                elseif ($this->m_aoNode[$cnt]->m_szLink == "0") //output plain text with hyperlink
                {
              if ($this->m_iMaxNodeNameLength != -1 &&
            strlen($this->m_aoNode[$cnt]->m_szText) > $this->m_iMaxNodeNameLength)
          {
            $this->m_aoNode[$cnt]->m_szText = substr($this->m_aoNode[$cnt]->m_szText, 0, $this->m_iMaxNodeNameLength)."...";
          }
                  $table[$row][$col++] = $this->m_szFont.$this->m_aoNode[$cnt]->m_szText.$this->m_szFontClose;
                  //$table[$row][$col++] = "&nbsp;";
                }
                else //output plain text
                {
              if ($this->m_iMaxNodeNameLength != -1 &&
            strlen($this->m_aoNode[$cnt]->m_szText) > $this->m_iMaxNodeNameLength)
          {
            $this->m_aoNode[$cnt]->m_szText = substr($this->m_aoNode[$cnt]->m_szText, 0, $this->m_iMaxNodeNameLength)."...";
          }

                  if ($this->m_aoNode[$cnt]->m_szTarget != "0")
                  {
                      $table[$row][$col++] = "<a href=\"".$this->m_aoNode[$cnt]->m_szLink."\" target=\"".
                      $this->m_aoNode[$cnt]->m_szTarget."\">".$this->m_szFont.$this->m_aoNode[$cnt]->m_szText.
                      $this->m_szFontClose.'</a>';
                  }
                  else
                  {
                      $table[$row][$col++] = "<a href=\"".$this->m_aoNode[$cnt]->m_szLink."\">".
                      $this->m_szFont.$this->m_aoNode[$cnt]->m_szText.
                      $this->m_szFontClose.'</a>';
                  }

                  //$table[$row][$col++] = "&nbsp;";
                }
                //track how wide the row is?
                $maxwidth=max($maxwidth, count($table[$row]));
                //move to next row
                $row ++;
            }
            $cnt ++; //move to next tree item
        }

        //add a spacing row at the bottom one column wider than the other rows
        //the extra column shows up under the names to the left of any
        //extra stuff
        $maxwidth++;
        $maxwidth++;
        $table[$row] = array();

        for ($i=0;$i<$maxwidth;$i++)
          $table[$row][$i] = "&nbsp;";


        //do the title row
        $table[0][0] = $this->m_szFont.$this->m_szTitle.$this->m_szFontClose;
        //$table[0][$maxwidth-1] = "&nbsp;";

        //now output the table.
        if ($bStartEndTable)
            $szTreeMenu = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";
        else
            $szTreeMenu = "";
        for ($i=0;$i<count($table);$i++)
        {
            $szTreeMenu .= "<tr>\n";
            for ($j=0;$j<$maxwidth;$j++)
            {
                //$k will end up with the colspan value
                $k = $j + 1;
                while ( !isset($table[$i][$k]) && $k < $maxwidth ) $k++;
                if ( ($i == count($table) - 1) && ($j == $maxwidth - 1) && isset($table[$i][$j]) )
                {
                    $szTreeMenu .= "<td align=left valign=top width=\"100%\">".$table[$i][$j]."</td>\n";
                }
                elseif ( isset($table[$i][$j]) )
                {
                    //account for colspans
                    $szTreeMenu .= "  <td valign=top align=left ";
                    if (isset($this->m_aoNode[$cnt]) && strlen($this->m_aoNode[$cnt]->m_szText) < 80)
                        $szTreeMenu .= "nowrap";
                    if ($k > ($j + 1))
                      $szTreeMenu .= " colspan=\"".($k - $j)."\" ";
                    //output contents
                    $szTreeMenu .= ">".$table[$i][$j]."</td>\n";
                }
            }
            $szTreeMenu .= "</tr>\n";
        }
        if ($bStartEndTable)
            $szTreeMenu .= "</table>\n";

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_VERBOSE, "TreeMenu::DisplayTreeMenu() returning."); #STRIPED_LOG# */

        return $szTreeMenu;
    }
}


/**
 * This class derived from TreeMenu.
 *
 * This class takes a TreeMenu structure stored in a file.
 * Each line in the file represent a node in the tree. See comments
 * on top of this document for node line structure.
 *
 */
class FileTreeMenu extends TreeMenu
{
    function FileTreeMenu($szTreeFile, $oUserConnection=false)
    {
        // call parent
        parent::TreeMenu($oUserConnection);
        //init logging context
        $this->Logger( "FileTreeMenu" );
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "FileTreeMenu::FileTreeMenu($szTreeFile, $oUserConnection) called."); #STRIPED_LOG# */


        if (!file_exists($szTreeFile))
        {
            $this->error(0, "Tree file $szTreeFile does not exist.");
        }
        else
        {
            $this->m_aszTreeStructure = file($szTreeFile);
            $this->loadTreeStructure();
        }

/* #STRIPED_LOG#         $this->logFuncEnd(LOG_ALL, "FileTreeMenu::FileTreeMenu() returning."); #STRIPED_LOG# */
    }
}

/**
 * initialize a treemenu instance from a string in memory
 */
class StringTreeMenu extends TreeMenu
{
    /**
     * Constructor
     *
     * @param $szTreemenu the string to initialize from, requires \n separators
     * between node lines.
     **/
    function StringTreeMenu($szTreemenu)
    {
        // call parent
        parent::TreeMenu();
        //init logging context
        $this->Logger( "StringTreeMenu" );
/* #STRIPED_LOG#         $this->logFuncStart(LOG_VERBOSE, "StringTreeMenu::StringTreeMenu($szTreemenu) called."); #STRIPED_LOG# */


        //parse the string
        $this->m_aszTreeStructure = explode("\n", $szTreemenu );
        $this->loadTreeStructure();


/* #STRIPED_LOG#         $this->logFuncEnd(LOG_ALL, "StringTreeMenu::StringTreeMenu() returning."); #STRIPED_LOG# */
    }
}

class DBTreeMenu extends TreeMenu
{
    // maybe some day....
}
