<?php
/*
 * SymboPicker is a WEB interface that let the user choose a symbol
 * from a mapserver symbol file.
 *
 * Package(s) used: PHPMapscript
 *
 * @author Sacha Fournier (sfournier@dmsolutions.ca)
 * @project Mapedit
 * @revision $Id
 * @purpose Simple graphic interface that display all symbol from
 *          mapserver symbol file There is also a graphical preview.
 *
 *          The PHP mapscript module name can be specified by the
 *          $_SESSION["gszPHPMapScriptModName"] variable. If not specified, default
 *          name is used.
 *
 *          Those variables MUST be defined.
 *
 *          $gszMap              -> Contain the map file content
 *          $gszMapName          -> Full Map file name
 *          $gnCurrentLayerIndex -> Layer to load symbol
 *          $gszTmpMapPath       -> Path where to create tmp map file
 *          $szCallBack          -> Picker call back function
 *
 *
 * @copyright Copyright DM Solutions Group Inc 2002 All Rights Reserved
 *
 */

/*
 * Open session
 * to retrieve the font file reference.
 */

include_once("../session/session.php");
installSessionDirectoryHandler();
initializeSession();

// convert the global session reference if necessary
if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
{
    if ( version_compare( phpversion(), "4.2.1" ) < 0 )
        $_SESSION = &$HTTP_SESSION_VARS;
}

include_once("../logger/logger.php");

class SymbolPicker extends Logger
{
    var $m_aszSymbolList; /// List of symbol to dsplay
    var $m_nSelectedSymbol; //index of selected symbol
    var $m_oDummyMap; /// Dummy map object. Needed to load symbolset.
    var $m_oDummyLayer; ///Dummy layer object. Needed to set symbol attribute.
    var $m_oDummyClass; ///Dummy class object. Needed to draw symbol.
    var $m_oDummyStyle; ///Dummy style object. Needed to draw symbol w/ mapserver>36.

    /**
     * SymbolPicker( )
     *
     * @param $nLayerIndex Current layer
     * @param $nSelectedSymbol current selected symbol.
     *
     * @return (NONE)
     **/
    function SymbolPicker ($nLayerIndex, $nSelectedSymbol=0)
    {
        $this->Logger("Symbol picker");

        $szCurDir = getcwd();

        /* -------------------------------------------------------------------- */
        /*      Load required modules                                           */
        /* -------------------------------------------------------------------- */
        if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
        {
            if (!extension_loaded("MapScript"))
            {
                /**
                 * Check if a module name is specified.
                 * If so, use it. If not takes the default
                 * one.
                 */
                if (!isset($_SESSION["gszPHPMapScriptModName"]))
                    $_SESSION["gszPHPMapScriptModName"] = "php_mapscript.dll";

                dl($_SESSION["gszPHPMapScriptModName"]);
            }
        }
        else
        {
            if (!extension_loaded("MapScript"))
            {
                /**
                 * Check if a module name is specified.
                 * If so, use it. If not takes the default
                 * one.
                 */
                if (!isset($_SESSION["gszPHPMapScriptModName"]))
                    $_SESSION["gszPHPMapScriptModName"] = "php_mapscript.so";

                dl($_SESSION["gszPHPMapScriptModName"]);
            }
        }

        $this->m_aszSymbolList = array();

        // save a temp copy of the map file
        $szTempDir = $_SESSION["gszTmpMapPath"];
        $szTempMap = $szTempDir."/".session_id().".map";
        $hMap = fopen( $szTempMap, "w+" );
        fwrite( $hMap, $_SESSION["gszMap"] );
        fclose($hMap);

        $this->m_oDummyMap = ms_newMapObj($szTempMap, dirname($_SESSION["gszMapName"]));

        // Check if image path and tmp url directory is set.
        // If not use the one specified in .xml config file.
        if ($this->m_oDummyMap->web->imagepath == "" && $_SESSION["gszTmpImgPath"] != "")
            $this->m_oDummyMap->web->set("imagepath", $_SESSION["gszTmpImgPath"]);

        if ($this->m_oDummyMap->web->imageurl == "" && $_SESSION["gszTmpWebImgPath"] != "")
            $this->m_oDummyMap->web->set("imageurl", $_SESSION["gszTmpWebImgPath"]);


        // delete temp map file
        unlink($szTempMap);

        // get first layer with a class
        for($i=0; $i<$this->m_oDummyMap->numlayers; $i++)
        {
            $this->m_oDummyLayer = $this->m_oDummyMap->getLayer($i);

            if ($this->m_oDummyLayer->numclasses > 0)
                break;
        }



        $this->m_oDummyClass = $this->m_oDummyLayer->getClass(0);
        //test for mapserver > 36
        $aMs = explode(" ", ms_GetVersion());
        if (substr($aMs[2], 0, 3) >= "3.6")
        {
            $this->m_oDummyStyle = $this->m_oDummyClass->getStyle(0);
        }

        if ($nSelectedSymbol == "")
            $nSelectedSymbol = 0;

        $this->m_nSelectedSymbol = $nSelectedSymbol;

        if (!is_numeric($this->m_nSelectedSymbol))
        {
            // convert it to numeric
            $this->m_nSelectedSymbol = $this->m_oDummyMap->getSymbolByName($this->m_nSelectedSymbol);
        }

//        chdir($szCurDir);
    }

    /**
     * parseSymbolSet( )
     *
     *
     * @return (NONE)
     **/
    function parseSymbolSet ()
    {
        $szCurDir = getcwd();

        $szSymbolList = "";
        $this->m_aszSymbolList = array();

        // set layer to point
        $this->m_oDummyLayer->set("type", MS_LAYER_POINT);

        for ($i=1; $i<$this->m_oDummyMap->getNumSymbols(); $i++)
        {
            // Set style symbol if we're in 4.0
            $aMs = explode(" ", ms_GetVersion());
            if (substr($aMs[2], 0, 3) >= "3.6")
            {
                $this->m_oDummyStyle->set("symbol", $i);
                // force size to 15
                $this->m_oDummyStyle->set("size", 20);
                // force color to black
                $this->m_oDummyStyle->color->setRGB(0,0,0);
                // force outlinecolor
                $this->m_oDummyStyle->outlinecolor->setRGB(227,240,240);

            }
            else
            //use class symbol for legacy mapserver
            {
                $this->m_oDummyClass->set("symbol", $i);

                $oBgColor = $this->m_oDummyMap->addColor(227,240,240);
                // force size to 15
                $this->m_oDummyClass->set("size", 20);
                // force color to black
                $this->m_oDummyClass->set('color', $this->m_oDummyMap->addColor(0,0,0));
                // force outlinecolor
                $this->m_oDummyClass->set('outlinecolor', $oBgColor);
            }

            // Create the symbol image
            $imgSymbol = $this->m_oDummyClass->createLegendIcon(28, 28);

            // Save it to a temporary dir.
            $szUrl = $imgSymbol->saveWebImage($this->m_oDummyMap->imagetype, 0, 0, 95);

            // Add symbol index and image url to XML document.
            $aSymbolProp = array("SymbolId" => $i, "SymbolUrl" => $szUrl);

            array_push($this->m_aszSymbolList, $aSymbolProp);
        }

        chdir($szCurDir);
    }
}

if($_GET["szCallBack"] != ""  && $_SESSION["gnCurrentLayerIndex"] >= 0 &&
   $_SESSION["gszTmpMapPath"]!= "" && $_SESSION["gszMap"] != "" && $_SESSION["gszMapName"] != "")
{
    if (!isset($_GET["nSelectedSymbol"]))
        $_GET["nSelectedSymbol"] = 0;

    $oPicker = new SymbolPicker($_SESSION["gnCurrentLayerIndex"], $_GET["nSelectedSymbol"]);
    $oPicker->parseSymbolSet();
}
else
{
    echo "szCallBack($szCallBack)<br>
         gnCurrentLayerIndex($gnCurrentLayerIndex)<br>
         gszTmpMapPath($gszTmpMapPath)<br>
         gszMap(".substr($gszMap,0,15)."...)<br>
         gszMapName($gszMapName)<br> not specified.";
}
?>
