<?php
/*
 * ShapeFileAttrPicker is a WEB interface that let the user choose a field
 * from shape file of a layer.
 *
 * Package(s) used: Templates
 *
 * @author Sacha Fournier (sfournier@dmsolutions.ca)
 * @project PhpUtil
 * @revision $Id
 * @purpose Simple graphic interface that display all shape filefield
 *          from a layer and let user choose one.
 *
 *          Two variables must be set in session:
 *            - szMapFileRef (contains full path to mapfile)
 *            - nLayerIdx (contains layer index to show shape file attribute)
 *
 *          Function return the shape file attribute in text format.
 *
 *          The PHP mapscript module name can be specified by the
 *          $_SESSION["gszPHPMapScriptModName"] variable. If not specified, default
 *          name is used.
 *
 * @copyright Copyright DM Solutions Group Inc 2002 All Rights Reserved
 *
 */
include_once("../logger/logger.php");
include_once("../logger/error_manager.php");
include_once("../session/session.php");
installSessionDirectoryHandler();
initializeSession();


// convert the global session reference if necessary
if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
{
    if ( version_compare( phpversion(), "4.2.1" ) < 0 )
        $_SESSION = &$HTTP_SESSION_VARS;
}

$nLoadOk=true;

class ShapeFileAttr extends Logger
{
    var $m_szMapFile;
    var $m_szMapPath;
    var $m_szSelectedItem;

    var $m_aszItems;

    /**
     * ShapeFileAttr( )
     *
     * @param $szMapFile Full name of map file to open
     * @param $nLayerIdx Wich layer should we get attributes
     * @param $szSelectedItem Current selected item
     *
     * @return (NONE)
     **/
    function ShapeFileAttr ($szMapFile, $szMapPath = ".", $nLayerIdx, $szSelectedItem="")
    {
        $this->Logger("Shape file attribute");

        $this->m_szMapFile = $szMapFile;
        $this->m_szMapPath = $szMapPath;
        $this->m_nLayerIdx = ($nLayerIdx == "") ? -1 : $nLayerIdx;
        $this->m_szSelectedItem = $szSelectedItem;

        $this->m_aszItems = array();

        $this->getItems();
    }

    /**
     * getItems( )
     *
     **/
    function getItems ( )
    {
        global $nLoadOk, $gErrorManager;

        $szCurDir = getcwd();


/* -------------------------------------------------------------------- */
/*      Load required modules                                           */
/* -------------------------------------------------------------------- */
        if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
        {
            if (!extension_loaded("MapScript"))
            {
                /**
                 * Check if a module name is specified.
                 * If so, use it. If not takes the default
                 * one.
                 */
                if (!isset($_SESSION["gszPHPMapScriptModName"]))
                $_SESSION["gszPHPMapScriptModName"] = "php_mapscript.dll";

                dl($_SESSION["gszPHPMapScriptModName"]);
            }
        }
        else
        {
            if (!extension_loaded("MapScript"))
            {
                /**
                 * Check if a module name is specified.
                 * If so, use it. If not takes the default
                 * one.
                 */
                if (!isset($_SESSION["gszPHPMapScriptModName"]))
                $_SESSION["gszPHPMapScriptModName"] = "php_mapscript.so";

                dl($_SESSION["gszPHPMapScriptModName"]);
            }
        }
       
        if (isset($_SESSION['gErrorManager']))
            $_SESSION['gErrorManager']->setErrorHandler("errHandler");
        $oMapObj = ms_newMapObj($this->m_szMapFile, $this->m_szMapPath);
        if (isset($_SESSION['gErrorManager']))
            $_SESSION['gErrorManager']->restoreErrorHandler();

        if ($nLoadOk)
        {
            if ($this->m_nLayerIdx <= $oMapObj->numlayers)
            {
                $oLayer = $oMapObj->getLayer($this->m_nLayerIdx);

                if (file_exists($oMapObj->shapepath."/".$oLayer->data) ||
                    file_exists($oMapObj->shapepath."/".$oLayer->data.".shp"))
                {
                    // open the layer to make the shape properties available
                    if ( strpos( strtoupper( ms_GetVersion() ), "VERSION 3.6") > 0 )
                        $oLayer->open( $oMap->shapepath );
                    else 
                        $oLayer->open();
                        
                    $this->m_aszItems = $oLayer->getItems();
                    $oLayer->close();
                }
                else
                  $aszItems = array();
            }
            else
                $aszItems = array();
        }
        chdir($szCurDir);
    }
}

function errHandler($errno, $errmsg, $filename, $linenum, $vars)
{
    global $nLoadOk;

    $nLoadOk = false;
}

// save a temp copy of the map file
$szTempMap = $_SESSION['gszTmpMapPath'].uniqid("").".map";
$hMap = fopen( $szTempMap, "w+" );
fwrite( $hMap, $_SESSION["gszMap"]);
fclose($hMap);

$oPicker = new ShapeFileAttr($szTempMap, dirname($_SESSION["gszMapName"]),
                             $_GET["nLayerIdx"], $_GET["szSelectedItem"]);
?>
