<?php
/*
 * FontPicker is a WEB interface that let the user choose a font
 * from a mapserver font file.
 *
 * Package(s) used: Templates
 *
 * @author Sacha Fournier (sfournier@dmsolutions.ca)
 * @project PhpUtil
 * @revision $Id
 * @purpose Simple graphic interface that display all font from
 *          mapserver font file and let user choose one. There is
 *          also a graphical preview.
 *
 * @copyright Copyright DM Solutions Group Inc 2002 All Rights Reserved
 *
 */
include_once("../logger/logger.php");
include_once("../logger/error_manager.php");
include_once("../session/session.php");
installSessionDirectoryHandler();
initializeSession();

// convert the global session reference if necessary
if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
{
    if ( version_compare( phpversion(), "4.2.1" ) < 0 )
        $_SESSION = &$HTTP_SESSION_VARS;
}


class FontPicker extends Logger
{
    var $m_szFontFile; /// Font file name to parse.
    var $m_aszFontName; /// Font name
    var $m_aszFontFileName; /// Font file name
    var $m_nSelectedFont; ///index of selected font

    /**
     * FontPicker( )
     *
     * @param $szCallBack Call back function to call.
     * @param $szFontFile Font file name to parse.
     * @param $szSelectedFont current selected font
     *
     **/
    function FontPicker ($szFontFile="", $szSelectedFont="")
    {
        $this->Logger("FontPicker");

        $this->m_szFontFile = $szFontFile;

        /// Initialize some members
        $this->m_aszFontName = array();
        $this->m_aszFontFileName = array();
        $this->m_nSelectedFont = -1;

        $this->parseFontFile();

        $this->selectFont($szSelectedFont);
    }

    /**
     * pre-select a font
     *
     * @param $szFont find selected font
     *
     * @return (NONE)
     */
    function selectFont( $szFont )
    {
        for($i=0; $i<count($this->m_aszFontName); $i++)
        {
//            echo $szFont. " ". $this->m_aszFontName[$i] ."<BR>";
            if (strcasecmp($szFont, $this->m_aszFontName[$i]) == 0)
            {
                $this->m_nSelectedFont = $i;
                break;
            }
        }
    }

    /**
     * parseFontFile( )
     *
     *
     * @return (NONE)
     **/
    function parseFontFile ( )
    {
//        echo $this->m_szFontFile;
        if ($this->m_szFontFile != "" && is_file($this->m_szFontFile))
        {
            $aszTmpFontList = file($this->m_szFontFile);
            $aszFontList = array();

            $szFontList = "";
            $szTmpFont = "";

            // For eache font in font file
            $i=0;
            foreach ($aszTmpFontList as $szFont)
            {
                /*
                 * extract font name
                 */
                $szFont = trim($szFont);
                $szFont = preg_replace("/\s+/", "|", $szFont);
                $aszFont = explode("|", $szFont);

                array_push($this->m_aszFontName, $aszFont[0]);
                array_push($this->m_aszFontFileName, $aszFont[1]);
            }
        }
        else
        {
            $this->error(ERR_FILE_IO, "Font file (".$this->m_szFontFile.") dont exist.");
        }
    }

    /**
     * renderFontPreview( )
     *
     **/
    function renderFontPreview()
    {
        $nFontSize = 14;

        // If no font specify, display a empty gif.
        if ($this->m_nSelectedFont == -1)
        {
            // Just return a empty image
            $nImgId = ImageCreate(100, 30);

            // Set bgcolor to white
            $bg_color = ImageColorAllocate ($nImgId, 255, 255, 255);

            ImageFill($nImgId, 0, 0, $bg_color);

        }
        else
        {
            // FontFileRef must be set...
            if (isset($this->m_aszFontName[$this->m_nSelectedFont]))
                $nKey = $this->m_nSelectedFont;
            else
                $nKey = false;

            if ($nKey !== false)
            {
                /* -------------------------------------------- */
                /*      Load required modules                   */
                /* -------------------------------------------- */
                if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
                {
                    if (!extension_loaded("gd"))
                    {
                        dl("php_gd2.dll");
                    }
                }
                else
                {
                    if (!extension_loaded("gd"))
                    {
                        dl("php_gd.so");
                    }
                }

                // Extrack the font file name
                $szFontFileNameToDisplay = basename($this->m_aszFontFileName[$nKey]);

                // Get bounding box of text
                $ttfBBox =  imagettfbbox ($nFontSize, 0,
                                          dirname($this->m_szFontFile).
                                          "/". $szFontFileNameToDisplay,
                                          $this->m_aszFontName[$nKey]);

                // Create the image
                $nImgId = ImageCreate($ttfBBox[2]+10, 30);

                // Set bgcolor to white
                $bg_color = ImageColorAllocate ($nImgId, 255, 255, 255);
                $text_color = ImageColorAllocate ($nImgId, 0, 0, 0);

                // Draw text. Use font name for sample text
                ImageTTFText($nImgId, $nFontSize, 0, 5, 22,
                             $text_color, dirname($this->m_szFontFile)."/".
                             $szFontFileNameToDisplay,  $this->m_aszFontName[$nKey]);
            }
            else
            {
                echo "ERROR: Font not found.";
                // font not found.
            }

        }
        if (!isset($_SESSION["gszImageType"]))
        {
            header("Content-type: image/png");
            ImagePng($nImgId);
        }
        else
        {
            header("Content-type: image/".$_SESSION["gszImageType"]);
            eval("Image".$_SESSION["gszImageType"]."(\$nImgId);");
        }


        //return it in PNG


        // Destroy
        ImageDestroy($nImgId);
    }
}

$oPicker = new FontPicker($_SESSION["gszFontFile"], $_GET["szSelectedFont"]);

if (isset($_GET['bPreview']) && $_GET["bPreview"]==1)
{
    $oPicker->renderFontPreview();
}
?>
