<?php
/**
 * MapBrowser application
 *
 * @project     MapLab
 * @revision    $Id: layerinfo_contents.php,v 1.7 2003/06/10 14:10:03 sacha Exp $
 * @purpose     This is the contents of the legend page.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: layerinfo_contents.php,v $
 * Revision 1.7  2003/06/10 14:10:03  sacha
 * Replaced all <? php tag to <?php
 *
 * Revision 1.6  2003/02/20 19:41:34  sacha
 *  'Added the multi lingual'
 *
 * Revision 1.5  2003/02/13 19:48:20  sacha
 * Change all php_utils to use session from phputils
 *
 * Revision 1.4  2002/11/19 21:08:24  sacha
 * seperate the body from the code
 *
 * Revision 1.3  2002/10/30 16:21:37  pspencer
 * final bug fixes
 *
 * Revision 1.2  2002/10/30 15:47:58  pspencer
 * layout fixes
 *
 * Revision 1.1  2002/10/30 13:35:05  pspencer
 * layer info dialog added
 *
 *****************************************************************************/

 define( "COMMON", "../" );
// include wrapper file(s)
include_once( COMMON."logger/logger.php" );
include_once( COMMON."wrapper/map_session.php" );
include_once( COMMON."phpwms/dbf.php" );
include_once( COMMON."session/session.php");
installSessionDirectoryHandler();
initializeSession();


/* ============================================================================
 * HTTP_FORM_VARS array contains the HTTP GET or POST parameters
 * ========================================================================= */
$http_form_vars = (count($_POST) > 0) ?
                  $_POST : ((count($_GET) > 0) ? $_GET : array() );

// Define the location of the language file.
$szLanguageResource = "./phpwms.dbf";

// create a new MLT object
$oTmpMLT = new MLTdBase( $szTempLang );
if (isset($gLogFile))
    $oTmpMLT->setLogFile( $gLogFile );
if (isset($_SESSION['gErrorManager']))
    $oTmpMLT->setErrorManager( $_SESSION["gErrorManager"] );

// load the resourcre file into memory
if (!isset($http_form_vars['szLang'])) $http_form_vars['szLang'] = "EN_CA";
$oTmpMLT->loadResource( $szLanguageResource, $http_form_vars['szLang']);
$szLang = $http_form_vars['szLang'];
              
// convert the global session reference if necessary
if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
{
    if ( version_compare( phpversion(), "4.2.1" ) < 0 )
        $_SESSION = &$HTTP_SESSION_VARS;
}

//set up a logger, note that it doesn't log anywhere :(
$oLog = new Logger( "LayerInfo" );

/* ============================================================================
* Setup the map session class (required by some actions)
* ========================================================================= */
if ( strlen( trim( $_SESSION["gszMapName"] ) ) > 0 &&
   isset( $_SESSION["gszMapName"] ) )
{

// ensure that the mapscript module is loaded
if (!extension_loaded("MapScript")) dl($_SESSION["gszPHPMapScriptModName"]);

// create a new map session object
$oMapSession = new MapSession_RW;

// set the global log file and error manager
//$oMapSession->setLogFile( $gLogFile );
//$oMapSession->setErrorManager( $_SESSION["gErrorManager"] );

// set the temp directory for the map session
$oMapSession->setTempDir( $_SESSION["gszTmpMapPath"] );


/* ============================================================================
 * Re-instate the previous map state
 * ========================================================================= */

$oMapSession->restoreState( $_SESSION["gszCurrentState"], $_SESSION["gszMapName"],
                            dirname( $_SESSION["gszMapName"] ) );

$oLayer = $oMapSession->oMap->getlayerbyname($http_form_vars['layerName']);

if ($http_form_vars['bSetStyle'] == 1)
{
    $oLayer->setMetadata("wms_style", $http_form_vars['style'][0]);
    $oMapSession->saveState();
    echo "<script>parent.close();</script>";
}

/* ============================================================================
 * get capabilities information
 * ========================================================================= */
//This section defines the location of the database files
$oWMSDatabase = new WMSDatabase($_SESSION["gszServerDataPath"]);
// open the capabilities file
$dbCap = $oWMSDatabase->getDB( DB_CAPABILITIES );

// check for failure on opening
if ( $dbCap === false )
{
    // failed so give message and return
    $oLog->error( ERR_WARNING, "Failed to open capabilities file [".
                                                        DB_CAPABILITIES."].");
    return false;
}

// locate the record
$nRecNo = $oWMSDatabase->find_record( $dbCap, "title", $oLayer->getMetadata('wms_title') );

// check if found
if ( $nRecNo === false )
{
    // not found so give error and return
    $oLog->error( ERR_WARNING, "LayerID [$nLayerID] was not found in ".
                  "capabilities file [".DB_CAPABILITIES."]." );
    dbase_close( $dbCap );
    return false;
}

// put the record into an associative array
$axCapRec = dbase_get_record_with_names( $dbCap, $nRecNo );

// close the database
dbase_close( $dbCap );

// log
$oLog->log( LOG_QUIET, "Successfully opened capabilities database." );

/* ============================================================================
* get server information
* ========================================================================= */
// open the server database
$dbServ = $oWMSDatabase->getDB( DB_SERVER );

// check for failure on opening
if ( $dbServ === false )
{
    // failed so give message and return
    $oLog->error( ERR_WARNING, "Failed to open server file [".
                  DB_SERVER."].");
    return false;
}

// locate the record
$nRecNo = $oWMSDatabase->find_record( $dbServ, "server_id", $axCapRec['server_id']);

// check if found
if ( $nRecNo === false )
{
    // not found so give error and return
    $oLog->error( ERR_WARNING, "ServerID [".$axCapRec["server_id"].
                        "] was not found in server file [".DB_SERVER."]." );
    dbase_close( $dbServ );
    return false;
}

// put the record into an associative array
$axServRec = dbase_get_record_with_names( $dbServ, $nRecNo );

// close the database
dbase_close( $dbServ );

// log
$oLog->log( LOG_QUIET, "Successfully opened server database." );
?>
<html>
<head><title><?php echo trim($oMLT->get("0", "Layer info")); ?> - <?php echo $http_form_vars["layerName"]?></title></head>
<body BGCOLOR="#E3F0F0">
<form action="layerinfo.phtml?<?php echo SID; ?>" method=post>
<?php
include("layerinfo_body.phtml");
?>
</form>
</body>
</html>
<?php
}
