<?php
/**
 * MapBrowser application
 *
 * @project     MapLab
 * @revision    $Id: dbf.php,v 1.14 2003/06/25 18:43:46 pspencer Exp $
 * @purpose     This is the dbase database management utility page.
 * @author      William A. Bronsema, C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: dbf.php,v $
 * Revision 1.14  2003/06/25 18:43:46  pspencer
 * removed whitespace
 *
 * Revision 1.13  2003/02/28 19:23:12  pspencer
 * made loading of the dbase extension mandatory.
 *
 * Revision 1.12  2002/11/28 21:28:48  sacha
 * look for a config define to include phpwms
 *
 * Revision 1.11  2002/11/19 21:04:46  julien
 * Add legendurl height, width and format for the mapcontext in the style.dbf
 *
 * Revision 1.10  2002/10/30 15:20:53  pspencer
 * fixed typos and type of abstractid field
 *
 * Revision 1.9  2002/10/30 14:17:37  pspencer
 * look for phpwms.php first
 *
 * Revision 1.8  2002/10/25 15:30:10  sacha
 * added functionality to layer browser.
 *
 * Revision 1.7  2002/10/23 03:05:44  pspencer
 * turn on all options by default
 *
 * Revision 1.6  2002/10/10 18:39:08  julien
 * Add abstract and style and
 *
 * Revision 1.5  2002/10/08 18:59:01  pspencer
 * added new field for map url
 *
 * Revision 1.4  2002/10/07 19:17:54  assefa
 * Add Extract layers fields.
 *
 * Revision 1.2  2002/06/17 18:15:12  sacha
 * moved php wms dialogs and component to php_utils.
 *
 * Revision 1.1  2002/06/14 14:32:32  sacha
 * *** empty log message ***
 *
 * Revision 1.5  2002/06/07 13:42:37  pspencer
 * updated refresh of servers to use service name if a user name is not provided
 *
 * Revision 1.3  2002/05/27 21:08:17  pspencer
 * updated layer id handling
 *
 * Revision 1.1  2002/05/16 16:52:27  bronsema
 * Initial addition
 *
 *****************************************************************************/

define( 'DB_THEME', "theme.dbf" );
define( 'DB_ALIAS', "alias.dbf" );
define( 'DB_LAYER', "layer.dbf" );
define( 'DB_FIELD', "field.dbf" );
define( "DB_SERVER","server.dbf" );
define( "DB_CAPABILITIES", "capab.dbf" );
define( "DB_BBOX", "bbox.dbf" );
define( "DB_STYLE", "style.dbf" );
//define( "SRS_DIR", $gszServerDataPath );

if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
    {
        include_once( COMMON."logger/logger.php");
        if (defined( "CONFIG_PATH" ) && is_dir( CONFIG_PATH ) &&
        file_exists(CONFIG_PATH."/phpwms.php"))
            include_once( CONFIG_PATH."/phpwms.php");
        elseif (file_exists(COMMON."phpwms/phpwms.php"))
            include_once( COMMON."phpwms/phpwms.php");
        elseif (file_exists(COMMON."phpwms/phpwms.default.php"))
            include_once( COMMON."phpwms/phpwms.default.php");
    }
    else
    {
        include_once( COMMON."/logger/logger.php");
        if (defined( "CONFIG_PATH" ) && is_dir( CONFIG_PATH) &&
        file_exists(CONFIG_PATH."/phpwms.php"))
            include_once( CONFIG_PATH."/phpwms.php");
        elseif (file_exists(COMMON."/phpwms/phpwms.php"))
            include_once( COMMON."/phpwms/phpwms.php");
        elseif (file_exists(COMMON."/phpwms/phpwms.default.php"))
            include_once( COMMON."/phpwms/phpwms.default.php");
    }
}
elseif (file_exists("../logger/logger.php"))
{
    include_once("../logger/logger.php");
    if (defined( "CONFIG_PATH" ) && is_dir( CONFIG_PATH) &&
    file_exists(CONFIG_PATH."/phpwms.php"))
        include_once( CONFIG_PATH."/phpwms.php");
    elseif (file_exists("../phpwms/phpwms.php"))
        include_once( "../phpwms/phpwms.php");
    elseif (file_exists("../phpwms/phpwms.default.php"))
        include_once("../phpwms/phpwms.default.php");
}
else
{
    include_once("./logger/logger.php");
    if (defined( "CONFIG_PATH" ) && is_dir( CONFIG_PATH) &&
    file_exists(CONFIG_PATH."/phpwms.php"))
        include_once( CONFIG_PATH."/phpwms.php");
    if (file_exists("./phpwms/phpwms.php"))
        include_once( "./phpwms/phpwms.php");
    elseif (file_exists("./phpwms/phpwms.default.php"))
        include_once("./phpwms/phpwms.default.php");
}

class WMSDatabase extends Logger
{
    var $m_szBaseDir;

    function WMSDatabase($szBaseDir)
    {
        parent::Logger("WMSDatabase");

        if (!extension_loaded("dbase"))
            dl("php_dbase.dll");

        $this->m_szBaseDir = "";

        if (is_dir(str_replace("\\", "/", realpath($szBaseDir))))
        {
            $this->m_szBaseDir = str_replace("\\","/",realpath($szBaseDir));
            if (substr($this->m_szBaseDir, -1) != "/")
                $this->m_szBaseDir .= "/";
        }
        else
            $this->error(0, "Directory ($szBaseDir) don't exist in WMSDatabase.");
    }

    /**
     * open a database by filename and return a reference to it
     *
     * @param szDBFFile string the name of the database to open
     *
     * @return int a link id for the database or false if the open failed.
     */
    function getDB( $szDBFFile )
    {
        //try to open the database (surpress error if open fails)
        $db = @dbase_open( $this->m_szBaseDir . $szDBFFile, 2 );

        //if the open fails, then try to create the database
        if ( $db == false )
        {
            $defs = $this->getDBStructure($szDBFFile);

            if ($defs != false)
            {
                $fh = fopen($this->m_szBaseDir . $szDBFFile .".struct", "w");
                fwrite($fh, serialize($defs));

                //create the database using the appropriate field definitions
                if ( !($db = dbase_create( $this->m_szBaseDir . $szDBFFile, $defs )) )
                    return false;
            }
        }

        //should only get here with a valid db handle, but if something failed, it
        //will be false anyway.
        return $db;
    }

    /**
     * Retrieve table structure
     *
     * @param szDBFFile string the name of the database to retrieve structure
     *
     * @return false if table don't exist, else return an array.
     */
    function getDBStructure($szDBFFile)
    {
        global $gaExtraFields;

        //set up fields for the database (depends on name)
        $defs = array();
        if ( $szDBFFile == DB_SERVER )
        {
            array_push( $defs, array( "server_id",   "N", 16, 0 ) );
            array_push( $defs, array( "capab_url",   "C", 255 ) );
            array_push( $defs, array( "map_url",     "C", 255 ) );
            array_push( $defs, array( "version",     "C", 64 ) );
            array_push( $defs, array( "formats",     "C", 128 ) );
            array_push( $defs, array( "name",        "C", 64 ) );
            array_push( $defs, array( "svc_title",   "C", 64 ) );
            array_push( $defs, array( "comment",     "C", 255 ) );
            array_push( $defs, array( "con_status",  "N", 1, 0 ) );
        }
        elseif ( $szDBFFile == DB_CAPABILITIES )
        {
            array_push( $defs, array( "layer_id",  "N", 16, 0, ) );
            array_push( $defs, array( "server_id", "N", 16, 0 ) );
            array_push( $defs, array( "name",      "C", 100 ) );
            array_push( $defs, array( "title",     "C", 100 ) );
            array_push( $defs, array( "srs_ids",   "C", 50 ) );

            if (defined("LAYER_ABSTRACT") && LAYER_ABSTRACT == true)
                array_push( $defs, array( "abstractid",   "N", 16, 0 ) );

            array_push( $defs, array( "ll_minx",   "N", 16, 5 ) );
            array_push( $defs, array( "ll_miny",   "N", 16, 5 ) );
            array_push( $defs, array( "ll_maxx",   "N", 16, 5 ) );
            array_push( $defs, array( "ll_maxy",   "N", 16, 5 ) );
            array_push( $defs, array( "bbox_id",   "N", 16, 0 ) );

            if (defined("LAYER_STYLE") && LAYER_STYLE == true)
                array_push( $defs, array( "style_id",   "N", 16, 0 ) );

            array_push( $defs, array( "depth",     "C", 12 ) );
            array_push( $defs, array( "queryable", "N", 1, 0 ) );

            if (defined("EXTRACTABLE_LAYER") && EXTRACTABLE_LAYER == true)
            {
                array_push( $defs, array( "extractabl", "N", 1, 0));
                array_push( $defs, array( "datatype", "C", 20));
                array_push( $defs, array( "formats", "C", 255));
                array_push( $defs, array( "extracturl","C", 255 ) );
            }
        }
        elseif ( $szDBFFile == DB_BBOX )
        {
            array_push( $defs, array( "bbox_id",   "N", 16, 0 ) );
            array_push( $defs, array( "SRS",       "C", 64 ) );
            array_push( $defs, array( "minx",      "N", 16, 5 ) );
            array_push( $defs, array( "miny",      "N", 16, 5 ) );
            array_push( $defs, array( "maxx",      "N", 16, 5 ) );
            array_push( $defs, array( "maxy",      "N", 16, 5 ) );
            array_push( $defs, array( "next_id",   "N", 16, 0 ) );
        }
        elseif ( $szDBFFile == DB_STYLE )
        {
            array_push( $defs, array( "style_id",  "N", 16, 0 ) );
            array_push( $defs, array( "name",      "C", 100 ) );
            array_push( $defs, array( "title",     "C", 100 ) );
            array_push( $defs, array( "legendurl", "C", 255 ) );
            array_push( $defs, array( "leg_height","N", 16, 0 ) );
            array_push( $defs, array( "leg_width", "N", 16, 0 ) );
            array_push( $defs, array( "leg_format","C", 255 ) );
            array_push( $defs, array( "stylesheet","C", 255 ) );
            array_push( $defs, array( "styleurl",  "C", 255 ) );
            array_push( $defs, array( "next_id",   "N", 16, 0 ) );
        }
        elseif ( $szDBFFile == DB_THEME )
        {
            array_push( $defs, array( "theme_id",  "N", 16, 0 ) );
            array_push( $defs, array( "parent_id", "N", 16, 0 ) );
            array_push( $defs, array( "position",  "N", 16, 0 ) );
            array_push( $defs, array( "en_name",   "C", 30 ) );
            array_push( $defs, array( "fr_name",   "C", 30 ) );
        }
        elseif ( $szDBFFile == DB_ALIAS )
        {
            array_push( $defs, array( "alias_id",  "N", 16, 0 ) );
            array_push( $defs, array( "theme_id",  "N", 16, 0 ) );
            array_push( $defs, array( "position",  "N", 16, 0 ) );
            array_push( $defs, array( "en_name",   "C", 30 ) );
            array_push( $defs, array( "fr_name",   "C", 30 ) );
            array_push( $defs, array( "icon",      "C", 255 ) );
        }
        elseif ( $szDBFFile == DB_LAYER )
        {
            array_push( $defs, array( "layer_id",  "N", 16, 0 ) );
            array_push( $defs, array( "alias_id",  "N", 16, 0 ) );
            array_push( $defs, array( "position",  "N", 16, 0 ) );
            array_push( $defs, array( "en_name",   "C", 30 ) );
            array_push( $defs, array( "fr_name",   "C", 30 ) );
            array_push( $defs, array( "icon",      "C", 255 ) );
            array_push( $defs, array( "scale_min", "N", 16, 0 ) );
            array_push( $defs, array( "scale_max", "N", 16, 0 ) );
            array_push( $defs, array( "geo_field",   "C", 16 ) );
            array_push( $defs, array( "server_id", "N", 16, 0 ) );
            array_push( $defs, array( "name",      "C", 100 ) );
            array_push( $defs, array( "title",     "C", 100 ) );
            array_push( $defs, array( "srs_ids",   "C", 50 ) );
            array_push( $defs, array( "ll_minx",   "N", 16, 0 ) );
            array_push( $defs, array( "ll_miny",   "N", 16, 0 ) );
            array_push( $defs, array( "ll_maxx",   "N", 16, 0 ) );
            array_push( $defs, array( "ll_maxy",   "N", 16, 0 ) );
            array_push( $defs, array( "bbox_id",   "N", 16, 0 ) );
        }
        elseif ( $szDBFFile == DB_FIELD )
        {
            array_push( $defs, array( "field_id",  "N", 16, 0 ) );
            array_push( $defs, array( "layer_id",  "N", 16, 0 ) );
            array_push( $defs, array( "position",  "N", 16, 0 ) );
            array_push( $defs, array( "selected",  "N", 16, 0 ) );
            array_push( $defs, array( "fld_name",  "C", 30 ) );
            array_push( $defs, array( "en_name",   "C", 30 ) );
            array_push( $defs, array( "fr_name",   "C", 30 ) );
        }
        elseif ( $szDBFFile == DB_DATA )
        {
            array_push( $defs, array( "dbf_id",     "N", 16, 0 ) );
            array_push( $defs, array( "data_file",  "C", 50 ) );
            array_push( $defs, array( "geo_field",  "C", 16 ) );
            array_push( $defs, array( "layer_id",   "N", 16, 0 ) );
        }
        else //unknown database, return false
        {
            trigger_error( "unrecognized database name ($szDBFFile)");
            return false;
        }

        if (isset($gaExtraFields[$szDBFFile]) &&
            is_array($gaExtraFields[$szDBFFile]) &&
            count($gaExtraFields[$szDBFFile]) > 0)
            $defs = array_merge($defs, $gaExtraFields[$szDBFFile]);

        return $defs;
    }

    /**
     * search the database for a szKey containing a mValue
     *
     * returns the record number for the first record found or false if no record
     * was found
     *
     * @param hDB int the database identifier
     *
     * @param szKey string the field name to look it
     *
     * @param mValue mixed the mValue to look for in the field
     *
     * @param nStartRow int the row to start at (for multiple finds)
     *
     * @return int the record number or false if not found
     */
    function find_record( $hDB, $szKey, $mValue, $nStartRow = 1 )
    {
        $nrecs = dbase_numrecords( $hDB );

        if ( $nrecs == 0 )
            return false;

        //make sure nStartRow is valid
        if ($nStartRow < 1) $nStartRow = 1;
        if ($nStartRow > $nrecs) $nStartRow = $nrecs;


        for ($i = $nStartRow; $i <= $nrecs; $i++ )
        {
            $rec = dbase_get_record_with_names( $hDB, $i );
            if ( trim($rec[$szKey]) == trim($mValue) ||
                 strcmp(trim( $rec[$szKey] ),trim( $mValue )) == 0)
            {
                return $i;
            }
        }
        return false;
    }

    /**
     * returns first row in $db for which $fld containing $id or false
     *
     * @param $db integer a link id for an open database
     *
     * @param $fld string the name of the field to look in
     *
     * @param $id mixed the value to look for
     *
     * @return integer the row number where $id was found or false if not found.
     */
    function validate_id( $db, $fld, $id )
    {
        $nrecs = dbase_numrecords( $db );
        for ($i = 1; $i <= $nrecs; $i++ )
        {
            $rec = dbase_get_record_with_names( $db, $i );
            if ( $rec[$fld] == $id  ||
                 strcasecmp( trim($rec[$fld]), trim($id) ) == 0)
            {
                return $i;
            }
        }
        return false;
    }

    /**
     * return an array of values from a db by a common field value.
     *
     * This routine searchs a database for a particular value in a particular field
     * and returns an array of values from another field in matched records
     *
     * @param db_name string the name of the database to search
     *
     * @param match_field string the name of the field to match
     *
     * @param match_value mixed the value to look for in the match field
     *
     * @param extract_field string the name of the field to return values from
     *
     * @param extra_filter_field string the name of the field to additionally match
     *
     * @param extra_filter_value mixed the value to look for in the additional
     * match field
     *
     * @param b_return_all boolean flag to indicate if filter is required
     *
     * @return array of values or false if an error occurred.
     *
     */
    function list_records( $db_name, $match_field, $match_value, $extract_field,
                           $extra_filter_field = "", $extra_filter_value = "",
                           $b_return_all = false)
    {
        //array for return values
        $values = array();

        //open the database
        $db = $this->getDB( $db_name );
        if ( $db == false )
        {
            trigger_error( "getDB( $db_name ) failed in _extract_list",
                           ERROR );
            return false;
        }

        //loop through records looking for ones with parent_id = theme_id
        $nrecs = dbase_numrecords( $db );
        for ($i = 1; $i <= $nrecs; $i++ )
        {
            $rec = dbase_get_record_with_names( $db, $i );

            // return all necessary
            if ($b_return_all)
            {
                //just add
                $values[$i] = $rec[$extract_field];

            }
            elseif ( $extra_filter_field != "" && $extra_filter_value != "" )
            {
                // use extra filter criteria
                if ( $rec[$match_field] == $match_value &&
                     $rec[$extra_filter_field] == $extra_filter_value )
                {
                    $position = $rec['position'];
                    $values[$position] = $rec[$extract_field];
                }
            }
            else
            {
                // no extra filter necessary
                if ( $rec[$match_field] == $match_value  )
                {
                    $position = $rec['position'];
                    $values[$position] = $rec[$extract_field];
                }
            }
        }
        //all done, close the db and return the result (which could be
        //an empty array)
        dbase_close( $db );
        ksort( $values );

        return $values;
    }


    /**
     * return one field value from a db by looking up another field value
     *
     * @param db_name string the name of the database to search
     *
     * @param match_field string the name of the field to match
     *
     * @param match_value mixed the value to look for in the match field
     *
     * @param extract_field string the name of the field to return the value from
     *
     * @return value of the field or false if an error occurred.
     */
    function get_info( $db_name, $match_field, $match_value, $extract_field )
    {
        //open the database
        if ( !($db = $this->getDB( $db_name )) )
        {
            trigger_error( "getDB( $db_name ) failed in get_info");
            return false;
        }

        //find the matching row
        if ( !($rec = $this->validate_id( $db, $match_field, $match_value )) )
        {
            trigger_error( "get_info found no key ($match_value) in field " .
                           "$match_field in database $db_name." );
            return false;
        }

        //get the info
        $row = dbase_get_record_with_names( $db, $rec );

        if ($extract_field == null)
        {
            array_pop( $row );
            return $row;
        }
        elseif (in_array( $extract_field, $row ))
            return trim($row[$extract_field]);
        else
        {
            trigger_error( "invalid field name ($extract_field) in _get_info" );
            return false;
        }
    }

    /**
     * sets a key = value pair for the given record in the given db.
     *
     * @param rec integer the row number to set the key = value pair on
     * @param key integer the field name to set
     * @param value integer the value to set
     * @return boolean true if the update succeeded, false otherwise
     */
    function setInfo( $db, $rec, $key, $value )
    {
        $result = true;

        //how do we detect an invalid row?
        $row = dbase_get_record_with_names( $db, $rec );
        //remove 'deleted' item
        array_pop( $row );

        if (in_array( $key, array_keys($row) ))
        {
            //update the value
            $row[$key] = $value;
            //replace the record (this can fail)
            if (!dbase_replace_record( $db, array_values( $row ),  $rec ))
            {
                trigger_error( "dbase_replace_record failed in _set_info");
                $result = false;
            }
        }
        else
        {
            trigger_error( "invalid key ($key) in _set_info" );
            $result = false;
        }
        return $result;
    }

    /**
     * assumes a numeric field, will find the maximum value in that field of
     * all records in the dbf file by scanning every line (blah).  Intended
     * primarily for scanning ID fields.
     *
     * @param hDB integer the PHP identifier for the database (must be open)
     * @param szField string the name of the field to scan.
     *
     * @result integer the maximum value or false if it failed.
     */
    function findMaxValue( $hDB, $szField )
    {
        $result = false;

        $nRec = dbase_numrecords($hDB);

        if ($nRec > 0)
        {
            $nCurrent = 1;
            $rec = dbase_get_record_with_names( $hDB, $nCurrent );
            if ( !isset($rec[$szField] ) )
            {
                trigger_error( "findMaxValue: $szField is not a valid field" );
                return false;
            }
            $result = $rec[$szField];
            while ( $nCurrent < $nRec )
            {
                $nCurrent++;
                $rec = dbase_get_record_with_names( $hDB, $nCurrent );
                $result = max( $result, $rec[$szField] );
            }
        }

        return $result;
    }

    /**
     *  Delete all tables
     */
    function dropTable($szTableName="")
    {
        if ($szTableName == "" || $szTableName == DB_SERVER)
            @unlink($this->m_szBaseDir . DB_SERVER);

        if ($szTableName == "" || $szTableName == DB_THEME)
            @unlink($this->m_szBaseDir . DB_THEME);

        if ($szTableName == "" || $szTableName == DB_ALIAS)
            @unlink($this->m_szBaseDir . DB_ALIAS);

        if ($szTableName == "" || $szTableName == DB_LAYER)
            @unlink($this->m_szBaseDir . DB_LAYER);

        if ($szTableName == "" || $szTableName == DB_FIELD)
            @unlink($this->m_szBaseDir . DB_FIELD);

        if ($szTableName == "" || $szTableName == DB_CAPABILITIES)
            @unlink($this->m_szBaseDir . DB_CAPABILITIES);

        if ($szTableName == "" || $szTableName == DB_BBOX)
            @unlink($this->m_szBaseDir . DB_BBOX);

        if ($szTableName == "" || $szTableName == DB_STYLE)
            @unlink($this->m_szBaseDir . DB_STYLE);
    }
}
?>
