<?php
/**
 * WatershedService   Class definition for WaterShed search service
 *
 * @project     CISE Viewer
 * @revision    $Id: watershed_server.php,v 1.3 2004/06/18 14:58:43 pspencer Exp $
 * @purpose     Class definition of WaterShed search service.
 * @author      Paul Spencer (pspencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * Check for a defined COMMON variable containing the absolute path.  If not 
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
        include_once( COMMON."phpgeocoder/web_service.php");
    else
        include_once( COMMON."/phpgeocoder/web_service.php");
}
elseif (file_exists("../web_service.php"))
{
    include_once("../web_service.php");
}
else
{
    include_once("./web_service.php");
} 

class WatershedServer extends WebSearchService
{
    var $bFound = false;
    var $nIndex;
    var $bInWatershed = false;

    function WatershedServer($oGeoCoder="")
    {
        parent::WebSearchService("WATERSHED_SERVER", $oGeoCoder, "http://devgeo.cciw.ca:8080/WatershedLookupServlet/WatershedLookupServlet");

        $this->nIndex = 0;
    }

    function search()
    {
        global $aszCanadianProvince;

        $this->szParameters = "version=1.0.0&request=GetWatershed&";

        foreach ($this->oGeoCoder->aoSearchAttribute as $oAttribute)
        {
            if ($oAttribute->getName() == "CODE")
            {
                $this->szParameters .= "code=".urlencode($oAttribute->getValue())."&";

                $bFound = true;
            }
        }

        if (parent::search())
        {
            // Parse respond
            $xml_parser = xml_parser_create();
            xml_set_object($xml_parser, $this);
            xml_set_character_data_handler($xml_parser, "characterData");
            xml_set_element_handler($xml_parser, "startElement", "endElement");

            if (!xml_parse($xml_parser, $this->szRawResult)) 
            {
                die(sprintf("XML error: %s at line %d",
                xml_error_string(xml_get_error_code($xml_parser)),
                xml_get_current_line_number($xml_parser)));
            }

            xml_parser_free($xml_parser);
        }
    }

    function characterData($oParser, $szData) 
    {
        $this->szLastValue = utf8_decode($szData);
    }

    function startElement($oParser, $szName, $szAttrs) 
    {
        if (strcasecmp( $szName, "WatershedLookupResultSet" ) == 0)
        {
            $this->bFound = true;
            $oRes = new Result();
            array_push($this->aoResult, $oRes); 
            $this->nIndex = count($this->aoResult) - 1;
        }
        
        if (strcasecmp( $szName, "Watershed" ) == 0)
        {
            $this->bInWatershed = true;
        }
    }

    function endElement($oParser, $szName) 
    {
        if ( strcasecmp($szName, "WatershedLookupResultSet") == 0)
            $this->bFound = false;
            
        if ($this->bFound)
        {    
            if ($this->bInWatershed)
            {
                if (strcasecmp( $szName, "Watershed" ) == 0)
                    $this->bInWatershed = false;
                
                if (strcasecmp( $szName, "gml:name" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("WATERSHED_NAME", $this->szLastValue));

                if (strcasecmp( $szName, "watershedType" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("WATERSHED_TYPE", $this->szLastValue));

                if (strcasecmp( $szName, "nameEn" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("NAME_EN", $this->szLastValue));
        
                if (strcasecmp( $szName, "nameFr" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("NAME_FR", $this->szLastValue));
        
                if (strcasecmp( $szName, "watershedType" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("WATERSHED_TYPE", $this->szLastValue));

                if (strcasecmp( $szName, "sda" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("SDA", $this->szLastValue));
            
                if (strcasecmp( $szName, "sdaNameEn" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("SDA_NAME_EN", $this->szLastValue));
               
                if (strcasecmp( $szName, "sdaNameFr" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("SDA_NAME_FR", $this->szLastValue));
               
                if (strcasecmp( $szName, "mda" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("MDA", $this->szLastValue));
            
                if (strcasecmp( $szName, "mdaNameEn" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("MDA_NAME_EN", $this->szLastValue));
               
                if (strcasecmp( $szName, "mdaNameFr" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("MDA_NAME_FR", $this->szLastValue));
               
                if (strcasecmp( $szName, "pop2001" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("POP2001", $this->szLastValue));
            
                if (strcasecmp( $szName, "res2001" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("RES2001", $this->szLastValue));
               
                if (strcasecmp( $szName, "oceanEn" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("OCEAN_EN", $this->szLastValue));
                
                if (strcasecmp( $szName, "oceanFr" ) == 0)
                    $this->aoResult[$this->nIndex]->addAttribute(new SearchAttribute("OCEAN_FR", $this->szLastValue));

                if (strcasecmp( $szName, "gml:coordinates") == 0 )
                {
                    $aszLatLong = explode(",", $this->szLastValue);
                    $nPoints = count($aszLatLong);
                    $oPolygon = new Polygon( );
                    for ($i=0; $i < $nPoints; $i += 2)
                    {
                        if (isset($aszLatLong[$i]) && isset($aszLatLong[$i+1]))
                        {
                            $oPolygon->addPoint( $aszLatLong[$i], $aszLatLong[$i+1] );
                        }
                    }
                    $this->aoResult[$this->nIndex]->addAttribute($oPolygon);
                }
                 
            }

        
            else
            {
                if (strcasecmp( $szName, "gml:coordinates") == 0 )
                {
                    $aszLatLong = explode(",", $this->szLastValue);
                    $this->aoResult[$this->nIndex]->addAttribute(new BBox($aszLatLong[0], $aszLatLong[1], $aszLatLong[2], $aszLatLong[3]));
                }
            }
        }
    }
}
?>
