<?php
/**
 * PostalCodeServer  Class definition of postalcode server search service
 *
 * @project     PHPGeoCoder
 * @revision    $Id:
 * @purpose     Class definition of postalcode search service.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * Check for a defined COMMON variable containing the absolute path.  If not 
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
        include_once( COMMON."phpgeocoder/web_service.php");
    else
        include_once( COMMON."/phpgeocoder/web_service.php");
}
elseif (file_exists("../web_service.php"))
{
    include_once("../web_service.php");
}
else
{
    include_once("./web_service.php");
}

class PostalCodeServer extends WebSearchService
{
    var $bFound = false;
    var $szLastError = "";
    var $nLastError = "";

    function PostalCodeServer($oGeoCoder)
    {
        parent::WebSearchService("POSTALCODE_SERVER", $oGeoCoder, 
                                 "http://ceonet.gc.ca/postalcodeserver");
    }

    /**
     *  Postal code search server protocol is very simple. Just
     *  send a parameter "code=???" where ??? is the first three 
     *  letter of you canadian postal code. EG: if postalcode is
     *  G7S2X6 then "...code=g7s" should do the thing.
     */
    function search()
    {
        $bCanGo = false;
        $bInCanada = true;

        // Scan all attributes
        foreach ($this->oGeoCoder->aoSearchAttribute as $oAttribute)
        {
            // Only postal code is used
            if ($oAttribute->szName == "POSTAL_CODE")
            {
                $this->szParameters = "code=".urlencode($oAttribute->szValue);
                $this->szParameters .= "&version=1.0.0";
                $this->szParameters .= "&request=GetPostalCode";
                $this->szParameters .= "&sortarea=FSA";
                $bCanGo = true;
            }

            if ($oAttribute->getName() == "COUNTRY" &&
                $oAttribute->getValue() != "CA")
            {
                $bInCanada = false;
            }

            if ($bCanGo && $bInCanada)
            {
                if (parent::search())
                {
                    // Parse respond
                    $xml_parser = xml_parser_create();
                    xml_set_object($xml_parser, $this);
                    xml_set_character_data_handler($xml_parser, "characterData");
                    xml_set_element_handler($xml_parser, "startElement", "endElement");

                    if (!xml_parse($xml_parser, $this->szRawResult)) 
                    {
                        die(sprintf("XML error: %s at line %d",
                        xml_error_string(xml_get_error_code($xml_parser)),
                        xml_get_current_line_number($xml_parser)));
                    }

                    xml_parser_free($xml_parser);
                }
            }
        }
        
        // If an error occure, send the last error.
        // Dont send error if no record found.
        if ($this->nLastError != "" && $this->nLastError != "12010")
        {
            $this->error(ERR_WARNING, $this->szLastError);
        }
    }

    function characterData($oParser, $szData) 
    {
        $this->szLastValue = $szData;
    }

    function startElement($oParser, $szName, $szAttrs) 
    {

    }

    function endElement($oParser, $szName) 
    {
        if ($szName == "ERRORMESSAGE" && trim($this->szLastValue) != "")
        {
            // Error
            $this->szLastError = $this->szLastValue;
        }
        if ($szName == "ERRORCODE" && trim($this->szLastValue) != "")
        {
            // Error
            $this->nLastError = $this->szLastValue;
        }

        if ($szName == "PLACENAME" && trim($this->szLastValue) != "")
        {
            if (!isset($this->aoResult[0]))
                array_push($this->aoResult, new Result()); 

            $this->bFound = true;

            $this->aoResult[0]->addAttribute(new PlaceName($this->szLastValue));
        }

        if (($szName == "PROVINCEORTERRITORY" || $szName == "PROVINCE")
            && trim($this->szLastValue) != "")
        {
            if (!isset($this->aoResult[0]))
                array_push($this->aoResult, new Result()); 

            $this->bFound = true;

            $this->aoResult[0]->addAttribute(new StateProvince($this->szLastValue));
        }

        if ($szName == "GML:COORDINATES" && $this->bFound)
        {
            if (!isset($this->aoResult[0]))
                array_push($this->aoResult, new Result()); 

            $aszLatLong = explode(",", $this->szLastValue);
            $this->aoResult[0]->addAttribute(new LatLong($aszLatLong[0], $aszLatLong[1]));
        }

    }
}
?>
