<?php
/**
 * NTSService   Class definition for NTS search service
 *
 * @project     PHPGeoCoder
 * @revision    $Id:
 * @purpose     Class definition of NTS search service.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * Check for a defined COMMON variable containing the absolute path.  If not 
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
        include_once( COMMON."phpgeocoder/web_service.php");
    else
        include_once( COMMON."/phpgeocoder/web_service.php");
}
elseif (file_exists("../web_service.php"))
{
    include_once("../web_service.php");
}
else
{
    include_once("./web_service.php");
} 

class NTSServer extends WebSearchService
{
    var $nIndex;
    var $bNTSLookupFound = false;
    var $bQuadFound = false;
    var $bNeatLineFound = false;
    var $mnScale = "";

    function NTSServer($oGeoCoder="")
    {
        parent::WebSearchService("NTS_SERVER", $oGeoCoder, "http://geoservices.cgdi.ca/NTS/NTSLookup");

        $this->nIndex = 0;
    }

    function search()
    {
        $this->szParameters = "version=1.1.0&request=GetMapsheet&";

        foreach ($this->oGeoCoder->aoSearchAttribute as $oAttribute)
        {
            if ($oAttribute->getName() == "MAP_SHEET")
            {
                $this->szParameters .= "mapsheet=".urlencode($oAttribute->getValue())."&";

                $bFound = true;
            }
        }

        if (parent::search())
        {
            // Parse respond
            $xml_parser = xml_parser_create();
            xml_set_object($xml_parser, $this);
            xml_set_character_data_handler($xml_parser, "characterData");
            xml_set_element_handler($xml_parser, "startElement", "endElement");

            xml_parse($xml_parser, $this->szRawResult);

            xml_parser_free($xml_parser);
        }
    }

    function characterData($oParser, $szData) 
    {
        if (trim($szData) != "")
            $this->szLastValue = utf8_decode(trim($szData));
    }

    function startElement($oParser, $szName, $aszAttrs) 
    {
        if ($szName == "NTSLOOKUP")
        {
            $this->bNTSLookupFound = true;
        }
        if ($szName == "NTSRESULTSET")
        {
            if (isset($aszAttrs['SCALE']))
            {
                $this->mnScale = $aszAttrs['SCALE'];
            }
        }

        if ($szName == "NTSQUADRANGLE")
        {
            $this->bQuadFound = true;
        }

        if ($szName == "NTSNEATLINE")
        {
            $this->bNeatLineFound = true;
        }

        if ($szName == "GML:LINEARRING")
        {
            if (isset($aszAttrs['SRSNAME']) > 0 && 
                ($this->bQuadFound == true || $this->bNeatLineFound == true))
            {
                if (strtoupper($aszAttrs['SRSNAME']) != "EPSG:4326")
                {
                    $this->setError(ERR_WARNING, "Only EPGS:4326 is supported");

                    if ($this->bQuadFound)
                        $this->bQuadFound = false;

                    if ($this->bNeatLineFound)
                        $this->bNeatLineFound = false;
                }
            }
        }
    }

    function endElement($oParser, $szName) 
    {
        if ($szName == "NTSQUADRANGLE")
            $this->bQuadFound = false;

        if ($szName == "NTSNEATLINE")
            $this->bNeatLineFound = false;

        if ($szName == "NTSRESULTSET")
        {
            if (!isset($this->aoResult[0]))
                $this->aoResult[0] = new Result();

            $this->aoResult[0]->addAttribute(new Scale($this->mnScale));
        }

        if ($szName == "GML:COORDINATES")
        {
            $aszCoords = explode(" ", trim($this->szLastValue));
            
            if ($this->bQuadFound && count($aszCoords) == 5)
            {
                $ac1 = explode(",", $aszCoords[0]);
                $ac2 = explode(",", $aszCoords[2]);
                $this->aoResult[0]->addAttribute(
                        new BBox($ac1[0], $ac1[1], $ac2[0], $ac2[1]));
            }
            elseif ($this->bNeatLineFound)
            {
              // not supported yet
            }
        }

        if ($szName == "SCALE")
            $this->aoResult[0]->addAttribute(new Scale($this->szLastValue));

        if ($szName == "GML:NAME" || $szName == "NTSNUMBER")
        {
            if (!isset($this->aoResult[0]))
                $this->aoResult[0] = new Result();

            $this->aoResult[0]->addAttribute(new MapSheet($this->szLastValue));
        }
    }
}
?>
