<?php
/**
 * PHPGeoCoder main class
 *
 * @project     PHPGeoCoder
 * @revision    $Id:
 * @purpose     Main application class definition of PHP GeoCoder
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * Check for a defined COMMON variable containing the absolute path.  If not 
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
        include_once( COMMON."logger/logger.php");
    else
        include_once( COMMON."/logger/logger.php");
}
elseif (file_exists("../logger/logger.php"))
{
    include_once("../logger/logger.php");
}
else
{
    include_once("./logger/logger.php");
} 

include_once("service.php");
include_once("attribute.php");


class PHPGeoCoder extends Logger
{
    var $aoSearchService;    // List all registered search services
    var $aoSearchAttribute;  // List all search attributes

    function PHPGeoCoder()
    {
        parent::Logger("PHPGeoCoder");

        // initialize some array
        $this->aoSearchService = array();
        $this->aoSearchAttribute = array();
    }

    /**
     * This function register a new search service.
     */ 
    function addSearchService($oSearchService)
    {
        $this->log(LOG_VERBOSE, "Adding search service (".$oSearchService->szName.")");

        if (!isset($oSearchService->oErrorManager))
            $oSearchService->oErrorManager =& $this->oErrorManager;

        array_push($this->aoSearchService, $oSearchService);
    }

    /**
     *  This function add a new search attribute
     */
    function addSearchAttribute($oSearchAttribute)
    {
        $this->log(LOG_VERBOSE, "Adding search attribute (".$oSearchAttribute->szName." \"$oSearchAttribute->szValue\")");

        array_push($this->aoSearchAttribute, $oSearchAttribute);
    }

    /**
     *  This function search for match of attributes in 
     *  search services.
     */
    function searchServices($szServiceName="", 
                            $bStopOnSuccess=true,
                            $bIntelligentSearch=false)
    {
        $this->log(LOG_VERBOSE, "searchServices($szServiceName, $bStopOnSuccess, $bIntelligentSearch)");

        $this->resetSearchServices($szServiceName);

        foreach(array_keys($this->aoSearchService) as $szKey)
        {
            if (($szServiceName != "" && 
                 $this->aoSearchService[$szKey]->szName == $szServiceName) ||
                ($szServiceName == ""))
            {
                $this->aoSearchService[$szKey]->search();

                if (count($this->aoSearchService[$szKey]->aoResult) > 0 && $bStopOnSuccess)
                    break;
            }
        }
    }

    /**
     *  This function reset search to initial state.
     */
    function resetSearchServices($szServiceName="")
    {
        $this->log(LOG_VERBOSE, "resetSearchServices($szServiceName)");

        foreach(array_keys($this->aoSearchService) as $szKey)
        {
            if (($szServiceName != "" && 
                 $this->aoSearchService[$szKey]->szName == $szServiceName) ||
                ($szServiceName == ""))
            {
                $this->aoSearchService[$szKey]->reset();
            }
        }
    }

    /**
     *  Return number of results
     */
    function getNumResult($szServiceName="")
    {
        $this->log(LOG_VERBOSE, "getNumResult($szServiceName)");

        $nCount = 0;

        foreach(array_keys($this->aoSearchService) as $szKey)
        {
            if (($szServiceName != "" && 
                 $this->aoSearchService[$szKey]->szName == $szServiceName) ||
                ($szServiceName == ""))
            {
                $nCount = $nCount + count($this->aoSearchService[$szKey]->aoResult);
            }
        }

        return $nCount;
    }

    /**
     *  Return a array of result.
     */
    function getResult($szServiceName="")
    {
        $this->log(LOG_VERBOSE, "getResult($szServiceName)");

        $aoResult = array();

        foreach(array_keys($this->aoSearchService) as $szKey)
        {
            if (($szServiceName != "" && 
                 $this->aoSearchService[$szKey]->szName == $szServiceName) ||
                ($szServiceName == ""))
            {
                $aoResult = array_merge($aoResult, $this->aoSearchService[$szKey]->aoResult);
            }
        }

        return $aoResult;
    }
}
?>
