<?php
/**
 * DBFService   Abstract class definition
 *
 * @project     PHPGeoCoder
 * @revision    $Id:
 * @purpose     Abstract class definition of DBF service.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once("database_service.php");

class DBFService extends DatabaseService
{
    var $oDBFConnection;

    function DBFService($szSearchServiceName="", $oGeoCoder="", 
                        $szDBFFileName="")
    {
        parent::DatabaseService($szSearchServiceName, $oGeoCoder, 
                                "file=".$szDBFFileName);

        $this->log(LOG_VERBOSE, "DatabaseService($szSearchServiceName, 
                                 $oGeoCoder, $szDBFFileName)");

        $this->oDBFConnection = false;
    }

    function connect()
    {
        $this->log(LOG_VERBOSE, "connect()");

        $aDSN = explode(",", $this->szDSN);
        foreach($aDSN as $szParam)
        {
            $aParam = explode("=", $szParam);
            if ($aParam[0] == "file")
            {
                // Check if file exist
                if (file_exists($aParam[1]))
                    $this->oDBFConnection = dbase_open($aParam[1], 0);
                else
                    $this->error(ERR_FILEIO, "DBF file (".$aParam[1].") 
                                              does'nt exist.");
            }
        }

        if ($this->oDBFConnection == false)
        {
            $this->error(ERR_CRITICAL, "Can't open DBF.");
            return false;
        }

        return true;
    }
}

?>
