<?php
/**
 * Edit Resources
 * 
 * @project     PHP Utilities
 * @revision    $Id: edit_resources.php,v 1.3 2002/03/07 03:31:30 bronsema Exp $
 * @purpose     This file contains functions edit a given resource file.
 * @author      William A. Bronsema, C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2001, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: edit_resources.php,v $
 * Revision 1.3  2002/03/07 03:31:30  bronsema
 * Finished construction.
 *
 * Revision 1.2  2002/03/06 17:49:18  bronsema
 * Updated to use a radio button interface and minor javascript
 *
 * Revision 1.1  2002/03/06 16:38:52  bronsema
 * Initial creation
 *
 * Revision 1.1  2002/03/05 20:41:24  bronsema
 * Initial Creation
 *
 *****************************************************************************/

// include the global preferences file
include_once( "globprefs.php" );

// open the dbase file (surpress any errors)
$db = dbase_open( RESOURCE_FILE, 2 );

// get a record count
$nNumRecords = dbase_numrecords( $db );

// initialize ID
$szID = "";

/* ============================================================================
 * build an array with the HTTP GET or POST parameters
 * ========================================================================= */
// check for POST vars
if (sizeof($HTTP_POST_VARS) > 0)
{
    // found so use
    $http_form_vars = $HTTP_POST_VARS;
}
// otherwise check for GET vars
else if (sizeof($HTTP_GET_VARS) > 0)
{
    // found so use
    $http_form_vars = $HTTP_GET_VARS;
}
// otherwise create an empty array
else
{
    $http_form_vars = array();
}

/* ============================================================================
 * process an edit request
 * ========================================================================= */
if ( isset( $http_form_vars["go_edit"] ) && $http_form_vars["type"] == "edit")
{
    // check to see if the id is numeric
    if ( is_numeric( $http_form_vars["id"] ) )
    {
        // check if id is valid
        if ( $http_form_vars["id"] > 0 && 
             $http_form_vars["id"] <= $nNumRecords )
        {
            // set the values
            $szID = $http_form_vars["id"];
            $szEnglish = trim( $oMLT->get( $szID, ENGLISH ) );
            $szFrench = trim( $oMLT->get( $szID, FRENCH ) );
            $szRef = trim( $oMLT->get( $szID, -99 ) );
          
        }
        else
        {
            // id is invalid for edit give error
            $oMLT->error(ERR_CRITICAL,"The ID[".$http_form_vars["id"].
                                                        "] is not valid.");
        // end valid check
        }

    }
    else
    {
            // id is invalid for edit give error
            $oMLT->error(ERR_CRITICAL,"The ID[".$http_form_vars["id"].
                                                        "] is not numeric.");
    // end is_numeric check
    }
}

/* ============================================================================
 * process an new request
 * ========================================================================= */
if ( isset( $http_form_vars["go_edit"] ) && $http_form_vars["type"] == "new")
{
    // just set the new ID
    $szID = $nNumRecords + 1;
}

/* ============================================================================
 * process an add request
 * ========================================================================= */
if ( isset( $http_form_vars["add"] ) )    
{
    // set the values to add
    $aRec[0] = $http_form_vars["english"];
    $aRec[1] = $http_form_vars["french"];
    
    // add the resource
    $oMLT->addResource( $aRec, $http_form_vars["ref"] );
}

/* ============================================================================
 * process an update request
 * ========================================================================= */
if ( isset( $http_form_vars["update"] ) )    
{
    // set the values to add
    $aRec[0] = $http_form_vars["english"];
    $aRec[1] = $http_form_vars["french"];
    
    // add the resource
    $oMLT->setResource( $http_form_vars["id"], $aRec, $http_form_vars["ref"] );
}

/* ============================================================================
 * process a remove request
 * ========================================================================= */
if ( isset( $http_form_vars["remove"] ) )    
{
    // through the database and remove all records
    for ( $i=1; $i<=$nNumRecords; $i++ )
    {
        dbase_delete_record( $db, $i );
    }
        
}

/* ============================================================================
 * process a pack request
 * ========================================================================= */
if ( isset( $http_form_vars["pack"] ) )    
{
    // pack the database
    dbase_pack($db);
}

// reset record count to reflect any changes
$nNumRecords = dbase_numrecords( $db );

// close the database
dbase_close($db);

?>