<?php
/****************************************************************************** 
 * $Id: dbf_nav.php,v 1.2 2003/06/10 14:10:03 sacha Exp $ 
 *
 * Name   : dbf_nav.php
 * Project: NHSI Public Health Map Generator
 * Purpose: displays HTML table for a DBF file and allows user to navigate the
 *          recordset.
 * Author : Paul Spencer - pspencer@dmsolutions.ca
 *
 ******************************************************************************
 * Copyright (c) 2001, DM Solutions Group Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/

/**
 * output a nicely formatted table and navigation tools for a dbf file.
 *
 * This function provides a preview of the contents of a dbf file in a
 * table format with the field names across the top and a number of rows
 * of the data.  It is displayed inside a form and has rowset navigation
 * to allow the user to move to different parts of the dbf file and to
 * change the number of rows visible at any one time.
 *
 * @param szDBFFile string the path/name of the dbf file to open.
 *
 * @param szURL string an optional URL to place in the action of the form
 *        to allow additional parameters to be passed back to the page that
 *        contains the dbf navigation widget.
 */
function display_table( $szDBFFile, $szURL )
{
    global $HTTP_POST_VARS, $HTTP_GET_VARS;
  
    //check for previous values passed by submitting the form
    
    if (!isset($HTTP_GET_VARS['row_start']))
        $row_start = 1;
    else
        $row_start = $HTTP_GET_VARS['row_start'];
    
    if (!isset($HTTP_POST_VARS['num_rows']))
        $num_rows = 5;
    else
        $num_rows = $HTTP_POST_VARS['num_rows'];
      
    //open the database and get the data
    $db = dbase_open( $szDBFFile, 0 );
    $num_records = dbase_numrecords( $db );
    $num_fields = dbase_numfields( $db );
    
    $fields = array();
    if ($num_records > 0)
    {
        $rec = dbase_get_record_with_names( $db, 1 );
        array_pop( $rec );
        $fields = array_keys( $rec );
    }
    
    //check how we were called and fix up the URL
    //GO just updates the table based on current row start and num rows
    //FIRST resets row_start to 0
    //END resets row_start to all_rows - num_rows
    //PREV subtracts num_rows from row_start.  If < 0, set to 0
    //NEXT adds num_rows to row_start.  If > all_rows - num_rows, = all_rows - num_rows
    if (isset($HTTP_POST_VARS['first']))
    {
        $row_start = 1;
    }
    elseif (isset($HTTP_POST_VARS['next']))
    {
        $row_start = $row_start + $num_rows;
        if ($row_start > $num_records - $num_rows + 1)
            $row_start = $num_records - $num_rows + 1;
    }
    elseif (isset($HTTP_POST_VARS['prev']))
    {
        $row_start = $row_start - $num_rows;
        if ($row_start < 1)
            $row_start = 1;
    }
    elseif (isset($HTTP_POST_VARS['last']))
    {
        $row_start = $num_records - $num_rows + 1;
    }
    
    $szURL .= "row_start=$row_start&num_rows=$num_rows#dbf_nav";
    
    //set up form and table
    echo "<form method=POST action=$szURL>\n";
    echo "<A NAME='dbf_nav'><FONT FACE='Arial, Helvetica, sans-serif' ";
    echo "SIZE='2'>\nShowing records $row_start to ";
    echo ($row_start + $num_rows - 1)." of $num_records.\n ";
    echo "Display <input name=num_rows type=text size=2 value=$num_rows> ";
    echo "records <input type=submit name=go value='Go'></FONT></A><BR>\n";
    echo "<TABLE BORDER='1' CELLSPACING='0' CELLPADDING='2'>\n";
    
    //header row
    echo "<TR BGCOLOR='#EEEEEE'>\n";
    for ($i=0;$i<count($fields);$i++)
    {   
        // interpret the titles
        switch (trim($fields[$i]))
        {
          case "row_cnt":
            $szNewTitle = "ID";
            break;
          case "ref":
            $szNewTitle = "Context";
            break;
          case "lang_0":
            $szNewTitle = "English";
            break;
          case "lang_1":
            $szNewTitle = "French";
            break;
          default:
            $szNewTitle = $fields[$i];
        }
    
        echo "  <TD align=center><font FACE=\"Arial, Helvetica, sans-serif\" SIZE=\"2\"><b>".$szNewTitle."</b></font></TD>\n";
    }
    echo "</TR>\n";
    
    //data
    $row_color = "#FFFFFF";
    for ($i=$row_start; $i<$row_start + $num_rows; $i++)
    {
        $rec = dbase_get_record( $db, $i );
        array_pop( $rec );
        echo "<TR bgcolor='$row_color'>\n";
        for ($j=0;$j<count($rec);$j++)
        {
            // check for blanks
            if ( trim($rec[$j]) == "" )
                $result = "&nbsp;";
            else
                $result = $rec[$j];
            
            echo "  <TD><font FACE=\"Arial, Helvetica, sans-serif\" SIZE=\"2\">".$result."</font></TD>\n";
        }
        echo "</TR>\n";
        
        if ($row_color == "#EFF3F7" )
            $row_color = "#FFFFFF";
        else
            $row_color = "#EFF3F7";
            
    }
    
    //end of table
    echo "</TABLE>\n";   
        
    //rowset navigation
    echo "<INPUT TYPE=SUBMIT NAME=first VALUE=' << '>\n";
    echo "<INPUT TYPE=SUBMIT NAME=prev VALUE=' < '>\n";
    echo "<INPUT TYPE=SUBMIT NAME=next VALUE=' > '>\n";
    echo "<INPUT TYPE=SUBMIT NAME=last VALUE=' >> '>\n";
    
    //end form
    echo "</FORM>\n";
    
}

?>







