///////////////////////////////////////////////////////////////////////
// JavaScript ColorPicker Init
// (c) 1998 Netscape Communications Corporation
// Written by Michael Bostock (mikebos@netscape.com)
//
// Modified October, 2003 by DM Solutions Group (dev@dmsolutions.ca)
///////////////////////////////////////////////////////////////////////


 /** 
  * var mode   - integer - single (0), complimentary (1), triadic (2)
  * var format - integer - RGB (1), HSB (0), HSV (null)
  */
var mode = 0, format = 1;


 /** 
  * function webSafify(n)
  * turns [0-255] number into web-safe equivalent
  */
function webSafify(n) 
{
    if(n < 26) 
        return 0;
    else if(n < 77) 
        return 51;
    else if(n < 128) 
        return 102;
    else if(n < 179) 
        return 153;
    else if(n < 230) 
        return 204;
    else 
        return 255;
}


 /** 
  * function update(e, type, override, r, g, b)
  * Updates colors, thumbs, and forms
  */
function update(e, type, override, r, g, b)
{
    var hex, rgb, hsv, f;

    if(!override) 
    {
        /* convert everything to RGB */
        switch(format) 
        {
        
            case 0: 
                hsv = getHSV(); 
                /* these three if's make sure that we never have negative HSB values */
                if(hsv.h<0) {hsv.h=0;}
                if(hsv.s<0) {hsv.s=0;}
                if(hsv.v<0) {hsv.v=0;}
                rgb = HSVtoRGB(hsv.h,hsv.s,hsv.v); 
                break;
                
            default: 
                rgb = getRGB(); 
                break;
                
        }
    } 
    else 
    {
        rgb = new Array(3);
        rgb.r = r; rgb.g = g; rgb.b = b;
    }

  /****************/
  /* update forms */
  /****************/
  if(!hsv) hsv = RGBtoHSV(rgb.r,rgb.g,rgb.b);
  f = isNav4 ? GetLayer("hsvLayer").document.forms[0] : document.hsvForm;
  
  /* set the HSVform value */
  f.H.value = Math.round(hsv.h);
  f.S.value = Math.round(hsv.s*100);
  f.V.value = Math.round(hsv.v*100);
  
  /* set the RGB form value */
  f = isNav4 ? GetLayer("rgbLayer").document.forms[0] : document.rgbForm;
  f.R.value = Math.round(rgb.r);
  f.G.value = Math.round(rgb.g);
  f.B.value = Math.round(rgb.b);
  f = null;

  /******************/
  /* update bgcolor */
  /******************/
  f = isNav4 ? GetLayer("hexLayer").document.forms[0] : document.rgbhsv;
  
  /* if there's no HEX value available create one */
  if(!hex)
  {
      hex = RGBtoHex(rgb.r,rgb.g,rgb.b);
  }

  /* if no HSB value then create one */
  if(!hsv) hsv = RGBtoHSV(rgb.r,rgb.g,rgb.b);

  /* this updates the bgcolor of the main color display */
  setLayerBgcolor(GetLayer("testLayer"), f.webcolor.value = hex);


  /* update the dynamic saturation and brightness bars */
  setLayerOpacity(GetLayer("saturation"), 100 - 100*hsv.v);
  setLayerOpacity(GetLayer("brightness2"), 100 - 100*hsv.s);
  
  var myrgb = HSVtoRGB( hsv.h, 1, 1 );
  var myhex = RGBtoHex(myrgb.r, myrgb.g, myrgb.b );
  setLayerBgcolor(GetLayer("saturation3"), myhex );
  setLayerBgcolor(GetLayer("brightness3"), myhex );

  /* do web-safe stuff */
  var rS,gS,bS,hex2;
  rS = webSafify(rgb.r); 
  gS = webSafify(rgb.g); 
  bS = webSafify(rgb.b);
  /* if the color selected is not websafe then show the exclaim icon */
  setLayerBgcolor(GetLayer("webSafeLayer"), hex2 = RGBtoHex(rS,gS,bS));
  (hex2 == hex)? setVisibility(GetLayer("exclaim"), "hidden") :
                 setVisibility(GetLayer("exclaim"), "visible");
                 
  /* set our vals to null */                 
  rS = gS = bS = hex2 = null;

  /***********************/
  /* update other thumbs */
  /***********************/
  if(override || format != 0) 
  {
      if(!hsv) hsv = RGBtoHSV(rgb.r,rgb.g,rgb.b);
      setHSV(hsv.h,hsv.s,hsv.v,format);
  }
  
  if(override || format != 2) 
  {
      setRGB(rgb.r,rgb.g,rgb.b);
  }
  

  /* update triadic or complementary colors, if necessary */
  if(mode == 2) 
  {
      /* triadic */
      rgb = HSVtoRGB((hsv.h+120)%360,hsv.s,hsv.v);
      setLayerBgcolor(GetLayer("testLayer3"), RGBtoHex(rgb.r,rgb.g,rgb.b));
      rgb = HSVtoRGB((hsv.h+240)%360,hsv.s,hsv.v);
      setLayerBgcolor(GetLayer("testLayer4"), RGBtoHex(rgb.r,rgb.g,rgb.b));
  } 
  else if(mode == 1) 
  {
      /* complimentary */
      rgb = HSVtoRGB((hsv.h+180)%360,hsv.s,hsv.v);
      setLayerBgcolor(GetLayer("testLayer2"), RGBtoHex(rgb.r,rgb.g,rgb.b));
  }
  
  /* set our vals to null */
  rgb = hsv = null;
}


 /**
 * function change(type, dst, val)
 * update based on text input
 */
function change(type, dst, val) {

  /* must correct values! */
  switch(type)
  {
      
      case "HSB":
          switch(dst)
          {
              case "H":
                  if(val < 0) val = 0; if(val > 359) val = 359;
                  setHSV(val,-1,-1);
                  break;
              case "S":
                  if(val < 0) val = 0; if(val > 100) val = 100;
                  setHSV(-1,val/100,-1);
                  break;
              case "V":
                  if(val < 0) val = 0; if(val > 100) val = 100;
                  setHSV(-1,-1,val/100);
                  break;
              default: 
                  break;
          }
          break;
          
      case "RGB":
          switch(dst)
          {
              case "R":
                  if(val < 0) val = 0; if(val > 255) val = 255;
                  setRGB(val,-1,-1);
                  break;
              case "G":
                  if(val < 0) val = 0; if(val > 255) val = 255;
                  setRGB(-1,val,-1);
                  break;
              case "B":
                  if(val < 0) val = 0; if(val > 255) val = 255;
                  setRGB(-1,-1,val);
                  break;
              default: 
                  break;
          }
          break;
          
      case "HEX":
          var rgb = HextoRGB(val);
          update(false, "", true, rgb.r, rgb.g, rgb.b);
          rgb = null;
          break;
      default:
          break;
    }
    
    update();
    
}


 /**
 * updateFormat(e,t,override,iformat) 
 * called when changing colorspaces - sets up the appropriate DIV's
 */
function updateFormat(e,t,override,iformat) 
{
    if(override) format = iformat;
    setZIndex(GetLayer("tabRGB"), 0);
    setZIndex(GetLayer("tabHSB"), 0);
    /* if format equals HSB */
    if(format == 0) 
    {
        setVisibility(GetLayer("thumbH"), "visible");
        setZIndex(GetLayer("tabHSB"), 10);
        setVisibility(GetLayer("thumbS"), "visible");
        setVisibility(GetLayer("thumbV"), "visible");
        setVisibility(GetLayer("rgbLayer"), "hidden");
        setVisibility(GetLayer("hsvLayer"), "visible");
        setVisibility(GetLayer("thumbR"), "hidden");
        setVisibility(GetLayer("thumbG"), "hidden");
        setVisibility(GetLayer("thumbB"), "hidden");
        setVisibility(GetLayer("hue"), "visible");
        setVisibility(GetLayer("hue_bg"), "visible");
        setVisibility(GetLayer("saturation_bg"), "visible");
        setVisibility(GetLayer("brightness_bg"), "visible");
        /* if IE */
        if (isIE4)
        {
            setVisibility(GetLayer("saturation"), "visible");
            setVisibility(GetLayer("saturation3"), "visible");
            setVisibility(GetLayer("brightness2"), "visible");
            setVisibility(GetLayer("brightness3"), "visible");
            setVisibility(GetLayer("brightness_ie"), "visible");
            setVisibility(GetLayer("saturation2_ie"), "visible");
            setVisibility(GetLayer("saturation_nn4"), "hidden");
            setVisibility(GetLayer("brightness_nn4"), "hidden");
            setVisibility(GetLayer("brightness"), "hidden");
            setVisibility(GetLayer("saturation2"), "hidden");
        }
        else if (isNav4)
        {
            setVisibility(GetLayer("saturation_nn4"), "visible");
            setVisibility(GetLayer("brightness_nn4"), "visible");
            setVisibility(GetLayer("brightness"), "hidden");
            setVisibility(GetLayer("saturation2"), "hidden");
            setVisibility(GetLayer("saturation"), "hidden");
            setVisibility(GetLayer("saturation3"), "hidden");
            setVisibility(GetLayer("brightness2"), "hidden");
            setVisibility(GetLayer("brightness3"), "hidden");
        }
        else /* Nav 6+ */
        {
            setVisibility(GetLayer("saturation"), "visible");
            setVisibility(GetLayer("saturation3"), "visible");
            setVisibility(GetLayer("brightness2"), "visible");
            setVisibility(GetLayer("brightness3"), "visible");
            setVisibility(GetLayer("brightness_ie"), "hidden");
            setVisibility(GetLayer("saturation2_ie"), "hidden");
            setVisibility(GetLayer("saturation_nn4"), "hidden");
            setVisibility(GetLayer("brightness_nn4"), "hidden");
            setVisibility(GetLayer("brightness"), "visible");
            setVisibility(GetLayer("saturation2"), "visible");
        }
        
        setVisibility(GetLayer("red"), "hidden");
        setVisibility(GetLayer("red_bg"), "hidden");
        setVisibility(GetLayer("green"), "hidden");
        setVisibility(GetLayer("green_bg"), "hidden");
        setVisibility(GetLayer("blue"), "hidden");
        setVisibility(GetLayer("blue_bg"), "hidden");
    } 
    else /* RGB */
    {
        setVisibility(GetLayer("rgbLayer"), "visible");
        setVisibility(GetLayer("hsvLayer"), "hidden");
        setZIndex(GetLayer("tabRGB"), 10);
        setVisibility(GetLayer("thumbH"), "hidden");
        setVisibility(GetLayer("thumbS"), "hidden");
        setVisibility(GetLayer("thumbV"), "hidden");
        setVisibility(GetLayer("thumbR"), "visible");
        setVisibility(GetLayer("thumbG"), "visible");
        setVisibility(GetLayer("thumbB"), "visible");
        setVisibility(GetLayer("hue"), "hidden");
        setVisibility(GetLayer("hue_bg"), "hidden");
        setVisibility(GetLayer("saturation"), "hidden");
        setVisibility(GetLayer("saturation2"), "hidden");
        setVisibility(GetLayer("saturation3"), "hidden");
        setVisibility(GetLayer("saturation_bg"), "hidden");
        setVisibility(GetLayer("brightness"), "hidden");
        setVisibility(GetLayer("brightness2"), "hidden");
        setVisibility(GetLayer("brightness3"), "hidden");
        setVisibility(GetLayer("brightness_bg"), "hidden");
        setVisibility(GetLayer("red"), "visible");
        setVisibility(GetLayer("red_bg"), "visible");
        setVisibility(GetLayer("green"), "visible");
        setVisibility(GetLayer("green_bg"), "visible");
        setVisibility(GetLayer("blue"), "visible");
        setVisibility(GetLayer("blue_bg"), "visible");
        setVisibility(GetLayer("saturation_nn4"), "hidden");
        setVisibility(GetLayer("brightness_nn4"), "hidden");
        if (isIE4 || isNav6)
        {
          setVisibility(GetLayer("saturation2_ie"), "hidden");
          setVisibility(GetLayer("brightness_ie"), "hidden");
        }
    }   
}


  /**
  * updateMode(e,t,imode)
  * When you change hues (complementary,triadic)
  */
function updateMode(e,t,imode)
{
// not CB
    var f = isNav4 ? GetLayer("hexLayer").document.forms[0] : document.rgbhsv;
    mode = imode || f.scheme.selectedIndex;

    switch(mode)
    {
        /* single mode */
        case 0:
            setVisibility(GetLayer("testLayer2"), "hidden");
            setVisibility(GetLayer("testLayer2_bg"), "hidden");
            setVisibility(GetLayer("testLayer3"), "hidden");
            setVisibility(GetLayer("testLayer3_bg"), "hidden");
            setVisibility(GetLayer("testLayer4"), "hidden");
            setVisibility(GetLayer("testLayer4_bg"), "hidden");
            break;
        /* complimentary mode */
        case 1:
            setVisibility(GetLayer("testLayer2"), "visible");
            setVisibility(GetLayer("testLayer2_bg"), "visible");
            setVisibility(GetLayer("testLayer3"), "hidden");
            setVisibility(GetLayer("testLayer3_bg"), "hidden");
            setVisibility(GetLayer("testLayer4"), "hidden");
            setVisibility(GetLayer("testLayer4_bg"), "hidden");
            break;
        /* triadic mode */
        case 2:
            setVisibility(GetLayer("testLayer2"), "hidden");
            setVisibility(GetLayer("testLayer2_bg"), "hidden");
            setVisibility(GetLayer("testLayer3"), "visible");
            setVisibility(GetLayer("testLayer3_bg"), "visible");
            setVisibility(GetLayer("testLayer4"), "visible");
            setVisibility(GetLayer("testLayer4_bg"), "visible");
            break;
    }
    
    update();
    
}


  /**
  * move()
  */
function move()
{
    var rgb;
    if (isNav4)
    {
        rgb = HextoRGB(DectoHex(this.bgColor));
    }
    else if (isNav6)
    {
        var szRGB = this.style.backgroundColor;
        /* parse the string returned in szRGB to get the proper RGB values */
        var first = szRGB.indexOf( "(" ) + 1;
        var last = szRGB.indexOf( ")" );
        szRGB = szRGB.substring( first, last );
        rgb = szRGB.split( "," );
        rgb.r = rgb[0];
        rgb.g = rgb[1];
        rgb.b = rgb[2];
    }
    else if (isIE4)
    {
        /* no parse required - IE returns proper vals from this.style.backgroundColor */
        rgb = HextoRGB(this.style.backgroundColor);
    }
    
    update(false, "", true, rgb.r, rgb.g, rgb.b);
    rgb = null;
}


  /**
  * jump()
  * Jump to nearest web-safe color
  */
function jump() 
{

    var rgb, hsv;

    /* convert everything to RGB */
    switch(format)
    {
        case 0:
            hsv = getHSV();
            rgb = HSVtoRGB(hsv.h,hsv.s,hsv.v);
            break;
        default:
            rgb = getRGB();
            break;
    }

    /* make web-safe */
    rgb.r = webSafify(rgb.r);
    rgb.g = webSafify(rgb.g);
    rgb.b = webSafify(rgb.b);

    /* update (with override) */
    update(false, "", true, rgb.r, rgb.g, rgb.b);

    /* clear memory */
    rgb = hsv = null;

}


/* encapsed functions to update the position and visibility of the DIV's on the page */
function gohsb() { updateFormat(false,false,true,0); }
function gorgb() { updateFormat(false,false,true,2); }


  /**
  * init()
  * Load behaviors, display everything OK
  */
function init()
{

    db = new Behavior(true);
    db.setAction("MOUSEMOVE", update);
    /* everything is vLock now - no hLock present on page */
    db.vLock = true;
    db.hLock = false;
    /* setBounds relates to the restriced dimensions of the sliders */
    if (isNav4) // account for browser inner width
    {
        db.setBounds(95,306,0,10);
    }
    else
    {
        db.setBounds(95,295,0,10);
    }
    db.applyBehavior(GetLayer("thumbH"));
    db.applyBehavior(GetLayer("thumbS"));
    db.applyBehavior(GetLayer("thumbV"));
    db.applyBehavior(GetLayer("thumbR"));
    db.applyBehavior(GetLayer("thumbG"));
    db.applyBehavior(GetLayer("thumbB"));
    db = null;
    db = new Behavior(false);
    db.setAction("MOUSEDOWN", gorgb);
    db.applyBehavior(GetLayer("tabRGB"));
    db.setAction("MOUSEDOWN", gohsb);
    db.applyBehavior(GetLayer("tabHSB"));
    db.setAction("MOUSEDOWN", jump);
    db.applyBehavior(GetLayer("webSafeLayer"));
    db.applyBehavior(GetLayer("exclaim"));
    db.setAction("MOUSEDOWN", move);
    db.applyBehavior(GetLayer("testLayer2"));
    db.applyBehavior(GetLayer("testLayer3"));
    db.applyBehavior(GetLayer("testLayer4"));
    db = null;
    updateFormat();
    update(null, null, true, szRed, szGreen, szBlue);
}