<?php
/**
 *
 * @project     CWC2
 * @revision    $Id: chameleon.php,v 1.42 2004/07/09 18:30:35 pspencer Exp $
 * @purpose     Main Chameleon class definition
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

//
// Make sure to report ALL errors
//
error_reporting( E_ALL );

//
// Form variables manager class definition
//
include_once("HttpFormVars.php");

//
// Define chameleon absolute path
//
if(!defined("CHAMELEON_PATH"))
    define( "CHAMELEON_PATH", dirname(__FILE__)."/." );

//    
// Define path to the conguration settings
//
if(!defined("CHAMELEON_CONFIG_PATH"))
    define( "CHAMELEON_CONFIG_PATH", dirname(__FILE__)."/../config/" );
if (!file_exists(CHAMELEON_CONFIG_PATH))
{
    echo "Fatal error: Chameleon configuration directory (".CHAMELEON_CONFIG_PATH.
         ") does not exist. Please check your configuration.";
    exit;
}
if (!file_exists(str_replace("\\","/",CHAMELEON_CONFIG_PATH."/chameleon.xml")))
{
    echo "Fatal error: Chameleon configuration file ".
         "does not exist. Please check your configuration.";
    exit;
}

//
// Those 2 lines shouldn't be touched. They are replaced
// by the installer.
//
//%DMPEAR_COMMON%
//%DMPEAR_WEBCOMMON%


//
// Define path to php_utils
//
if(!defined("COMMON"))
    define( "COMMON",  dirname(__FILE__)."/common/" );
if (!file_exists(COMMON))
{
    echo "Fatal error: Common directory (".COMMON.") does not exist. Please check your configuration.";
    exit;
}

//
// include the logging functions
//
include_once( COMMON."logger/logfile.php" );
include_once( COMMON."logger/error_manager.php" );
include_once( COMMON."logger/logger.php" );

//
// include the xml parsing class
//
include_once( COMMON."appcontext/appcontext.php" );

//
// include wrapper file(s)
//
include_once( COMMON."wrapper/map_session.php" );

//
// include the mlt file
//
include_once( COMMON."mlt/mlt.php" );

//
// Session management
//
include_once( COMMON."session/session.php");

//
// Initialize session management and start a session
//
installSessionDirectoryHandler();
$GLOBALS['bSessionOK'] = initializeSession("sid");


//
// convert the global session reference if necessary
//
if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
{
    if ( version_compare( phpversion(), "4.2.1" ) < 0 )
        $_SESSION = &$HTTP_SESSION_VARS;
}

//
// Retrieve gszAppWebPath from session or as global variable
//
if (!isset($GLOBALS['gszAppWebPath']))
{
    if (isset($_SERVER["HTTPS"]) && strcasecmp($_SERVER['HTTPS'], "on") == 0)
        $http = "https://";
    else
        $http = "http://";

    $GLOBALS['gszAppWebPath'] = $http.$_SERVER['HTTP_HOST'];
    
    if (version_compare( phpversion(), "4.3.3" ) < 0 ||
        (isset($_SERVER['REQUEST_URI']) &&
         $_SERVER['REQUEST_URI'] != $_SERVER['SCRIPT_NAME']))
    {
        $szURI = $_SERVER['REQUEST_URI'];        
    }
    else
    {
        $szURI = $_SERVER['SCRIPT_NAME'];
    }

    /* there was a bug that caused gszAppWebPath to be incorrect if no
       filename was provided in the url (specifically, using the default
       index page in a directory), the original code did not account for
       this and the directory name would be stripped.  This attempts to
       build the directory correctly
    */
    $aszURI = parse_url( $szURI );
    $aszPath = pathinfo($aszURI['path']);
    if (isset($aszPath['extension']))
        $szPath = $aszPath['dirname'].'/';
    else
        $szPath = $aszPath['dirname'].$aszPath['basename'].'/';
    
    $GLOBALS['gszAppWebPath'] .= $szPath;
    $GLOBALS['gszAppWebPath'] = str_replace( '\\', '/', $GLOBALS['gszAppWebPath']);
    //$GLOBALS['gszAppWebPath'] = ereg_replace ("/+", "/", $GLOBALS['gszAppWebPath']);

}

if (!isset($_SESSION['gszAppWebPath']))
{
    $_SESSION['gszAppWebPath'] = $GLOBALS['gszAppWebPath'];
}

if (!isset($GLOBALS['gszAppPath']))
{
    //print_r($_SERVER);
    if (isset($_SERVER['PATH_TRANSLATED']))
        $GLOBALS['gszAppPath'] = dirname( $_SERVER['PATH_TRANSLATED'])."/";
    else
    if (isset($_SERVER['ORIG_PATH_TRANSLATED']))
        $GLOBALS['gszAppPath'] = dirname( $_SERVER['ORIG_PATH_TRANSLATED'])."/";
    $GLOBALS['gszAppPath'] = realpath($GLOBALS['gszAppPath']);
}
if (!isset($_SESSION['gszAppPath']))
{
    $_SESSION['gszAppPath'] = $GLOBALS['gszAppPath'];
}


/**
 * Chameleon application base class.
 *
 * This class define the base behavior of Chameleon. Every Chameleon
 * application should be a class that derive from Chameleon class.
 *
 * The class manage all form variables and make sure to pass them to
 * all widets for their own use. 
 *
 * By default, the class will try to load a template using file system
 * througt CWCLoadTemplate method. So, if for instance you need to load
 * a template from something else thant the file system (for instance, a 
 * database), you'll have to overwrite CWCLoadTemplate method in your 
 * application class definition.
 *
 * A map file is needed by Chameleon to work (should change some day). The
 * map file have to b specified as the second parameter of method CWCInitialize.
 * For now, map file should be on local file system. If you want to et your
 * map file somewhere else (database for instance), you'll have to take care 
 * of it before calling CWCInitialize so it can be loaded from your local file
 * system.
 * 
 * All session variables are set by CWCInitializeSession method. If for any reason
 * you need to sets some custom session variables, you'll need to overwrite this
 * methos in your application class definition. Please take note that session
 * variables seted in that method is only done once (first page load).
 *
 * 
 *
 *
 */
class Chameleon
{
    // Form variables manager object
    var $moHttpFormVars;
    // PHP form variables ARRAY
    var $HTTP_FORM_VARS1;

    // Configuration manager object
    var $moContext;

    // Current language used
    var $mszCurrentLanguage;
    // List of templates for every languages.
    var $maszTemplates = array();
    
    // Current template name
    var $mszTemplateName = "";
    // Current template content    
    var $mszTemplate = "";

    // Current mapfile
    var $mszMapFile;

    // Wrapper map session object (Can be ReadOnly or Writable)
    var $moMapSession = "";
    // Current State for MapSession object
    var $mszCurrentState = "";

    // Multilingual object resource manager
    var $moMLT;
    var $moCommonMLT;

    // Chameleon UI manager
    var $moUI;

    // Chameleon error manager
    var $moErrorManager;
    // Chameleon Log object
    var $moLogFile;

    // Absolute path to chameleon
    var $mszCoreWebPath;

    // Template name to display if a non fatal error occure.
    var $mszInvalidSessionTmpl = "";

    var $mbSessionOK = true;
    
    var $maszSkinSearchPath = array( 'skins/default' );


    /**
     * Chameleon class constructor.
     *
     * Initialize Form variables, make sure the session (PHP)
     * was created and set current language (if any).
     */
    function Chameleon()
    {
        // Get form variables from POST of GET
        if (sizeof($_POST) > 0)
            $this->HTTP_FORM_VARS1 =& $_POST;
        else if (sizeof($_GET) > 0)
            $this->HTTP_FORM_VARS1 =& $_GET;
        else
            $this->HTTP_FORM_VARS1 = array("");

        // Check session
        if (isset($GLOBALS['bSessionOK']) && !$GLOBALS['bSessionOK'])
          $this->mbSessionOK = false;

        // Load form variables into a class
        $this->moHttpFormVars = new HttpFormVars($this->HTTP_FORM_VARS1);

        // Retrieve laststate for MapSession object (if any)
        if (isset($_SESSION['gszCurrentState']))
        {
            $this->mszCurrentState = $_SESSION['gszCurrentState'];
            //echo "state in session $this->mszCurrentState<BR>";
        }
        else
        if ($this->moHttpFormVars->isVarSet('currentState', false) &&
            $this->moHttpFormVars->getVar('currentState', false) != "")
        {
            $this->mszCurrentState = $this->moHttpFormVars->getVar('currentState', false);
        }

        // Retrieve language (if any)
        if( $this->isVarSet("LANGUAGE"))
        {
            $this->mszCurrentLanguage = $this->getVar("LANGUAGE");
        }
        elseif(isset($_SESSION['gszCurrentLanguage']))
        {
            $this->mszCurrentLanguage = $_SESSION['gszCurrentLanguage'];
        }
    }
    
    /**
     * CWCAddRegionalTemplate( $szLang, $szTemplateName )
     *
     * This function add a new template (to the list) for a 
     * specific language.
     *
     * @param $szLang Template language
     * @param $szTemplateName Template name to set for the language
     */
    function CWCAddRegionalTemplate( $szLang, $szTemplateName )
    {
        $this->maszTemplates[$szLang] = $szTemplateName;
    }

    /**
     * CWCExecute($aszWidgetsDir=array())
     *
     * This functin execute chameleon engine.
     *
     * @param $aszWidgetsDir Array of path to search for more widgets.
     */
    function CWCExecute($aszWidgetsDir=array())
    {
        // set a global reference
        $GLOBALS['oChameleonApp'] =& $this;

        include("UIManager.php");

        $nCount = 0;

        $bRet = false;
        /*
          Since some widget can redirect to different (events)
          template, we loop to the infinite or until
          the template was corretly loaded and displayed.
        */
        while($bRet == false)
        {
            // First thing, check if session is invalid and if a tmeplate is
            // specified
            if (!$this->mbSessionOK)
            {
                // If session failed and there's a Invalid Session template
                // specified, display it.
                if ($this->mszInvalidSessionTmpl == "")
                {
                // if no Invalid Session template specified, check template
                // name (if SessoinExpired in it) display it if so, or display
                // a messsage and exit.
                    $this->CWCLoadTemplate($this->mszTemplateName);
                    if (strpos($this->mszTemplate, "SessionExpired") === false)
                    {
                        echo "Your session has expired from our server, please come back to the entry page of the application to initiate a new session";
                        exit;
                    }
                }
                else
                    $this->CWCLoadTemplate($this->mszInvalidSessionTmpl);
            }
            else
                $this->CWCLoadTemplate($this->mszTemplateName);

            // Create UI Manager object
            $this->moUI = new UIManager($this->mszTemplate,
                                        $this->moMapSession,
                                        $aszWidgetsDir);

            // Call process URL. This will process URL for
            // all widgets in template.
            if ($this->moUI->ProcessURL($this->HTTP_FORM_VARS1))
            {
                $nCount = 0;

                // If no error, prepare display template content.
                $this->moUI->PrepareDrawPublish();

                // Save MapSession state for next page and close sessoin
                $_SESSION['gszCurrentState']=$this->moMapSession->saveState();
                //echo "saved state to ".$_SESSION['gszCurrentState'];
                session_write_close();

                // And output it to client.
                $this->moUI->DrawPublish();


                $bRet = true;
            }
            else
            {
                // An error occure in ProcessURL
                //
                // Check if the last template is the same as the previous one.
                // If so exit. If not, increment an internal couter to prevent
                // infinit loop and go back at the begining of the main loop.
                if ($this->mszTemplateName == $this->mszLastTemplateName)
                    $bRet = true;
                else
                    $nCount ++;

                // This should never happen.
                if ($nCount > 10)
                {
                    echo "Infinit loop. Exiting."; 
                   
                    echo "<!-- ".$this->mszTemplateName."\n\n";
                    print_r($this->HTTP_FORM_VARS1);
                    echo " -->";

                    exit;
                }
            }
        }
    }

    /**
     * CWCInitialize($szTemplateName, $szMapFile="")
     *
     * Chameleon main initialization method. This set the template
     * and the mapfile to use. Also initialize all helper object.
     *
     * @param $szTemplateName Template name to use
     * @param $szMapFile Mapfile to load.
     */
    function CWCInitialize($szTemplateName, $szMapFile="")
    {
        // Set template name and map file
        $this->CWCSetTemplate($szTemplateName);

        // Make sure the path is absolute.
        //echo $_SESSION['gszAppPath']."<BR>";
        if ($szMapFile != "")
            $this->mszMapFile  = $this->resolvePath2($szMapFile, $_SESSION['gszAppPath']);
        else
            $this->mszMapFile = "";

        // define a new AppContext object
        $this->moContext = new AppContext( CHAMELEON_CONFIG_PATH."chameleon.xml" );
      
        // Get web path to php_utils.  
        if(!defined("WEBCOMMON"))
            define( "WEBCOMMON", $this->moContext->getContextValue("web_server_path")."/common/" );

        // Get invalid session template
        $this->mszInvalidSessionTmpl =
          $this->moContext->getContextValue("invalid_session_template", "");

        // Get default language from configuration file
        if ($this->mszCurrentLanguage == "")
            $this->mszCurrentLanguage = $this->moContext->getContextValue("default_language","");

        // Set current language in session (should it be in CWCInitializeSession ?)
        $_SESSION['gszCurrentLanguage'] = $this->mszCurrentLanguage;
        
        // create a new MLT object
        $this->moMLT = new MLTdBase( $this->mszCurrentLanguage );

        // create a new common MLT object
        $this->moCommonMLT = new MLTdBase( $this->mszCurrentLanguage );

        // load the resourcre file into memory
        $this->moMLT->loadResource( dirname(__FILE__)."/CWC2.dbf", $this->mszCurrentLanguage );

        // load common resources
        $this->moCommonMLT->loadResource( dirname(__FILE__)."/common.dbf", $this->mszCurrentLanguage );

        // Init session variables if not already set
        if (!$this->moHttpFormVars->isVarSet('SID') ||
            !$this->mbSessionOK ||
            (isset($_SESSION['gszMapName']) && 
             realpath($_SESSION['gszMapName']) != realpath($szMapFile)) &&
             $szMapFile != "")
        {
            //echo "resetting session<BR>";
            $this->mszCurrentState = "";
            $this->CWCInitializeSession();
        }

        if (!extension_loaded("MapScript"))
            dl($_SESSION['gszMapscriptModule']);

    // Load mapfile
        $this->CWCInitializeMap();
    }

    /**
     * CWCSetTemplate($szTemplateName)
     *
     * Set current template name (don't loading it).
     *
     * @param $szTemplateName Current template name.
     */
    function CWCSetTemplate($szTemplateName)
    {
        // Keep last template name just in case...
        $this->mszLastTemplateName = $this->mszTemplateName;

        // If a template list is provided, use it with current language.
        if (isset($this->maszTemplates[$this->mszCurrentLanguage]))
        {
            $this->mszTemplateName = $this->maszTemplates[$this->mszCurrentLanguage];
        }
        else
        {
            $this->mszTemplateName = $szTemplateName;
        }
    }

    /**
     * CWCLoadTemplate($szTemplateName)
     *
     * Load the template content into mszTemplate
     *
     * @param $szTemplateName Template name to load.
     */
    function CWCLoadTemplate($szTemplateName)
    {
        // PHP function from 4.3.0 and up. Much faster.
        if (function_exists('file_get_contents'))
            $this->mszTemplate = file_get_contents($szTemplateName);
        else
            $this->mszTemplate = implode("\n", file($szTemplateName));
    }
    
    /**
     * required by TemplateParser interface, return a template to be parsed
     * @param szTemplateName the template to load
     * @return a string containing the contents of the template
     */
    function GetTemplate( $szTemplateName )
    {
        if (function_exists('file_get_contents'))
            return file_get_contents($szTemplateName);
        else
            return implode("\n", file($szTemplateName));
    }

    /**
     * CWCInitializeMap()
     *
     * Load mapfile. This method load the mapfile using
     * mapsession object. By default, a "ReadOnly" map session
     * object is used to load the map. If you need a writeable
     * map session object, make sure to create is before calling
     * this method and put a reference in to MapSession member.
     */
    function CWCInitializeMap()
    {
        //session map init
        // create a new map session object if not created
        if ($this->moMapSession == "")
            $this->moMapSession = new MapSession_R;

        // set the global log file and error manager
        $this->moMapSession->setLogFile( $this->moLogFile );
        $this->moMapSession->setErrorManager( $this->moErrorManager );

        /* ===========================================================
         * Re-instate the previous map state
         * =========================================================== */
        if ($this->mszCurrentState == "" )
        {
            // load mapfile if necessary
            if ($this->mszMapFile != "")
            {
                // Init error stack
                ms_ResetErrorList();

                $bStatus = MS_FAILURE;
                if (strtoupper(substr($this->mszMapFile, -3)) == "MAP")
                {
                    $bStatus = $this->moMapSession->readMapFile($this->mszMapFile,
                                                                dirname($this->mszMapFile));

                    if ($bStatus)
                        $bStatus = MS_SUCCESS;
                    else
                        $bStatus = MS_FAILURE;

                }

                if ($bStatus == MS_FAILURE)
                {
                    if (isset($this->moErrorManager))
                        $this->moErrorManager->setError(ERR_WARNING,
                                                   trim($this->moMLT->get("4", "ERROR: Invalid map file file.")));
                    else
                        echo "ERROR: Invalid map file file (".$this->mszMapFile.").";

                    // Get mapserver error stack and display them as HTML comments.
                    $oError = ms_GetErrorObj();
                    while($oError && $oError->code > 0)
                    {
                        switch($oError->code)
                        {    
                            case MS_NOERR:
                                $szMsg = "No Error: ".$oError->message;
                                break;
                                
                            case MS_IOERR:
                                $szMsg = "MapServer IO Error: ".$oError->message;
                                break;
                            
                            case MS_MEMERR:
                                $szMsg = "MapServer Memory Allocation Error: ".$oError->message;
                                break;

                            case MS_TYPEERR:
                                $szMsg = "MapServer Type Error: ".$oError->message;
                                break;
                            
                            case MS_SYMERR:
                                $szMsg = "MapServer Symbol Error: ".$oError->message;
                                break;
                            
                            case MS_TYPEERR:
                                $szMsg = "MapServer Regular Expression Error: ".$oError->message;
                                break;
                            
                            case MS_TTFERR:
                                $szMsg = "MapServer TrueType Font Error: ".$oError->message;
                                break;
                            
                            case MS_DBFERR:
                                $szMsg = "MapServer DBF Error: ".$oError->message;
                                break;
                            
                            case MS_GDERR:
                                $szMsg = "MapServer GD Error: ".$oError->message;
                                break;
                            
                            case MS_IDENTERR:
                                $szMsg = "MapServer IDENT Error: ".$oError->message;
                                break;
                            
                            case MS_EOFERR:
                                $szMsg = "MapServer EOF Error: ".$oError->message;
                                break;
                            
                            case MS_PROJERR:
                                $szMsg = "MapServer Projection Error: ".$oError->message;
                                break;
                            
                            case MS_MISCERR:
                                $szMsg = "MapServer Miscellaneous Error: ".$oError->message;
                                break;
                            
                            case MS_CGIERR:
                                $szMsg = "MapServer CGI Error: ".$oError->message;
                                break;
                            
                            case MS_WEBERR:
                                $szMsg = "MapServer Web Error: ".$oError->message;
                                break;
                            
                            case MS_IMGERR:
                                $szMsg = "MapServer Image Error: ".$oError->message;
                                break;
                            
                            case MS_HASHERR:
                                $szMsg = "MapServer HashTable Error: ".$oError->message;
                                break;
                            
                            case MS_JOINERR:
                                $szMsg = "MapServer Join Error: ".$oError->message;
                                break;
                            
                            case MS_NOTFOUND:
                                $szMsg = "MapServer Not Found (empty search result) Error: ".$oError->message;
                                break;
                            
                            case MS_SHPERR:
                                $szMsg = "MapServer Shapefile Error: ".$oError->message;
                                break;
                            
                            case MS_PARSEERR:
                                $szMsg = "MapServer Parser Error: ".$oError->message;
                                break;
                            
                            case MS_SDEERR:
                                $szMsg = "MapServer SDE Error: ".$oError->message;
                                break;
                            
                            case MS_OGRERR:
                                $szMsg = "MapServer OGR Error: ".$oError->message;
                                break;
                            
                            case MS_QUERYERR:
                                $szMsg = "MapServer Query Error: ".$oError->message;
                                break;
                            
                            case MS_WMSERR:
                                $szMsg = "MapServer WMS Error: ".$oError->message;
                                break;
                            
                            case MS_WMSCONNERR:
                                $szMsg = "MapServer WMS Connection Error: ".$oError->message;
                                break;
                            
                            /*case MS_ORCALESPATIALERR:
                                $szMsg = "MapServer Oracle Spatial Error: ".$oError->message;
                                break;
                            */
                            case MS_WFSERR:
                                $szMsg = "MapServer WFS Error: ".$oError->message;
                                break;
                            
                            case MS_WFSCONNERR:
                                $szMsg = "MapServer WFS Connection Error: ".$oError->message;
                                break;
                            
                            /*case MS_CONTEXTERR:
                                $szMsg = "MapServer Web Map Context Error: ".$oError->message;
                                break;
                            */
                            case MS_HTTPERR:
                                $szMsg = "MapServer HTTP Error: ".$oError->message;
                                break;
                            
                            case MS_CHILDERR:
                                $szMsg = "MapServer Child Array Error: ".$oError->message;
                                break;
                            
                            /*
                            case MS_WCSERR:
                                $szMsg = "MapServer WCS Error: ".$oError->message;
                                break;
                            */
                            default:
                                $szMsg = "Unrecognized error code ".$oError->code.", message is ".$oError->message;
                        }
                        if (isset($this->moErrorManager))
                        {
                            
                            $this->moErrorManager->setError(ERR_WARNING, $szMsg);
                        }
                        echo "<!-- ".$szMsg." -->";

                        $oError = $oError->next();
                    }
                }
                else
                {
                    // Reset form Vars when new context is loaded
                    $this->resetFormVars();
                    if (isset($_SESSION['gszTmpImgPath']) && $_SESSION['gszTmpImgPath'] != '')
                    {
                        $this->moMapSession->oMap->web->set( "imagepath", $_SESSION['gszTmpImgPath'] );
                    }
                    if (isset($_SESSION['gszTmpWebPath']) && $_SESSION['gszTmpWebPath'] != '')
                    {
                        $this->moMapSession->oMap->web->set( "imageurl", $_SESSION['gszTmpWebPath'] );
                    }
                }
            }
            else
            {
                //echo "create map file<BR>";
                $this->mszMapFile = getSessionSavePath()."default.map";
                $oMap = ms_newMapObj( "" );
                $oMap->set( "width", 1 );
                $oMap->set( "height", 1 );
                $oMap->setExtent( -1, -1, 1, 1 );
                $oMap->save( $this->mszMapFile );
                
                $this->moMapSession->readMapFile($this->mszMapFile,
                                                                dirname($this->mszMapFile));
                $_SESSION['gszMapName'] = $this->mszMapFile;
            }
        }
        else
        {
            if ($this->mszMapFile == "")
                $this->mszMapFile = getSessionSavePath()."default.map";
                
            // Load previous state.
            //echo "restoring state: ".$this->mszCurrentState." ".$this->mszMapFile."<BR>";
            $this->moMapSession->restoreState($this->mszCurrentState,
                                              $this->mszMapFile,
                                              dirname($this->mszMapFile));
        }
    }

    /**
     * CWCInitializeSession()
     *
     * Initialize all session variables. This method
     * is only called once when page first loading.
     */
    function CWCInitializeSession()
    {
        $_SESSION['gszCoreWebPath'] =
                       $this->moContext->getContextValue("web_server_path");
        $aszParts = parse_url( $_SESSION['gszCoreWebPath']);
        
        if (!isset($aszParts['scheme']))
        {
            if (isset($_SERVER["HTTPS"]) && strcasecmp($_SERVER['HTTPS'], "on") == 0)
                $aszParts['scheme'] = "https";
            else
                $aszParts['scheme'] = "http";
        }
        if (!isset($aszParts['host']))
        {
            $aszParts['host'] = $_SERVER["HTTP_HOST"];
        }
        if (!isset($aszParts['port']))
        {
            $aszParts['port'] = "";
        }
        else
        {
            $aszParts['port'] = ":".$aszParts['port'];
        }
        if (!isset($aszParts['path']))
        {
            $aszParts['path'] = '/chameleon/';
        }
        $szPath = str_replace( '//', '/', $aszParts['host'].$aszParts['port']."/".
                                      $aszParts['path'].'/' );
        //paste it back together
        $_SESSION['gszCoreWebPath'] = $aszParts['scheme']."://".$szPath;
        
        $_SESSION['gszCorePath'] = dirname(__FILE__)."/";

        $_SESSION['gszTmpPath']    = getSessionSavePath();
        $_SESSION['gszTmpMapPath'] = getSessionSavePath();
        $_SESSION['gszDefaultLanguage'] = $this->mszCurrentLanguage;

        $_SESSION['gnMapSessionMode'] = ((method_exists($this->moMapSession, "MapSession_RW")) ? "1":"0");
        
        $_SESSION['gaszSkinSearchPath'] = $this->maszSkinSearchPath;

        //  tmp web path
        $gszTmpWebPath = str_replace("\\", "/",
                                     $this->moContext->getContextValue("tmp_web_path"));
        if (substr($gszTmpWebPath, -1) != "/")
            $gszTmpWebPath .= "/";
        $_SESSION["gszTmpWebPath"] = $gszTmpWebPath;

        //  tmp image path
        $gszTmpImgPath = str_replace("\\", "/",
                                     $this->moContext->getContextValue("tmp_img_path"));
        if (substr($gszTmpImgPath, -1) != "/")
            $gszTmpImgPath .= "/";
        $_SESSION["gszTmpImgPath"] = $gszTmpImgPath;

        //button cache path
        $gszButtonCachePath = $this->moContext->getContextValue("button_cache_path");
        if (substr($gszButtonCachePath, -1) != "/")
            $gszButtonCachePath .= "/";
        $_SESSION["gszButtonCachePath"] = $gszButtonCachePath;

        //button cache url
        $gszButtonCacheWebPath = $this->moContext->getContextValue("button_cache_web_path");
        if (substr($gszButtonCacheWebPath, -1) != "/")
            $gszButtonCacheWebPath .= "/";
        $_SESSION["gszButtonCacheWebPath"] = $gszButtonCacheWebPath;

        // Get image output type
        $_SESSION["gszImgType"] = $this->moContext->getContextValue("image_type");

        
        // set a default map title font.
        $_SESSION["gszMapTitleFontName"] = "Vera";

        // set a default legend font.
        $_SESSION["gszLegendFontName"] = "Vera";
        
        // path for the log file
        //$gszLogPath = str_replace("\\", "/", realpath($this->moContext->getContextValue("log_path")));
        //if (substr($gszLogPath, -1) != "/")
        //  $gszLogPath .= "/";

        // get the log level
        //$gszLogLevel = $this->moContext->getContextValue("log_level");

        $gnTimeout = intval($this->moContext->getContextValue( "execution_timeout" ));
        if ( $gnTimeout < 30 )
          $gnTimeout = 30;

        set_time_limit( $gnTimeout );

        // create new logfile object (customize parameters)
        //$aszLog = explode(".", basename($_SERVER["PHP_SELF"]));
        //$gLogFile = new LogFile( $gszLogPath.$aszLog[0]."_cwc2.log", LOG_TO_FILE, true );

        // determine the max log level ( set in mapbrowser.xml )
        /*
        switch( $gszLogLevel )
          {
            case "LOG_ALL";
            $gnLogLevel = LOG_ALL;
            break;
          case "LOG_VERBOSE":
            $gnLogLevel = LOG_VERBOSE;
            break;
          case "LOG_QUIET":
            $gnLogLevel = LOG_QUIET;
            break;
          default:
            $gnLogLevel = LOG_OFF;
          } // switch
        */
        // set the max log level
        //$gLogFile->setMaxLogLevel( $gnLogLevel );

        // add log file parameters to the session for use elsewhere
        //$_SESSION["gnLogLevel"]= $gnLogLevel;
        //$_SESSION["gszLogPath"]= $gszLogPath;

        if (!isset($_SESSION["gErrorManager"] ) )
        {
            // create new error manager object
            $_SESSION["gErrorManager"]= new ErrorManager();
        }

        // create a logger object
        $oLog = new Logger( "General" );

        // set the global log file and error manager
        //$oLog->setLogFile( $gLogFile );
        $oLog->setErrorManager( $_SESSION["gErrorManager"] );

        $_SESSION['gszMapscriptModule'] =
                  $this->moContext->getContextValue("mapscript_module");

        $_SESSION['gszCurrentState'] = ((!isset($_SESSION['gszCurrentState'])) ? "" : $_SESSION['gszCurrentState']);
        $_SESSION['gszTmpWebPath'] = $gszTmpWebPath;
        $_SESSION['gszMapName'] = $this->mszMapFile;
        $_SESSION['gszMapPath'] = dirname($this->mszMapFile);
        $_SESSION['gnTimeout'] = $gnTimeout;
        $_SESSION['gszCurrentLanguage'] = $this->mszCurrentLanguage;

        // build list of languages to load
        $_SESSION['aszLang'] = array_keys( $this->maszTemplates );
    }


    /**
     * Not sure if that function is still needed
     */
    function resetFormVars()
    {
        // Reset some form variables when loading a new context or map file
        if(isset($GLOBALS["HTTP_FORM_VARS1"]["MAP_EXTENTS_MINX"]))
        {
            unset($GLOBALS["HTTP_FORM_VARS1"]["MAP_EXTENTS_MINX"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["MAP_EXTENTS_MINY"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["MAP_EXTENTS_MAXX"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["MAP_EXTENTS_MAXY"]);
        }

        if(isset($GLOBALS["HTTP_FORM_VARS1"]["Extent_MAXX"]))
        {
            unset($GLOBALS["HTTP_FORM_VARS1"]["Extent_MAXX"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["Extent_MAXY"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["Extent_MINX"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["Extent_MINY"]);
        }

        if(isset($GLOBALS["HTTP_FORM_VARS1"]["CursorPos_X"]))
        {
            unset($GLOBALS["HTTP_FORM_VARS1"]["CursorPos_X"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["CursorPos_Y"]);
        }

        if(isset($GLOBALS["HTTP_FORM_VARS1"]["MAP_WIDTH"]))
        {
            unset($GLOBALS["HTTP_FORM_VARS1"]["MAP_WIDTH"]);
            unset($GLOBALS["HTTP_FORM_VARS1"]["MAP_HEIGHT"]);
        }

        if(isset($GLOBALS["HTTP_FORM_VARS1"]["NAV_INPUT_COORDINATES"]))
            unset($GLOBALS["HTTP_FORM_VARS1"]["NAV_INPUT_COORDINATES"]);

        if(isset($GLOBALS["HTTP_FORM_VARS1"]["NAV_CMD"]))
            unset($GLOBALS["HTTP_FORM_VARS1"]["NAV_CMD"]);

        if(isset($GLOBALS["HTTP_FORM_VARS1"]["SCALE"]))
            unset($GLOBALS["HTTP_FORM_VARS1"]["SCALE"]);
    }
    
    /**
     * abstract moHttpFormVars via accessor function to check if a URL
     * variable was set in the page load
     * @param szVar the var to check
     * @return boolean flag indicating if var was set
     */
    function isVarSet( $szVar )
    {
        return $this->moHttpFormVars->isVarSet($szVar);
    }
    
    /**
     * return the value of a URL variable
     * @param szVar the var to get
     * @return string containing the value or false if key not found
     */
    function getVar( $szVar )
    {
        return $this->moHttpFormVars->getVar( $szVar );
    }
    
    /**
     * set the value of a URL variable, overwriting existing value if set
     * @param szVar the var to set
     * @param szValue the value to set
     * @return string containing the value or false if key not found
     */
    function setVar( $szVar, $szValue )
    {
        return $this->moHttpFormVars->setVar( $szVar, $szValue );
    }

    /**
     * &getWidgetByName($szName)
     *
     * Return a reference to a widget object
     * based on it's name. If more that one widget (with
     * the same name exist in template, return the first
     * one.
     *
     * @param $szName Widget name to return
     */

    function &getWidgetByName($szName)
    {
        $nWidgets = count($this->moUI->maoWidgets);

        foreach(array_keys($this->moUI->maoWidgets) as $szKey)
        {
            $oWidget =& $this->moUI->maoWidgets[$szKey];

            if ($oWidget->GetValue("TYPE") == $szName)
                return $oWidget;
        }

        return false;
    }
    
    function registerSkin( $szPath )
    {
        array_push( $this->maszSkinSearchPath, $szPath );
    }
    
    /**
     * this function attempts to locate a file in one of
     * (possibly) several locations.  If the original file
     * path is absolute, it will be returned as is.  If it
     * is relative, the it will be looked for in four possible
     * cases.
     * 
     * 1. relative to app path in skin search paths
     * 2. relative to app path
     * 3. relative to chameleon in skin search paths
     * 4. relative to chameleon
     *
     * @param szFilePath an absolute or relative path and file
     *        name to locate
     * @return an absolute path to the file or false if the file
     *         could not be found.
     */
    function findFile( $szFilePath )
    {
        //echo "finding: $szFilePath<BR>\n";
        /* case 1 - skin search path relative to app */
        foreach( array_reverse($this->maszSkinSearchPath) as $szPath )
        {
            $szTempPath = $this->resolvePath2( $szFilePath, $_SESSION['gszAppPath'].'/'.$szPath."/" );
            if ($szTempPath != "" && file_exists($szTempPath))
            {
                //echo "found: $szTempPath<BR>\n";
                return $szTempPath;
            }
        }
        
        /* case 2 - relative to app */
        $szTempPath = $this->resolvePath2( $szFilePath, $_SESSION['gszAppPath'] );
        if ($szTempPath != "" && file_exists($szTempPath))
        {
            //echo "found: $szTempPath<BR>\n";
            return $szTempPath;
        }
        
        /* case 3 - skin search path relative to chameleon */
        foreach( array_reverse($this->maszSkinSearchPath) as $szPath )
        {
            $szTempPath = $this->resolvePath2( $szFilePath, $_SESSION['gszCorePath'].'/'.$szPath.'/' );
            if ($szTempPath != "" && file_exists($szTempPath))
            {
                //echo "found: $szTempPath<BR>\n";
                return $szTempPath;
            }
        }
                
        /* case 4 - relative to chameleon */
        $szTempPath = $this->resolvePath2( $szFilePath, $_SESSION['gszCorePath'] );
        if ($szTempPath != "" && file_exists($szTempPath))
        {
            //echo "found: $szTempPath<BR>\n";
            return $szTempPath;
        }
        
        return false;
    }
    
    function fileSystemToURL( $szFileSystemPath )
    {
        $szFileSystemPath = str_replace( '\\', '/', $szFileSystemPath );
        $szFileSystemPath = ereg_replace ("/+", "/", $szFileSystemPath);
        //echo "filesystem path: $szFileSystemPath<BR>";
        
        $szAppPath = str_replace( '\\', '/', realpath($_SESSION['gszAppPath']) );
        $szAppPath = ereg_replace ("/+", "/", $szAppPath);
        //echo "app path: $szAppPath<BR>";
        
        if (strncmp( $szFileSystemPath, $szAppPath, strlen($szAppPath) ) == 0)
            return $_SESSION['gszAppWebPath'].'/'.substr( $szFileSystemPath, strlen($szAppPath));
        
        $szCorePath = str_replace( '\\', '/', realpath($_SESSION['gszCorePath']) );
        $szCorePath = ereg_replace ("/+", "/", $szCorePath);
        if (strncmp( $szFileSystemPath, $szCorePath, strlen($szCorePath) ) == 0)
            return $_SESSION['gszCoreWebPath'].'/'.substr($szFileSystemPath,strlen($szCorePath));
        
        return $szFileSystemPath;
    }
    
    /**
     * this function determines if a path represents an absolute path and returns
     * true if it is, and false if it is not
     * @param szPath the path to test
     * @result boolean, true if the path is absolute, false otherwise
     */
    function isAbsolutePath( $szPath )
    {
        if ($szPath == "") return false;
        if ($szPath[0] == "/" || preg_match('/^(\w:)/', $szPath)) 
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    /**
     * This function translate $szDestPath (relative or absolute)
     * to a absolute path based on $szOrigPath.
     *
     * @param $szDestPath Destination path to translate
     * @param $szOrigPath Refenrece path
     */
    function resolvePath2 ($szDestPath, $szOrigPath)
    {
        // If one or other path is missing or absolute, return it.
        if ($szDestPath == "") return $szOrigPath;
        if ($szOrigPath == "") return $szDestPath;
        if ($szDestPath[0] == "/" || preg_match('/^(\w:)/', $szDestPath))
        {
            return $szDestPath;
        }

        // If windows prefix (eg: c:) get it
        $szPrefix = "";
        if ($szOrigPath[0] != "/")
        {
            if (preg_match('/^(\w:)(.*)/i', $szOrigPath, $aMatch))
            {
                $szPrefix = $aMatch[1];
                $szOrigPath = $aMatch[2];
            }
            else
            {
                $szOrigPath = "/".$szOrigPath;
            }
        }

        // Make sure path finishing with "/"
        if ($szOrigPath[strlen($szOrigPath)-1] != "/" &&
            !is_dir($szOrigPath))
            $szOrigPath = dirname($szOrigPath)."/";
        if ($szOrigPath[strlen($szOrigPath)-1] != "/")
            $szOrigPath = $szOrigPath."/";

        $szPath = $szOrigPath.$szDestPath;
  
        // Remove repetitive "/"
        $szPath = ereg_replace ("/+", "/", $szPath);

        $szPath = $this->iterate_ereg_replace ("/\./", "/", $szPath);
        $szPath = $this->iterate_ereg_replace ("/[^(/|\.)]+/\.\./", "/", $szPath);
  
        //Rest of the function
        return $szPrefix.$szPath;
    }

    /**
     * Recursive ereg_replace
     */
    function iterate_ereg_replace ( $szPattern, $szReplacement, $szString)
    {
        $szResult = $szString;
        do
        {
            $szString = $szResult;
            $szResult = ereg_replace ($szPattern, $szReplacement, $szString);
        }
        while ($szResult != $szString);
  
        return $szResult;
    }
}

/**
 * Return a reference to the main application.
 */
function &GetChameleonApplication()
{
    if(isset($GLOBALS['oChameleonApp']))
        return $GLOBALS['oChameleonApp'];

    return false;
}
?>
