<?php
/**
 * Widget Manager
 *
 * @project     CWC2
 * @revision    $Id: WidgetManager.php,v 1.35 2004/07/07 11:28:31 wbronsema Exp $
 * @purpose     Utility class that create/register widgets
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
/*
if (@require_once 'PEAR/Registry.php')
    $GLOBALS['gbPear']=true;
else
*/
    $GLOBALS['gbPear']=false;

/**
 * class WidgetManager is a factory for creating widgets from tags found in
 * a Chameleon template.  The WidgetManager creates new instances of widgets
 * from widget tag
 *
 * $oWidgetMgr = WidgetManager( array( "c:/mywidgets" ) );
 * $oWidget = $oWidgetMgr->CreateWidgetUsingTag( '<CWC2 type="Title"/>" );
 *
 * The WidgetManager only loads widget classes on demand to optimize
 * performance.
 *
 * The WidgetManager also maintains an array of SharedResource widgets and
 * ensures that every widget created has a *reference* to this array.
 */
class WidgetManager
{
    /* the array of shared resources available to all widgets */
    var $maSharedResourceWidgets = array();
    
    /* directories that can be used to load widgets from */
    var $maszWidgetDirectories = array();

    /* packages that can be used to load widgets from (PEAR installed)*/
    var $maszWidgetPackages = array();
    
    /**
     * Initialize the widget manager, optionally taking an array of
     * directories that can be used to find widgets as required
     * @param aszExtraWidgetDir - an array of directory names to search
     *        for widgets in.
     */
    function WidgetManager($aszExtraWidgetDir = array())
    {
        // Register pear widgets
        if ($GLOBALS['gbPear'] && is_writable("../"))
        {
            $oRegistry = new PEAR_Registry("../");
            $aszPackages = $oRegistry->listPackages();

            foreach($aszPackages as $szPackage)
            {
                $aPackage = $oRegistry->packageInfo($szPackage);
                foreach ($aPackage['filelist'] as $szFileName => $aFileInfo)
                {
                    if (substr($szFileName, -11) == ".widget.php" && 
                        !in_array(dirname($aFileInfo['installed_as']), $this->maszWidgetDirectories))
                    {
                        $szVersion = substr(dirname($aFileInfo['installed_as']), -3);
                        $szVersion = implode(".", explode("_", $szVersion));
                        $this->maszWidgetPackages[substr(basename($szFileName), 0, -11)][$szVersion] = dirname($aFileInfo['installed_as']);
                    }
                }
            }
        }

        //register widgets
        array_push( $this->maszWidgetDirectories, 
                    realpath( dirname(__FILE__).'/widgets' ));
        $this->maszWidgetDirectories = array_merge( $aszExtraWidgetDir, $this->maszWidgetDirectories);
    }

    /**
     * ensure that a widget's class definition is available by 'include'ing
     * the widget's php file if necessary.
     * @param szWidget the widget to load
     * @param szVersion the widget version to load
     * @return boolean true if the widget is loaded, false if an error occured
     */
    function LoadWidget($szWidget, $szVersion="")
    {
        if (!class_exists($szWidget))
        {
            // If a version is specified, don't look in widget directories.
            if ($szVersion == "")
            {
                $i=-1;
                $nDirectories = count($this->maszWidgetDirectories);
                while( ++$i < $nDirectories )
                {
                    $szFile = $this->maszWidgetDirectories[$i].'/'.$szWidget.'/'.$szWidget.'.widget.php';
                    if (file_exists( $szFile ))
                    {
                        include( $szFile );
                        return $szWidget;
                    }
                }
            }

            //ini_set('include_path', ini_get('include_path').':/home/sacha/proj/chameleon/htdocs/widgets/');

            foreach ($this->maszWidgetPackages as $szName => $aszPackage)
            {
                if ($szWidget == $szName)
                {
                    if ($szVersion != "")
                    {
                        include($aszPackage[$szVersion].'/'.$szWidget.'/'.$szWidget.'.widget.php');
                        return $szWidget;
                    }
                    else
                    {
                        $szTmpVersion = "";
                        foreach($aszPackage as $szVersion => $aPackage)
                        {
                            if ($szTmpVersion < $szVersion)
                                $szTmpVersion = $szVersion;
                        }
                        include($aszPackage[$szTmpVersion].'/'.$szWidget.'/'.$szWidget.'.widget.php');
                        return $szWidget;                        
                    }
                }
            }
            return false;
        }
        return $szWidget;
    }

    /**
     * Create a new instance of a widget from the widget's tag.
     *
     * @param nWidgetID the unique id to give to the widget
     * @param szWidgetTag the tag to create the widget from
     *
     * @return the newly created widget or false
     */
    function &CreateWidgetUsingTag($nWidgetID, &$szWidgetTag)
    {
        $szClassName = $this->LoadWidget($this->ExtractClassName($szWidgetTag));
        if ($szClassName != false)
        {
            $szClass = $szClassName;
            $szEval = "\$oWidget =& new $szClass();";
            eval($szEval);

            $oWidget->SetUniqueId($nWidgetID);
            $bResult = $oWidget->InitUsingTag($szWidgetTag);

            if (!$bResult)
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                'ERROR: Initialization for '.$szClassName.' failed with an invalid attribute value.');
                return false;
            }

            $oWidget->mszWidgetName = $szClass;

            if ($szClass == 'SharedResource')
            {
                $this->maSharedResourceWidgets[$oWidget->maParams['NAME']] =& $oWidget;
            }
            else
            {
                $oWidget->SetSharedResourceWidgets($this->maSharedResourceWidgets);
            }
            return $oWidget;
        }
        else
        {
            $_SESSION['gErrorManager']->setError(ERR_WARNING,
            '"ERROR: Widget Definition for class \''.$szClassName.'\' not found (tag is '.htmlentities($szWidgetTag).').');
        }
        return false;
    }

    /**
     * extract the widget registry name from a tag
     * @param $szWidgetTag the tag to inspect
     * @return string the widget type
     */
    function ExtractClassName(&$szWidgetTag)
    {
        $szStart = substr(stristr($szWidgetTag, "type=\""), 6);

        return trim(substr($szStart, 0, strpos($szStart, "\"")));
    }

    /**
     * Get a list of all available widgets
     */
    function GetAvailableWidgets()
    {
        $aResult = array();

        $i=-1;
        $nDirectories = count($this->maszWidgetDirectories);
        while( ++$i < $nDirectories )
        {
            $fh = dir($this->maszWidgetDirectories[$i].'/');
            while (false !== ($szEntry = $fh->read()))
            {
                // skip '.'and '..'
                if ( $szEntry == '.' || $szEntry == '..' )
                {
                    continue;
                }
                
                // widgets are now nested in their own subdirectories
                // so check if the entry is a directory
                if ( is_dir( $this->maszWidgetDirectories[$i].'/'.$szEntry ) )
                {
                    // loop through the directory looking for widgets
                    $fp = dir( $this->maszWidgetDirectories[$i].'/'.$szEntry.'/' );
                    while ( false !== ( $szSubEntry = $fp->read() ) )
                    {
                        // check for widget
                        if (substr($szSubEntry, -11) == '.widget.php')
                        {
                            array_push($aResult, array(substr($szSubEntry, 0, -11), '',
                                $this->maszWidgetDirectories[$i].'/'.$szEntry.'/'));
                        }
                    }                    
                }
                
                // check if a widget still exists at this level
                if (substr($szEntry, -11) == '.widget.php')
                {
                    array_push($aResult, array(substr($szEntry, 0, -11), '', 
                                            $this->maszWidgetDirectories[$i].'/'));
                }
            }
        }

        //ini_set('include_path', ini_get('include_path').':/home/sacha/proj/chameleon/htdocs/widgets/');

        foreach ($this->maszWidgetPackages as $szName => $aszPackage)
        {
            foreach ($aszPackage as $szVersion => $szDir)
                array_push($aResult, array($szName, $szVersion, $szDir));
        }

        return $aResult;
    }
}//end of class
