<?php
/**
 *
 * @project     CWC2
 * @revision    $Id: UpdateMap.php,v 1.45 2004/06/18 02:31:47 pspencer Exp $
 * @purpose     Uses with CWCJS API to update the map file
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


// define the path to the components folder

// define the path to the components folder
//%DMPEAR_COMMON%
//%DMPEAR_WEBCOMMON%
if(!defined("COMMON"))
    define( "COMMON",  dirname(__FILE__)."/common/" );
if(!defined("WEBCOMMON"))
    define( "WEBCOMMON", dirname($_SERVER['PHP_SELF'])."/common/" );

// include the logging functions
include_once( COMMON."logger/logfile.php" );
include_once( COMMON."logger/error_manager.php" );
include_once( COMMON."logger/logger.php" );

include_once( COMMON."session/session.php");

// include wrapper file(s)
include_once(COMMON."wrapper/map_session.php" );
include_once( COMMON."wrapper/map_navigator.php" );

// include the mlt file
include_once( COMMON."mlt/mlt.php" );

//include the chameleon definitions
include_once( "chameleon.php" );

//init session
installSessionDirectoryHandler();
initializeSession("sid");

//echo "module " . $_SESSION['gszMapscriptModule'] . "<br>\n";

//print_r( $_SESSION );


//makse sure the module is loaded.
if (!extension_loaded("MapScript")) dl($_SESSION['gszMapscriptModule']);


// create a new map session object
// create a new map session object
if ($_SESSION['gnMapSessionMode'] == "1")
{
    $oMapSession = new MapSession_RW;
}
else
{
    $oMapSession = new MapSession_R;
}

// set the global log file and error manager
$oMapSession->setLogFile( $gLogFile );
$oMapSession->setErrorManager( $_SESSION["gErrorManager"] );

// set the temp directory for the map session
$oMapSession->setTempDir($_SESSION['gszTmpPath'] );

$oMapSession->restoreState( $_SESSION["gszCurrentState"],
                            $_SESSION['gszMapName'],
                            $_SESSION['gszMapPath'] );

$oMap = $oMapSession->oMap;

//get query variables
if (sizeof($_POST) > 0)
  $HTTP_FORM_VARS = $_POST;
else if (sizeof($_GET) > 0)
  $HTTP_FORM_VARS = $_GET;
else
  $HTTP_FORM_VARS = array("");

/* -------------------------------------------------------------------- */
/*      look for onload function name. If it exists It will be set      */
/*      on the bidy tag onload function.                                */
/* -------------------------------------------------------------------- */
if (isset($HTTP_FORM_VARS["ONLOAD_FUNCTION"]) && $HTTP_FORM_VARS["ONLOAD_FUNCTION"] != "")
  $szOnLoadFunc = $HTTP_FORM_VARS["ONLOAD_FUNCTION"];
else
  $szOnLoadFunc = "";

if (isset($HTTP_FORM_VARS["NETSCAPE4"]))
  $gbNescape4 = 1;
else
$gbNescape4 = 0;


//populate this variable with HTML form variables that should be sent back to the app.
$szFormContents = "";
$oHttpFormVars = new HttpFormVars($HTTP_FORM_VARS);

/* -------------------------------------------------------------------- */
/*      Look for nav commands.                                          */
/* -------------------------------------------------------------------- */
if (isset($HTTP_FORM_VARS["NAV_CMD"]) && $HTTP_FORM_VARS["NAV_CMD"] != "")
{
/* -------------------------------------------------------------------- */
/*      zoom in                                                         */
/* -------------------------------------------------------------------- */
    if ($HTTP_FORM_VARS["NAV_CMD"] == "ZOOM_IN")
    {
        include("widgets/ZoomIn/ZoomIn.widget.php");
        $oWidget = new ZoomIn();
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
    }

    if ($HTTP_FORM_VARS["NAV_CMD"] == "ZOOM_OUT")
    {

        include("widgets/ZoomOut/ZoomOut.widget.php");
        $oWidget = new ZoomOut();
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
    }

    if ($HTTP_FORM_VARS["NAV_CMD"] == "ZOOM_FULL")
    {

        include("widgets/ZoomAllLayers/ZoomAllLayers.widget.php");
        $oWidget = new ZoomAllLayers();
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
    }

    if ($HTTP_FORM_VARS["NAV_CMD"] == "RECENTER")
    {

        include("widgets/Recenter/Recenter.widget.php");
        $oWidget = new Recenter();
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
    }

    if ($HTTP_FORM_VARS["NAV_CMD"] == "PAN_MAP")
    {
        include("widgets/PanMap/PanMap.widget.php");
        $oWidget = new PanMap();
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
    }

    if ($HTTP_FORM_VARS["NAV_CMD"] == "ZOOM_BBOX")
    {
        include("widgets/BoundingBoxPopup/BoundingBoxPopup.widget.php");
        $oWidget = new BoundingBoxPopup();
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
    }


    if ($HTTP_FORM_VARS["NAV_CMD"] == "KEY_MAP")
    {

        include("widgets/KeyMap/KeyMap.widget.php");
        $oWidget = new KeyMap();
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
    }

    if (substr($HTTP_FORM_VARS["NAV_CMD"], 0, 13) == "COMPASS_POINT")
    {
        include("widgets/CompassPoint/CompassPoint.widget.php");
        $oWidget = new CompassPoint();
        $oWidget->mszDirection = strtoupper(substr( $HTTP_FORM_VARS["NAV_CMD"], 14 ));
        $oWidget->SetMap($oMapSession);
        $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
        $_SESSION["gszCurrentState"] = $oMapSession->saveState();
        
        //print_r($HTTP_FORM_VARS);
        
    }

    $szFormContents .= BuildHTMLOutputMapExtentsChanged($oMap);
}

//scale zoom : ?? should be in nav tools
if (isset( $HTTP_FORM_VARS["SCALE_ZOOM"]) &&
    $HTTP_FORM_VARS["SCALE_ZOOM"] != "")
{
    include("widgets/ScaleZoom/ScaleZoom.widget.php");
    $oWidget = new ScaleZoom();
    $oWidget->SetMap($oMapSession);
    $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
    $_SESSION["gszCurrentState"] = $oMapSession->saveState();

    $szFormContents .= BuildHTMLOutputMapExtentsChanged($oMap);
}

//quick zoom

if (isset( $HTTP_FORM_VARS["NAV_QUICKZOOM"]) &&
    $HTTP_FORM_VARS["NAV_QUICKZOOM"] != "")
{
    //echo "quick zoom : " . $HTTP_FORM_VARS["NAV_QUICKZOOM"] . "<br> \n";
    include("widgets/QuickZoom/QuickZoom.widget.php");
    $oWidget = new QuickZoom();
    $oWidget->SetMap($oMapSession);
    $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
    $_SESSION["gszCurrentState"] = $oMapSession->saveState();

    $szFormContents .= BuildHTMLOutputMapExtentsChanged($oMap);
}

//
// Projection Changes
//
if (isset( $HTTP_FORM_VARS["MAP_PROJECTION"] ))
{
  
    include("widgets/ProjectionSelector/ProjectionSelector.widget.php");
    $oWidget = new ProjectionSelector();
    $oWidget->SetMap($oMapSession);
    $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
    $_SESSION["gszCurrentState"] = $oMapSession->saveState();

    $szFormContents .= BuildHTMLOutputMapExtentsChanged($oMap);
    $szFormContents .= BuildHTMLOutputProjectionChanged($oMap);
}

//layer status update
if (isset( $HTTP_FORM_VARS["LAYER_STATUS_CHANGED"] ))
{
    //echo "LAYER_STATUS_CHANGED";
    for ($i=0; $i<$oMap->numlayers; $i++)
    {
        $oLayer = $oMap->GetLayer($i);
        if ($oLayer->connectiontype == MS_WMS)
          $szName = $oLayer->getMetaData("wms_name");
        else
          $szName = $oLayer->name;
        if(isset($HTTP_FORM_VARS[$szName]) )
        {
            //echo "layer = $szName " . "status = " . $HTTP_FORM_VARS[$szName];
            $oLayer->set("status", $HTTP_FORM_VARS[$szName]);
        }
    }
}

//layer order update
if (isset( $HTTP_FORM_VARS["LAYER_ORDER_CHANGED"] ))
{
    $szLayerOrder = $HTTP_FORM_VARS["LAYER_ORDER_CHANGED"];
    $aLayerOder = explode(",", $szLayerOrder);
    if (count($aLayerOder) == $oMap->numlayers)
    {
        $oMap->setlayersdrawingorder($aLayerOder);
    }
}

//layer style update
if (isset( $HTTP_FORM_VARS["LAYER_STYLE_CHANGED"] ))
{
    for ($i=0; $i<$oMap->numlayers; $i++)
    {
        $oLayer = $oMap->GetLayer($i);
        if ($oLayer->connectiontype == MS_WMS)
          $szName = $oLayer->getMetaData("wms_name");
        else
          $szName = $oLayer->name;
        if(isset($HTTP_FORM_VARS[$szName]))
        {
            $szStyle = urldecode($HTTP_FORM_VARS[$szName]);;
            $oLayer->setMetadata("wms_style", $szStyle);
        }
    }
}


//add new wms layer
if (isset( $HTTP_FORM_VARS["ADD_NEW_WMS_LAYER"]))
{
    if (isset( $HTTP_FORM_VARS["LAYER_NAME"]) &&
        isset( $HTTP_FORM_VARS["LAYER_TITLE"]) &&
        isset( $HTTP_FORM_VARS["LAYER_SRS"]) &&
        isset( $HTTP_FORM_VARS["LAYER_CONNECTION"]) &&
        isset( $HTTP_FORM_VARS["LAYER_VERSION"]) &&
        isset( $HTTP_FORM_VARS["LAYER_FORMAT"]) )
    {
        $oNewLayer = ms_newLayerObj($oMap);
        $oNewLayer->set("name",$HTTP_FORM_VARS["LAYER_NAME"]);
        $oNewLayer->set("type",MS_RASTER);
        $oNewLayer->set( "status", MS_ON );
        $oNewLayer->set( "connection",$HTTP_FORM_VARS["LAYER_CONNECTION"]  );
        $oNewLayer->set( "connectiontype",MS_WMS);
        $oNewLayer->setMetaData("wms_srs", $HTTP_FORM_VARS["LAYER_SRS"]);
        $oNewLayer->setMetaData("wms_onlineresource", $HTTP_FORM_VARS["LAYER_CONNECTION"]);
        $oNewLayer->setMetaData("wms_name", $HTTP_FORM_VARS["LAYER_NAME"]);
        $oNewLayer->setMetaData("wms_title", $HTTP_FORM_VARS["LAYER_TITLE"]);
        $oNewLayer->setMetaData("wms_server_version", $HTTP_FORM_VARS["LAYER_VERSION"]);
        $oNewLayer->setMetaData("wms_format", $HTTP_FORM_VARS["LAYER_FORMAT"]);
        //$oNewLayer->setMetaData("wms_formatlist", "image/gif,image/png,image/jpeg,image/wbmp");

        $szFormContents .= BuildHTMLOutputNewLayerChanged($oNewLayer);

    }

}
//add new point and rectangle : oMap.AddPoint and oMap.AddRectangle
if (isset( $HTTP_FORM_VARS["ADD_NEW_FEATURE"] ))
{
    //echo $HTTP_FORM_VARS["ADD_NEW_FEATURE"];

    if (!extension_loaded("dbase"))
    {
      if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
        dl("php_dbase.dll");
      else
        dl("php_dbase.so");
    }


    include("widgets/Locate/Locate.widget.php");
    $oWidget = new Locate();
    $oWidget->SetMap($oMapSession);
    $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
    //$_SESSION["gszCurrentState"] = $oMapSession->saveState();

    $szFormContents .= BuildHTMLOutputMapExtentsChanged($oMap);
}


//add new point from the locate widget
if (isset( $HTTP_FORM_VARS["ADD_POINT_WIDGET"] ) ||
    isset( $HTTP_FORM_VARS["ADD_RECTANGLE_WIDGET"] ) )
{
    if (!extension_loaded("dbase"))
    {
      if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
        dl("php_dbase.dll");
      else
        dl("php_dbase.so");
    }

    include("widgets/Locate/Locate.widget.php");
    $oWidget = new Locate();
    $oWidget->SetMap($oMapSession);
    $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);
    //$_SESSION["gszCurrentState"] = $oMapSession->saveState();

    $szFormContents .= BuildHTMLOutputMapExtentsChanged($oMap);
}

// set the expression from the expression builder widget
if (isset( $HTTP_FORM_VARS["WFS_APPLY_EXPRESSIONLIST"] ))
{
    include("widgets/ExpressionBuilder/ExpressionBuilder.widget.php");
    $oWidget = new ExpressionBuilder();
    $oWidget->SetMap($oMapSession);
    $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS); 

    // execute update to let other JSAPI aware widgets update
    $szFormContents .= BuildHTMLOutputMapExtentsChanged( $oMap );
}

//reproject point
if (isset( $HTTP_FORM_VARS["REPROJECT_POINT"] ))
{
    if(isset($HTTP_FORM_VARS["REPROJECT_FROM"]) &&
       isset($HTTP_FORM_VARS["REPROJECT_TO"]) &&
       isset($HTTP_FORM_VARS["FUNCTION_CALLBACK"]))
    {
        $oMap = $oMapSession->oMap;

        $projInObj = ms_newprojectionobj("init=".
                                         strtolower($HTTP_FORM_VARS["REPROJECT_FROM"]));
        $projOutObj = ms_newprojectionobj("init=".
                                          strtolower($HTTP_FORM_VARS["REPROJECT_TO"]));
        $poPoint = ms_newpointobj();

        $aPoint = explode("|", $HTTP_FORM_VARS["REPROJECT_POINT"]);
        if (count($aPoint) == 2)
        {
            $poPoint->setXY($aPoint[0], $aPoint[1]);
            $poPoint->project($projInObj, $projOutObj);

            // set the variables
            $szFormContents.= "<input type='hidden' name='REPROJECTED_POINT_X' value='".
              $poPoint->x."'/>\n";
            $szFormContents.= "<input type='hidden' name='REPROJECTED_POINT_Y' value='".
              $poPoint->y."'/>\n";

            $szFormContents.= "<input type='hidden' name='FUNCTION_CALLBACK'".
                              " value='".$HTTP_FORM_VARS["FUNCTION_CALLBACK"].
                              "'/>\n";
        }
    }
}


//add grid layer
if (isset($HTTP_FORM_VARS["ADD_NEW_GRID_LAYER"] ))
{
    $oMap = $oMapSession->oMap;

    $szName = "grid";
    if ($HTTP_FORM_VARS["NAME"] != "")
      $szName = $HTTP_FORM_VARS["NAME"];

    $oLayer = ms_newlayerobj($oMap);
    $oLayer->set("name", $szName);

    $oLayer->set("type", MS_LAYER_LINE);
    $oLayer->set("status", MS_ON);


    if ($HTTP_FORM_VARS["PROJECTION"] != "")
    {
        $szFinalProj = "";
        if (strncasecmp(trim($HTTP_FORM_VARS["PROJECTION"]), "AUTO", 4) ==0)
        {
            $szFinalProj = trim($HTTP_FORM_VARS["PROJECTION"]);
            $nCenterX = ($oMap->extent->minx + $oMap->extent->maxx) / 2.0;
            $nCenterY = ($oMap->extent->miny + $oMap->extent->maxy) / 2.0;
            $oCenter = ms_newPointObj( );
            $oCenter->setXY( $nCenterX, $nCenterY );

            $szMapProj = $oMap->getProjection();
            $oProj = ms_newProjectionObj($szMapProj);

            $oLatLonProj = ms_newProjectionObj("proj=latlong");
            $oCenter->project($oProj, $oLatLonProj);

            $aProjElem = split(",",$szFinalProj);
            $nProjElem = count($aProjElem);
            if ($nProjElem == 1)
            {
                $szFinalProj =
                  $szFinalProj.",9001".",".$oCenter->x.",".$oCenter->y;
            }
            else if ($nProjElem == 4) //valid AUTO projection
            {
                $szFinalProj =
                  $aProjElem[0].",".AUTO_PROJECTION_UNIT.",".$oCenter->x.",".$oCenter->y;
            }
            else
              $szFinalProj = "";
        }
        else if (strncasecmp(trim($HTTP_FORM_VARS["PROJECTION"]), "epsg", 4)== 0)
        {
            $szFinalProj = "init=".strtolower(trim($HTTP_FORM_VARS["PROJECTION"]));
        }
        if ($szFinalProj != "")
          $oLayer->setprojection($szFinalProj);
    }
    //create class with a style and set the label object
    $oClass = ms_newClassObj($oLayer);
    $oStyle = ms_newStyleObj($oClass);

    $aColor[0] = 0;
    $aColor[1] = 0;
    $aColor[2] = 0;
    if ($HTTP_FORM_VARS["COLOR"]!= "")
      $aColor = explode(",", $HTTP_FORM_VARS["COLOR"]);

    $oStyle->color->setRGB($aColor[0], $aColor[1], $aColor[2]);


    //echo "font = " . $HTTP_FORM_VARS["LABELFONT"] . "<br>";
    if ($HTTP_FORM_VARS["LABELFONT"] != "")
    {
        $oClass->label->set("font", $HTTP_FORM_VARS["LABELFONT"]);
        $oClass->label->set("type", MS_TRUETYPE);
    }
    else
      $oClass->label->set("type", MS_BITMAP);

    $aColor[0] = 0;
    $aColor[1] = 0;
    $aColor[2] = 0;
    if ($HTTP_FORM_VARS["LABELCOLOR"]!= "")
      $aColor = explode(",", $HTTP_FORM_VARS["LABELCOLOR"]);
    $oClass->label->color->setRGB($aColor[0], $aColor[1], $aColor[2]);

    //echo "label size = " . $HTTP_FORM_VARS["LABELSIZE"];
    if ($HTTP_FORM_VARS["LABELSIZE"] != "")
      $oClass->label->set("size", $HTTP_FORM_VARS["LABELSIZE"]);
    else
      $oClass->label->set("size", MS_MEDIUM);


    //add the grid object
    ms_newgridobj($oLayer);

/* ==================================================================== */
/*      Get the layer object once the grid is added.                    */
/* ==================================================================== */
    $oLayer = $oMap->getlayerbyname($oLayer->name);

    if ($HTTP_FORM_VARS["LABELFORMAT"] != "")
      $oLayer->grid->set("labelformat", $HTTP_FORM_VARS["LABELFORMAT"]);

    if ($HTTP_FORM_VARS["MINSUBDIVIDE"] != "")
      $oLayer->grid->set("minsubdivide", $HTTP_FORM_VARS["MINSUBDIVIDE"]);

    if ($HTTP_FORM_VARS["MAXSUBDIVIDE"] != "")
      $oLayer->grid->set("maxsubdivide", $HTTP_FORM_VARS["MAXSUBDIVIDE"]);

    //echo "minin = " . $HTTP_FORM_VARS["MININTERVAL"];
    if ($HTTP_FORM_VARS["MININCREMENT"] != "")
      $oLayer->grid->set("mininterval", $HTTP_FORM_VARS["MININTERVAL"]);

    if ($HTTP_FORM_VARS["MAXINTERVAL"] != "")
      $oLayer->grid->set("maxinterval", $HTTP_FORM_VARS["MAXINTERVAL"]);

    if ($HTTP_FORM_VARS["MINARCS"] != "")
      $oLayer->grid->set("minarcs", $HTTP_FORM_VARS["MINARCS"]);

    if ($HTTP_FORM_VARS["MAXARCS"] != "")
      $oLayer->grid->set("maxarcs", $HTTP_FORM_VARS["MAXARCS"]);

    $szFormContents .= BuildHTMLOutputNewLayerChanged($oLayer);
}

//create new layer
if (isset( $HTTP_FORM_VARS["CREATE_NEW_LAYER"]) &&
    $HTTP_FORM_VARS["CREATE_NEW_LAYER"] != "")
{
    $oMap = $oMapSession->oMap;

    $szType = "POINT";
    if (isset($HTTP_FORM_VARS["TYPE"]))
      $szType = trim($HTTP_FORM_VARS["TYPE"]);

    $nType =  MS_LAYER_POINT;
    if (strcasecmp($szType, "POINT") == 0)
      $nType =  MS_LAYER_POINT;
    else if (strcasecmp($szType, "LINE") == 0)
       $nType =  MS_LAYER_LINE;

    $szName = "cwcjsapi new layer";
    if (isset($HTTP_FORM_VARS["NAME"]))
      $szName = trim($HTTP_FORM_VARS["NAME"]);

     $oLayer = ms_newlayerobj($oMap);
     $oLayer->set("name", $szName);
     $oLayer->set("type", $nType);
     $oLayer->set("status", MS_ON);

     $szFormContents .= BuildHTMLOutputNewLayerChanged($oLayer);
}

//set layer projection
if (isset( $HTTP_FORM_VARS["LAYER_PROJECTION_CHANGED"]) &&
    $HTTP_FORM_VARS["LAYER_PROJECTION_CHANGED"] != "")
{
    //echo "LAYER_PROJECTION_CHANGED";

    $oMap = $oMapSession->oMap;

    $nLayerIndex = -1;
    if (isset($HTTP_FORM_VARS["LAYER_INDEX"]))
      $nLayerIndex = $HTTP_FORM_VARS["LAYER_INDEX"];
    $szProjection = "";
    if (isset($HTTP_FORM_VARS["PROJECTION"]))
      $szProjection = $HTTP_FORM_VARS["PROJECTION"];

    if ($nLayerIndex >=0 && $nLayerIndex < $oMap->numlayers &&
        $szProjection != "")
    {
        $oLayer = $oMap->getlayer($nLayerIndex);
        $oLayer->setprojection("init=".strtolower($szProjection));
    }
}


// Load resource
if (isset( $HTTP_FORM_VARS["LOAD_RESOURCE"]) &&
    $HTTP_FORM_VARS["LOAD_RESOURCE"] != "")
{
    // include the mlt file
    include_once( COMMON."mlt/mlt.php" );

    // create a new MLT object
    $oTmpMLT = new MLTdBase($HTTP_FORM_VARS["LOAD_RESOURCE"]);
    $oTmpMLT->setErrorManager($_SESSION["gErrorManager"]);

    // load the resourcre file into memory
    $oTmpMLT->loadResource("widgets/cwcjsapi/jsapi.dbf", $HTTP_FORM_VARS["LOAD_RESOURCE"]);

    $nbResource = count($oTmpMLT->aszMLT);
    $szFormContents .= "<input type='hidden' name='NB_RESOURCE' value='".
      $nbResource."'/>\n";

    $j=0;
    foreach($oTmpMLT->aszMLT as $szKey => $szValue)
    {
        $szFormContents .= "<input type='hidden' name='RESOURCE_ID_".$j."' ".
          "value='".urlencode(trim($szKey))."'/>\n";

        $szFormContents .= "<input type='hidden' name='RESOURCE_TXT_".$j."' ".
          "value='".urlencode(trim($oTmpMLT->get(strtoupper($szKey))))."'/>\n";

        $j++;
    }
}

// Load Error
if (isset( $HTTP_FORM_VARS["LOAD_SERVER_ERROR"]) &&
    $HTTP_FORM_VARS["LOAD_SERVER_ERROR"] == "1")
{
    $nbError = $_SESSION['gErrorManager']->nErrorCount;
    $szFormContents .= "<input type='hidden' name='NB_ERROR' value='".
      $nbError."'/>\n";

    for ($j=0;$j<$nbError;$j++)
    {
      $oError = $_SESSION['gErrorManager']->popLastError();
      $szFormContents .= "<input type='hidden' name='ERROR_ID_".$j."' ".
        "value='".urlencode(trim($oError->nErrorType))."'/>\n";

      $szFormContents .= "<input type='hidden' name='ERROR_TXT_".$j."' ".
        "value='".urlencode(trim($oError->szMessage))."'/>\n";
    }
}

// Process the legend template
if (isset( $HTTP_FORM_VARS["PROCESS_L_TEMPLATE"]) &&
    $HTTP_FORM_VARS["PROCESS_L_TEMPLATE"] == "1")
{
    include("widgets/LegendTemplate/LegendTemplate.widget.php");
    $oWidget = new LegendTemplate();
    $oWidget->SetMap($oMapSession);
    $oWidget->SetURL($oHttpFormVars, $HTTP_FORM_VARS);

    // replace all ' and "
    $checkString = $oWidget->DrawPublish();
    $newString = str_replace( "'", "#!#", $checkString );
    $newString = str_replace( "\"", "#!!#", $newString );

    $szFormContents .= "<input type=\"hidden\" name=\"UPDATE_LEGEND_TEMPLATE_RESULTS".
                    "\" value='".$newString."'>\n";
}

//save context
if (isset( $HTTP_FORM_VARS["SAVE_CONTEXT"]))
{
    $oMap = $oMapSession->oMap;
    $szFileName = tempnam($_SESSION['gszTmpImgPath'], "").".cml";
    if (isset($_SESSION['gszSchemasLocation']))
    {
        $oMap->setMetadata("ows_schemas_location",
                           $_SESSION['gszSchemasLocation']);
    }
    $oMap->savemapcontext($szFileName);
    


    $szBaseName = basename($szFileName);
    $szBaseName = trim($szBaseName, "\\,/");

    if (substr($_SESSION['gszTmpWebPath'], -1) != "/" &&
        substr($_SESSION['gszTmpWebPath'], -1) != "\\" )
      $szFileURL = $_SESSION['gszTmpWebPath']."/".$szBaseName;
    else
      $szFileURL = $_SESSION['gszTmpWebPath'].$szBaseName;

    //echo $szFileURL;
    // set the variables
    $szFormContents.= "<input type='hidden' name='FILENAME' value='".
              $szFileURL."'/>\n";

    $szFormContents.= "<input type='hidden' name='FUNCTION_CALLBACK'".
                              " value='".$HTTP_FORM_VARS["FUNCTION_CALLBACK"].
                              "'/>\n";
  
}
 
$_SESSION["gszCurrentState"] = $oMapSession->saveState();

//output the final result
echo BuildHTMLOutput( $szOnLoadFunc, $szFormContents, $gbNescape4 );

/**
 * BuildHTMLOutputMapExtentsChanged
 *
 * Utility function to output html code with hidden varaiables
 * for map elements.
 */
function BuildHTMLOutputMapExtentsChanged($oMap)
{
    $nPixSize = $oMap->width;
    $nGeoSize = $oMap->extent->minx -
                 $oMap->extent->maxx;

    $nPixelSize = abs($nPixSize / $nGeoSize);

    if ($nPixelSize > 1)
        $nNbDecimal = abs(log($nPixelSize))/log(10)+1;
    else
        $nNbDecimal = 0;

    $nExtentMinx = number_format($oMap->extent->minx, $nNbDecimal, ".", "");
    $nExtentMiny = number_format($oMap->extent->miny, $nNbDecimal, ".", "");
    $nExtentMaxx = number_format($oMap->extent->maxx, $nNbDecimal, ".", "");
    $nExtentMaxy = number_format($oMap->extent->maxy, $nNbDecimal, ".", "");


    $szResult = "<input type=\"hidden\" name=\"MAP_EXTENT_MINX\" value=".$nExtentMinx."> <br>\n";
    $szResult .= "<input type=\"hidden\" name=\"MAP_EXTENT_MINY\" value=".$nExtentMiny."> <br>\n";
    $szResult .= "<input type=\"hidden\" name=\"MAP_EXTENT_MAXX\" value=".$nExtentMaxx."> <br>\n";
    $szResult .= "<input type=\"hidden\" name=\"MAP_EXTENT_MAXY\" value=".$nExtentMaxy."> <br>\n";

    $szResult .= "<input type=\"hidden\" name=\"MAP_SCALE\" value=".$oMap->scale."> <br>\n";

    $szResult .= "<input type=\"hidden\" name=\"MAP_CELLSIZE\" value=".$oMap->cellsize."> <br>\n";

    $szResult .= "<input type=\"hidden\" name=\"MAP_WIDTH\" value=".$oMap->width."> <br>\n";

    $szResult .= "<input type=\"hidden\" name=\"MAP_HEIGHT\" value=".$oMap->height."> <br>\n";

    return $szResult;
}

/**
 * build form elements for a projection change
 */
function BuildHTMLOutputProjectionChanged( $oMap )
{
    if (is_object($oMap))
        $szProj = $oMap->getProjection();
    else
        $szProj = "init=EPSG:None";
    $szProj = substr( $szProj, 5 );

    $szResult = "<input type=\"hidden\" name=\"MAP_PROJECTION\" value=\"".$szProj."\"?<BR>\n";
    return $szResult;
}

/**
 * BuildHTMLOutputMapExtentsChanged
 *
 * Utility function to output html code with hidden varaiables
 * for map elements.
 */
function BuildHTMLOutputNewLayerChanged($oLayer)
{
    $szName = $oLayer->name;
    if ($oLayer->connectiontype == MS_WMS)
      $szName =  $oLayer->getMetaData("wms_name");

    $szResult = "<input type=\"hidden\" name=\"LAYER_NAME\" value=\"".$szName."\"><BR>\n";
    $szResult .= "<input type=\"hidden\" name=\"LAYER_INDEX\" value=\"".$oLayer->index."\"><BR>\n";
    $szResult .= "<input type=\"hidden\" name=\"LAYER_STATUS\" value=\"".$oLayer->status."\"><BR>\n";
    $szResult .= "<input type=\"hidden\" name=\"LAYER_TYPE\" value=\"".$oLayer->type."\"><BR>\n";
    $szResult .= "<input type=\"hidden\" name=\"LAYER_DATA\" value=\"".$oLayer->data."\"><BR>\n";
    $szTitle = "";
    if ($oLayer->connectiontype == MS_WMS)
      $szTitle = $oLayer->getMetaData("wms_title");
    $szResult .= "<input type=\"hidden\" name=\"LAYER_TITLE\" value=\"".$szTitle."\"><BR>\n";

    $szResult .= "<input type=\"hidden\" name=\"LAYER_CONNECTION\" value=\"".$oLayer->connection."\"><BR>\n";

    $szResult .= "<input type=\"hidden\" name=\"LAYER_CONNECTIONTYPE\" value=\"".$oLayer->connectiontype."\"><BR>\n";

     $szResult .= "<input type=\"hidden\" name=\"LAYER_ONLINERESOURCE\" value=\"".$oLayer->getMetaData("wms_onlineresource")."\"><BR>\n";

     $szResult .= "<input type=\"hidden\" name=\"LAYER_SRS\" value=\"".$oLayer->getMetaData("wms_srs")."\"><BR>\n";

     $szResult .= "<input type=\"hidden\" name=\"LAYER_VERSION\" value=\"".$oLayer->getMetaData("wms_server_version")."\"><BR>\n";

     $szResult .= "<input type=\"hidden\" name=\"LAYER_FORMAT\" value=\"".$oLayer->getMetaData("wms_format")."\"><BR>\n";

     $szResult .= "<input type=\"hidden\" name=\"LAYER_FORMATLIST\" value=\"".$oLayer->getMetaData("wms_formatlist")."\"><BR>\n";

     $szResult .= "<input type=\"hidden\" name=\"LAYER_STYLE\" value=\"".$oLayer->getMetaData("wms_style")."\"><BR>\n";

     $szResult .= "<input type=\"hidden\" name=\"LAYER_STYLELIST\" value=\"".$oLayer->getMetaData("wms_stylelist")."\"><BR>\n";

    return $szResult;
}

/**
 * build an output form using the given contents
 */
function BuildHTMLOutput( $szOnLoadFunc, $szContents, $bNetscape4=0)
{
    $nLoadFunc = 0;
    if ($szOnLoadFunc != "")
    {
        //echo "passed : " . $szOnLoadFunc . "<br>\n";
        $aLoadFunc = explode(";",$szOnLoadFunc);
        $nLoadFunc = count($aLoadFunc);
        //echo "onloadfunc = " . $nLoadFunc ."<br>\n";
    }

    $szFuncStr = "";
    for ($i=0; $i<$nLoadFunc; $i++)
    {
        if (trim($aLoadFunc[$i]) != "")
        {
            if ($bNetscape4)
              $szFuncStr .= "". $aLoadFunc[$i] . ";";
            else
              $szFuncStr .= "p.". $aLoadFunc[$i] . ";";
        }
    }
    //echo "final : " . $szFuncStr . "<br>\n";
    //IE and NS > 4
    if (!$bNetscape4)
      $szResult = "<html><body onload=\"p=document.layers?parentLayer:window.parent;" . $szFuncStr. ";p.goCWCJSAPI.CheckCallStack()\";><form> <br>\n";
    else //NS4
      $szResult = "<html><body onload='" . $szFuncStr. ";goCWCJSAPI.CheckCallStack()';><form name=\"cwcjsapin4\"> <br>\n";

    //    else
    //$szResult = "<html><body><form>";

    $szResult .= $szContents;

    //echo "this is outputed by UpdateMap.php <br>";
    $szResult .= "</form></body></html>";

    return $szResult;
}
?>
