<?php
/**
 * User Interface Manager
 *
 * @project     CWC2
 * @revision    $Id: UIManager.php,v 1.42 2004/05/20 23:38:01 pspencer Exp $
 * @purpose     Parse the UI Context file and create the widgtes
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once("TemplateParser.php");
include_once("WidgetManager.php");
include_once("widgets/Widget.php");


/**
 * User Interface Management class, this provides the wrapper for different
 * applications to parse a UI Template into widgets, process changes to the
 * widgets, and output an HTML result
 */
class UIManager
{
    var $mszUITemplate ="";
    var $oCWCParser;
    var $mnErrorCode = 0;
    var $maoWidgets = array();
    var $manPriorities = array();
    var $moWidgetManger;
    var $moMapObject;
    var $maJSFunctions = array();
    var $maJSVariables = array();
    var $maHTMLVariables = array();
    var $maJSOnLoadFunctions = array();
    var $maJSOnMouseMoveFunctions = array();
    var $maJSOnMouseDownFunctions = array();
    var $maJSOnMouseUpFunctions = array();
    var $maJSInitFunctions = array();
    var $maJSIncludeFunctions = array();

    /**
     * create a new UIMananger instance
     * @param $szUITemplate the template to use
     * @param &$oMapObject the map session object to use
     */
    function UIManager(&$szUITemplate, &$oMapObject, $aszWidgetdDir=array())
    {
        $this->mszUITemplate =& $szUITemplate;
        $this->moMapObject =& $oMapObject;

        $this->oCWCParser = new CWCTemplateParser(GetChameleonApplication());

        $this->moWidgetManger = new WidgetManager($aszWidgetdDir) ;

        for ($i=PRIORITY_MAXIMUM; $i>=PRIORITY_MINIMUM; $i--)
            $this->manPriorities[$i] = array();

        if ($this->Parse())
        {
            $this->CreateWidgets();
        }
    }

    /**
     * parse the UI Template
     */
   function Parse()
   {
        $this->oCWCParser->SetTemplate($this->mszUITemplate);
        if (!$this->oCWCParser->Parse())
          $this->mnErrorCode = 2;

        return true;
    }

    /**
     * create widgets from the parsed template
     */
    function CreateWidgets()
    {
        if ($this->mnErrorCode == 0)
        {
            $this->maoWidgets = array();
            $nWidgets = $this->oCWCParser->NumElements();

            for ($i=0; $i<$nWidgets; $i++)
            {
                $szTag = trim($this->oCWCParser->GetElement( $i ));
                $oWidget =& $this->moWidgetManger->CreateWidgetUsingTag( $i, $szTag );
                if (!is_object( $oWidget ) || $oWidget === false)
                {
                    $szTag = "<FONT SIZE=2 COLOR=#FF3333>".htmlentities( $szTag )."</FONT>";
                    $this->oCWCParser->SetElement( $i, $szTag );
                    continue;
                }
                $oWidget->SetMap($this->moMapObject);
                $this->maoWidgets[$i] =& $oWidget;
                //record widget priority
                $nPriority = $oWidget->mnPriority;
                array_push($this->manPriorities[$nPriority] ,$i);
            }

            for ($i=0; $i<$nWidgets; $i++)
            {
                // Make sure widget exist.
                if (isset($this->maoWidgets[$i]) && is_object( $this->maoWidgets[$i] ))
                {
                    $this->maoWidgets[$i]->InitDefaults();
                }
            }
        }
    }

    /**
     * process the application parameters coming over the URL by passing it
     * to each widget in priority sequence
     * @param $aURL the array of URL values ($_GET or $_POST)
     *        aURL is going to be deprecated in place of $oApp->moHttpFormVars
     */
    function ProcessURL(&$aURL)
    {
        $oApp = GetChameleonApplication();

        for ($i=PRIORITY_MAXIMUM; $i>=PRIORITY_MINIMUM; $i--)
        {
            foreach( $this->manPriorities[$i] as $nWidgetIndex )
            {
                if (!$this->maoWidgets[$nWidgetIndex]->SetURL($oApp->moHttpFormVars, $aURL))
                {
                    echo "<!-- ".$this->maoWidgets[$nWidgetIndex]->mszWidgetName." ParseURL Failed ! -->\n\n";
                    
                    if ($oApp->mszLastTemplateName!=$oApp->mszTemplateName &&
                        $oApp->mszLastTemplateName!="")
                        return false;
                }
            }
        }

        return true;
    }


/************************************************************************/
/*                          function PrepareDrawPublish()                      */
/*                                                                      */
/*      Prepare the output using the widgets.                        */
/************************************************************************/
    function PrepareDrawPublish()
    {
        //get javascript code from widgets
        $this->ProcessWidgetIncludes();

        //process widgets into template
        for ($i=PRIORITY_MAXIMUM; $i>=PRIORITY_MINIMUM; $i--)
        {
            foreach( $this->manPriorities[$i] as $nWidgetIndex )
            {
                $oWidget =& $this->maoWidgets[$nWidgetIndex];
                $this->oCWCParser->SetElement( $nWidgetIndex, $oWidget->DrawPublish() );
            }
        }
        $this->oCWCParser->ProcessElements();

        //process main javascript block
    $szHTML = "";
        
        $szJSVar = "";
        //write variables
        while ( list( $key, $val ) = each($this->maJSVariables))
        {
            $szJSVar .= "\n";
            $szJSVar .=  $this->maJSVariables[$key];
        }

        //write all general javascript functions
        while ( list( $key, $val ) = each($this->maJSFunctions))
        {
            $szJSVar .= "\n";
            $szJSVar .=  $this->maJSFunctions[$key];
        }

        $szOnLoadFunc = "";
        //write the onload function
        while ( list( $key, $val ) = each($this->maJSOnLoadFunctions))
        {
            $szOnLoadFunc .= "\n";
            $szOnLoadFunc .=  $this->maJSOnLoadFunctions[$key];
        }

        //if ($szOnLoadFunc != "")
        //{
            $szOnLoadFunc = "function CWC2OnLoadFunction()\n{\n".$szOnLoadFunc;
            $szOnLoadFunc.= "\n}\n";
        //}

        $szOnMouseMove = "";
        //add javascript onmousemove functions
        if (count($this->maJSOnMouseMoveFunctions) > 0)
        {
            //$szOnMouseMove .= "document.onmousemove = CWC2OnMouseMoveFunction; \n";
            //$szHTML .= "document.captureEvents(Event.MOUSEMOVE); \n";
            $szOnMouseMove .= "function CWC2OnMouseMoveFunction(e)\n{\n";
            while ( list( $key, $val ) = each($this->maJSOnMouseMoveFunctions))
            {
                $szOnMouseMove .= "\n";
                $szOnMouseMove .=  $this->maJSOnMouseMoveFunctions[$key];
            }
/* ----------------------------------------------------------------------- */
/* MapWinsideMap is a function defined by MapDHTML widget and KeyMapDHTML. */
/* ----------------------------------------------------------------------- */
            $szOnMouseMove .= "\n if ((window.MapWinsideMap && MapWinsideMap()) || (window.KeyMapWinsideKeyMap && KeyMapWinsideKeyMap())) return false; else return true;";

            $szOnMouseMove .= "\n}\n";
        }

        $szOnMouseDown = "";
        //add javascript onmousedown functions
        if (count($this->maJSOnMouseDownFunctions) > 0)
        {
            //$szOnMouseDown .= "document.onmousedown = CWC2OnMouseDownFunction; \n";
            //$szOnMouseDown .= "document.captureEvents(Event.MOUSEDOWN); \n";
            $szOnMouseDown .= "function CWC2OnMouseDownFunction(e)\n{\n";
            while ( list( $key, $val ) = each($this->maJSOnMouseDownFunctions))
            {
                $szOnMouseDown .= "\n";
                $szOnMouseDown .=  $this->maJSOnMouseDownFunctions[$key];
            }

            $szOnMouseDown .= "\n}\n";
        }

        $szOnMouseUp = "";
        // add javascript onmouseup functions
        if (count($this->maJSOnMouseUpFunctions) > 0)
        {
            //$szOnMouseUp .= "document.onmouseup = CWC2OnMouseUpFunction; \n";
            //$szOnMouseUp .= "document.captureEvents(Event.MOUSEUP); \n";
            $szOnMouseUp .= "function CWC2OnMouseUpFunction(e)\n{\n";
            while ( list( $key, $val ) = each($this->maJSOnMouseUpFunctions))
            {
                $szOnMouseUp .= "\n";
                $szOnMouseUp .=  $this->maJSOnMouseUpFunctions[$key];
            }

            $szOnMouseUp .= "\n}\n";
        }

        $bScriptOpen = false;
        if ($szJSVar != "")
        {
            if (!$bScriptOpen)
            {
                $szHTML = "<SCRIPT Language=\"JavaScript\">\n";
                $bScriptOpen = true;
            }
            $szHTML.= $szJSVar;
        }

        if ($szOnLoadFunc != "")
        {
            if (!$bScriptOpen)
            {
                $szHTML = "<SCRIPT Language=\"JavaScript\">\n";
                $bScriptOpen = true;
            }
            $szHTML.= $szOnLoadFunc;
        }
        if ($szOnMouseMove != "")
        {
            if (!$bScriptOpen)
            {
                $szHTML = "<SCRIPT Language=\"JavaScript\">\n";
                $bScriptOpen = true;
            }
            $szHTML.= $szOnMouseMove;
        }
        if ($szOnMouseDown != "")
        {
            if (!$bScriptOpen)
            {
                $szHTML = "<SCRIPT Language=\"JavaScript\">\n";
                $bScriptOpen = true;
            }
            $szHTML.= $szOnMouseDown;
        }
        if ($szOnMouseUp != "")
        {
            if (!$bScriptOpen)
            {
                $szHTML = "<SCRIPT Language=\"JavaScript\">\n";
                $bScriptOpen = true;
            }
            $szHTML.= $szOnMouseUp;
        }

        if ($bScriptOpen)
            $szHTML .= "</SCRIPT>\n";

        $szJSInclude = "";
        //process javascript includes
        if (count($this->maJSIncludeFunctions) > 0)
        {
            while ( list( $key, $val ) = each($this->maJSIncludeFunctions))
             {
                 $szJSInclude .= "<!-- javascript include $key -->\n";
                 $szJSInclude .=  $this->maJSIncludeFunctions[$key];
                 $szJSInclude .= "\n";
             }
        }
        if ($szJSInclude != "" || $szHTML != "")
        {
            $szJSInclude = "<HEAD>".$szJSInclude;
            
            //this should put it just before the body tag.
            $this->oCWCParser->ProcessPatternReplacement( "/(<HEAD>)/iUs", $szJSInclude.$szHTML );
        }

        while ( list( $nIndex, $aFormVars ) = each($this->maHTMLVariables))
        {
            $nIndex++;

            $szFormVar = "";
            while ( list( $key, $val ) = each($aFormVars))
            {
                $szFormVar .=  "\n".$aFormVars[$key];
            }

            if ($szFormVar != "")
            {
            $szFormVar = "$szFormVar";
                //this should go right after the start form tag

                $this->oCWCParser->ProcessPatternReplacement( "/(<FORM[^>]*>)/iUs", $szFormVar, $nIndex );
            }
        }

        $szJSInitFunc = "";
        if (count($this->maJSInitFunctions) > 0)
        {
             $szJSInitFunc = "\n";
             $szJSInitFunc.= "<script LANGUAGE=\"JavaScript\">\n";
             while ( list( $key, $val ) = each($this->maJSInitFunctions))
             {
                 $szJSInitFunc .= "\n";
                 $szJSInitFunc .=  $this->maJSInitFunctions[$key];
             }
             $szJSInitFunc .= "\n</script>\n</HTML>";
             //this should put it just before the end tag.
             //TODO: this assumes there is an end HTML tag, if it isn't there,
             //      it should just append it
             $this->oCWCParser->ProcessPatternReplacement( "/(<\/HTML>)/iUs", $szJSInitFunc );
        }

        //debugging
        //for($i=0;$i<count($this->maoWidgets);$i++)
        //{
        //    echo "<!-- widget $i is ".$this->maoWidgets[$i]->GetValue( "TYPE" )."-->\n";
        //}
        
        /*
         * using a doctype appears to improve content handling in some browsers
         * and avoids some issues relating to positioning and layout of the page
         */
        if (!stristr( $this->oCWCParser->mszTemplate, "<!DOCTYPE"))
            $this->oCWCParser->mszTemplate = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'."\n".$this->oCWCParser->mszTemplate;
    }

    /*
      This function just output the template to the client.
    */
    function DrawPublish()
    {
        /* this is an attempt to improve performance over slower connections
         * by compressing the output.  Unfortunately the ob_gzhandler emits
         * a warning if there is any output before it is used.  We tested
         * putting the ob_start call at the beginning of chameleon.php and it
         * seemed to work more reliably, but until we understand why I don't
         * think we can use this.
         */
         
        //ob_start("ob_gzhandler"); 
        echo $this->oCWCParser->mszTemplate;
        //ob_end_flush();
    }

    /**
     * process all extra outputs such as javascript functions for each widget
     */
    function ProcessWidgetIncludes()
    {
        for ($i=PRIORITY_MAXIMUM; $i>=PRIORITY_MINIMUM; $i--)
        {
            foreach( $this->manPriorities[$i] as $nWidgetIndex )
            {
                $oWidget =& $this->maoWidgets[$nWidgetIndex];
                $this->MergeArrays( $this->maJSFunctions,
                        $oWidget->GetJavascriptFunctions() );
                $this->MergeArrays( $this->maJSOnLoadFunctions,
                        $oWidget->GetJavascriptOnLoadFunctions() );
                $this->MergeArrays( $this->maJSOnMouseMoveFunctions,
                        $oWidget->GetJavascriptOnMouseMoveFunctions() );
                $this->MergeArrays( $this->maJSOnMouseUpFunctions,
                        $oWidget->GetJavascriptOnMouseUpFunctions() );
                $this->MergeArrays( $this->maJSOnMouseDownFunctions,
                        $oWidget->GetJavascriptOnMouseDownFunctions() );
                $this->MergeArrays( $this->maJSInitFunctions,
                        $oWidget->GetJavascriptInitFunctions() );
                $this->MergeArrays( $this->maJSIncludeFunctions,
                        $oWidget->GetJavascriptIncludeFunctions() );
                $this->MergeArrays( $this->maJSVariables,
                        $oWidget->GetJavascriptVariables() );

                if (!isset($this->maHTMLVariables[$oWidget->mnFormIndex]) || 
                    !is_array($this->maHTMLVariables[$oWidget->mnFormIndex]))
                    $this->maHTMLVariables[$oWidget->mnFormIndex] = array();
                $this->MergeArrays( $this->maHTMLVariables[$oWidget->mnFormIndex],
                        $oWidget->GetHTMLHiddenVariables() );
            }
        }
    }

    /**
     * merge values from the source array into the target array
     * @param $aFunctions the functions to add
     */
    function MergeArrays( &$aTarget, $aSource )
    {
        if (is_array($aSource))
        {
            while ( list( $key, $val ) = each($aSource) )
            {
                if (!isset($aTarget[$key]))
                    $aTarget[$key] = $val;
            }
        }
    }

}//end class UIManager
