<?php
/**
 * MapLab XML configuration Tool
 *
 * @project     MapLab
 * @revision    $Id: edit_xml.php,v 1.2 2002/12/11 04:39:20 bronsema Exp $
 * @purpose     This is the XML configuration page.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: edit_xml.php,v $
 * Revision 1.2  2002/12/11 04:39:20  bronsema
 * Completed construction
 *
 * Revision 1.1  2002/12/10 18:25:35  bronsema
 * added
 *
 * Revision 1.1  2002/11/21 04:38:30  pspencer
 * new file.
 *
 * Revision 1.1  2002/08/12 12:57:50  sacha
 * Moved all common lib into htdocs. Not yet completed with Mapbrowser and gmapfactory.
 *
 * Revision 1.9  2002/06/30 17:29:03  pspencer
 * modified for register_globals = off
 *
 * Revision 1.8  2002/06/25 16:03:04  sacha
 * Fixed bug 1147
 *
 * Revision 1.7  2002/06/18 19:48:03  sacha
 * Fixed some bug when using config tool in Netscape also added a new
 * file that puts default values in configuration file BEFORE opening
 * configuration tool.
 *
 * Revision 1.6  2002/06/17 19:45:26  sacha
 * Save when changing tabs.
 *
 * Revision 1.5  2002/06/13 14:23:44  bronsema
 * Removed "subappcontext_" from the parameter maplab parameter name.
 *
 * Revision 1.4  2002/06/13 13:58:10  bronsema
 * Fixed looping problem for subappcontext items.
 *
 * Revision 1.3  2002/06/12 19:50:13  pspencer
 * give visual indication of changed values
 *
 * Revision 1.2  2002/06/09 00:40:56  bronsema
 * Added check to see if files are writable.
 *
 * Revision 1.1  2002/06/08 02:08:39  bronsema
 * added new  XML config tool
 *
 *****************************************************************************/

error_reporting( E_ALL );

// define the common directory    
if (!defined( "COMMON" ) )
    define("COMMON", "../htdocs/common/");

// include appcontext definition
include_once(COMMON."appcontext/appcontext.php");

include_once("./edit_xml_default.php");

/* ============================================================================
 * Build an array with the HTTP GET or POST parameters.
 * ========================================================================= */
// check for POST vars
$http_form_vars =  (count($_POST) > 0) ? 
                   $_POST : ((count($_GET) > 0) ? $_GET : array());

if (!isset($http_form_vars["bSave"]))
    $http_form_vars["bSave"] = false;

/* ============================================================================
 * Check for valid config file
 * ========================================================================= */
// initialize vars
$gszStatus = "";
$gbErrors = false;
 
// check for the configuration file
if ( $http_form_vars["szConfigFile"] == "" || 
     !is_file( $http_form_vars["szConfigFile"] ) )
{
    // log message
    echo "No configuration file specified.";
    exit;
}    
else
{
    //TODO: add regex expression to make sure that this value is a valid file
    //name, ends with XML and doesn't have any extra path information than it
    //should.  Should probably limit it to one of four file names also.
    // check if the file is read-only
    if ( !is_writable( $http_form_vars["szConfigFile"] ) )
        $gbWritable = false;
    else
        $gbWritable = true;    

    // create the new appcontext object
    $oAppContext = new AppContext( $http_form_vars["szConfigFile"] );

/* ============================================================================
 * Process save command
 * ========================================================================= */    
    if ( $http_form_vars["bSave"] == 1 && $gbWritable )
    {
        // set flag
        $bChanged = false;
        //array of changed keys
        $aszChangedKeys = array();
        
        // loop through each query variable and set
        foreach ($http_form_vars as $szKey => $szValue)
        {
            $bRet = false;
            // Check if it is a include variable
            if ( substr($szKey,0, 14) == "SUBAPPCONTEXT_" )
            {
                // get name
                $szSubContextName = substr($szKey, 14);
                
                // loop through each
                foreach(array_keys($oAppContext->aoContext) as $szContextKey)
                {
                    if ($oAppContext->aoContext[$szContextKey]->szContextName == $szSubContextName)
                    {
                        if ( trim ( $oAppContext->aoContext[$szContextKey]->szContextFile ) != trim( $szValue ) )
                        {
                            $oAppContext->aoContext[$szContextKey]->szContextFile = $szValue;
                            $bRet = true;
                            //array_push($aszChangedKeys, $szValue);
                        }
                    }
            
                    // update the name to display
                    $szKey = $szSubContextName;
                    break;
                }
            
                //continue;
            } 
            else
            {      
                // set if changed
                $szCurrentValue = $oAppContext->getContextValue( $szKey );
                if (trim($szCurrentValue) != trim($szValue))
                {
                    $bRet = $oAppContext->setContextValue($szKey, $szValue);
                }
                
            }
            
            // check for failure
            if ($bRet !== false)
            {
               $bChanged = true;
               array_push($aszChangedKeys, $szKey);
            }
            
        }
        
        // check for any changes
        if ($bChanged)
        {
            // save the file
            $gszStatus .= "Committing changes....";
            $bRes = $oAppContext->saveAppContext( 
                                            $http_form_vars["szConfigFile"] );
            // check success
            if ($bRes == true)
            {
                // flag success
                $gszStatus .= "OK\n";
            }
            else
            {
                // log error
                $gszStatus .= "Failed\n";
                $gbErrors = true;            
            }
        }
    }
    if (isset($http_form_vars["szTargetConfigFile"]) && 
        $http_form_vars["szTargetConfigFile"] != "" && 
        is_file("../config/".$http_form_vars["szTargetConfigFile"].".xml"))
        header("Location:./edit_xml.phtml?szConfigFile=../config/".$http_form_vars['szTargetConfigFile'].".xml");
}   
?>


