<?php
// get the name of the file to build.
define( "HTML_DIR", "../html/" );
$szDocName = HTML_DIR."CWC2WidgetDocs.xml";

//$szDocURL = "http://".$_SERVER['HTTP_HOST'].
//             dirname($_SERVER['PHP_SELF'])."/../html/".$szDocName;
$szDocURL = $szDocName;

/* ============================================================================
 * $http_form_vars array contains the HTTP GET or POST parameters
 * ========================================================================= */
$http_form_vars = count( $_POST ) > 0 ? $_POST :
                                    ( count($_GET) > 0 ? $_GET : array("") );

/* DEBUG
foreach( $http_form_vars as $index=>$value )
A    echo "$index=>$value<br>";
/* ============================================================================
 * only process if necessary
 * ========================================================================= */
if ( isset( $http_form_vars["buildDocs"] ) )
{
    dl("php_mapscript_41.so");

    $szDir = getcwd();
    define( "HTDOCS", "../htdocs/" );
    chdir( HTDOCS );

    // include the necessary files
    define( "COMMON", HTDOCS."common/" );
    define( "WIDGETS", HTDOCS."widgets/" );

    include_once( HTDOCS."common/xml_utils/XMLObject.php" );

    include_once( HTDOCS."chameleon.php" );
    include_once( COMMON."logger/logger.php" );
    include_once( WIDGETS."Widget.php" );
    include_once( WIDGETS."Popup.php" );
    include_once( WIDGETS."Label.php" );
    include_once( WIDGETS."Button.php" );
    include_once( HTDOCS."WidgetManager.php" );

    // check if the html dir is writable
    if ( !is_writable( HTML_DIR ) )
    {
        // give message and exit
        exit( "The directory: 'HTML_DIR' is not writable.  You must make this ".
                  "directory writable by the webserver in order to continue." );
    }

    // build list of base attributes
    $oWidget = new CWCWidget();
    $aszBaseAttributes = getAttributeList( $oWidget );

    // build list of popup attributes
    $oWidget->maAttributes = array();  // reset to remove last attributes
    $oPopup = new CWCPopup( $oWidget );
    $aszPopupAttributes = getAttributeList( $oWidget );

    // build list of button attributes
    $oWidget->maAttributes = array();  // reset to remove last attributes
    $oButton = new CWCButton( $oWidget );
    $aszButtonAttributes = getAttributeList( $oWidget );

    // build list of label attributes
    $oWidget->maAttributes = array();  // reset to remove base attributes
    $oLabel = new CWCLabel( $oWidget );
    $aszLabelAttributes = getAttributeList( $oWidget );

    // generate the widget documents
    genDocs( $aszBaseAttributes, $aszPopupAttributes,
             $aszButtonAttributes, $aszLabelAttributes);

    // signal completion
    echo "<h4>File Done - ".time()."</h4>";
}

function getIncludes($oWidget)
{
    // parse all class object vars
    $aszClassVars = get_class_vars(get_class($oWidget));

    $aRet = array();

    foreach($aszClassVars as $szKey=>$szVar)
    {
        eval('$szClass = get_class($oWidget->'.$szKey.');');
        switch ($szClass)
	{
          case "cwclabel"  : $aRet["label"] = true; break;
          case "cwcbutton" : $aRet["button"] = true; break;
          case "cwcpopup"  : $aRet["popup"] = true; break;
	}
    }
    return $aRet;
}

/**
 * Postcondition:  This function returns an array of the given widget's
 *                 attribute index values.
 *
 * @param $oWidget object - The widget to process.
 * @return array - An array of attribute indexes (names).
 **/
function getAttributeList( $oWidget )
{
    // push the attribute array's indexes into a new array
    $aszAttributes = array();
    foreach($oWidget->maAttributes as $index=>$szAtt)
        $aszAttributes[$index] = $szAtt;

    // return results
    return $aszAttributes;
}

function processDoc($oWidgetManager, $szWidget, $szVersion, $szFileName,
                    $aszBaseAttributes, $aszPopupAttributes,
                    $aszButtonAttributes, $aszLabelAttributes)
{
    // only generate docs for widgets not in the skip array
    $aszWidgetsToSkip = array( "MAPIMAGEWIDGET", "ECOSTRATWIDGET", "CONTEXTSELECTOR", "EXTRACTCONTEXT", "GEOLINK", "SLDCACHE", "STYLEMANAGER");

    $aszLanguage = array("en-ca", "fr-ca");

    // if exist open it
    if ( file_exists( $szFileName) )
    {
        // check that the file is writable
        if ( !is_writable( $szFileName ) )
        {
            // give message and exit
            exit( "The file '$szFileName' is not writable.  You must make this ".
                   "file writable by the webserver in order to continue." );
        }
        $oXML = new XMLObject(implode("", file($szFileName)));
        $oXML = $oXML->getNextChild("widgetdoc");

        if ($oXML == "")
	  return;
	
        // get all languages
        $oLang = $oXML->getNextChild("language");
        while($oLang != "")
	{
	  if (isset($oLang->_attributes['name']) && 
              strtoupper($oLang->_attributes['name']) != "EN-CA" &&
              strtoupper($oLang->_attributes['name']) != "FR-CA")
	  {
	      array_push($aszLanguage, $oLang->_attributes['name']);
	  }
          $oLang = $oXML->getNextChild("language");
	}
    }

    $szDetails = "";

    if ( !in_array( strtoupper($szWidget), $aszWidgetsToSkip ) )
    {
        $oWidgetManager->LoadWidget( $szWidget, $szVersion );

        // create new widget instance
        $szEval = "\$oWidget =& new $szWidget();";

        eval($szEval);
        //set it's ID to nothing
        $oWidget->mnId = "";

	/* ============================================================================
	 * next build include list of widget
	 * ========================================================================= */
	$aIncludes = getIncludes($oWidget);
	$szIncludes = "";
	foreach ($aIncludes as $szKey=>$bVal)
	{
	    if ($bVal)
	        $szIncludes .= "      <includes target=\"$szKey\"/>\n";
	}

        // get details
	$szDetails = "";
	$szDetails .= "  <widgetdoc name=\"$szWidget\" parentclass=\"".get_parent_class($oWidget)."\">\n";
	$szDetails .= $szIncludes;

        foreach($aszLanguage as $szLanguage)
            $szDetails .= getDetails( $szLanguage, $szWidget, $oWidget, $oXML, $aszBaseAttributes,
                                     $aszPopupAttributes, $aszButtonAttributes, $aszLabelAttributes);

	$szDetails .= "  </widgetdoc>\n";
    }

    // create file
    $fp = fopen( $szFileName, 'w');

    // write buffer to file
    fwrite( $fp, $szDetails );

    // close the file
    fclose( $fp );
}

/**
 * Postcondition:  This function generates the widget information as a string
 *                 and returns it.
 *
 * @param $aszBaseAttributes array - An array of base attributes.
 * @param $aszPopupAttributes array - An array of popup attributes.
 * @param $aszButtonAttributes array - An array of button attributes.
 * @param $aszLabelAttributes array - An array of label attributes.
 * @return string - Document in HTML format.
 **/
function genDocs( $aszBaseAttributes, $aszPopupAttributes,
                  $aszButtonAttributes, $aszLabelAttributes)
{
    $oWidgetManager = new WidgetManager();
    $aszWidgets = $oWidgetManager->GetAvailableWidgets();

    /*
    processDoc($oWidgetManager, "cwcwidget", "", WIDGETS."Widget.help.xml",
               $aszBaseAttributes, $aszPopupAttributes,
               $aszButtonAttributes, $aszLabelAttributes);

    processDoc($oWidgetManager, "cwcbutton", "", WIDGETS."Button.help.xml",
               $aszBaseAttributes, $aszPopupAttributes,
               $aszButtonAttributes, $aszLabelAttributes);

    processDoc($oWidgetManager, "cwclabel", "", WIDGETS."Label.help.xml",
               $aszBaseAttributes, $aszPopupAttributes,
               $aszButtonAttributes, $aszLabelAttributes);

    processDoc($oWidgetManager, "cwcpopup", "", WIDGETS."Popup.help.xml",
               $aszBaseAttributes, $aszPopupAttributes,
               $aszButtonAttributes, $aszLabelAttributes);
    */
    // only generate docs for widgets not in the skip array
    $aszWidgetsToSkip = array( "MAPIMAGEWIDGET", "ECOSTRATWIDGET", "CONTEXTSELECTOR", "EXTRACTCONTEXT", "GEOLINK", "SLDCACHE", "STYLEMANAGER");

    // do each widget separately
    foreach($aszWidgets as $aWidgetInfo)
    {
      processDoc($oWidgetManager, $aWidgetInfo[0], $aWidgetInfo[1], $aWidgetInfo[2]."/".$aWidgetInfo[0].".help.xml", 
                 $aszBaseAttributes, $aszPopupAttributes,
                 $aszButtonAttributes, $aszLabelAttributes);
    }
// end genDocs() function
}

/**
 * Postcondition:  This function generates the detail information on a specific
 *                 widget and returns it as a formatted string.
 *
 * @param $szName string - The widget name.
 * @param $oWidget object - Widget object.
 * @param $oXML object - Old XML doc file (if any).
 * @param $aszBaseAttributes array - An array of base attributes.
 * @param $aszPopupAttributes array - An array of popup attributes.
 * @param $aszButtonAttributes array - An array of button attributes.
 * @param $aszLabelAttributes array - An array of label attributes.
 * @return string - HTML formatted string of widget details.
 **/
function getDetails( $szLanguage, $szName, &$oWidget, &$oXML, $aszBaseAttributes, $aszPopupAttributes,
                     $aszIconAttributes,
                     $aszLabelAttributes)
{
/* ============================================================================
 * first get widget name and description
 * ========================================================================= */
    // get properties
    $szWidgetName = get_class($oWidget);
   
    if (isset($oWidget->szWidgetDescription))
        $szWDescription = $oWidget->szWidgetDescription;
    else
        $szWDescription = "";

    $aszAttributeTypesFound = array();
    $aszAttributes = getAttributeList($oWidget);

    // declare strings and attribute lists
    $bBaseAttributes = false;
    $aszTmpFoundBaseAttributes = array();
    $bPopupAttributes = false;
    $aszTmpFoundPopupAttributes = array();
    $bLabelAttributes = false;
    $aszTmpFoundLabelAttributes = array();
    $bButtonAttributes = false;
    $aszTmpFoundButtonAttributes = array();

    $aszAttributeTypesFound = array();

    // open tag
    $szTagSample = "&lt;CWC2 ";

    // loop and build
    foreach( $oWidget->maAttributes as $index=>$oAttr )
    {
        $index = strtoupper($index);
        // add each attribute - override the TYPE sample
        $szTagSample .= " ".$oAttr->getSample();

        // check index if common attribute
        if ( isset($aszBaseAttributes[$index] ) )
        {
            // flag that base atributes were found
            $bBaseAttributes = true;

            // add attribute to array of found common attributes
            array_push( $aszTmpFoundBaseAttributes, $index );
        }
        if ( isset($aszPopupAttributes[$index] ) )
        {
            // flag that popup sttribute was found
            $bPopupAttributes = true;

            // add attribute to array of found common attributes
            array_push( $aszTmpFoundPopupAttributes, $index );
        }
        if ( isset($aszLabelAttributes[$index] ) )
        {
            // flag that label attribute was found
            $bLabelAttributes = true;

            // add attribute to array of found common attributes
            array_push( $aszTmpFoundLabelAttributes, $index );
        }

        if ( isset($aszButtonAttributes[$index] ) )
	{
            // flag that button attribute is found
            $bButtonAttributes = true;

            // add attribute to array of found common attributes
            array_push( $aszTmpFoundButtonAttributes, $index );
        }

        $aszAttributes[$index] = $oAttr;
    }

    $aszCommonAttributes = array();

    // verify that all base attributes were found
    if ( $bBaseAttributes )
    {
        if( count( $aszTmpFoundBaseAttributes ) == count( $aszBaseAttributes ) )
        {
            array_push( $aszAttributeTypesFound, array("Base Attributes",
                                                                "baseattributes") );
            $aszCommonAttributes = array_merge( $aszCommonAttributes, $aszBaseAttributes );
        }
    }

    // verify that all popup attributes were found
    if ( $bPopupAttributes )
    {
        if ( count( $aszTmpFoundPopupAttributes ) == count( $aszPopupAttributes ) )
        {
            array_push( $aszAttributeTypesFound, array("Popup Attributes",
                                                                "popupattributes", $aszPopupAttributes) );
            $aszCommonAttributes = array_merge( $aszCommonAttributes, $aszPopupAttributes );
        }
    }

    // verify that all label attributes were found
    if ( $bLabelAttributes )
    {
        if ( count( $aszTmpFoundLabelAttributes ) == count( $aszLabelAttributes ) )
        {
            array_push( $aszAttributeTypesFound, array("Label Attributes",
                                                                "labelattributes") );
            $aszCommonAttributes = array_merge( $aszCommonAttributes, $aszLabelAttributes );
        }
    }

    // verify that all button attributes were found
    if ( $bButtonAttributes )
    {
        if ( count( $aszTmpFoundButtonAttributes ) == count( $aszButtonAttributes ) )
        {
            array_push( $aszAttributeTypesFound, array("Button Attributes",
                                                              "buttonattributes") );
            $aszCommonAttributes = array_merge( $aszCommonAttributes, $aszButtonAttributes );
        }
    }

    $aszAttributes = array_diff_assoc( $aszAttributes, $aszCommonAttributes );
    // build string to display uncommon attributes
    $szUCAttributes = "";

    foreach ( $aszAttributes as $index=>$aszUCAttribute )
    {
        // get the attribute description
        $szDescription =  getDescription( $szWidgetName.".".$szLanguage.".attributes.".$index, $oXML );
        if ($szDescription === false)
	    echo "$szWidgetName.$szLanguage.attributes.$index : Doesn't exist. Adding to help file.<br>";

        $szType = substr(get_class($aszUCAttribute), 0, strpos(get_class($aszUCAttribute), "attribute"));

        // build formatted list of attributes
        $szUCAttributes .= "      <attribute name=\"$index\" type=\"$szType\" required=\"".(($aszUCAttribute->mbMandatory==1) ? "true":"false")."\">\n";

        // Check possvalue
        $szPossValue = "";
        switch($szType)
	{
          case "boolean":
	  case "string" : if (count($aszUCAttribute->maValues) > 0) 
                             $szPossValue = "<possvalue value=\"".implode("\"/>\n<possvalue value=\"", $aszUCAttribute->maValues)."\"/>\n"; 
                          break;
          case "integer": $szPossValue = "<possvalue value=\"".
                             htmlentities("[integer,>".$aszUCAttribute->mnMin.",<".$aszUCAttribute->mnMax."]")."\"/>\n"; break;
          case "float"  : $szPossValue = "<possvalue value=\"".
                             htmlentities("[integer,>".$aszUCAttribute->mfMin.",<".$aszUCAttribute->mfMax."]")."\"/>\n"; break;
	}

        if ($szPossValue != "")
	{
            $szUCAttributes .= "        <possvalues>\n";
	    $szUCAttributes .= $szPossValue;
            $szUCAttributes .= "        </possvalues>\n";
	}

        $szUCAttributes .= "        <description>\n";
        $szUCAttributes .= "          ".htmlentities($szDescription)."\n";
        $szUCAttributes .= "        </description>\n";
        $szUCAttributes .= "      </attribute>\n";
    }

/* ============================================================================
 * next build list of form variables
 * ========================================================================= */
    $szFormVariables = generateList( $szLanguage, $oWidget, $szWidgetName,
                        "GetHTMLHiddenVariables();",
                        array(), $oXML, false, "formelement");

/* ============================================================================
 * next build list of javascript functions
 * ========================================================================= */
    // get the javascript functions
    $szJSFunctions  = generateList( $szLanguage, $oWidget, $szWidgetName,
                    "GetJavascriptFunctions();", array(), $oXML , true, "jsfunction");

/* ============================================================================
 * next build list of javascript variables
 * ========================================================================= */
    if ( !defined( "SID" ) )
        define( "SID", "" );
    $szJSVariables = generateList( $szLanguage, $oWidget, $szWidgetName,
                    "GetJavascriptVariables();", array(), $oXML, false, "jsvariable");

/* ============================================================================
 * format the output
 * ========================================================================= */
    $szResult = formatOutput( $szLanguage, $szName, $szWidgetName, $szWDescription,
                "", "", $szUCAttributes,
                $szFormVariables, $szJSFunctions, $szJSVariables);

/* ============================================================================
 * return details
 * ========================================================================= */
    return $szResult;

// end getDetails() function
}

/**
 * Postcondition:  This function executes the requested function on the given
 *                 widget and returns the details in a formatted string.
 *
 * @param $oWidget object - Widget object.
 * @param $szWidgetName string - The name of the widget.
 * @param $szFunction string - Function to execute.
 * @param $aSkipList array - An array of widget names to skip because they cause
 *                           errors.
 * @param $aszDescList array - Array of description values.
 * @param $bAddBrac boolean - Flag to add brackets to the results.
 * @return string - HTML formatted string of function results.
 **/
function generateList( $szLanguage, $oWidget, $szWidgetName, $szFunction, $aSkipList,
                      &$oXML, $bAddBrac=false, $szClass="" )
{
    // get list of html form variables
    $szVariables = "";
    $aszVariables = array();
    if ( !in_array( $szWidgetName, $aSkipList ) )
    {
        // assemble function command
        $szTmpEval = '$aszVariables = $oWidget->'.$szFunction;
        eval($szTmpEval);
    }
    else
    {
        return $szVariables;
    }

    if ( !is_array( $aszVariables ) )
        $aszVariables = array();

    reverseCheck($szLanguage, $aszVariables, $oXML, $szWidgetName, $szClass);

    foreach( $aszVariables as $szIndex=>$szFormVariable )
    {
        // add brackets if necessary
        if ( $bAddBrac )
	{
	    // Get parameters
	    $nPos = strpos($szFormVariable, "function $szIndex");
	    $nPos1 = strpos($szFormVariable, "(", $nPos);
	    $nPos2 = strpos($szFormVariable, ")", $nPos);
            $szParams = str_replace("\n", " ", substr($szFormVariable, $nPos1+1, $nPos2-$nPos1-1));
            $aszParams = explode(",", $szParams);

            $szParameters = "";

            foreach($aszParams as $szParam)
	    {
  	        if ($szParam == "")
		    continue;
	        $szParam = trim($szParam);
		$szType = "string";
                $szT = substr($szParam, 0, 1);

                if ($szT == "a")
		  $szType = "array";
                else
                if ($szT == "n")
		  $szType = "integer";
                else
                if ($szT == "f")
		  $szType = "float";
                else
                if ($szT == "o")
		  $szType = "object";

                $szParameters .= "      <parameter name=\"$szParam\" type=\"[$szType]\">\n";
                $szDescription = getDescription( $szWidgetName.".".$szLanguage.".jsfunctions.".$szIndex.".".$szParam, $oXML );
                if ($szDescription === false)
	            echo "$szWidgetName.$szLanguage.jsfunctions.$szIndex.$szParam : Doesn't exist. Adding to help file.<br>";

                $szParameters .= "        $szDescription\n";
                $szParameters .= "      </parameter>\n";
	    }
	}

        // get description
        $szDescription = getDescription( $szWidgetName.".".$szLanguage.".".$szClass."s.".$szIndex, $oXML );
        if ($szDescription === false)
	    echo "$szWidgetName.$szLanguage.".$szClass."s.$szIndex : Doesn't exist. Adding to help file.<br>";

        if ($szDescription == "No description available.")
        {
            echo "warning: no description available for $szWidgetName : $szIndex.  Please update description file.<BR>";
        }

        // build
        $szVariables .= "      <$szClass name=\"$szIndex\">\n";

        if ($bAddBrac)
	    $szVariables .= $szParameters;

        $szVariables .= "        <description>\n";
        $szVariables .= "          ".htmlentities($szDescription)."\n";
        $szVariables .= "        </description>\n";
        $szVariables .= "      </$szClass>\n";
    }

    //return
    return $szVariables;

// end generateList() function
}

function reverseCheck($szLanguage, &$aszVariables, $oXML, $szWidgetName, $szClass)
{
    if ($oXML == "")
        return false;

    $oXML->_cur_child_index = 0;

    /// Check required node
    $oLang = $oXML->getNextChild("language");
    while ($oLang != "")
    {
        if (strtolower($szLanguage) == strtolower($oLang->_attributes['name']))
        {
	    $oNodes = $oLang->getNextChild($szClass."s");
	    if ($oNodes == "")
	      return false;

	    $oNode = $oNodes->getNextChild($szClass);
	    while ($oNode != "")
	    {
	        if (isset($oNode->_attributes['name']))
		{
		    if (!isset($aszVariables[$oNode->_attributes['name']]))
		    {
		        echo $szWidgetName." ".$szLanguage." ".$szClass." ".$oNode->_attributes['name']." is deprecate.<br>";
			$aszVariables[$oNode->_attributes['name']] = "";
		    }
		}
		$oNode = $oNodes->getNextChild($szClass);
	    }
	}
        $oLang = $oXML->getNextChild("language");
    }
    return false;
}

/**
 * Postcondition:  This functon takes the given parameters and returns the final
 *                 HTML formatted table for the widget.
 *
 * @param $szName string - Name of the widget.
 * @param $szWidgetName string - Class name of the widget.
 * @param $szWDescription string - Widget description.
 * @param $szTagSample string - Sample of the widget's tag.
 * @param $szCommonAttributeGroups string - List of common attribute groups.
 * @param $szUCAttributes string - List of uncommon attributes.
 * @param $szFormVariables string - List of form variables.
 * @param $szJSFunctions string - List of Javascript functions and variables.
 * @return string - HTML formatted table describing the widget.
 **/
function formatOutput( $szLanguage, $szName, $szWidgetName, $szWDescription, $szTagSample,
              $szCommonAttributeGroups, $szUCAttributes, $szFormVariables,
              $szJSFunctions, $szJSVariables)
{
    $szReturn  = "  <language name=\"".$szLanguage."\">\n";
    $szReturn .= "    <description>\n";
    $szReturn .= "      ".htmlentities($szWDescription)."\n";
    $szReturn .= "    </description>\n";
    $szReturn .= "    <attributes>\n";
    $szReturn .= $szUCAttributes.$szCommonAttributeGroups;
    $szReturn .= "    </attributes>\n";
    $szReturn .= "    <formelements>\n";
    $szReturn .= $szFormVariables;
    $szReturn .= "    </formelements>\n";
    $szReturn .= "    <jsfunctions>\n";
    $szReturn .= $szJSFunctions;
    $szReturn .= "    </jsfunctions>\n";
    $szReturn .= "    <jsvariables>\n";
    $szReturn .= $szJSVariables;
    $szReturn .= "    </jsvariables>\n";
    $szReturn .= "  </language>\n";
  return $szReturn;
}

/**
 * Postcondition:  This function takes the given key value and looks up the
 *                 desciption in the correct text file according to the type
 *                 given.  If the key is not found then a default entry is
 *                 created and returned.
 *
 * @param $szKey string - The key value to look up.
 * @param $aszDescriptions array - Array of description values.
 * @return string - The description or a default string.
 **/
function getDescription( $szKey, &$oXML )
{
    if ($oXML == "")
        return false;

    $oXML->_cur_child_index = 0;

    $aszKey = explode(".", $szKey);

    if (!isset($aszKey[0]) || !isset($aszKey[1]))
        return false;

    // return widget desc
    $oLang = $oXML->getNextChild("language");
    while ($oLang != "")
    {
        if (strtoupper($oLang->_attributes['name']) == strtoupper($aszKey[1]))
	{
  	    if (count($aszKey) == 2)
	    {
	        $oDesc = $oLang->getNextChild("description");

  	        if ($oDesc != "")
	            return trim($oDesc->value);
		else
		    return false;
	    }

	    /// Check required node
	    $oNodes = $oLang->getNextChild($aszKey[2]);
	    if ($oNodes == "")
	        return false;

	    if (count($aszKey) != 4 && count($aszKey) != 5)
	        return false;

	    $oNode = $oNodes->getNextChild(substr($aszKey[2], 0, -1));
	    while ($oNode != "")
	    {
	        if (isset($oNode->_attributes['name']) && $oNode->_attributes['name'] == $aszKey[3])
		{
		    if (isset($aszKey[4]))
		    {
		        $oParam = $oNode->getNextChild($aszKey[4]);
			if ($oParam != "")
			{
			    return trim($oParam->value);
			}
			else
			    return false;
		    }
		    else
		    {
		        $oDesc = $oNode->getNextChild("description");
			if ($oDesc != "")
			    return trim($oDesc->value);
			else
			    return false;
		    }
		}
		$oNode = $oNodes->getNextChild(substr($aszKey[2], 0, -1));
	    }
	}
	$oLang = $oXML->getNextChild("language");
    }

    return false;
// end getDescription() function
}