// Drag Object
// an object that makes an unlimited number DynLayers draggable
// 19991010

// Copyright (C) 1999 Dan Steinman
// Distributed under the terms of the GNU Library General Public License
// Available at http://www.dansteinman.com/dynapi/
/**
 *
 * @project     CWC2
 * @revision    $Id: drag.js,v 1.6 2003/10/27 20:46:19 sfournier Exp $
 * @purpose     Used with PanMap widget
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
function Drag() {
	this.obj = null
	this.array = new Array()
	this.dropTargets = new Array()
	this.active = false
	this.offsetX = 0
	this.offsetY = 0
	this.zIndex = 0
        this.resort = false;
	this.add = DragAdd
	this.addTargets = DragAddTargets
	this.checkTargets = DragCheckTargets
	this.targetHit = null
	this.remove = DragRemove
	this.setGrab = DragSetGrab
	this.mouseDown = DragMouseDown
	this.mouseMove = DragMouseMove
	this.mouseUp = DragMouseUp
	this.onDragStart = new Function()
	this.onDragMove = new Function()
	this.onDragEnd = new Function()
	this.onDragDrop = new Function()
}
function DragAdd() {
        //        alert("DragAdd");
	for (var i=0; i<arguments.length; i++) {
		var l = this.array.length
		this.array[l] = arguments[i]
                //this.array[l].dragGrab = new Array(0,this.array[l].w,this.array[l].h,0)
		this.array[l].dragGrab = new Array(0,gMapWiWidth,gMapWiHeight,0);
                var ttt = "drag add : w " + this.array[l].dragGrab[1];
                //alert(ttt);
		
		this.zIndex += 1;
	}
}
function DragAddTargets() {
         //alert("DragAddTargets");
	for (var i=0; i<arguments.length; i++) {
		var l = this.dropTargets.length
		this.dropTargets[l] = arguments[i]
                //this.dropTargets[l].dragGrab = new Array(0,this.dropTargets[l].w,this.dropTargets[l].h,0);
                this.dropTargets[l].dragGrab = new Array(0,gMapWiWidth,gMapWiHeight,0);
		
	}
}
function DragSetGrab(dynlayer,top,right,bottom,left) { 
        //alert("DragSetGrab");
	dynlayer.dragGrab = new Array(top,right,bottom,left)
}
function DragRemove() {
	for (var i=0; i<arguments.length; i++) {
		for (var j=0; j<this.array.length; j++) {
			if (this.array[j]==arguments[i]) {
				for (var k=j;k<=this.array.length-2;k++) this.array[k] = this.array[k+1]
				this.array[this.array.length-1] = null
				this.array.length -= 1
				break
			}
		}
	}
}
function DragMouseDown(x,y) {
        //alert("mousedown");
		
	for (var i=this.array.length-1;i>=0;i--) {
		var lyr = this.array[i]
                //alert("mousedown");
		if (checkWithinLayer(x,y,lyr)) {
			this.obj = this.array[i]
			this.offsetX = x-this.obj.x
			this.offsetY = y-this.obj.y
			this.active = true
			break
		}
	}
	if (!this.active) return false
	else {
		if (this.resort) {
			this.obj.css.zIndex = this.zIndex++
			for (var j=i;j<=this.array.length-2;j++) this.array[j] = this.array[j+1]
			this.array[this.array.length-1] = this.obj
		}
                PanMapWDragStart(x,y);
                this.onDragStart(x,y);  
                
		return true
	}
}

var gttt = 0;
//alert(gttt);
function DragMouseMove(x,y) {
	if (!this.active) return false
	else 
        {
           if (MapWinsideMap())
          {     
             maplayer.clipTo(0,gMapWiWidth,gMapWiHeight,0); //original values
             var layerminX = maplayer.x;
             var layerminY = maplayer.y;
        
              
             var layermaxX = layerminX + gMapWiWidth;
             var layermaxY = layerminY + gMapWiHeight;
             var clipval = 0;
             
             if (0)
             {
                var ttt = "minx="+layerminX+" ,minY="+layerminY+", maxx="+layermaxX+", maxy="+layermaxY;
               alert(ttt);
             }
             //gttt++;      
             if (layerminX <= gMapWhspc)
             {
                 clipval = gMapWhspc - layerminX;
                  maplayer.clipBy(0,0,0,clipval);
             }

             if (layerminY <= gMapWvspc)
             {
                 clipval = gMapWvspc - layerminY;
                  maplayer.clipBy(clipval, 0,0,0);
             }
        
             if (layermaxX >= (gMapWhspc + gMapWiWidth) )
             {
                //alert("clip maxx");
                var clipval = (gMapWhspc + gMapWiWidth) - layermaxX;
                 maplayer.clipBy(0,clipval, 0, 0);
              }
              
              if (layermaxY > (gMapWvspc + gMapWiHeight) )
             {
                var clipval = (gMapWvspc + gMapWiHeight) - layermaxY;
                 maplayer.clipBy(0,0,clipval, 0);
              }

        
              //maplayer.clipTo(0,200,150,0);
                this.obj.moveTo(x-this.offsetX,y-this.offsetY)
		this.onDragMove(x,y)
		return true
         }
       }
}
function DragMouseUp(x,y) {
        //         alert("mouseup");
	if (!this.active) return false
	else {
        //ttt = "mouse up" + "x=" + x + " y=" + y;
        //        alert(ttt);
        //alert(maplayer.x);
        
		this.active = false
		if (this.checkTargets()) this.onDragDrop()
		this.onDragEnd(x,y);
                PanMapWDragEnd(x,y);
		return true
	}
}
function DragCheckTargets() {
	for (i in this.dropTargets) {
		var lyr = this.dropTargets[i]
		if (checkWithinLayer(lyr.x,lyr.y,this.obj) ||
		checkWithinLayer(lyr.x+lyr.w,lyr.y,this.obj) ||
		checkWithinLayer(lyr.x,lyr.y+lyr.h,this.obj) ||
		checkWithinLayer(lyr.x+lyr.w,lyr.y+lyr.h,this.obj) ||
		checkWithinLayer(this.obj.x,this.obj.y,lyr) ||
		checkWithinLayer(this.obj.x+this.obj.w,this.obj.y,lyr) ||
		checkWithinLayer(this.obj.x,this.obj.y+this.obj.h,lyr) ||
		checkWithinLayer(this.obj.x+this.obj.w,this.obj.y+this.obj.h,lyr)) {
			this.targetHit = lyr
			return true
		}
	}
	return false
}

function checkWithin(x,y,left,right,top,bottom) {
        var ttt = "x="+x+",y="+y+",left="+left+",right="+right+",top="+top+",bot="+bottom;
        //alert(ttt);
	if (x>=left && x<right && y>=top && y<bottom) return true
	else return false
}
function checkWithinLayer(x,y,lyr) {
        //alert("in checkWithinLayer lyr.x");
        //alert(lyr.left);
	if (checkWithin(x,y,lyr.x+lyr.dragGrab[3],lyr.x+lyr.dragGrab[1],lyr.y+lyr.dragGrab[0],lyr.y+lyr.dragGrab[2])) return true;
        
	else return false
}

// automatically define the default "drag" Drag Object
drag = new Drag()
