/**
 *
 * @project     CWC2
 * @revision    $Id: cwc_sr.js,v 1.4 2003/10/29 15:32:31 jfournier Exp $
 * @purpose     Java Script for jsEnabled Shared Resources
 * @author      DM Solutions Group (zjames@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/************************************************************************/
/*                           CWC_JSSR_SharedResource                    */
/* Node object for a Javascript Shared Resource                         */
/*                                                                      */
/************************************************************************/
function CWC_JS_SharedResource()
{
    //members
    this.maProperties = new Array();
    this.maValues = new Array();
    this.maoChildren = new Array();
    this.type = "CWC_JS_SharedResource";
    //methods
    this.AddChild = CWC_JSSR_AddChild;
    this.SetProperty = CWC_JSSR_SetProperty;
    this.GetProperty = CWC_JSSR_GetProperty;
    this.SetValue = CWC_JSSR_SetValue;
    this.GetValue = CWC_JSSR_GetValue;
    this.IsBranchNode = CWC_JSSR_IsBranchNode;
}

/************************************************************************/
/*                           CWC_JSSR_SetChild                        */
/*                                                                      */
/*          */
/************************************************************************/
function CWC_JSSR_AddChild(oChild)
{
    if (oChild.type == "CWC_JS_SharedResource")
    {
        this.maoChildren[this.maoChildren.length] = oChild;
        return 1;
    }
    return 0;
}

/************************************************************************/
/*                           CWC_JSSR_SetProperty                        */
/*                                                                      */
/*          */
/************************************************************************/
function CWC_JSSR_SetProperty(szProperty, szValue)
{
    this.maProperties[this.maProperties.length] = szProperty;
    this.maValues[this.maValues.length] = szValue;
    //nb length is not set if there is only one item.
    return this.maProperties.length;
    //error check on index
}

/************************************************************************/
/*                           CWC_JSSR_GetProperty                        */
/*                                                                      */
/*          */
/************************************************************************/
function CWC_JSSR_GetProperty(nIndex)
{
    if (!(typeof this.maProperties[nIndex] == "undefined"))
    {
        return this.maProperties[nIndex];
    }
    return "";
}
/************************************************************************/
/*                           CWC_JSSR_SetValue                        */
/*                                                                      */
/*          */
/************************************************************************/
function CWC_JSSR_SetValue(szProperty, szValue)
{
    var i = 0;
    for (i=0; i < this.maProperties.length; i++)
    {
        if (this.maProperties[i] == szProperty)
        {
            this.maValues[i] = szValue;
            return i;
        }
    }
    return -1;
}
/************************************************************************/
/*                           CWC_JSSR_GetValue                        */
/*                                                                      */
/*          */
/************************************************************************/
function CWC_JSSR_GetValue(szProperty)
{
    var i = 0;
    for (i=0; i < this.maProperties.length; i++)
    {
        if (this.maProperties[i] == szProperty)
        {
            return (this.maValues[i]);
        }
    }
    return "";
    
}

/************************************************************************/
/*                           CWC_JSSR_IsBranchNode                        */
/*      returns true if a node has children                             */
/*                                                                      */
/************************************************************************/
function CWC_JSSR_IsBranchNode()
{
    if (this.maoChildren.length > 0)
    {
        return 1;
    }
    else
    {
        return 0;
    }    
}
