/**
 *
 * @project     CWC2
 * @revision    $Id: cwc_cs.js,v 1.8 2004/02/25 20:37:14 wbronsema Exp $
 * @purpose     Java Script API for CWC
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
function CWC2_CS_Manager()
{
    this.nThemes = 0;
    this.aThemes = new Array();
    this.form = null;
}

function CWC2_CS_Manager_AddTheme( oTheme )
{
    oTheme.SetForm( this.form );
    this.aThemes[this.nThemes++] = oTheme;
    //js1.2/1.3 feature not supported by IE 5.0
    //this.nThemes = this.aThemes.push( oTheme );
}

function CWC2_CS_Manager_UpdateStatus( )
{
    var i;
    for( i=0; i<this.nThemes; i++ )
    {
        this.aThemes[i].UpdateStatus();
    }
    
    return true;
}

function CWC2_CS_Manager_SetThemeStatus( nTheme, bStatus )
{
    this.aThemes[nTheme].SetStatus( bStatus );
}

function CWC2_CS_Manager_SetGroupStatus( nTheme, nGroup, bStatus )
{
    this.aThemes[nTheme].SetGroupStatus( nGroup, bStatus );
}

function CWC2_CS_Manager_GetVisibleLayerNames( )
{
    var szResult = "";
    var szThemeLayers = "";
    var szSep = "";
    var i;
    
    this.UpdateStatus();
 
    for( i=0; i<this.nThemes; i++ )
    {
        szThemeLayers = this.aThemes[i].GetVisibleLayerNames();
        if (szThemeLayers != "")
        {
            szResult += szSep + szThemeLayers;
            szSep = "|";
        }
    }    
    return szResult;
}

function CWC2_CS_Manager_GetState()
{
    var anState = new Array();
    
    // loop through themes & groups and record state
    for (var i=0; i<this.aThemes.length; i++)
    {
        // record theme status in the 0 index
        anState[i] = new Array();
        anState[i][0] = this.aThemes[i].GetStatus();
        
        // record group(s) status
        for (var j=0; j<this.aThemes[i].aGroups.length; j++)
        {
            anState[i][j+1] = this.aThemes[i].aGroups[j].GetStatus();
        }
    }
    
    // return the array
    return anState;
}

function CWC2_CS_Manager_SetState( anState )
{
    // loop through state array and set the status
    for (var i=0; i<anState.length; i++)
    {
        // set theme status from the 0 index
        this.SetThemeStatus( i, anState[i][0] );
        
        // record group(s) status
        for (var j=0; j<anState[i].length - 1; j++)
        {
            this.SetGroupStatus( i, j, anState[i][j+1] );
        }
    }
    
    // update the status
    this.UpdateStatus();
    
    return;
}

CWC2_CS_Manager.prototype.AddTheme = CWC2_CS_Manager_AddTheme;
CWC2_CS_Manager.prototype.SetThemeStatus = CWC2_CS_Manager_SetThemeStatus;
CWC2_CS_Manager.prototype.SetGroupStatus = CWC2_CS_Manager_SetGroupStatus;
CWC2_CS_Manager.prototype.UpdateStatus = CWC2_CS_Manager_UpdateStatus;
CWC2_CS_Manager.prototype.GetVisibleLayerNames = CWC2_CS_Manager_GetVisibleLayerNames;
CWC2_CS_Manager.prototype.GetState = CWC2_CS_Manager_GetState;
CWC2_CS_Manager.prototype.SetState = CWC2_CS_Manager_SetState;

/*
 * the main theme object
 */
function CWC2_CS_Theme( szName )
{
    this.name = szName;
    this.nGroups = 0;
    this.aGroups = new Array();
    this.status = false;
    this.type = "checkbox";
    this.form = null;
}

function CWC2_CS_Theme_SetForm( oForm )
{
    this.form = oForm;
}

function CWC2_CS_Theme_AddGroup( oGroup )
{
    oGroup.SetTheme( this );
    oGroup.SetForm( this.form );
    this.aGroups[this.nGroups++] = oGroup;
    //js1.2/1.3 feature, not compatible with IE 5
    //this.nGroups = this.aGroups.push( oGroup )
}

function CWC2_CS_Theme_SetStatus( bStatus )
{
    var i;
    var found;
    
    this.status = bStatus;
    
    if (this.type == 'radio' && this.nGroups > 0 && bStatus )
    {
        found = false;
        
        for( i=0; i<this.nGroups; i++ )
        {
            if (this.aGroups[i].GetStatus())
                if (!found)
                    found = true;
                else
                    this.aGroups[i].SetStatus( false );
        }
        if (!found)
            this.aGroups[0].SetStatus( true );
    }
    else
    {    
        for( i=0; i<this.nGroups; i++ )
        {
            this.aGroups[i].SetStatus( bStatus );
        }
    }
}

function CWC2_CS_Theme_SetGroupStatus( nGroup, bStatus )
{
    var i;
    this.aGroups[nGroup].SetStatus( bStatus );
    
    if (this.type == 'radio')
    {
        for (i=0; i<this.nGroups; i++)
            if (i != nGroup )
                this.aGroups[i].SetStatus( false );
    }
}

function CWC2_CS_Theme_UpdateStatus( )
{
    var i;
    var n = 0;
    var status = (this.type == 'checkbox')
        
    //get the status of each group, ignoring invisible ones
    for( i=0; i<this.nGroups; i++ )
    {
        if (this.aGroups[i].GetVisible())
        {
            if (this.type == 'checkbox')
                status &= this.aGroups[i].UpdateStatus( );
            else
                status |= this.aGroups[i].UpdateStatus( );
            n++;
        }
    }
    
    if (n>0) //at least one non-visible group
    {
        this.status = status;
    }
    
    //process hidden groups separately, they follow the status of the theme
    for (i=0; i<this.nGroups; i++)
    {
        if (!this.aGroups[i].GetVisible())
            this.aGroups[i].SetStatus( this.status );
    }
    
    if (this.form != null && this.form.elements[this.name] != null)
    {
        this.form.elements[this.name].checked = this.status;
    }
    
    return this.status;
}

function CWC2_CS_Theme_GetStatus( bStatus )
{
    return this.status;
}

function CWC2_CS_Theme_GetVisibleLayerNames( )
{
    var szResult = "";
    var szGroupLayers = "";
    var szSep = "";
    var i;
   
    for( i=0; i<this.nGroups; i++ )
    {
        szGroupLayers = this.aGroups[i].GetVisibleLayerNames();
        if (szGroupLayers != "")
        {
            szResult += szSep + szGroupLayers;
            szSep = "|";
        }
    }
    return szResult;
}

function CWC2_CS_Theme_SetType( szType )
{
    this.type = szType;
}

function CWC2_CS_Theme_GetType( )
{
    return this.type;
}

CWC2_CS_Theme.prototype.SetForm = CWC2_CS_Theme_SetForm;
CWC2_CS_Theme.prototype.AddGroup = CWC2_CS_Theme_AddGroup;
CWC2_CS_Theme.prototype.SetStatus = CWC2_CS_Theme_SetStatus;
CWC2_CS_Theme.prototype.SetGroupStatus = CWC2_CS_Theme_SetGroupStatus;
CWC2_CS_Theme.prototype.UpdateStatus = CWC2_CS_Theme_UpdateStatus;
CWC2_CS_Theme.prototype.GetStatus = CWC2_CS_Theme_GetStatus;
CWC2_CS_Theme.prototype.GetVisibleLayerNames = CWC2_CS_Theme_GetVisibleLayerNames;
CWC2_CS_Theme.prototype.SetType = CWC2_CS_Theme_SetType;
CWC2_CS_Theme.prototype.GetType = CWC2_CS_Theme_GetType;

/*
 * A Group Object
 */
function CWC2_CS_Group( szName )
{
    this.name = szName;
    this.nLayers = 0;
    this.aLayers = new Array();
    this.theme = null;    this.form = null;
    this.status = false;
    this.form = null;
    this.visible = true;
}

function CWC2_CS_Group_GetVisible( )
{
    return this.visible;
}

function CWC2_CS_Group_SetVisible( bVisible )
{
    this.visible = bVisible;
}

function CWC2_CS_Group_AddLayer( oLayer)
{
    oLayer.SetGroup( this );
    this.aLayers[this.nLayers++] = oLayer;
    //js1.2/1.3 feature not supported by IE 5.0
    //this.nLayers = this.aLayers.push( oLayer );
}

function CWC2_CS_Group_SetForm( oForm )
{
    this.form = oForm;
}

function CWC2_CS_Group_SetTheme( oTheme )
{
    this.theme = oTheme;
}

function CWC2_CS_Group_SetStatus( bStatus )
{
    var i;
    var szStatement;
    
    this.status = bStatus;
    
    for( i=0; i<this.nLayers; i++ )
    {
        this.aLayers[i].SetStatus( bStatus );
    }

    if( this.theme.GetStatus() != this.status )
    {
        this.theme.UpdateStatus();
    }
    
}

function CWC2_CS_Group_UpdateStatus( )
{
    var i;
    
    this.status = true;//(this.nLayers > 0);
    
    for( i=0; i<this.nLayers; i++ )
    {
        this.status &= this.aLayers[i].UpdateStatus( );
    }
    
    if (this.form != null && this.form.elements[this.name] != null && this.visible)
    {
        this.form.elements[this.name].checked = this.status;
    }
    
    return this.status;
}

function CWC2_CS_Group_GetStatus( )
{
    return this.status;
}

function CWC2_CS_Group_GetVisibleLayerNames( )
{
    var i;
    var szResult = "";
    var szSep = "";
    
    if (this.status)
    {
        for( i=0; i<this.nLayers; i++ )
        {
            szResult += szSep + this.aLayers[i].name;
            szSep = "|";
        }
    }
    //alert('visible layer names:' + szResult);    
    return szResult;
}


CWC2_CS_Group.prototype.GetVisible = CWC2_CS_Group_GetVisible;
CWC2_CS_Group.prototype.SetVisible = CWC2_CS_Group_SetVisible;
CWC2_CS_Group.prototype.SetForm = CWC2_CS_Group_SetForm;
CWC2_CS_Group.prototype.AddLayer = CWC2_CS_Group_AddLayer;
CWC2_CS_Group.prototype.SetTheme = CWC2_CS_Group_SetTheme;
CWC2_CS_Group.prototype.SetStatus = CWC2_CS_Group_SetStatus;
CWC2_CS_Group.prototype.UpdateStatus = CWC2_CS_Group_UpdateStatus;
CWC2_CS_Group.prototype.GetStatus = CWC2_CS_Group_GetStatus;
CWC2_CS_Group.prototype.GetVisibleLayerNames = CWC2_CS_Group_GetVisibleLayerNames;


/*
 * A Layer object - not needed likely
 */
function CWC2_CS_Layer( szName )
{
    this.name = szName;
    this.oGroup = null;
    this.status = false;
}

function CWC2_CS_Layer_SetGroup( oGroup )
{
    this.oGroup = oGroup;
}

function CWC2_CS_Layer_SetStatus( bStatus )
{
    this.status = bStatus;
}

function CWC2_CS_Layer_UpdateStatus( )
{
    return this.GetStatus();
}

function CWC2_CS_Layer_GetStatus( )
{
    return this.status;
}

CWC2_CS_Layer.prototype.SetGroup = CWC2_CS_Layer_SetGroup;
CWC2_CS_Layer.prototype.SetStatus = CWC2_CS_Layer_SetStatus;
CWC2_CS_Layer.prototype.UpdateStatus = CWC2_CS_Layer_UpdateStatus;
CWC2_CS_Layer.prototype.GetStatus = CWC2_CS_Layer_GetStatus;
