<?php
/**
 * ZoomIn Widget class
 *
 * @project     CWC2
 * @revision    $Id: cwcjsapi.widget.php,v 1.2 2004/07/08 15:58:59 pspencer Exp $
 * @purpose     Zoom In Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

class CWCJSAPI extends CWCWidget
{

    var $mbDebug = false;

    function CWCJSAPI()
    {
        $this->mnPriority = PRIORITY_MAXIMUM;

        $this->maAttributes["DEBUG"] = new BooleanAttribute( "DEBUG", false );

        $this->szWidgetDescription = <<<EOT
The CWCJSAPI Widget provides a javascript API to the CWC core architecture.
This provides an application that runs almost entirely on the client side,
with very few 'submits' of the page.  It also provides the application
developer with a javascript API to access and change the state of the Context.
EOT;
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["DEBUG"]))
        {
            $this->mbDebug = (strcasecmp($this->maParams["DEBUG"], "true") == 0) ? true : false;
        }

    }

    /**
     * GetJavascriptFunctions
     *
     */
    function GetJavascriptFunctions()
    {
        $poMap = $this->moMapObject->oMap;
        if (!is_object( $poMap ) )
            return array();
        $dfMinX = $poMap->extent->minx;
        $dfMinY = $poMap->extent->miny;
        $dfMaxX = $poMap->extent->maxx;
        $dfMaxY = $poMap->extent->maxy;
        $nWidth = $poMap->width;
        $nHeight = $poMap->height;
        $dfScale = $poMap->scale;
        $dfCellSize = $poMap->cellsize;
        $dfResolution = $poMap->resolution;
        $nUnits = $poMap->units;

        if (is_object($poMap))
            $szProj = $poMap->getProjection();
        else
            $szProj = "init=EPSG:None";
        $szProj = substr( $szProj, 5 );


        $aReturn = array();

    $szJsFunctionName = "CWCJSAPIGetObject";

    $szFunction = "function CWCJSAPIGetObject()\n";
    $szFunction .= <<<EOT
{
  return gpoCWCJSAPI;
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;


    $szJsFunctionName = "CWCJSAPICreateLayer";
    $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to create a dynamic layer
 */
function {$szJsFunctionName}(containerName)
{
    var layer ;
    var str;
    var left = 0;
    var right = 0;
    var width = 10;
    var height = 10;
    var visible = 0;
    var bNetscape4 = 0;
    var bNetscape6 = 0;
    var bIE = 0;


    if (navigator.appName == "Netscape")
    {
        if (navigator.appVersion[0] <= 4)
        {
            bNetscape4 = 1;
        }
        else
        {
            bNetscape6 =1;
        }
    }
    else if (navigator.appName == "Microsoft Internet Explorer")
    {
        bIE = 1;
    }


    if (bNetscape4)
    {
/* ==================================================================== */
/*      For netscape 4 the Layer is created in the cwcjsapi :           */
/*      when CWCGetDocumentObject() function is called the first        */
/*      time. Seeems to have a problem when created beforehand.         */
/* ==================================================================== */
        //container = new Layer(100);

        //container.name = containerName;
        //container.visibility = 'hide';
        //container.visibility = 'show';
        // container.resizeTo(100,100);
        //container.document = '';
        //container.src = '';
        //container.clip.width = 100;
        //container.clip.height = 100;
    }
    else if (bIE)
    {
        document.body.insertAdjacentHTML( "afterBegin", '<span id="' + containerName + '"></span>' );
      var span = document.all(containerName );
      var html = '<iframe name="' + "frame_" + containerName + '" src""></iframe>';
      span.innerHTML = html;
      span.style.display = 'none';
      container = window.frames[ "frame_" + containerName ];
    }
    else if (bNetscape6)
    {
        var span = document.createElement('SPAN');
        span.id = containerName;
        document.body.appendChild( span );
        var iframe = document.createElement('IFRAME');
        iframe.name = "frame_"+containerName;
        span.appendChild( iframe );
        container = iframe;
    }
    return container;
}
EOT;

    $aReturn[$szJsFunctionName] = $szFunction;


    $session_id = session_id();

    //arrays contains the infos on the layers.
    $szLayerInfo="";
    for ($i=0; $i<$poMap->numlayers; $i++)
    {
      $poLayer = $poMap->getlayer($i);
      if ($poLayer->connectiontype == MS_WMS)
        $szLayerInfo .="aLayername[".$i."] = '" .  $poLayer->getMetaData("wms_name") . "';\n";
      else
        $szLayerInfo .="aLayername[".$i."] = '" .  $poLayer->name . "';\n";

      $szLayerInfo .="aLayerindex[".$i."] = '" .  $poLayer->index . "';\n";
      $szLayerInfo .="aLayerstatus[".$i."] = '" .  $poLayer->status . "';\n";
      $szLayerInfo .="aLayerdata[".$i."] = '" .  $poLayer->data . "';\n";
      $szLayerInfo .="aLayertype[".$i."] = '" .  $poLayer->type . "';\n";


      if ($poLayer->connectiontype == MS_WMS && 
          strlen($poLayer->getMetaData("wms_title")) > 0)
        $szLayerInfo .="aLayertitle[".$i."] = \"" .  $poLayer->getMetaData("wms_title") . "\";\n";
      else
        $szLayerInfo .="aLayertitle[".$i."] = \"" .  $poLayer->name . "\";\n";

      $szLayerInfo .="aLayerconnection[".$i."] = '" .  $poLayer->connection . "';\n";
      $szLayerInfo .="aLayeronlineresource[".$i."] = '" . $poLayer->getMetaData("wms_onlineresource")  . "';\n";
      $szLayerInfo .="aLayersrs[".$i."] = '" .  $poLayer->getMetaData("wms_srs") . "';\n";
      $szLayerInfo .="aLayerversion[".$i."] = '" .  $poLayer->getMetaData("wms_server_version") . "';\n";
      $szLayerInfo .="aLayerformat[".$i."] = '" .  $poLayer->getMetaData("wms_format") . "';\n";
      $szLayerInfo .="aLayerformatlist[".$i."] = '" .  $poLayer->getMetaData("wms_formatlist") . "';\n";

      $szLayerInfo .="aLayerconnection[".$i."] = '" .  $poLayer->connection . "';\n";
      $szLayerInfo .="aLayerconnectiontype[".$i."] = '" .  $poLayer->connectiontype . "';\n";
      $szLayerInfo .="aLayeronlineresource[".$i."] = '" . $poLayer->getMetaData("wms_onlineresource")  . "';\n";
      $szLayerInfo .="aLayersrs[".$i."] = '" .  $poLayer->getMetaData("wms_srs") . "';\n";
      $szLayerInfo .="aLayerversion[".$i."] = '" .  $poLayer->getMetaData("wms_server_version") . "';\n";
      $szLayerInfo .="aLayerformat[".$i."] = '" .  $poLayer->getMetaData("wms_format") . "';\n";
      $szLayerInfo .="aLayerformatlist[".$i."] = '" .  $poLayer->getMetaData("wms_formatlist") . "';\n";

      $szLayerInfo .="aLayerstyle[".$i."] = '" .  $poLayer->getMetaData("wms_style") . "';\n";
      $szLayerInfo .="aLayerstylelist[".$i."] = '" .  $poLayer->getMetaData("wms_stylelist") . "';\n";
    }

    $aLayerOder = $poMap->getlayersdrawingorder();
    $szLayerDrawingOrder = implode(",", $aLayerOder);
    $szCurrentLanguage = strtoupper($_SESSION['gszCurrentLanguage']);

    $szJsFunctionName = "CWCJSAPIWInit";
    $bDebug = ($this->mbDebug) ? 1 : 0;
    $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to initialize the JS API widget
 */
function {$szJsFunctionName}()
{
    aLayername = new Array({$poMap->numlayers});
    aLayerindex = new Array({$poMap->numlayers});
    aLayerstatus = new Array({$poMap->numlayers});
    aLayertitle = new Array({$poMap->numlayers});
    aLayerdata = new Array({$poMap->numlayers});
    aLayertype = new Array({$poMap->numlayers});
    aLayerconnection = new Array({$poMap->numlayers});
    aLayerconnectiontype = new Array({$poMap->numlayers});
    aLayeronlineresource = new Array({$poMap->numlayers});
    aLayersrs = new Array({$poMap->numlayers});
    aLayerversion = new Array({$poMap->numlayers});
    aLayerformat = new Array({$poMap->numlayers});
    aLayerformatlist = new Array({$poMap->numlayers});
    aLayerstyle = new Array({$poMap->numlayers});
    aLayerstylelist = new Array({$poMap->numlayers});

    //create a CWC JS API class
    goCWCJSAPI = new CWCApplication();
    goCWCJSAPI.szURL = "{$_SESSION["gszCoreWebPath"]}";

    //init map elements
    goCWCJSAPI.oMap.minx = {$dfMinX};
    goCWCJSAPI.oMap.miny = {$dfMinY};
    goCWCJSAPI.oMap.maxx = {$dfMaxX};
    goCWCJSAPI.oMap.maxy = {$dfMaxY};

    goCWCJSAPI.oMap.width = {$nWidth};
    goCWCJSAPI.oMap.height = {$nHeight};

    goCWCJSAPI.oMap.scale = {$dfScale};
    goCWCJSAPI.oMap.cellsize = {$dfCellSize};
    goCWCJSAPI.oMap.resolution = {$dfResolution};
    goCWCJSAPI.oMap.units = {$nUnits};

    goCWCJSAPI.oMap.projection = '{$szProj}';

    goCWCJSAPI.oMap.layerdrawingorder='{$szLayerDrawingOrder}';

/* -------------------------------------------------------------------- */
/*      Add properties in the application object.                       */
/* -------------------------------------------------------------------- */
    goCWCJSAPI.aProperties = new Array(11);

    //add all the layers in the map file.

    {$szLayerInfo};
    for (i=0; i<{$poMap->numlayers}; i++)
    {
        goCWCJSAPI.oMap.AddLayer(aLayername[i]);
        goCWCJSAPI.oMap.aLayers[i].index = aLayerindex[i];
        goCWCJSAPI.oMap.aLayers[i].status = aLayerstatus[i];
        goCWCJSAPI.oMap.aLayers[i].data = aLayerdata[i];
        goCWCJSAPI.oMap.aLayers[i].type = aLayertype[i];
        goCWCJSAPI.oMap.aLayers[i].title = aLayertitle[i];
        goCWCJSAPI.oMap.aLayers[i].connection = aLayerconnection[i];
        goCWCJSAPI.oMap.aLayers[i].connectiontype = aLayerconnectiontype[i];
        goCWCJSAPI.oMap.aLayers[i].onlineresource = aLayeronlineresource[i];
        goCWCJSAPI.oMap.aLayers[i].srs = aLayersrs[i];
        goCWCJSAPI.oMap.aLayers[i].version = aLayerversion[i];
        goCWCJSAPI.oMap.aLayers[i].format = aLayerformat[i];
        goCWCJSAPI.oMap.aLayers[i].formatlist = aLayerformatlist[i];
        goCWCJSAPI.oMap.aLayers[i].style = aLayerstyle[i];
        goCWCJSAPI.oMap.aLayers[i].stylelist = aLayerstylelist[i];
    }
    //alert(goCWCJSAPI.oMap.numlayers);
    //alert(goCWCJSAPI.oMap.aLayers[0].name);


    //create htnml layer that will be used to communicate with server


/* ==================================================================== */
/*      For Netscape 4, the container (which is a DHTML Layer will      */
/*      be created the first time that the GetDocuemntObject            */
/*      function is called.                                             */
/* ==================================================================== */
    if (navigator.appName != "Netscape" ||
        navigator.appVersion[0] > 4)
    {
        oContainer = CWCJSAPICreateLayer("CWCJSAPILayer");
        goCWCJSAPI.szContainerName = "CWCJSAPILayer";
        goCWCJSAPI.oContainer = oContainer;
        goCWCJSAPI.ContainerSetVisibility({$bDebug});
    }
    if ({$bDebug})
    {
        goCWCJSAPI.bDebug = true;
    }

    //szURL = "" + window.location;
    //szURL = szURL.substr( 0, szURL.lastIndexOf("?") + 1 );
    //szURL = szURL.substr( 0, szURL.lastIndexOf("/" ) + 1 );
    //goCWCJSAPI.szURL = szURL;

    //set the session id
    goCWCJSAPI.sid = "{$session_id}";

/* -------------------------------------------------------------------- */
/*      for netscape 4 the setlanguage  will be called in               */
/*      CWCGetDocumentObject the first time the function is called.     */
/* -------------------------------------------------------------------- */
    if (navigator.appName != "Netscape" ||
        navigator.appVersion[0] > 4)
    {
        goCWCJSAPI.oMLT.SetLanguage("{$szCurrentLanguage}");
    }

    goCWCJSAPI.szLanguage = "{$szCurrentLanguage}";
}
EOT;

    $aReturn[$szJsFunctionName] = $szFunction;




    return $aReturn;
}



    /**
     * GetJavascriptIncludeFunctions.
     *
     */
    function GetJavascriptIncludeFunctions()
    {
        $poMap = $this->moMapObject->oMap;

        $aReturn = array();

        $szJsIncludeName = $_SESSION["gszCoreWebPath"]."/widgets/js/cwcjsapi.js";
        $szInclude = "<script language=\"JavaScript\" src=\"".$_SESSION["gszCoreWebPath"]."/widgets/js/cwcjsapi.js\"></script>";
        $aReturn[$szJsIncludeName] = $szInclude;

         return $aReturn;
    }


    /**
     * GetJavascriptVariables
     *
     */
    function GetJavascriptVariables()
    {
        $aReturn = array();

        $szVariable = "goCWCJSAPI";
        $szValue = " var $szVariable = '';\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * GetJavascriptInitFunctions
     *
     * Functions to be called at the end of the load.
     */
    function GetJavascriptInitFunctions()
    {
        $aReturn = array();

        $szJsFunctionName = "CWCJSAPIWInit";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }


    /**
     * GetHTMLHiddenVariables
     *
     * Return HTML hidden variables.
     *
     * @return HTML hidden variables.
     */
    function GetHTMLHiddenVariables()
    {
         $aReturn = array();
        //used with load context. Needed to add this in case the
        //UploadContext widget is not in the template.
        $szVariable = "CONTEXT";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

}
//end of class CWCJSAPIWidget

if ((function_exists( "RegisterWidget" )))
    RegisterWidget( "CWCJSAPI", "CWCJSAPI" );
?>
