<?php
/**
 * ZoomIn Widget class
 *
 * @project     CWC2
 * @revision    $Id: ZoomIn.widget.php,v 1.3 2004/05/04 18:12:34 pspencer Exp $
 * @purpose     Zoom In Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../NavTool.php");

/**
 * ZoomIn
 *
 * @desc Zoomin widget.
 */
class ZoomIn extends NavTool
{
    var $mszImageTip = "Zoom In";
    var $mdfZoomMin = 4;

    /**
     * ZoomIn
     *
     * Constructor. Set the default values.
     */
    function ZoomIn()
    {
        // invoke constructor of parent
        parent::NavTool();

        $this->NavTool();
        $this->SetNavCommand("ZOOM_IN");
        $this->mnAllowRectangle = 1;
        $this->maAttributes["MINIMUMZOOMRECTANGLE"] = new IntegerAttribute( "MINIMUMZOOMRECTANGLE", false, 1 );
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ZoomIn widget is a navigation tool that allows the user to zoom in
on the map image using either a single point click or by dragging a
zooming box on the map.
EOT;
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset( $this->maParams["MINIMUMZOOMRECTANGLE"] ))
            $this->mdfZoomMin = $this->maParams["MINIMUMZOOMRECTANGLE"];
    }
    /**
     * ParseURL
     *
     * Look for the ZOOM_IN command and if founddo the zooming
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        parent::ParseURL();

        $szCmd = "";
        if ($this->isVarSet( "NAV_CMD" ))
            $szCmd = $this->getVar( "NAV_CMD" );

        if ($szCmd == "ZOOM_IN")
        {

            $szInputCoords = "";
            $szInputCoords = $this->getVar( "NAV_INPUT_COORDINATES" );
            $szInputType = $this->getVar( "NAV_INPUT_TYPE" );

            if(strlen($szInputCoords) <= 0)
            {
                //The nav tool could be set to zoomin and the page submitted
                //using other tools so this message is invalid.

                //$_SESSION['gErrorManager']->setError(ERR_WARNING,
                //   "ERROR: No input coordinates specified in ZoomIn.php.");
                return true;
            }
            if (strlen($szInputType) <= 0)
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                 trim($this->moMLT->get("0", "ERROR: No input type specified in "))."ZoomIn.php.");
                return false;
            }
            $nZoomFactor = 2;
            if ($this->isVarSet( "ZOOMFACTOR" ))
              $nZoomFactor = intval($this->getVar( "ZOOMFACTOR" ));
            if ($nZoomFactor <= 0)
              $nZoomFactor = 2;

            if ($szInputType == "POINT")
            {
                $aPixPos = explode(",", $szInputCoords);
                $this->moMapNavigator->zoomPoint($nZoomFactor, $aPixPos[0],
                                                 $aPixPos[1]);
            }
            else if ($szInputType == "RECTANGLE")
            {
                $aPixPos = explode(";", $szInputCoords);
                $aPixMin = explode(",", $aPixPos[0]);
                $aPixMax = explode(",", $aPixPos[1]);
/* -------------------------------------------------------------------- */
/*      check if the rectangle is bigger than the minmum size allowed.  */
/* -------------------------------------------------------------------- */

                if (abs($aPixMax[0] - $aPixMin[0]) < $this->mdfZoomMin &&
                    abs($aPixMax[1] - $aPixMin[1]) < $this->mdfZoomMin)
                {
                    $this->moMapNavigator->zoomPoint($nZoomFactor, $aPixMin[0],
                                                     $aPixMin[1]);
                }
                else
                  $this->moMapNavigator->zoomRectangle($aPixMin[0], $aPixMin[1],
                                                       $aPixMax[0], $aPixMax[1]);
/* -------------------------------------------------------------------- */
/*      Call the reporjectauto function in case the map projection      */
/*      is set to AUTO:XXX. If it is not, the function will do          */
/*      nothing.                                                        */
/* -------------------------------------------------------------------- */
                $this->ReprojectAuto();
            }
            else
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                  trim($this->moMLT->get("1", "ERROR: Invalid input type specified in "))."ZoomIn.php.");
                return false;
            }
        }
        
        // return success
        return true;
    }
}
?>
