<?php
/**
 * Z39Query Widget Class
 *
 * @project     Chameleon
 * @revision    $Id: Z39Query.widget.php,v 1.2 2004/04/24 22:00:02 pspencer Exp $
 * @purpose     Display a dialog box to build queries
 * @author      Jason Fournier (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");
include_once( COMMON."/xml_utils/XMLObject.php" );

/**
 * Z39Query
 *
 * @desc Display a widget that pops up a Z39 Query widget.
 */
class Z39Query extends CWCWidget
{
    var $moLabel;
    var $moButton;
    var $moPopup;
    var $mszImagePath = "images/tool_zoombounds.gif";
    var $mszImageSelectedPath = "images/tool_zoombounds.gif";
    var $mszImageHoverPath = "images/tool_zoombounds.gif";
    var $mszImageTip = "Build Z39 Query";
    
    var $mszSearchServer = '';
    var $mszSharedResourceName = '';
    var $mszGMLName = '';
    var $mnSearchOffset = 0;
    var $mnSearchLimit = 100;

    /**
     * Z39Query
     *
     * Constctor method for the Z39Query
     */
    function Z39Query()
    {
        
        parent::CWCWidget();
        
        $this->mnPriority = PRIORITY_LOW;

        $this->moLabel = new CWCLabel( $this );
        $this->moButton = new CWCButton( $this );
        $this->moPopup = new CWCPopup( $this );
        $this->moPopup->mszLink = "widgets/Z39Query.phtml";
        
        // add search params
        $this->maAttributes["GMLNAME"] = new StringAttribute( "GMLNAME", true );        
        $this->maAttributes["SEARCHSERVER"] = new StringAttribute( "SEARCHSERVER", true );        
        $this->maAttributes["SEARCHOFFSET"] = new IntegerAttribute( "SEARCHOFFSET", false );        
        $this->maAttributes["SEARCHLIMIT"] = new IntegerAttribute( "SEARCHLIMIT", false );        

        $this->maAttributes["SHAREDRESOURCE"] = new StringAttribute( "SHAREDRESOURCE", false );        

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
DESC here
EOT;

    }

    function InitDefaults()
    {

        parent::InitDefaults();
        
        $this->moButton->mszImagePath = $this->mszImagePath;
        $this->moButton->mszImageSelectedPath = $this->mszImageSelectedPath;
        $this->moButton->mszImageHoverPath = $this->mszImageHoverPath;
        $this->moButton->mszAltText = $this->mszImageTip;
        $this->moButton->InitDefaults();

        if ( isset( $this->maParams["GMLNAME"] ) )
           $this->mszGMLPath = $this->maParams["GMLNAME"];
        if ( isset( $this->maParams["SEARCHSERVER"] ) )
           $this->mszSearchServer = $this->maParams["SEARCHSERVER"];
        if ( isset( $this->maParams["SHAREDRESOURCE"] ) )
           $this->mszSharedResourceName = $this->maParams["SHAREDRESOURCE"];

        if ( isset( $this->maParams["SEARCHOFFSET"] ) )
           $this->mnSearchOffset = $this->maParams["SEARCHOFFSET"];
        if ( isset( $this->maParams["SEARCHLIMIT"] ) )
           $this->mnSearchLimit = $this->maParams["SEARCHLIMIT"];

    }

    /**
     * SetMap
     *
     * Set the map session and create a navigation tool.
     */
    function SetMap($oMapSession)
    {
        $this->moMapObject = $oMapSession;
    }


    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    /**
     * ParseURL
     *
     */
    function  ParseURL()
    {
        
        /*
         * 1. check layer status, if on then continue, if off, then quit
         * 2. if sharedresource name is not ''
         * 2a. convert geo2pix
         * 3. get gml and put into sharedresource
         */
         $nFTime = microtime();
         
         //$szFilePath = getSessionSavePath() . $_FORM['GMLName'];
         $szFilePath = 'D:/ms4w/apps/scihi/data/GML/sampleGML.gml';
         $szFileContents = implode( " ", file( $szFilePath ) );   
         
         $oXML = new XMLObject( $szFileContents );
         $oXML = $oXML->children[0];
         $aResults = array();
         $j = 0;
         
         $oProjIn = ms_newprojectionobj( "init=epsg:4326" );
         $oProjOut = ms_newprojectionobj( $this->moMapObject->oMap->GetProjection() );
         
         $oPoint = ms_newPointObj();
         
         $oChild = $oXML->getNextChild( "em:envirodatMetadataMember" );
         while ($oChild != "" && $oChild != null)
         {
             $aResults[$j]['station_name'] = $oChild->children[0]->children[0]->value;
             $aResults[$j]['station_id'] = $oChild->children[0]->children[1]->value;
             $aResults[$j]['geo_x'] = $oChild->children[0]->children[2]->children[0]
                                      ->children[0]->children[0]->value;
             $aResults[$j]['geo_y'] = $oChild->children[0]->children[2]->children[0]
                                      ->children[0]->children[1]->value;
              
             $oPoint->setXY( $aResults[$j]['geo_x'], $aResults[$j]['geo_y'] );
             $oPoint->project( $oProjIn, $oProjOut );
             
             $aResults[$j]['pix_x'] = $this->Geo2Pix( $oPoint->x, 
                                                      0, 
                                                      $this->moMapObject->oMap->width, 
                                                      $this->moMapObject->oMap->extent->minx,
                                                      $this->moMapObject->oMap->extent->maxx, 
                                                      0 );
             $aResults[$j]['pix_y'] = $this->Geo2Pix( $oPoint->y, 
                                                      0, 
                                                      $this->moMapObject->oMap->height, 
                                                      $this->moMapObject->oMap->extent->miny,
                                                      $this->moMapObject->oMap->extent->maxy, 
                                                      1 );

             $j++;
             $oChild = $oXML->getNextChild( "em:envirodatMetadataMember" );
         } 
         
         $oPoint->free();
         
         $this->maSharedResourceWidgets[$this->mszSharedResourceName]->maszContents = array();
         $this->maSharedResourceWidgets[$this->mszSharedResourceName]->maszContents['LayerAttributes'] = $aResults;
         
         $nETime = microtime();
         echo 'processing time for JSSR: ' . (substr($nETime, 0, 5) - substr($nFTime, 0, 5)) . '<br>';
 
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        // set the server url etc
        if ( isset( $this->maParams["GMLNAME"] ) )
            $szTmpName = urlencode( $this->maParams["GMLNAME"] );
        else
            $szTmpPath = "null";

        if ( isset( $this->maParams["SEARCHSERVER"] ) )
            $szTmpSearch = urlencode( $this->maParams["SEARCHSERVER"] );
        else
            $szTmpSearch = "null";

        /**
         * {clickZ39Query}
         * popup a Z39 Query dialog
         */
        $aReturn = $this->moButton->GetJavascriptFunctions();//array();
        $this->moPopup->mszLink = "widgets/Z39Query.phtml?SearchServer=".
                                  $szTmpSearch . "&GMLName=".urlencode($szTmpName);
        $szJsFunctionName = "clickZ39Query";
        $szButtonJS = $this->moPopup->DrawPublish();
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a Z39 Query dialog
 */
function {$szJsFunctionName}()
{
    {$szButtonJS}
    return;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;


        /**
         * {fnname}
         * desc
         */
        // add the apply javascript code to apply the filter
        $szJsFunctionName = "executeEnvirodatQuery";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * Execute the Query
 */
function {$szJsFunctionName}( szQueryString )
{
   
    // return
    return;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        
        
        $szJsFunctionName = "applyZ39BoundingBox";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a Bounding Box dialog
 */
function {$szJsFunctionName}(nMinX, nMinY, nMaxX, nMaxY)
{
    szCoords = "" + nMinX + "," + nMinY;
    if (nMaxX != "" && nMaxY != "")
    {
        szType = "RECTANGLE";
        szCoords = szCoords + "," + nMaxX + "," + nMaxY;
    }
    else
    {
        szType = "POINT";
    }
    {$this->mszHTMLForm}.NAV_CMD.value="ZOOM_BBOX";
    {$this->mszHTMLForm}.NAV_INPUT_TYPE.value=szType;
    {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value=szCoords;

    if ({$bCWCJSAPI})
    {
        goCWCJSAPI.NAV_CMD="ZOOM_BBOX";
        goCWCJSAPI.NAV_INPUT_TYPE = szType;
        goCWCJSAPI.NAV_INPUT_COORDINATES=szCoords;
        goCWCJSAPI.UpdateNavTools();
    }
    else
    {
        {$this->mszHTMLForm}.submit();
    }
     return;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        // return the array of functions
        return $aReturn;

    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- Z39Query popup widget hidden -->";

        $this->moButton->SetOnClick("clickZ39Query()");
        $szResult = $this->moButton->DrawPublish();

        $szResult = $this->moLabel->DrawPublish( $szResult );
        return $szResult;
    }


    /**
     * convert a geocoded position to pixel coord
     *
     * @param nGeoPos double Geocoded position
     * @param dfPixMin double minimum map pixel value
     * @param dfPixMax double maximum map pixel value
     * @param dfGeoMin double minimum map geocoded value
     * @param dfGeoMax double maximum map geocoded value
     * @param nInverseGeo integer optional flag to inverse , set to 1 for
     *                            Y pixel coordinates where UL > LR
     * @return double geocoded position
     */
    function Geo2Pix ($nGeoPos, $dfPixMin, $dfPixMax, $dfGeoMin,
                      $dfGeoMax, $nInverseGeo = "")
    {
    // calculate the geocoded & pixel width
    if ($nGeoPos < $dfGeoMin)
        $nGeoPos = $dfGeoMin;
    if ($nGeoPos > $dfGeoMax)
        $nGeoPos = $dfGeoMax;

    $dfWidthGeo = abs($dfGeoMax - $dfGeoMin);
    $dfWidthPix = abs($dfPixMax - $dfPixMin);

    // get ratio
    $dfGeoToPix = $dfWidthPix / $dfWidthGeo;

    // get difference
    if (!$nInverseGeo)
        $dfDeltaGeo = $nGeoPos - $dfGeoMin;
    else
        $dfDeltaGeo = $dfGeoMax - $nGeoPos;

    // calculate
    $dfDeltaPix = $dfDeltaGeo * $dfGeoToPix;
    $dfPosPix = $dfPixMin + $dfDeltaPix;

    //echo "$nGeoPos, $dfPixMin, $dfPixMax, $dfGeoMin, $dfGeoMax<br>";
    //echo ": ".round($dfPosPix)."<BR><br>";
    // return value
    return round ($dfPosPix);

    // end pixel_to_geo function
    }

}
?>
