<?php
/**
* WMSBrowser Widget class
*
* @project     CWC2
* @revision    $Id: WMSBrowser.widget.php,v 1.7 2004/07/08 17:49:09 pspencer Exp $
* @purpose     WMSBrowser Popup Widget class
* @author      DM Solutions Group (sfournier@dmsolutions.ca)
* @copyright
* <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*/
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

include_once( COMMON."/phpwms/dbf.php");

/**
* a simple widget to link to another page
*/
class WMSBrowser extends CWCWidget
{
    var $mszWMSCacheDirectory;
    var $mbUseUserSession = false;
    var $moButton;
    var $moPopup;
    
    /**
    * construct a new WMSBrowser widget
    */
    function WMSBrowser()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        $this->maAttributes["WMSCACHEDIRECTORY"] = new StringAttribute( "WMSCACHEDIRECTORY", false);
        $this->maAttributes["USEUSERSESSION"] = new BooleanAttribute( "USEUSERSESSION", false);
        
        $this->moButton = new CWCButton( $this );
        $this->moPopup = new CWCPopup( $this );
        
        $this->mnPriority = PRIORITY_SUPER;
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The WMSBrowser widget allows .....
EOT;
    }
    
    function InitDefaults()
    {
        $oApp = GetChameleonApplication();
        
        parent::InitDefaults();

        $this->moButton->InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->SetOnClick( 'clickWMSBrowser' );
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/WMSBrowser/WMSBrowser.php?";

        if (isset($this->maParams["USEUSERSESSION"]))
            $this->mbUseUserSession = (strtoupper($this->maParams["USEUSERSESSION"]) == "TRUE") ? true : false;

        if (isset($this->maParams["WMSCACHEDIRECTORY"]))
        {
            $this->mszWMSCacheDirectory = $oApp->resolvePath2($this->maParams["WMSCACHEDIRECTORY"], $_SESSION['gszAppPath']);        
        }
        else
        {
            $this->mszWMSCacheDirectory = realpath($_SESSION['gszCorePath']."/../data"); 
        }
            
        if (!isset($_SESSION['gszServerDataPath']))
        {
            if ($this->mbUseUserSession)
            {                
                 $szDir = str_replace("\\", "/", getSessionSavePath()."/data/");

                // Check if data exist in user dir
                if (!is_dir($szDir))
                    mkdir($szDir);

                // copy content of WMS cache dir to user directory
                $hDir = opendir($this->mszWMSCacheDirectory);
                while ($szFile = readdir($hDir))
                {
                    if (is_file($this->mszWMSCacheDirectory."/".$szFile))
                        copy($this->mszWMSCacheDirectory."/".$szFile, $szDir."/".$szFile);
                }

                $_SESSION["gszServerDataPath"] = $szDir;
            }
            else
                $_SESSION["gszServerDataPath"] = $this->mszWMSCacheDirectory;
        }
        
    }
    
    /**
    * Add WMS layer if any specified
    */
    function  ParseURL()
    {
        $this->moButton->ParseURL();
        
        if ($this->isVarSet( "WMS_LAYERS_TOADD" ) &&
        $this->getVar( "WMS_LAYERS_TOADD" ) != "")
        {
            $szSelectedLayers = $this->getVar( "WMS_LAYERS_TOADD" );
            
            //check the projection attribute before adding WMS layers
            $szProj = $this->moMapObject->oMap->getProjection();
            
            //initialize the layers array;
            $aszLayers = array();
            
            if ( $szProj == "" )
            {
                $_SESSION['gErrorManager']->setError(ERR_WARNING,
                "Projection must be set in map file to add WMS layers!" );
                $bWMSProjectionWarning = 1;
            }
            else
            {
                $aszLayers = explode (',',$szSelectedLayers);
                
                foreach($aszLayers as $szLayer)
                {
                    // add the layer to the map
                    if (is_numeric($szLayer));
                    {
                        $this->addWMSLayer( $szLayer );
                        $_SESSION['gszCurrentState'] = $this->moMapObject->saveState();
                    }
                }
            }
        }
        return true;
    }
    
    function GetJavascriptFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptFunctions();
        
        $szJsFunctionName = "BrowseWMSCallBack";
        $szFunction = <<<EOT
function {$szJsFunctionName}( actionId, wh )
{
    var szSelectedLayers = wh.document.forms[0].selectedLayers.value;

    if ( actionId == 0) //Clicked OK
    {
    wh.close();
    {$this->mszHTMLForm}.WMS_LAYERS_TOADD.value = szSelectedLayers;
    {$this->mszHTMLForm}.submit();
    }
    else
    if ( actionId == 1) // cancel
    {
    if (!wh.closed)
        wh.close();
    }
    return;
}
EOT;
        
        $aReturn[$szJsFunctionName] = $szFunction;
        
        $szPopup = $this->moPopup->DrawPublish();
        $szJsFunctionName = "clickWMSBrowser";
        $szFunction = <<<EOT
function {$szJsFunctionName}()
{
    {$szPopup}
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }
    
    /**
    * return hidden variables
    */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szVariable = "WMS_LAYERS_TOADD";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;
        
        return $aReturn;
    }
    
    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- WMSBrowser popup widget hidden -->";
        
        $szResult = $this->moButton->DrawPublish();

        return $szResult;
    }
    
    /**
    * This function fetches the layer data for the given layer id and adds it
    * as a layer to the given map object.
    *
    * @param $nLayerID integer - The ID of the layer to fetch.
    * @return boolean - True if successful, false if not.
    **/
    function addWMSLayer( $nLayerID )
    {
        $oMap =& $this->moMapObject->oMap;
        
        $oWMSDatabase = new WMSDatabase($_SESSION['gszServerDataPath']); 
        
        /* ============================================================================
        * Step 1 - get capabilities information
        * ========================================================================= */
        // open the capabilities file
        $dbCap = $oWMSDatabase->getDB( DB_CAPABILITIES );
        
        // check for failure on opening
        if ( $dbCap === false )
        {
            // failed so give message and return
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "Failed to open capabilities file [".DB_CAPABILITIES."].");
            return false;
        }
        
        // locate the record
        $nRecNo = $oWMSDatabase->find_record( $dbCap, "layer_id", $nLayerID );
        
        // check if found
        if ( $nRecNo === false )
        {
            // not found so give error and return
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "LayerID [$nLayerID] was not found in capabilities file [".DB_CAPABILITIES."]." );
            dbase_close( $dbCap );
            return false;
        }
        
        // put the record into an associative array
        $axCapRec = dbase_get_record_with_names( $dbCap, $nRecNo );
        
        // close the database
        dbase_close( $dbCap );
        
        /* ============================================================================
        * Step 2 - get server information
        * ========================================================================= */
        // open the server database
        $dbServ = $oWMSDatabase->getDB( DB_SERVER );
        
        // check for failure on opening
        if ( $dbServ === false )
        {
            // failed so give message and return
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "Failed to open server file [".DB_SERVER."].");
            return false;
        }
        
        // locate the record
        $nRecNo = $oWMSDatabase->find_record( $dbServ, "server_id", $axCapRec["server_id"] );
        
        // check if found
        if ( $nRecNo === false )
        {
            // not found so give error and return
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "ServerID [".$axCapRec["server_id"]."] was not found in server file [".DB_SERVER."]." );
            dbase_close( $dbServ );
            return false;
        }
        
        // put the record into an associative array
        $axServRec = dbase_get_record_with_names( $dbServ, $nRecNo );
        
        // close the database
        dbase_close( $dbServ );
        
        /* ============================================================================
        * Step 3 - get bbox information
        * ========================================================================= */
        // open the bbox database and locate the bbox for the layer
        // there can be 0 or more BBOX
        $szBBOX = "";
        $bbox_id = $axCapRec['bbox_id'];
        
        // open the bbox database
        $dbBBOX = $oWMSDatabase->getDB( DB_BBOX );
        
        // check for failure on opening
        if ( $dbBBOX === false )
        {
            // failed so give message and return
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "Failed to open bbox file [".$dbBBOX."].");
            return false;
        }
        
        // loop and process ALL bbox ids
        while ($bbox_id >= 0)
        {
            // locate the record
            $nRecNo = $oWMSDatabase->find_record( $dbBBOX, "bbox_id", $bbox_id );
            
            // check if found
            if ( $nRecNo === false )
            {
                // not found so give error and return
                $_SESSION['gErrorManager']->setError(ERR_WARNING, "BBOX ID [".$bbox_id.
                "] was not found in bbox file [".DB_BBOX."]." );
                dbase_close( $dbBBOX );
                return false;
            }
            
            // put the record into an associative array
            $axBBOXRec = dbase_get_record_with_names( $dbBBOX, $nRecNo );
            
            // add to the BBOX string
            $szBBOX .= trim($axBBOXRec['SRS'])." ".
            $axBBOXRec['minx']." ".$axBBOXRec['miny']." ".
            $axBBOXRec['maxx']." ".$axBBOXRec['maxy']." ";
            
            // update the ID
            $bbox_id = $axBBOXRec['next_id'];
        }
        
        // close the database
        dbase_close( $dbBBOX );
        
        /* ============================================================================
        * Step 3 and a half - get abstract information
        * ========================================================================= */
        // initialize value
        $szAbstract = "";
        
        if (defined("LAYER_ABSTRACT") && LAYER_ABSTRACT == true &&
        trim($axCapRec["abstractid"]) != -1)
        {
            if (file_exists(ABSTRACT_DIR."/a".trim(strval($axCapRec["server_id"])).
            "abstract.txt"))
            {
                
                // open the abstract text file for the correct server and access the data
                $aFile = file( ABSTRACT_DIR."/a".trim(strval($axCapRec["server_id"])).
                "abstract.txt");
                
                // scan lines until we get to the one that we need
                // 'abstract_id'
                $abstract_id = $axCapRec["abstractid"];
                
                $nAbstract = count($aFile);
                
                for ($i=0; $i<$nAbstract; $i++)
                {
                    if ( $i == $abstract_id )
                    {
                        // capture srs information if correct line
                        $szAbstract .= trim( $aFile[$i] );
                    }
                }
            }
            else
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "Error opening (".ABSTRACT_DIR."/s".trim(strval($axCapRec["server_id"]))."abstract.txt)");
        }
        
        /* ============================================================================
        * Step 4 - get srs information
        * ========================================================================= */
        if (trim($axCapRec["srs_ids"]) != "")
        {
            if (file_exists( $_SESSION['gszServerDataPath']."/s".trim(strval($axCapRec["server_id"]))."srs.txt"))
            {
                // open the srs text file for the correct server and access the data
                $fp = fopen(  $_SESSION['gszServerDataPath']."/s".trim(strval($axCapRec["server_id"]))."srs.txt", "r" );
                // initialize value
                $szSRS = "";
                
                // scan lines until we get to the one that we need
                // 'srs_ids' contains a comma-delimited list of SRS record ids
                $srs_ids = split(",", $axCapRec["srs_ids"]);
                $i = 0;
                
                while (!feof ($fp))
                {
                    if ( in_array($i, $srs_ids) )
                    {
                        // capture srs information if correct line
                        $szSRS .= trim( fgets($fp, 4096) ) ." ";
                    }
                    else
                    {
                        // Just skip this one
                        fgets($fp, 4096);
                    }
                    // increment the line counter
                    $i++;
                }
                
                // close the file pointer
                fclose( $fp );
            }
            else
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "Error opening (". $_SESSION['gszServerDataPath']."/s".trim(strval($axCapRec["server_id"]))."srs.txt)");
        }
        
        /* ============================================================================
        * Step 4 and a half - get style information
        * ========================================================================= */
        //initialize vars
        $szStyleList = "";
        $szStyle = "";
        $aStyle = "";
        if (defined("LAYER_STYLE") && LAYER_STYLE == true)
        {
            // open the style database
            $dbStyle = $oWMSDatabase->getDB( DB_STYLE );
            
            // check for failure on opening
            if ( $dbStyle === false )
            {
                // failed so give message and return
                $_SESSION['gErrorManager']->setError(ERR_WARNING, "Failed to open style file [".DB_STYLE."].");
                return false;
            }
            
            $nStyleID = $axCapRec['style_id'];
            $aStyle = array();
            $bFirst = true;
            while ($nStyleID != -1)
            {
                $nStyleRec = $oWMSDatabase->find_record($dbStyle, "style_id", $nStyleID);
                $styleRec = dbase_get_record_with_names($dbStyle, $nStyleRec);
                
                // validate name and title mapserver don't allow
                // quotes in metadata
                if (strchr($styleRec['name'], "\"") !== false ||
                strchr($styleRec['title'], "\"") !== false)
                {
                    $_SESSION['gErrorManager']->setError(ERR_FATAL, "NAME or TITLE can't have quote in it.");
                    return false;
                }
                
                $szStyleList .= ",".trim($styleRec['name']);
                
                if ($bFirst)
                {
                    $szStyle = trim($styleRec['name']);
                    $bFirst = false;
                }
                
                $aStyle[trim($styleRec['name'])] = array(trim($styleRec['title']),
                trim($styleRec['leg_width'])." ".
                trim($styleRec['leg_height'])." ".
                trim($styleRec['leg_format'])." ".
                trim($styleRec['legendurl']));
                
                $nStyleID = $styleRec['next_id'];
            }
            
            $szStyleList = substr($szStyleList, 1);
            
            // close the database
            dbase_close( $dbStyle );
        }
        
        /* ============================================================================
        * Step 5 - begin assembling layer information
        * ========================================================================= */
        // set the WMS layer name (replace spaces with "_")
        $szWMSName = trim( $axServRec["name"] )."-".trim( $axCapRec["name"] );
        $szWMSName = ereg_replace(" ", "_", $szWMSName);
        
        // set type
        $nWMSType = MS_LAYER_RASTER;
        
        // metadata item - title
        $szWMSMetaData = "wms_title=".trim( $axCapRec["title"] );
        
        // name
        $szWMSMetaData .= "|wms_name=".trim($axCapRec["name"]);
        
        // metadata item - server version
        $szWMSMetaData .= "|wms_server_version=".trim($axServRec['version']);
        
        // map url
        $szWMSMetaData .= "|wms_onlineresource=".urlencode(trim($axServRec['map_url']));
        
        // queryable
        if ( $axCapRec["queryable"] == 1 )
        $szWMSMetaData .= "|wms_queriable=1";
        
        // check for the wms_srs metadata
        if ( $szSRS != "" )
        $szWMSMetaData .= "|wms_srs=".$szSRS;
        
        // check for the wms_abstract metadata
        if ( $szAbstract != "" )
        $szWMSMetaData .= "|wms_abstract=".str_replace("\"", "'", $szAbstract);
        
        
        // check for the wms_stylelist metadata
        if ( $szStyleList != "" )
        $szWMSMetaData .= "|wms_stylelist=".$szStyleList;
        
        if ($szStyle != "")
        $szWMSMetaData .= "|wms_style=".$szStyle;
        
        if (is_array($aStyle))
        foreach($aStyle as $szKey => $aStyleAttr)
        {
            $szWMSMetaData .= "|wms_style_".$szKey."_title=".$aStyleAttr[0];
            $szWMSMetaData .= "|wms_style_".$szKey."_legendurl=".urlencode($aStyleAttr[1]);
        }
        
        // assemble the LLBBOX
        $szLLBBOX = $axCapRec['ll_minx']." ".
        $axCapRec['ll_miny']." ".
        $axCapRec['ll_maxx']." ".
        $axCapRec['ll_maxy'];
        
        // check for the wms_extents metadata
        if ( $szLLBBOX != "" )
        $szWMSMetaData .= "|wms_latlonboundingbox=".$szLLBBOX;
        
        // check for BBOX
        if ( $szBBOX != "" )
        $szWMSMetaData .= "|wms_boundingbox=".$szBBOX;
        
        if (isset($axCapRec["extractabl"]) && $axCapRec["extractabl"] == 1)
        $szWMSMetaData .= "|wms_extractable=1";
        
        // get the mapscript and WMS versions
        $szVersion = ms_GetVersion();
        $szWMSVersion = trim( $axServRec["version"] );
        
        // Find an image format recognized by both this client and the remote svr
        // First replace any commas with spaces
        //$axServRec['formats'] = str_replace( ",", " ", $axServRec['formats'] );
        $aszFormats = split( ",", trim( $axServRec['formats'] ) );
        $szFormat = "";
        
        // Try to match formats in this order: GIF, PNG, JPEG
        foreach( array("GIF", "PNG", "JPEG") as $szFmt)
        {
            // Does MapScript support this format?
            if (strpos($szVersion, "OUTPUT=".$szFmt) > 0)
            {
                // Yes... so does the remote server support it as well?
                foreach( $aszFormats as $thisFormat )
                {
                    if ( strtoupper(trim($thisFormat)) == $szFmt ||
                    strtoupper(trim($thisFormat)) == "IMAGE/".$szFmt )
                    {
                        // Found a match!
                        $szFormat = $thisFormat;
                        break 2;  // Get out of 2 loops
                    }
                }
            }
        }
        
        // metadata item - server format list
        $szWMSMetaData .= "|wms_formatlist=".trim($axServRec['formats']);
        
        // metadata item - server format
        $szWMSMetaData .= "|wms_format=".$szFormat;
        
        // check if the layer is queriable
        if ( $axCapRec['queryable'] = "1" )
        {
            // update the query string
            $szQueryLayers = "&QUERY_LAYERS=".urlencode( trim($axCapRec['name']) );
        }
        else
        {
            // update the query string
            $szQueryLayers = "";
        }
        
        // set connection string
        //printf("usrl = %s <br>", $aszLayer["URL"]);
        $szURL = trim( $axServRec['map_url'] );
        $nLength = strlen( $szURL );
        if (strstr($szURL, '?') !== false)
        {
            if (substr($szURL, -1) != "?" && substr($szURL, -1) != "&")
            $szQuestionMark = "&";
            else
            $szQuestionMark = "";
        }
        else
        $szQuestionMark ="?";
        
        // build connection string
        $szConnection = $szURL.$szQuestionMark;
        /*
         * this is not required, it should be built from metadata.
        ."SERVICE=WMS&VERSION=".$szWMSVersion
        ."&LAYERS=".urlencode( trim( $axCapRec['name'] ) )
        .$szQueryLayers
        ."&FORMAT=".$szFormat."&TRANSPARENT=TRUE";
        */
        // only add the layer if format is set
        if ($szFormat != "")
        {
            // build an array of layerparameters
            $axParams["metadata"] =  $szWMSMetaData;
            $axParams["connectiontype"] = MS_WMS;
            $axParams["connection"] = $szConnection;
            
            // create the layer
            $this->addLayer( $szWMSName, $nWMSType, $axParams );
            
            // get the current map projection
            $szTempMapProj = $oMap->getprojection();
            
            // only set the projection if it's set in the map
            if ( strlen( trim( $szTempMapProj ) ) > 0 )
            {
                // set layer projection
                $oLayer = $oMap->getlayerbyname( $szWMSName );
                $oLayer->setprojection( $szTempMapProj );
            }
        }
        else
        {
            $_SESSION['gErrorManager']->setError(ERR_WARNING, "Acceptable image format not found" );
        }
        
        // return success
        return true;
        
        // end addWMSLayer function
    }
    
    /**
    * This function adds a new layer to the given mapscript map object.  The
    * layer will NOT be added if the name is already in use.
    *
    * @param $szName string - New layer name.
    * @param $nType integer - The layer type.
    * @param $axParams array - Mixed associative array of optional layer
    *              properties:
    *              $axParams["status"] - layer status (default = MS_ON)
    *              $axParams["metadata"] - comma de-limited list of metadata
    *                                      items separated by "metadivider".
    *              $axParams["metadivider"] - metadata divider that separates
    *                                      metadata name from value (default = "=")
    *              $axParams["connectiontype"] - connection type
    *              $axParams["connection"] - the connection string
    *              $axParams["group"] - the group name for the layer
    *              $axParams["data"] - the data string
    *              $axParams["scalemin"] - the minimum scale for the layer
    *              $axParams["scalemax"] - the maximum scale for the layer
    *
    * @return boolean - True if successful, false if not.
    **/
    function addLayer( $szName, $nType, $axParams )
    {
        $oMap =& $this->moMapObject->oMap;
        
        // get an array of all layer names already present in the map
        $aszLayers = $oMap->getAllLayerNames();
        
        // initialize the variable
        $bLayerFound = false;
        
        // Check if anything was returned
        if ( is_array( $aszLayers ) )
        {
            // loop through all the layers and determine if name is found
            foreach ( $aszLayers as $szLayer )
            {
                // check for a match
                if ( strtoupper($szLayer) == strtoupper($szName) )
                {
                    // set flag
                    $bLayerFound = true;
                    
                    // exit loop
                    break;
                }
                // end foreach
            }
        }
        
        // only add the layer if the layer is not already present
        if (!$bLayerFound)
        {
            // create the layer object
            $oNewLayer = ms_newLayerObj($oMap);
            
            // set name
            $oNewLayer->set("name",$szName);
            
            // set type
            $oNewLayer->set("type",$nType);
            
            // set status
            if ( isset( $axParams["status"] ) )
            $oNewLayer->set( "status", $axParams["status"] );
            else
            $oNewLayer->set( "status", MS_ON );
            
            // set group name
            if ( isset( $axParams["group"] ) )
            $oNewLayer->set( "group", $axParams["group"] );
            
            // set the data tag
            if ( isset( $axParams["data"] ) )
            $oNewLayer->set( "data", $axParams["data"] );
            
            // set the min scale
            if ( isset( $axParams["scalemin"] ) &&
            is_numeric( $axParams["scalemin"] ) &&
            $axParams["scalemin"] > 0 )
            $oNewLayer->set( "minscale", $axParams["scalemin"] );
            
            // set the max scale
            if ( isset( $axParams["scalemax"] ) &&
            is_numeric( $axParams["scalemax"] ) &&
            $axParams["scalemax"] >= $axParams["scalemin"] )
            $oNewLayer->set( "maxscale", $axParams["scalemax"] );
            
            // set metadata
            if ( isset( $axParams["metadata"] ) )
            {
                // determine the metadata divider
                if ( isset( $axParams["metadivider"] ) )
                $sz_meta_div_str = $axParams["metadivider"];
                else
                $sz_meta_div_str = "=";
                
                // create an array of metadata
                $aszMetaData1 = explode( "|", $axParams["metadata"] );
                
                // loop and add metadata
                foreach ($aszMetaData1 as $MetaData)
                {
                    // separate the value from the label
                    $aszMetaData2 = explode( $sz_meta_div_str, $MetaData );
                    
                    // add
                    $oNewLayer->setMetaData(trim($aszMetaData2[0]),
                    urldecode(trim($aszMetaData2[1])));
                }
            }
            
            // set connecttion
            if ( isset( $axParams["connectiontype"] ) )
            $oNewLayer->set( "connectiontype",$axParams["connectiontype"] );
            
            //fix provided by Bart 2004-05-13 to make newly added layers queryable
            //TODO: is this the right thing to do?  we should check the queriable
            //value in $axParams probably
            $oNewLayer->set( "template", "blank.html" );
            $oNewLayer->set( "dump", MS_TRUE );
            
            // set connection string
            if ( isset( $axParams["connection"] ) )
            $oNewLayer->set( "connection", $axParams["connection"] );
            
            // return success
            $bReturn = true;
        }
        // otherwise the layer exists
        else
        {
            // return failure
            $bReturn = false;
        }
        
        // return status
        return $bReturn;
        
        // end addLayer function
    }
}
?>
