<?php
/**
 * WMSBrowser Widget class
 *
 * @project     CWC2
 * @revision    $Id: WMSBrowser.php,v 1.3 2004/05/26 20:45:41 pspencer Exp $
 * @purpose     WMSBrowser Application
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

// Include base class definition
include_once (dirname(__FILE__).'/../../chameleon.php');

/**
* This is our main chameleon class definition.
*/
class WMSBrowserApp extends Chameleon
{
    /**
    * Constructor
    *
    * In our example, we need a Writable mapsession object.
    * chameleon, by default, create a ReadOnly mapsession
    * object. So we will create it for the parent.
    */
    function WMSBrowserApp()
    {
        parent::Chameleon();
        $this->moMapSession = new MapSession_RW();
        $this->moMapSession->setTempDir(getSessionSavePath());
    }
    
}

$oApp = new WMSBrowserApp();

// Check if template is the iframe or not
if (!isset($_GET['template']) || substr($_GET['template'], 11,1) == "t")
{ 
    $oApp->CWCAddRegionalTemplate( "en-CA", "mapbrowser_template_en.html");
    $oApp->CWCAddRegionalTemplate( "fr-CA", "mapbrowser_template_fr.html");
}
else
{
    $oApp->CWCAddRegionalTemplate( "en-CA", "mapbrowser_iframe_en.html");
    $oApp->CWCAddRegionalTemplate( "fr-CA", "mapbrowser_iframe_fr.html");
}

if (isset($_SESSION['gszMapName']) && $_SESSION['gszMapName'] != "")
    $szMapName = $_SESSION['gszMapName'];
else
if (isset($_GET['mapfile']) && $_GET['mapfile'] != "")
    $szMapName = $_GET['mapfile'];
else
{
    echo "FATAL ERROR: Can't find any mapfile.";
    exit;
}

//this is to get the path to chameleon for use in the template
//access using [$gszCoreWebPath$]
$oApp->setVar( 'gszCoreWebPath', $_SESSION['gszCoreWebPath'] );
//$oApp->setVar( 'PopupCSS', $_SESSION['gszCSSFile'] );

$oApp->CWCInitialize("", $szMapName);
$oApp->CWCExecute();
?>