<?php
/**
 * ContextUpload Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     ContextUpload Popup Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * ContextUpload
 *
 * @desc ContextUpload widget class
 */
class UploadContext extends CWCWidget
{
    var $mszTemplate;      // [string]

    var $moButton;         // Button object
    var $moPopup;          // Popup object

    var $mszLink = '';
    var $mszParam = '&szCallbackFunc=OpenContextCB';

    /**
     * ContextUpload
     *
     * Constctor method for the ContextUpload widget.
     */
    function UploadContext()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ContextUpload widget allows the user to upload a Context file from their
local hard drive or from a URL to the current application.  This widget
does not limit the user from attempting to upload contexts if the CWC2 service
instance is configured not to allow it.  The user will receive an error message
after this widget attempts to upload the context.
EOT;

        $this->moButton = new CWCButton($this);

        $this->moPopup = new CWCPopup($this);
        $this->mnPriority = PRIORITY_MAXIMUM;
    }


    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('clickContextUpload');
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath'].'/widgets/UploadContext/UploadContext.phtml';
        $this->moPopup->mszParam = $this->mszParam;
        $this->moPopup->InitDefaults();
    }
    
    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }


    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $szJsFunctionName = "clickContextUpload";
        $szFunction = "function $szJsFunctionName()\n" .
                      "{\n".
                       $this->moPopup->DrawPublish()."\n".
                      "return;\n" .
                      "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "OpenContextCB";
        $szFunction = <<<EOF

function {$szJsFunctionName}(actionID, wh)
{
    if (actionID == 0 || actionID == 1) // ok
    {
        // The context has been loaded into the map session, simply reload
        // the page.  First we'll need to clear some previous state, though.
        if ({$this->mszHTMLForm}.MAP_EXTENTS_MINX.value != null)
            {$this->mszHTMLForm}.MAP_EXTENTS_MINX.value = "";
        if ({$this->mszHTMLForm}.MAP_EXTENTS_MINY.value != null)
           {$this->mszHTMLForm}.MAP_EXTENTS_MINY.value = "";
        if ({$this->mszHTMLForm}.MAP_EXTENTS_MAXX.value != null)
            {$this->mszHTMLForm}.MAP_EXTENTS_MAXX.value = "";
        if ({$this->mszHTMLForm}.MAP_EXTENTS_MAXY.value != null)
            {$this->mszHTMLForm}.MAP_EXTENTS_MAXY.value = "";
        if ({$this->mszHTMLForm}.MAP_WIDTH.value != null)
            {$this->mszHTMLForm}.MAP_WIDTH.value = "";
        if ({$this->mszHTMLForm}.MAP_HEIGHT.value != null)
            {$this->mszHTMLForm}.MAP_HEIGHT.value = "";       
        if ({$this->mszHTMLForm}.LEGENDTEMPLATE_RESET != null && {$this->mszHTMLForm}.LEGENDTEMPLATE_RESET.value != null)
            {$this->mszHTMLForm}.LEGENDTEMPLATE_RESET.value = "1";     
        wh.close();
        {$this->mszHTMLForm}.submit();
    }
    else if (actionID == 2) // cancel
    {
        wh.close();
    }

    return;
}

EOF;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     *
     * @return HTML Code
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return '<!-- Upload Context widget hidden -->';

        
        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
?>
