<?php
/**
 * Table Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     Driving Directions Table Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");

/**
 * Table Class
 *
 * @desc Table widget class
 */
class Table extends CWCWidget
{
    var $mszSharedResourceName = "";
    var $mszHeader = "";
    var $mszBody   = "";
    var $mszFooter = "";
    var $mszNextButton = "Next";
    var $mszPrevButton = "Previous";
    var $mnStart  = 0;
    var $mnCount  = 10;
    var $mszSortBy= "";
    var $mbReverseSort = false;
    var $maoSharedResources = array();

    // Array of from to replace into Header and footer
    var $maszFrom = array();
    var $maszTo   = array();
    var $maszRegExFrom = array();
    var $maszRegExTo   = array();
    var $maCallbackRegEx = array();

    // Array of from to replace into body
    var $maszBodyFrom = array();
    var $maszBodyTo   = array();
    var $maszBodyRegExFrom = array();
    var $maszBodyRegExTo   = array();
    var $maFunction = array();



    /**
     * Table
     *
     * Constructor method for the Table widget.
     */
    function Table ()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Table widget provides the functionality to display 
shared resource as Table.
EOT;

        $this->maAttributes["SHAREDRESOURCENAME"] = new StringAttribute( "SHAREDRESOURCENAME", true );
        $this->maAttributes["SORTBY"] = new StringAttribute( "SORTBY", false );
        $this->maAttributes["START"] = new IntegerAttribute( "START", false );
        $this->maAttributes["COUNT"] = new IntegerAttribute( "COUNT", false );
        $this->maAttributes["REVERSE"] = new BooleanAttribute( "REVERSE", false );
        $this->maAttributes["NEXTBUTTON"] = new StringAttribute( "NEXTBUTTON", false );
        $this->maAttributes["PREVBUTTON"] = new StringAttribute( "PREVBUTTON", false );

        $this->mnPriority = PRIORITY_HIGH;
    }

    function SortBy($a, $b)
    {
        // There can be more than one collumn to sort
        $aszSortBy = explode("|", $this->mszSortBy);

        $nRes = 0;

        // For each sortby collumn vlaue
        foreach($aszSortBy as $szSortBy)
        {
            $szSortBy = trim($szSortBy);

            $nPos = strpos($szSortBy, "/");
            if($nPos !== false)
            {
                $szFlags = substr($szSortBy, $nPos+1);
                $szSortBy = substr($szSortBy, 0, $nPos);

                if(strpos($szFlags, "i") !== false)
                {
                    $a[$szSortBy] = strtoupper($a[$szSortBy]);
                    $b[$szSortBy] = strtoupper($b[$szSortBy]);
                }
            }
            else
                $szFlags = "";

            if (!isset($a[$szSortBy]) || !isset($b[$szSortBy]))
                return 0;

            if(is_numeric($a[$szSortBy]) && is_numeric($b[$szSortBy]) && 
               $nRes == 0)
                if($a[$szSortBy] == $b[$szSortBy])
                    $nRes = 0;
                else if($a[$szSortBy] < $b[$szSortBy])
                    $nRes = -1;
                else
                    $nRes = 1;
            else
                $nRes = (($nRes == 0) ? strcmp($a[$szSortBy], $b[$szSortBy]) : $nRes);

            if($szFlags != "")
                if(strpos($szFlags, ">") !== false)
                    if ($nRes == 1) $nRes = -1;
                    else if ($nRes == -1) $nRes = 1;
        }

        if ($this->mbReverseSort)
        {
            if ($nRes == 1) $nRes = -1;
            else
            if ($nRes == -1) $nRes = 1;
        }
        return $nRes;
    }

    function InitDefaults()
    {
        if (isset($this->maParams["SHAREDRESOURCENAME"]))
            $this->mszSharedResourceName = $this->maParams["SHAREDRESOURCENAME"];

        if (isset($this->maParams["START"]))
            $this->mnStart = $this->maParams["START"];

        if (isset($this->maParams["COUNT"]))
            $this->mnCount = $this->maParams["COUNT"];

        if (isset($this->maParams["SORTBY"]))
            $this->mszSortBy = $this->maParams["SORTBY"];

        if (isset($this->maParams["NEXTBUTTON"]))
            $this->mszNextButton = $this->maParams["NEXTBUTTON"];

        if (isset($this->maParams["PREVBUTTON"]))
            $this->mszPrevButton = $this->maParams["PREVBUTTON"];

        if (isset($this->maParams["REVERSE"]))
        {
            $this->mbReverseSort = $this->maParams["REVERSE"];

            if (strcasecmp($this->mbReverseSort, "TRUE") == 0)
                $this->mbReverseSort = true;
            else
                $this->mbReverseSort = false;
        }

        if (isset($this->maszContents))
        {
            if(isset($this->maszContents["SHAREDRESOURCE"]) && 
               is_array($this->maszContents["SHAREDRESOURCE"]))
            {
                $this->maoSharedResources = 
                    $this->maszContents["SHAREDRESOURCE"];
            }
        }

        
        // Get all templates
        if (isset($this->maszContents['TEMPLATE']) &&
            is_array( $this->maszContents['TEMPLATE'] ))
        {
            foreach ($this->maszContents['TEMPLATE'] as $oTemplate)
            {
              if (isset($oTemplate['NAME']))
              {
                  if (isset($oTemplate['CONTENT']) || isset($oTemplate['_CONTENTS']))
                  {
                    if (strcasecmp($oTemplate['NAME'], "HEADER") == 0)
                      $this->mszHeader = isset($oTemplate['CONTENT']) ? $oTemplate['CONTENT'] : $oTemplate['_CONTENTS'];
                    else
                    if (strcasecmp($oTemplate['NAME'], "BODY") == 0)
                      $this->mszBody = isset($oTemplate['CONTENT']) ? $oTemplate['CONTENT'] : $oTemplate['_CONTENTS'];
                    else
                    if (strcasecmp($oTemplate['NAME'], "FOOTER") == 0)
                      $this->mszFooter = isset($oTemplate['CONTENT']) ? $oTemplate['CONTENT'] : $oTemplate['_CONTENTS'];
                  }
                  
              }
          }
        }

        return parent::InitDefaults();
    }

    /**
     * DrawPublish
     *
     */
    function DrawPublish ()
    {

        $szContent = "";

        // Get the shared resource (one or more)
        $aSharedResource =& $this->getTableSharedResource();

        if(!is_array($aSharedResource))
        {
            return "";
        }
        
        if (count($aSharedResource) == 0)
        {
            array_push($aSharedResource, array());
        }

        $aTmp = array_values($aSharedResource);
        if (!is_array($aTmp[0]))
            $aSharedResource = array($aSharedResource);

        // Replace all collumn name in header to sort array
        foreach($aSharedResource as $aFirstRow)
        {
            foreach($aFirstRow as $szKey => $szValue)
            {
                array_push($this->maszFrom, "%$szKey%");
                array_push($this->maszTo, "<a href=\"javascript:SortBy_".$this->mszName."('$szKey')\">$szKey</a>");
                array_push($this->maszRegExFrom, "/\%$szKey(\|([^\%]*))?\%/");
                array_push($this->maszRegExTo, "<a href=\"javascript:SortBy_".$this->mszName."('$szKey')\">\\2</a>");
            }
            break;
        }

        // Check for next and previous page tag
        array_push($this->maszFrom,"%NEXT_PAGE%","%PREV_PAGE%", "%NUMPAGE%", "%CURRENTPAGE%");
        array_push($this->maszRegExFrom,"/\%NEXT_PAGE(\|([^%]*))?\%/",
                   "/\%PREV_PAGE(\|([^%]*))?\%/");
        if($this->mnCount == -1 || $this->mnStart+$this->mnCount >= count($aSharedResource))
        {
            array_push($this->maszTo, "");
            array_push($this->maszRegExTo, "");
        }
        else
        {
            array_push($this->maszTo, "<a href=\"javascript:NextPage_".$this->mszName.
                "()\">".$this->mszNextButton."</a>");
            array_push($this->maszRegExTo, "<a href=\"javascript:NextPage_".
                       $this->mszName."()\">\\2</a>");
        }
        if($this->mnStart <= 0)
        {
            array_push($this->maszTo, "");
            array_push($this->maszRegExTo, "");
        }
        else
        {
            array_push($this->maszTo, "<a href=\"javascript:PrevPage_".$this->mszName.
                "()\">".$this->mszPrevButton."</a>");
            array_push($this->maszRegExTo, "<a href=\"javascript:PrevPage_".
                       $this->mszName."()\">\\2</a>");
        }
        // Add NumPage
        if ($this->mnCount == -1)
            $nNumPage = 1;
        else
        {
            $nNumPage = intval(count($aSharedResource) / $this->mnCount);
        }
        if(count($aSharedResource) % $this->mnCount) $nNumPage++;
        array_push($this->maszTo, $nNumPage);

        // Add CurrentPage
        if ($this->mnCount == -1)
            $nCurrentPage = 1;
        else
            $nCurrentPage = intval($this->mnStart / $this->mnCount)+1;

        array_push($this->maszTo, $nCurrentPage);

        $this->mszHeader = str_replace($this->maszFrom, $this->maszTo, $this->mszHeader);
        $this->mszFooter = str_replace($this->maszFrom, $this->maszTo, $this->mszFooter); 
        $this->mszHeader = preg_replace($this->maszRegExFrom, $this->maszRegExTo, $this->mszHeader);
        $this->mszFooter = preg_replace($this->maszRegExFrom, $this->maszRegExTo, $this->mszFooter);

        // Set header
        $szContent = "";

        // Initialize a shared resource of what the table will display.
        $this->maSharedResourceWidgets[$this->mszSharedResourceName."_IMAGE"] = array();

        if ($this->mnCount == -1)
            $nTmpCount = count($aSharedResource);
        else
            $nTmpCount = $this->mnCount;

        // Parse Shared resource
        for ($j=$this->mnStart; $j<$this->mnStart+$nTmpCount;$j++)
        {
            if (!isset($aSharedResource[$j]) || count($aSharedResource[$j]) == 0)
                break;

            $this->maSharedResourceWidgets[$this->mszSharedResourceName."_IMAGE"][$j+1] = $aSharedResource[$j];

            $szContent .= $this->processRow($j, $aSharedResource[$j]);   
        }

        if($szContent != "")
            $szContent = $this->mszHeader.$szContent.$this->mszFooter;

        return parent::DrawPublish() . $szContent;
    }

    function processRow($nIndex, $aszColumns)
    {
        // Run defined function on value in Table
        array_push($this->maCallbackRegEx, "/\%URL(\|([^%]*))?\%/" );
        array_push($this->maFunction, create_function('$matches', 'return urlencode($matches[2]);') );

        $szTmpBody = $this->mszBody;

        $szTmpBody = str_replace("%INDEX%", $nIndex+1, $szTmpBody);

        foreach($aszColumns as $szKey => $szCol) 
            $szTmpBody = str_replace("%$szKey%", $szCol, $szTmpBody);
  
        $szTmpBody = $this->processIf($szTmpBody);

        $szTmpBody = str_replace($this->maszBodyFrom, $this->maszBodyTo, $szTmpBody);
        $szTmpBody = preg_replace($this->maszBodyRegExFrom, $this->maszBodyRegExTo, $szTmpBody);

        $nCallback = count($this->maCallbackRegEx);
        for ($i=0;$i<$nCallback;$i++)
            $szTmpBody = preg_replace_callback($this->maCallbackRegEx[$i], $this->maFunction[$i], $szTmpBody);
            
        return $szTmpBody;
    }

    function processIf($szContent)
    {
        // Find position of the last if
        $szContent = str_replace("\"", "&quot;", $szContent);

        $nPosIf1 = $this->strlastpos($szContent, "\$if");

        while ($nPosIf1 !== false)
        {
            $nPosIf2 = strpos($szContent, "\$", $nPosIf1+1);

            $nPosIf3 = strpos($szContent, "\$endif\$", $nPosIf1);

            $aszCondition = explode(" ", trim(substr($szContent, $nPosIf1+4, $nPosIf2-$nPosIf1-4)));

            $szOper = "";
            $aszValue = array();

            // Find operator and value
            $nEle = count($aszCondition);
            for($i=0;$i<$nEle;$i++)
            {
                if (strcasecmp(substr($aszCondition[$i], 0, 5), "OPER=") == 0)
                {
                    $aOper = explode("=", $aszCondition[$i]);
                    $szOper = strtoupper($aOper[1]);
                }
                else
                if (strcasecmp(substr($aszCondition[$i], 0, 6), "&quot;") == 0)
                {   
                    // Get string bu strip the 6 first chars
                    $szValue = substr($aszCondition[$i], 6);

                    // If the string value don't have any space
                    if (substr($szValue, -6) == "&quot;") 
                        $szValue = substr($szValue, 0, -6);
                    else
                    {
                        // Loop thought all element until find the final &quot;
                        for ($j=$i+1;$j<$nEle;$j++)
                        {
                            if (substr($aszCondition[$j], -6) == "&quot;")
                            {
                                $szValue .= " ".substr($aszCondition[$j], 0, -6);
                                $i = $j;

                                break;
                            }

                            $szValue .= " ".$aszCondition[$j];
                        }
                    }
                    array_push($aszValue, $szValue);
                }
                else
                    array_push($aszValue, $aszCondition[$i]);
            }

            if (substr($szOper, 0, 1) == "I")
            {
                $aszValue[0] = strtoupper($aszValue[0]);
                $aszValue[1] = strtoupper($aszValue[1]);
            }

            switch ($szOper)
            {
                case "IEQ":
                case "EQ" : if (count($aszValue) == 2) $ret = (($aszValue[0] == $aszValue[1]) ? 1 : 0); else $ret = -1; break;
                case "INE":
                case "NE" : if (count($aszValue) == 2) $ret = (($aszValue[0] != $aszValue[1]) ? 1 : 0); else $ret = -1; break;
                case "IGR":
                case "GR" : if (count($aszValue) == 2) $ret = (($aszValue[0] >  $aszValue[1]) ? 1 : 0); else $ret = -1; break;
                case "ILE":
                case "LE" : if (count($aszValue) == 2) $ret = (($aszValue[0] <  $aszValue[1]) ? 1 : 0); else $ret = -1; break;
                case "IGRE":
                case "GRE": if (count($aszValue) == 2) $ret = (($aszValue[0] >= $aszValue[1]) ? 1 : 0); else $ret = -1; break;
                case "ILEE":
                case "LEE": if (count($aszValue) == 2) $ret = (($aszValue[0] <= $aszValue[1]) ? 1 : 0); else $ret = -1; break;
                default : $ret = -1;
            }

            if ($ret == 1) // condition returned true
            {
                $szContent = str_replace(substr($szContent, $nPosIf1, $nPosIf3+7-$nPosIf1), 
                                         substr($szContent, $nPosIf2+1, $nPosIf3-$nPosIf2-1), $szContent);
            }
            else
            if ($ret == 0) // condition returned false
            {
                $szContent = str_replace(substr($szContent, $nPosIf1, $nPosIf3+7-$nPosIf1), "", $szContent);
            }
            else // Something goes wrong.
            {
                $szContent = str_replace(substr($szContent, $nPosIf1, $nPosIf3+7-$nPosIf1), 
                                         "<font color=red>[".str_replace("\$" ," ", 
                                         htmlentities(substr($szContent, $nPosIf1, $nPosIf3+7-$nPosIf1)))."]</font><br>", $szContent);
            }

            $nPosIf1 = $this->strlastpos($szContent, "\$if");
        }

        $szContent = str_replace("&quot;", "\"", $szContent);

        return $szContent;
    }

    /**
     * return javascript functions required for this widget
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $szJsFunctionName = "SortBy_".$this->mszName;
        $szFunction = <<<EOT
/**
 * set the active collumn to sortby
 */
function {$szJsFunctionName}(sCol)
{
    {$this->mszHTMLForm}.SORTBY_{$this->mszName}.value = sCol;
    {$this->mszHTMLForm}.submit();
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "NextPage_".$this->mszName;
        $szFunction = <<<EOT
/**
 * Show Next page
 */
function {$szJsFunctionName}(sCol)
{
    var nTot = parseInt({$this->mnStart}) + parseInt({$this->mnCount});
    {$this->mszHTMLForm}.START_{$this->mszName}.value = nTot;

    {$this->mszHTMLForm}.submit();
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;


        $szJsFunctionName = "PrevPage_".$this->mszName;
        $szFunction = <<<EOT
/**
 * Show previous page
 */
function {$szJsFunctionName}(sCol)
{
    var nTot = parseInt({$this->mnStart}) - parseInt({$this->mnCount});

    {$this->mszHTMLForm}.START_{$this->mszName}.value = nTot;

    if ({$this->mszHTMLForm}.START_{$this->mszName}.value < 0)
        {$this->mszHTMLForm}.START_{$this->mszName}.value = 0;

    {$this->mszHTMLForm}.submit();
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;



        return $aReturn;
    }

    /**
     * handle the user using this tool as part of a toolset
     */
    function  ParseURL()
    {
        if ($this->isVarSet( "SORTBY_".strtoupper($this->mszName) ))
            $this->mszSortBy = $this->getVar( "SORTBY_".strtoupper($this->mszName) );

        if ($this->isVarSet( "START_".strtoupper($this->mszName) ))
            $this->mnStart = $this->getVar( "START_".strtoupper($this->mszName) );

        if ($this->isVarSet( "COUNT_".strtoupper($this->mszName) ))
            $this->mnCount = $this->getVar( "COUNT_".strtoupper($this->mszName) );

        return parent::ParseURL();
    }

    /**
     * return hidden variables required for this tool
     */
    function GetHTMLHiddenVariables()
    {
          $szVariable = "SORTBY_".$this->mszName;
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$this->mszSortBy."\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "START_".$this->mszName;
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$this->mnStart."\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "COUNT_".$this->mszName;
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$this->mnCount."\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "REVERSE_".$this->mszName;
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".(($this->mbReverseSort) ? "TRUE": "FALSE")."\">";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }


    function strlastpos($haystack, $needle)
    {
        // flip both strings around and search, then adjust position based on string lengths
        if (strpos(strrev($haystack), strrev($needle)) !== false)
            return strlen($haystack) - strlen($needle) - strpos(strrev($haystack), strrev($needle));
        else
            return false;
    }

    function getTableSharedResource()
    {
        if(count($this->maoSharedResources) > 0)
        {
            return $this->getMultipleSharedResource();
        }

        if (strpos($this->mszSharedResourceName,".") !== false)
            $aPath = explode(".", $this->mszSharedResourceName);
        else
            $aPath = array($this->mszSharedResourceName);

        if(isset($this->maSharedResourceWidgets[$aPath[0]]))
        {
            $aSharedResource = $this->maSharedResourceWidgets[$aPath[0]];

            $bInSRWidget = false;
            // Check if the Shared resource is a widget
            if (isset($aSharedResource->mszWidgetName) && 
                $aSharedResource->mszWidgetName == "SharedResource")
            {
                $bInSRWidget = true;
                $aSharedResource = $aSharedResource->maszContents;
            }

            for($i=1;$i<count($aPath); $i++)
            {
                if ($bInSRWidget)
                    $aSharedResource = $aSharedResource[strtoupper($aPath[$i])];
                else
                    $aSharedResource = $aSharedResource[$aPath[$i]];
            }

            // If sortby is set, then sort the table
            if ($this->mszSortBy != "")
                usort($aSharedResource, array($this, "SortBy"));                

            return $aSharedResource;
        }

        return "";
    }

    function getMultipleSharedResource()
    {
        // Get all the SR
        $numSR = 0;
        $aSRArray = array();
        $aSRDesc = array();
        $aSRStart = array();
        $aSRCount = array();
        $numSR = count($this->maoSharedResources);
        for($i=0; $i<$numSR; $i++)
        {
            $oSRDesc =& $this->maoSharedResources[$i];
            if(!isset($oSRDesc["SRNAME"]) || !$oSRDesc["SRNAME"] != "" || 
               !isset($this->maSharedResourceWidgets[$oSRDesc["SRNAME"]]))
                continue;

            // process the condition or use the entire array
            if(isset($oSRDesc["CONDITION"]) && $oSRDesc["CONDITION"] != "")
                $oSR =& $this->processArrayCondition(
                            $this->maSharedResourceWidgets[$oSRDesc["SRNAME"]],
                            $oSRDesc["CONDITION"]);
            else
                $oSR = $this->maSharedResourceWidgets[$oSRDesc["SRNAME"]];

            // Make sure that the new SR has at least one row
            if(count($oSR) <= 0)
                continue;

            // If sortby is set, then sort the table
            if (isset($oSRDesc["SORTBY"]) && $oSRDesc["SORTBY"] != "")
            {
                $szSortBy = $this->mszSortBy;
                $this->mszSortBy = $oSRDesc["SORTBY"];
                usort($oSR, array($this, "SortBy"));
                $this->mszSortBy = $szSortBy;
            }

            // if there's a limit, get it.
            $nLimit = -1;
            $nStart = -1;
            if(isset($oSRDesc["LIMIT"]) && is_numeric($oSRDesc["LIMIT"]))
                $nLimit = $oSRDesc["LIMIT"];
            if(isset($oSRDesc["START"]) && is_numeric($oSRDesc["START"]))
                $nStart = $oSRDesc["START"];
            if($nLimit > -1 || $nStart > -1)
            {
                if($nLimit == -1)
                    $nLimit = count($oSR);
                if($nStart == -1)
                    $nStart = 0;

                $oSR =& array_slice($oSR, $nStart, $nLimit);
            }

            // If postsortby is set, then resort the table
            if (isset($oSRDesc["POSTSORTBY"]) && $oSRDesc["POSTSORTBY"] != "")
            {
                $szSortBy = $this->mszSortBy;
                $this->mszSortBy = $oSRDesc["POSTSORTBY"];
                usort($oSR, array($this, "SortBy"));
                $this->mszSortBy = $szSortBy;
            }

            // Put the new SR in the SR array
            array_push($aSRArray, $oSR);
            array_push($aSRDesc, $oSRDesc);
            array_push($aSRStart, 0);
            array_push($aSRCount, count($oSR));
        }

        $aSharedResource = array();
        $numSREoa = 0;
        $numSR = count($aSRArray);
        while($numSREoa < $numSR)
        {
            $aSRPage = array();
            for($i=0; $i<$numSR; $i++)
            {
                if($aSRStart[$i] == -1)
                {
                    continue;
                }

                // Get the count
                if ($this->mnCount == -1)
                    $nCount = count($aSRArray[$i]);
                else
                    $nCount = $this->mnCount - count($aSRPage);

                if(isset($aSRDesc[$i]["COUNT"]) && 
                   is_numeric($aSRDesc[$i]["COUNT"]))
                    $nCount = ($nCount <= $aSRDesc[$i]["COUNT"])? $nCount : 
                                                       $aSRDesc[$i]["COUNT"];

                for($j=0; $j<$nCount; $j++)
                {
                    if(($aSRStart[$i]+$j) >= $aSRCount[$i])
                    {
                        $j = 0;
                        $aSRStart[$i] = -1;
                        $numSREoa++;
                        break;
                    }
                    array_push($aSRPage, $aSRArray[$i][($aSRStart[$i]+$j)]);

                    if($this->mnCount != -1 && count($aSRPage) == $this->mnCount)
                    {
                        $j++;
                        break;
                    }
                }
                $aSRStart[$i] += $j;

                if($this->mnCount != -1 && count($aSRPage) == $this->mnCount)
                    break;
            }

            // Sort the page
            if ($this->mszSortBy != "")
            {
                usort($aSRPage, array($this, "SortBy"));
            }
            $aSharedResource=array_merge_recursive($aSharedResource, $aSRPage);
        }

        return $aSharedResource;
    }

    function processArrayCondition($aArray, $szCondition)
    {
        $aOutArray = array();
        $numRow = count($aArray);
        $aszKey = array_keys($aArray);

        for($i=0; $i<$numRow; $i++)
        {
            $szCondition = str_replace("&quot;", "\"", $szCondition);

            $bResult = false;
            $nCnt = count($aArray[$aszKey[$i]]);
            $aszKeys = array_keys($aArray[$aszKey[$i]]);
            $szExp = $szCondition;
            if(strpos($szExp, "%") !== false)
            {
                for($j=0;$j<$nCnt;$j++)
                {
                    $szExp = str_replace("\"%".$aszKeys[$j]."%\"", 
                                         "\"".$aArray[$aszKey[$i]]
                                         [$aszKeys[$j]]."\"", 
                                         $szExp);
                    $szExp = str_replace("%".$aszKeys[$j]."%", 
                                         "\"".$aArray[$aszKey[$i]]
                                         [$aszKeys[$j]]."\"", 
                                         $szExp);
                }
            }

            if(evaluateExpression($szExp))
                array_push($aOutArray, $aArray[$aszKey[$i]]);
        }

        return $aOutArray;
    }
}
?>
