<?php
/**
 * SessionExpired Widget class
 *
 * @project     CWC2
 * @revision    $Id: 
 * @purpose     SessionExpired Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");

/**
 * SessionExpiredWidget
 *
 * @desc Widget That redirect to a template or a URL or display a text
 *       if session expire.
 */
class SessionExpired extends CWCWidget
{
    var $mszErrorMsg = "";

    /**
     * SessionExpiredWidget
     *
     * Constructor method for the SessionExpired widget.
     */
    function SessionExpired()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
SessionExpiredWidget is a simple widget that simply redirect to a template or a URL or display a text if session expire.
EOT;
        $this->maAttributes["URL"] = 
                 new StringAttribute( "URL", false );

        $this->maAttributes["TEMPLATE"] = 
                 new StringAttribute( "TEMPLATE", false );

        $this->maAttributes["TEXT"] = 
                 new StringAttribute( "TEXT", false );
    }

    function ParseURL()
    {
        parent::ParseURL();

        if (!$this->moApp->mbSessionOK)
        {
            if (isset($this->maParams['URL']))
            {
                header("Location: ".$this->maParams['URL']);
            }
            else
            if (isset($this->maParams['TEMPLATE']))
            {
                // Make sure tu use a valid session
                $this->setVar( 'sid', session_id());
                $this->moApp->mbSessionOK = true;

                $this->moApp->CWCSetTemplate($this->maParams['TEMPLATE']);
                
                return false;
            }
            else
            if (isset($this->maParams['TEXT']))
            {
                $this->mszErrorMsg = $this->maParams['TEXT'];
                  
                return false;
            }
        }

        return true;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        return $this->mszErrorMsg;
    }
}
?>
