<?php
/**
 * SECTPopup Widget Class
 *
 * @project     CWC2
 * @revision    $Id: SECTPopup.widget.php,v 1.4 2004/07/08 17:49:08 pspencer Exp $
 * @purpose     Display the sect tool to classify a layer
 * @author      DM Solutions Group (zjames dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * SECTPopup
 *
 * @desc Display the classification tool in a popup window.
 */
class SECTPopup extends CWCWidget
{
    var $moLabel;
    var $moButton;
    var $moPopup;

    /**
     * SECTPopup
     *
     * Constctor method for the SECTPopup
     */
    function SECTPopup()
    {
        parent::CWCWidget();

        $this->moLabel = new CWCLabel( $this );

        $this->moButton = new CWCButton( $this );

        $this->moPopup = new CWCPopup( $this );
        
        //optional relative path to studio install
        //defaults to use parallel install
        $this->maAttributes["STUDIOPATH"] = new StringAttribute( "STUDIOPATH", false );
        $this->maAttributes["STUDIOURL"] = new StringAttribute( "STUDIOURL", false );

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The SECTPopupWidget displays the SECT tool that allows the user
to classify a layer selected by the LayerSelectionWidget
EOT;

    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('Classify');
        $this->mszStudioPath = $_SESSION["gszCorePath"]."../../studio";
        if (isset($this->maParams["STUDIOPATH"]))
        {
           $this->mszStudioPath = $this->maParams["STUDIOPATH"];
        }
        $_SESSION['STUDIOPATH'] = $this->mszStudioPath;
        
        $this->mszStudioWebPath = "/studio/";
        if (isset($this->maParams["STUDIOURL"]))
        {
           $this->mszStudioWebPath = $this->maParams["STUDIOURL"];
        }
        //use the application font file or sect's internal font file if
        //there isn't one.
        if (!($this->moMapObject->oMap->fontsetfilename == ''))
        {
            //figure out the actual font file path
            $szFontFile = $this->moMapObject->oMap->fontsetfilename;
            if (substr($szFontFile, 0, 1) != "/" && substr($szFontFile, 1, 1) != ":")
            {
                if (substr($_SESSION['gszMapPath'], -1) != "/" && 
                    substr($_SESSION['gszMapPath'], -1) != "\\")
                {
                    $sep = "/";
                }
                else
                {
                    $sep = "";
                }
                $szFontFile = realpath( $_SESSION['gszMapPath'].$sep.$szFontFile );
            }
            else
            {
                $szFontFile = realpath( $szFontFile );
            }
           $_SESSION['gszFontFile'] = $szFontFile;
        }
        else
        {
           $_SESSION['gszFontFile'] = $this->mszStudioPath . '/etc/sectfonts.txt';
           $this->moMapObject->oMap->setfontset($_SESSION['gszFontFile']);
        }
    }


    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    /**
     * GetJavascriptFunctions
     *
     * Return the Javacriptfunctions needed by the widget.
     *
     * @return Javacriptfunctions needed by the widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $aReturn = $this->moButton->GetJavascriptFunctions();//array();
//        $this->moPopup->mszLink = "widgets/SECTPopup.phtml";
        $szButtonJS = $this->moPopup->DrawPublish();

        $szStudioURL = $this->mszStudioWebPath;
        $szSID = SID;
        
        //Launch SECT
        $szJsFunctionName = "Classify";
        $szFunction = <<<EOT
function {$szJsFunctionName}()
{
     if (document.forms[0].SELECTED_LAYERS == null ||
         document.forms[0].SELECTED_LAYERS.value == null ||
         document.forms[0].SELECTED_LAYERS.value == "" )
     {
         alert( "no layer selected!" );
         return;
     }
    
     var szTemplate = "&template=sect_classifier_template.html";
     var szLayer = "&initlayername=" + document.forms[0].SELECTED_LAYERS.value;
     var szCallback = "&szCallback=SECTCallback";
     var szURL = "{$szStudioURL}index.phtml?{$szSID}";
     szURL = szURL + szTemplate + szLayer + szCallback;
//     alert( szURL );
     wh = window.open(szURL, 'SECT', 'scrollbars=yes,resizable=yes,location=no,width=720,height=640');
     wh.focus();
}

EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        //SECT callback
        $szJsFunctionName = "SECTCallback";
        $szFunction = <<<EOT
function {$szJsFunctionName}( actionId, wh )
{
    if ( actionId == 0) //Clicked OK
    {
      wh.close();
    }
    else
    if ( actionId == 1) // cancel
    {
      if (!wh.closed)
          wh.close();
    }
    else if (actionId == 2) //apply
    {
      document.forms[0].SLD_TABLE_COMMAND.value = 'RETURN';
      document.forms[0].submit();
    }
    return;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    /**
     * GetHTMLHiddenVariables
     *
     * return the NAV_CMD varaiable.
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();

        $szVariable = 'SLD_TABLE_COMMAND';
        $aReturn[$szVariable] = '<INPUT TYPE="HIDDEN" NAME="'.$szVariable. '" VALUE="">';

        return $aReturn;
    }

    /**
     * return the current layer to the mapsession
     */
    function ReturnLayer()
    {
        $oSrcLayer = $this->moSLDSession->oMap->getLayer( 0 );
        if ($oSrcLayer == null)
        {
            echo "ERROR: source layer not set in ReturnLayer<BR>";
            return false;
        }

        $oDstLayer = $this->moMapObject->oMap->getLayerByName( $this->getVar( 'SELECTED_LAYERS' ) );
        if ($oDstLayer == null)
        {
            echo "ERROR: destination layer not set in ReturnLayer<BR>";
            return false;
        }
        
        //remove existing classes
        for( $i=0; $i<$oDstLayer->numclasses; $i++)
        {
            $oClass = $oDstLayer->getClass( $i );
            $oClass->set( "status",  MS_DELETE );
        }
        
        //copy over classes from the local mapsession layer
        for ($i=0; $i<$oSrcLayer->numclasses; $i++)
        {
            $oSrcClass = $oSrcLayer->getClass( $i );
            $oDstClass = ms_newClassObj( $oDstLayer, $oSrcClass );
        }
        
        //copy classitem, labelitem, layer type

        if ((strlen($oSrcLayer->classitem) > 0) &&
            ($oSrcLayer->classitem != "")&&
            ($oSrcLayer->classitem != NULL))
        {
            $oDstLayer->set( 'classitem', $oSrcLayer->classitem );
        }
        else 
        {
            $oDstLayer->set( 'classitem', NULL );
        }
        if ((strlen($oSrcLayer->labelitem) > 0) &&
            ($oSrcLayer->labelitem != "") &&
            ($oSrcLayer->labelitem != NULL))
        {
            $oDstLayer->set( 'labelitem', $oSrcLayer->labelitem );
        }
        else
        {
            $oDstLayer->set( 'labelitem', NULL );
        }
        $oDstLayer->set( 'type', $oSrcLayer->type );
        $oDstLayer->setMetaData( 'wms_sld_body', 'auto' );

        $this->moMapObject->saveState();        
//        $this->mbUpdateOpener = true;
//        $this->mbDirty = false;
        
        return true;
    }
    /**
     * ParseURL
     *
     * Look for the COMPASS_POINT command and if found, recenter
     * the image in the appropriate direction.
     * according to the other NAV paramaters.
     */
    function  ParseURL()
    {
        if ($this->isVarSet( 'SLD_TABLE_COMMAND' ))
        {
            if ($this->getVar( 'SLD_TABLE_COMMAND' ) == 'RETURN')
            {
                $this->mszSLDMapFile = getSessionSavePath()."/SLDCache".$this->mnId.".map";
                    
                $oMap = ms_newMapObj( "" );
                $oMap->set( 'width', 1 );
                $oMap->set( 'height', 1 );
                $oMap->extent->setextent( -1, -1, 1, 1 );
                //this shouldn't be needed, assefa to fix a bug related to this
                //$oMap->setsymbolset( realpath($GLOBALS['gszAppPath']."/../etc/sectsym.sym"));
                $this->moSLDSession = new MapSession_RW();
                $this->moSLDSession->szMapFile = $this->mszSLDMapFile;
                $this->moSLDSession->szTempDir = getSessionSavePath();
                $this->moSLDSession->oMap = $oMap;
                
                if (isset($_SESSION['SLDCACHESTATE']) && $_SESSION['SLDCACHESTATE'] != "" )
                {
                    $this->moSLDSession->restoreState( $_SESSION['SLDCACHESTATE'], $this->mszSLDMapFile );
                }

                $this->ReturnLayer();
            }
        }
        
        // return success
        return true;
    }


    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- SECT popup widget hidden -->";

        $szResult = $this->moButton->DrawPublish();

        return $szResult;
    }
}
?>
