<?php
/**
 * Ruler result Widget class
 *
 * @project     CWC2
 * @revision    $Id: RulerResult.widget.php,v 1.4 2004/07/08 15:58:58 pspencer Exp $
 * @purpose     Ruler result Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * RulerResult
 *
 * @desc RulerResult widget.
 *       Creates a text input field REULER_RESULT. This field will be
 *       used by the Ruler widget to display the value. If this field
 *       is not available the window.status will be used.
 */
class RulerResult extends CWCWidget
{
    var $moLabel;
    var $mnDefaultTextFieldSize = 20;
    var $mszClass = "CWCRulerResultWidgetClass";
    var $mszStyle = "";

    function RulerResult()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The RulerResults widget allows the results of the users distance measurements
to be displayed in a stylable HTML INPUT box.
EOT;

        $this->moLabel = new CWCLabel( $this );
        $this->maAttributes["WIDGETCLASS"] = new StringAttribute( "WIDGETCLASS", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );
        $this->maAttributes["TEXTFIELDSIZE"] = new IntegerAttribute( "TEXTFIELDSIZE", false, 0 );
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["WIDGETCLASS"]))
            $this->mszClass = strtoupper($this->maParams["WIDGETCLASS"]);
        if (isset($this->maParams["WIDGETSTYLE"]))
            $this->mszStyle = strtoupper($this->maParams["WIDGETSTYLE"]);
        if (isset($this->maParams["TEXTFIELDSIZE"]))
            $this->mnDefaultTextFieldSize = strtoupper($this->maParams["TEXTFIELDSIZE"]);
    }


    /**
     * DrawPublish.
     */
    function DrawPublish()
    {
        $nSize = $this->mnDefaultTextFieldSize;
        if (isset($this->maParams["TextFieldSize"]))
            $nSize = strtoupper($this->maParams["TextFieldSize"]);

        $szClass = "";
        if ( strlen($this->mszClass) > 0 )
            $szClass = " CLASS=\"$this->mszClass\"";
        $szStyle = "";
        if ( strlen($this->mszStyle) > 0 )
            $szStyle = " STYLE=\"$this->mszStyle\"";

        $szContents="<input$szClass$szStyle type=\"text\" name=\"RULER_RESULT\" value=\"\"  size=\"$nSize\" readonly>";

        return $this->moLabel->DrawPublish( $szContents );

    }
}
?>

