<?php
/**
 * ROIMode (region of interest) Widget class
 *
 * @project     CWC2
 * @revision    $Id: ROIMode.widget.php,v 1.2 2004/04/24 21:59:19 pspencer Exp $
 * @purpose     Makes navtools work differently - select area before tool select.
 * @author      DM Solutions Group (zjames@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2003, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../NavTool.php");

/**
 * ROIMode Widget
 *
 * @desc Makes navtools work differently - select area before tool select
 */
class ROIMode extends NavTool
{
    /**
     * ROI
     *
     * Constructor method for the ROI widget.
     */
    function ROIMode()
    {
        // invoke constructor of parent
        parent::NavTool();

        $this->NavTool();
        $this->SetNavCommand("ROI_MODE");
        $this->mnAllowRectangle = 1;

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ROIMode (region of interest) widget is an invisible widget that changes
the operation mode of various navtools widgets. When it is present, the user
first drags in the map to create a selection and then picks a tool to operate
on that region.
EOT;

        unset($this->maAttributes["IMAGESELECTED"]);
        unset($this->maAttributes["IMAGEHOVER"]);
        unset($this->maAttributes["IMAGE"]);
        unset($this->maAttributes["IMAGEWIDTH"]);
        unset($this->maAttributes["IMAGEHEIGHT"]);
        unset($this->maAttributes["IMAGETIP"]);
        unset($this->maAttributes["IMAGECLASS"]);
        unset($this->maAttributes["IMAGESTYLE"]);
        }

    function InitDefaults()
    {
        parent::InitDefaults();
        $this->maAttributes["DEFAULT"] = new BooleanAttribute( "DEFAULT", true );

        $this->submitOnClick = 0;
    }

    /**
     * Get JavascriptVariables
     *
     * Return the header javascript
     */
    function GetHTMLHiddenVariables()
    {
        //parent::GetJavascriptVariables();

        $aReturn = $this->moButton->GetHTMLHiddenVariables();
               
        $szVariableName = "ROI_MODE";
        $szVariable = "<INPUT TYPE=HIDDEN NAME=\"$szVariableName\" VALUE=\"".$this->mnId."\">";
        $aReturn[$szVariableName] = $szVariable;

        return $aReturn;
    }

    /**
     * Set as default tool on load
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();

        //if this tool is present, it is always the default
        $szJsFunctionName = "setCurrentTool";
        $szFunction = "$szJsFunctionName( ".$this->mnId." );\n";
        $szFunction .= "NavSetActiveTool( ".$this->mnId.", \"".$this->mszCmd."\", ".$this->mnAllowRectangle." );\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * draw the link widget
     */
    function DrawPublish()
    {
      $szReturn = "<!--ROIMode widget -->";
      return $szReturn;
    }
}
?>