<?php
/**
 * ROIManagerMode Widget class
 *
 * @project     CWC2
 * @revision    $Id: ROIManagerMode.widget.php,v 1.3 2004/04/26 19:59:01 wbronsema Exp $
 * @purpose     ROI Manager Mode setter class.  Allows the user to set the
 *              the current mode of the ROI manager.
 *
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * ROIManagerMode
 *
 * @desc A widget to remove the last ROI added to the ROI manager.
 */
class ROIManagerMode extends CWCWidget
{
    /* the button that is the interface for this widget */
    var $moButton;
    
    /* the mode to set the manager to */
    var $mnMode = 0;
    
    /**
     * construct a new ROI Removal Tool widget
     */
    function ROIManagerMode()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ROIManagerMode widget allows the user to set the current mode
of the ROI Manager.
EOT;
        $this->moButton = new CWCButton( $this );
        $this->maAttributes['MODE'] = new StringAttribute( 'MODE', false );
    }
    
    /**
     * initialize the widget.
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        
        $this->moButton->InitDefaults();
        
        if (isset($this->maParams['MODE']))
        {
            if (strcasecmp($this->maParams['MODE'], 'normal') == 0)
            {
                $this->mnMode = 1;
            }
            elseif (strcasecmp($this->maParams['MODE'], 'add') == 0)
            {
                $this->mnMode = 2;
            }
            elseif (strcasecmp($this->maParams['MODE'], 'subtract') == 0)
            {
                $this->mnMode = 3;
            }
        }
        $this->moButton->SetOnClick('CWCROIManagerModeSet', $this->mnMode);

    }
    
    function ParseURL()
    {
        return $this->moButton->ParseURL();
    }
    
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        
        $szName = 'CWCROIManagerModeSet';
        $szFunction = <<<EOT
function {$szName}( oButton, xValues )
{
    goCWCROIManager.SetMode( xValues );
}    
EOT;
        $aReturn[$szName] = $szFunction;
        
        return $aReturn;
    }
    
    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();

        return $aReturn;
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        return $aReturn;
    }

    /**
     * draw this widg5et on the page
     */
    function DrawPublish()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if (!$this->mbVisible)
            return "<!-- ROIManagerMode hidden -->";

        
        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
?>
