<?php
/**
 * Print widget
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     This page contains supporting php functions for the production
 *              page.
 * @author      William A. Bronsema, C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2001, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: production.inc.php,v $
 * Revision 1.2  2004/04/28 13:43:14  pspencer
 * fix file path related issues
 *
 * Revision 1.1  2004/04/23 16:51:44  pspencer
 * moved production.inc.php to PrintWidget/production.inc.php
 *
 * Revision 1.14  2004/02/25 20:25:07  sfournier
 * Change installer and make sure COMMON and WEBCOMMON is used everiwhere
 *
 * Revision 1.13  2003/10/27 20:46:19  sfournier
 * Overwrite main branch with 1.1 stuff
 *
 * Revision 1.10.2.1  2003/10/15 21:04:57  pspencer
 * fixes to work with Chameleon 1.1
 *
 * Revision 1.10  2003/04/08 20:09:58  sacha
 * Fixed few bug related to print
 *
 * Revision 1.9  2003/01/30 13:49:58  sacha
 * Changed the session management
 *
 * Revision 1.8  2003/01/07 20:25:08  bronsema
 * Updated function header comments to the doxygen style
 *
 * Revision 1.7  2003/01/07 20:04:20  bronsema
 * Included serveral misc settings
 *
 * Revision 1.6  2003/01/07 18:33:45  bronsema
 * Added legend
 *
 * Revision 1.5  2003/01/03 18:51:01  bronsema
 * Moved the download file capabiltiy to the production page.
 *
 * Revision 1.4  2002/12/13 19:42:19  bronsema
 * Updated the print and production dialogs to new style.  Fixed neat line.
 *
 * Revision 1.3  2002/11/28 18:29:19  sacha
 * Fixed path
 *
 * Revision 1.2  2002/11/28 04:14:33  pspencer
 * removed code that caused notices
 *
 * Revision 1.1  2002/11/21 00:46:00  sacha
 * added print widget
 *
 * Revision 1.15  2002/08/12 20:26:18  bronsema
 * Added delayed drawing functionality to map production.
 *
 * Revision 1.14  2002/07/22 18:57:23  bronsema
 * Fixed bug with displaying footer
 *
 * Revision 1.13  2002/07/11 19:23:28  bronsema
 * Updated layout
 *
 * Revision 1.12  2002/07/11 16:07:48  bronsema
 * Added ability to turn margins on and off
 *
 * Revision 1.11  2002/07/11 15:11:07  bronsema
 * Updated the production page to default to the map widht and height.
 *
 * Revision 1.10  2002/07/11 14:37:41  bronsema
 * Fixed projection issue in map production
 *
 * Revision 1.9  2002/07/10 03:34:56  bronsema
 * Updated to handle invalid characters
 *
 * Revision 1.8  2002/07/10 00:39:15  bronsema
 * Fixed foot note alignment problem
 *
 * Revision 1.7  2002/07/09 14:37:30  bronsema
 * Added new print icon
 *
 * Revision 1.6  2002/07/09 14:10:19  bronsema
 * Added north arrow symbols
 *
 * Revision 1.5  2002/07/05 02:22:46  bronsema
 * Removed dependancy on register_globals setting to be on.
 *
 * Revision 1.4  2002/06/27 02:19:10  bronsema
 * Finished translation
 *
 * Revision 1.3  2002/06/26 03:24:03  bronsema
 * Added map production
 *
 * Revision 1.2  2002/06/26 00:02:50  bronsema
 * Under construction
 *
 * Revision 1.1  2002/06/25 13:15:39  bronsema
 * Initial creation
 *****************************************************************************/

define("LOAD_MAPSESSION", 1);

include("../session.inc.php");

// give lots of time to draw the map
set_time_limit( 300 );

$nWidth   = isset( $http_form_vars["MapWidth"] )     
                                            ? $http_form_vars["MapWidth"] : 400;
$nHeight  = isset( $http_form_vars["MapHeight"] )    
                                           ? $http_form_vars["MapHeight"] : 400;
$bShowPreview = isset( $http_form_vars["bShowPreview"] ) 
                                          ? $http_form_vars["bShowPreview"] : 0;
$bShowDownload = isset( $http_form_vars["bShowDownload"] ) 
                                         ? $http_form_vars["bShowDownload"] : 0;
                                         
//figure out the font file path
$szFontFile = $oMapSession->oMap->fontsetfilename;
if (substr($szFontFile, 0, 1) != "/" && substr($szFontFile, 1, 1) != ":")
{
    if (substr($_SESSION['gszMapPath'], -1) != "/" && 
        substr($_SESSION['gszMapPath'], -1) != "\\")
    {
        $sep = "/";
    }
    else
    {
        $sep = "";
    }
    $szFontFile = realpath( $_SESSION['gszMapPath'].$sep.$szFontFile );
}
else
{
    $szFontFile = realpath( $szFontFile );
}
$szFontDir = dirname( $szFontFile );
$aFontList = file( $szFontFile );
$aFonts = array();
foreach($aFontList as $szFontEntry)
{
    $nSep = strpos($szFontEntry, " ");
    $szFont = trim(substr($szFontEntry, 0, $nSep ));
    $szFontTTF = trim(substr($szFontEntry, $nSep ));
    $aFonts[$szFont] = $szFontTTF;
}                                         

/* ============================================================================
 * check if the session production text file exists else create one
 * ========================================================================= */
checkSettingsFile( $_SESSION['gszTmpPath'].$http_form_vars['sid'].".txt",
                    $nWidth, $nHeight );

/* ============================================================================
 * Process settings etc.
 * ========================================================================= */
if ( $bShowPreview == 1 || $bShowDownload == 1 )
{
    // update the settings file
    updateSettingsFile( $_SESSION['gszTmpPath'].$http_form_vars['sid'].".txt",
                                                            $http_form_vars );
}
// include the settings file
include( $_SESSION['gszTmpPath'].$http_form_vars['sid'].".txt" );


$txtWidthPix = isset( $http_form_vars["MapWidth"] )
                            ? $http_form_vars["MapWidth"] : $txtWidthPix;
$txtHeightPix= isset( $http_form_vars["MapHeight"] )
                            ? $http_form_vars["MapHeight"] : $txtHeightPix;
                            

/**
 * Postcondition: This function checks to see if the settings file exists and
 * will create a new one if it doesn't.
 * 
 * @param $szFile string - The path and filename of the textfile to check.
 * @param $nWidth integer - The default value of the width setting.
 * @param $nHeight integer - The default value of the height setting.
 * @return boolean - True if successful, false if not.
 **/
function checkSettingsFile( $szFile, $nWidth, $nHeight )
{
    // check to see if the file exists
    if ( file_exists( $szFile ) )
        return true;

    // file does not exist so create it and default
    $fp = fopen($szFile, 'w');

    // set default values
    $szBuffer = "<?php\n";
    $szBuffer .= "\$chkTitleElem = 1;\n";
    $szBuffer .= "\$txtTitleDesc = \"New Map\";\n";
    $szBuffer .= "\$chkNeatElem = 1;\n";
    $szBuffer .= "\$chkScalebarElem = 1;\n";
    $szBuffer .= "\$chkLegendElem = 1;\n";
    $szBuffer .= "\$selScalebarPos = \"BR\";\n";
    $szBuffer .= "\$selLegendPos = \"TR\";\n";
    $szBuffer .= "\$selFontSize = \"12\";\n";
    $szBuffer .= "\$txtWidthPix = \"$nWidth\";\n";
    $szBuffer .= "\$txtHeightPix = \"$nHeight\";\n";
    $szBuffer .= "\$selImageFormat = \"GIF\";\n";
    $szBuffer .= "\$selTitleFont = \"\";\n";
    $szBuffer .= "\$selTitleFontFile = \"\";\n";
    $szBuffer .= "\$selLegendFont = \"\";\n";
    $szBuffer .= "\$selLegendFontFile = \"\";\n";
    
    $szBuffer .= "?>";

    // write the default settings
    fwrite($fp, $szBuffer);

    // close the file
    fclose($fp);
    echo $szBuffer;
    
    // return
    return true;

// end checkSettingsFile() function
}

/**
 * Postcondition - This method will open the given setting file and update the
 * necessary values according to the array of URL values passed to it.
 * 
 * @param $szFile string - The path and filename of the settings file to update.
 * @param $url mixed array - An array of values as passed through the url used
 *                           to update the settings file.
 * @return boolean - True if successful, false if not.
 **/
function updateSettingsFile( $szFile, $url )
{
    // check to see if the file exists
    if ( file_exists( $szFile ) )
        unlink( $szFile );

    // re-create the file
    $fp = fopen($szFile, 'w');

    // process checkbox values
    if ( !isset( $url["chkTitleElem"] ) ) $url["chkTitleElem"] = 0;
    if ( !isset( $url["chkNeatElem"] ) ) $url["chkNeatElem"] = 0;
    if ( !isset( $url["chkScalebarElem"] ) ) $url["chkScalebarElem"] = 0;
    if ( !isset( $url["chkLegendElem"] ) ) $url["chkLegendElem"] = 0;

    // set default values
    $szBuffer = "<?php\n";
    $szBuffer .= "\$chkTitleElem = ".$url["chkTitleElem"].";\n";
    $szBuffer .= "\$txtTitleDesc = \"".$url["txtTitleDesc"]."\";\n";
    $szBuffer .= "\$chkNeatElem = ".$url["chkNeatElem"].";\n";
    $szBuffer .= "\$chkScalebarElem = ".$url["chkScalebarElem"].";\n";
    $szBuffer .= "\$chkLegendElem = ".$url["chkLegendElem"].";\n";
    $szBuffer .= "\$selScalebarPos = \"".$url["selScalebarPos"]."\";\n";
    $szBuffer .= "\$selLegendPos = \"".$url["selLegendPos"]."\";\n";
    $szBuffer .= "\$selFontSize = \"".$url["selFontSize"]."\";\n";
    $szBuffer .= "\$txtWidthPix = \"".$url["txtWidthPix"]."\";\n";
    $szBuffer .= "\$txtHeightPix = \"".$url["txtHeightPix"]."\";\n";
    $szBuffer .= "\$selImageFormat = \"".$url["selImageFormat"]."\";\n";
    $szBuffer .= "\$szFontDir = \"".$GLOBALS["szFontDir"]."\";\n";
    $szBuffer .= "\$selTitleFont = \"".$url["titleFont"]."\";\n";
    $szBuffer .= "\$selTitleFontFile = \"".$GLOBALS["aFonts"][$url["titleFont"]]."\";\n";
    $szBuffer .= "\$selLegendFont = \"".$url["legendFont"]."\";\n";
    $szBuffer .= "\$selLegendFontFile = \"".$GLOBALS["aFonts"][$url["legendFont"]]."\";\n";
    $szBuffer .= "?>";

    // write the default settings
    fwrite($fp, $szBuffer);

    // close the file
    fclose($fp);
    
   
    // return
    return true;

// end updateSettingsFile() function
}

/**
 * This function restores the characters that give problems when passed through
 * a URL.
 *
 * @param $szString string - The string to fix.
 * @param $bHTML boolean - Optional flag to indicate if HTML quote is needed.
 * @return string - The restored string.
 **/
function restoreChars( $szString, $bHTML = false )
{
    // check for #!# and replace with \
    $szString = str_replace( "#!#", "\\", $szString );

    // check for #!!# and replace with '
    $szString = str_replace( "#!!#", "'", $szString );

    // check for #!!!# and replace with "
    if ( $bHTML )
        $szString = str_replace( "#!!!#", "&quot;", $szString );
    else
        $szString = str_replace( "#!!!#", "\"", $szString );

    // return string
    return $szString;

// end restorChars() function
}
?>
