<?php
/**
 * CWC application
 *
 * @project     CWC
 * @revision    $Id: preview.php,v 1.2 2004/04/25 04:20:39 pspencer Exp $
 * @purpose     This page contains supporting php functions.
 * @author      William A. Bronsema, C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2001, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: preview.php,v $
 * Revision 1.2  2004/04/25 04:20:39  pspencer
 * fixed file references
 *
 * Revision 1.1  2004/04/23 16:51:01  pspencer
 * moved preview.php to PrintWidget/preview.php
 *
 * Revision 1.32  2003/10/27 20:46:19  sfournier
 * Overwrite main branch with 1.1 stuff
 *
 * Revision 1.23.2.3  2003/10/21 01:32:00  pspencer
 * changed scalebar background to white bc ms40 imageobj pasteimage with transparency doesn't work.
 *
 * Revision 1.23.2.2  2003/10/15 21:04:57  pspencer
 * fixes to work with Chameleon 1.1
 *
 * Revision 1.23.2.1  2003/08/05 15:08:33  zak
 * removed tests requiring wms layers and metadata in map
 * (bug 2161)
 *
 * Revision 1.23  2003/04/30 15:18:55  bronsema
 * fixed "invalid syntax" javascript error by removing unecessary and
 * un-intialized variables
 *
 * Revision 1.22  2003/04/30 14:58:07  bronsema
 * removed SWF output option
 *
 * Revision 1.21  2003/04/30 14:35:11  bronsema
 * fixed map size problem
 *
 * Revision 1.20  2003/04/30 14:20:04  bronsema
 * Updated pdf support
 *
 * Revision 1.19  2003/04/29 20:48:39  sacha
 * Fixed the scalebar preview in jpeg.
 *
 * Revision 1.18  2003/04/28 19:18:39  sacha
 * Use right header for JPEG
 *
 * Revision 1.17  2003/04/25 19:47:46  daniel
 * Add the ability to set the output type for scalebar
 *
 * Revision 1.16  2003/04/17 19:10:51  sacha
 * Change the preview to reflect the exact map size from the main page.
 *
 * Revision 1.15  2003/04/16 18:51:09  sacha
 * Fixed few bugs related to the rendering preview of a map
 *
 * Revision 1.14  2003/04/08 20:09:58  sacha
 * Fixed few bug related to print
 *
 * Revision 1.13  2003/04/08 19:08:27  sacha
 * Added error report to production dialog and also fixed a bug about PDF format. Only offer the choice if available
 *
 * Revision 1.12  2003/03/05 20:59:47  sacha
 * Fixed a directory bug when copying image
 *
 * Revision 1.11  2003/02/24 19:32:34  sacha
 * Don't display layer temp_points in legend. Also fixed a few potential bugs in add point
 *
 * Revision 1.10  2003/01/30 13:49:58  sacha
 * Changed the session management
 *
 * Revision 1.9  2003/01/08 16:43:12  bronsema
 * Updated code to remove the dot that was appearing on labels with no
 * symbol
 *
 * Revision 1.8  2003/01/07 20:25:08  bronsema
 * Updated function header comments to the doxygen style
 *
 * Revision 1.7  2003/01/07 20:04:20  bronsema
 * Included serveral misc settings
 *
 * Revision 1.6  2003/01/07 18:33:45  bronsema
 * Added legend
 *
 * Revision 1.5  2003/01/03 18:51:01  bronsema
 * Moved the download file capabiltiy to the production page.
 *
 * Revision 1.4  2002/12/18 19:07:31  bronsema
 * Fixed problem with empty shape-file and temp layer.
 *
 * Revision 1.3  2002/12/17 18:14:13  bronsema
 * fixed misc bugs in production
 *
 * Revision 1.2  2002/12/15 04:59:45  bronsema
 * Changed resolution from 300 to 150 & added cross-hair to keymap
 *
 * Revision 1.1  2002/10/28 15:07:31  bronsema
 * Initial addition
 *
 * Revision 1.1  2002/08/12 20:26:18  bronsema
 * Added delayed drawing functionality to map production.
 *
  *****************************************************************************/
// set output flag if not defined
if ( !isset( $bFileOnly ) ) $bFileOnly = false;

// define flag if necessary
if ( !defined( "LOAD_MAPSESSION" ) ) 
{
    define("LOAD_MAPSESSION", 1);
}    

// include session info
include_once("../session.inc.php");

// give lots of time to draw the map
set_time_limit( 300 );

/* ============================================================================
 * Build an array with the HTTP GET or POST parameters.
 * ========================================================================= */
//$http_form_vars = sizeof( $_POST ) > 0 ? $_POST : 
//                                    ( sizeof($_GET) > 0 ? $_GET : array("") );

// determine the output format
switch ( $http_form_vars["selImageFormat"] )
{
    case "GIF":
        $szHeaderType = "Content-type: image/gif";
        $sz_format = "gif";
        $gsz_dl_ext = ".gif";
        $gsz_dl_name = "map.gif";
        break;
    case "JPEG":
        $szHeaderType = "Content-type: image/jpeg";
        $sz_format = "jpeg";        
        $gsz_dl_ext = ".jpg";
        $gsz_dl_name = "map.jpg";
        break;
    case "WBMP":
        $szHeaderType = "Content-type: image/wbmp";
        $sz_format = "wbmp";        
        $gsz_dl_ext = ".bmp";
        $gsz_dl_name = "map.bmp";
        break;
    case "PNG24":
        $szHeaderType = "Content-type: image/png";
        $sz_format = "png24";        
        $gsz_dl_ext = ".png";
        $gsz_dl_name = "map.png";
        break;
    case "PNG":
        $szHeaderType = "Content-type: image/png";
        $sz_format = "png";        
        $gsz_dl_ext = ".png";
        $gsz_dl_name = "map.png";
        break;
    case "PDF":
        $szHeaderType = "Content-type: application/x-pdf";
        $sz_format = "png";  // render as png!!!!!!        
        $gsz_dl_ext = ".pdf";
        $gsz_dl_name = "map.pdf";
        break;  
    //case "SWF":
        //$szHeaderType = "Content-type: application/x-shockwave-flash";
        //$sz_format = "swf";        
        //$gsz_dl_ext = ".swf";
        //$gsz_dl_name = "map.swf";
        //break; 
    default:
        $szHeaderType = "Content-type: image/png";
        $sz_format = "png";
        $gsz_dl_ext = ".png";
        $gsz_dl_name = "map.png";
        break;        
}

// set the output type
if ($oMapSession->oMap->selectoutputformat( $sz_format ) == MS_FAILURE &&
    isset($_SESSION['gErrorManager']))
     $_SESSION['gErrorManager']->setError(ERR_WARNING, 
               "Type \"$sz_format\" should correspond to one of the output formats declared in the map file");

// render the image
$oImage = renderImage( $oMapSession, 
                    $_SESSION['gszTmpPath'].$http_form_vars['sid'].".txt" );

// output map to screen or file
if ( $bFileOnly ) 
{
    // save image
    $urlMainMapFile = $oImage->saveWebImage();

    // generate a unique name for the tmp download file
    $szTmpDLName = $http_form_vars['sid'].$gsz_dl_ext;
    $szDownloadURL = $_SESSION["gszTmpWebPath"].$szTmpDLName;
    $szDownloadFile = $_SESSION["gszTmpImgPath"].$szTmpDLName; 

    // get the temp image path and filename
    $szTmpImage = realpath($oMapSession->oMap->web->imagepath.basename($urlMainMapFile));
    
    // convert the image to pdf if necessary
    if ( $http_form_vars["selImageFormat"] == "PDF" )
    {
        // check to see if pdf support is loaded
        if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
        {
            if (!extension_loaded("pdf")) dl("php_pdf.dll");
        }
        
        // create handle for new PDF document
        $pdf = pdf_new();
        
        // open a file
        pdf_open_file($pdf,$szDownloadFile);
        
        // start a new page
        pdf_begin_page($pdf, $ng_map_width, $ng_map_height);
        
        // position image
        $image = pdf_open_image_file($pdf, "png", $szTmpImage);
        pdf_place_image($pdf, $image, 0, 0, 1);
        
        // end page
        pdf_end_page($pdf);
        
        // close and save file
        pdf_close($pdf);
        
    }
    else
    {
        // copy the new image file to the unique name
        if ( file_exists( $szDownloadFile ) ) unlink( $szDownloadFile );
        copy( $szTmpImage, $szDownloadFile);
    }
}
else
{
    // output to screen
    header( $szHeaderType );
    $urlMainMap = $oImage->saveImage("");
}
                                    
/**
 * This function processes the given information and draws the image
 * accordingly.
 * 
 * @param $oMapSession object - The mapsession object to process.
 * @param $szSettings string - Path and filename of the settings file.
 * @return object - The image handle for the generated image.
 **/
function renderImage( $oMapSession, $szSettings )
{
    global $ng_map_width;
    global $ng_map_height;
    
    // include the settings file
    include( $szSettings );
 
    // set the pixel amount to have above and below the map
    $n_pix_whitespace_top = 40;
    $n_pix_whitespace_bot = 40; 
    $n_pix_whitespace_left = 10;
    $n_pix_whitespace_right = 10;

    // get the map object
    $oMap = $oMapSession->getMapObj();
 
    // check for any layers that are on and not deleted
    $bNoLayers = true;
    for ($i=0;$i<$oMap->numlayers;$i++)
    {
        // create layer object
        $oLayer = $oMap->getlayer($i);
        
        // check name
        if ($oLayer->status == MS_ON)
        {
            // a layer was found that is on
            $bNoLayers = false;
            break;
        }
    }

    // check flag
    if ($bNoLayers) return false;

    // set the scale value
    $n_scale_value = 1;

    // record the current backcolour
    $n_map_red = intval($oMap->imagecolor->red);
    $n_map_green = intval($oMap->imagecolor->green);
    $n_map_blue = intval($oMap->imagecolor->blue);

    // reset the background colour
    $oMap->imagecolor->setRGB($n_map_red,$n_map_green,$n_map_blue);

    // set the map width and height
    $oMap->set( "width", intval($txtWidthPix) );
    $oMap->set( "height", intval($txtHeightPix) );
    
    $map_width = $oMap->width+0; // leave the +0 to make a COPY of the value
    $map_height =$oMap->height+0; // leave the +0 to make a COPY of the value

    // draw the map
    $o_img_map = $oMap->draw();

    //now draw the legend, scalebar and north arrow
    //calculate positions for each as they could overlap
    //and will be stacked

    //the amount to inset from the edge and between stacked elements in pixels
    $nInsetWidth = 5;

    $nLegendWidth = 0;
    $nLegendHeight = 0;
    $nScalebarWidth = 0;
    $nScalebarHeight = 0;
    $nLegendX = 0;
    $nLegendY = 0;
    $nScalebarX = 0;
    $nScalebarY = 0;

    //record the max width at each position so we can center things
    //use the first one to have centering in each of the 6 positions
    //use the second one to center in each of the 3 columns
    //if you use the second one, change the code in the prepare image
    //sections to use substr($itemPos, 1,1])
    $aWidths = array( "TL"=>0, "TC"=>0, "TR"=>0, "BL"=>0, "BC"=>0, "BR"=>0);


    //prepare the scalebar image
    if ( $chkScalebarElem == 1 )
    {
        $szOldImageType = $oMap->outputformat->name;
        $oMap->selectOutputFormat("PNG");
        $oScalebarImg = $oMap->drawScaleBar();
        $oMap->selectOutputFormat($szOldImageType);

        $nScalebarHeight = $oScalebarImg->height * $n_scale_value;
        $nScalebarWidth = $oScalebarImg->width * $n_scale_value;
        $scalebarPos = $selScalebarPos;
        $aWidths[substr($scalebarPos, 0, 2)] = max($aWidths[$scalebarPos], 
                                                   $nScalebarWidth);

        $vOffset = 0 + (10 * $n_scale_value);
        if ( isset( $legendPos ) && $legendPos == $scalebarPos )
        {
            $vOffset = $nLegendHeight + $nInsetWidth + (10 * $n_scale_value);
        }
        if ( substr( $scalebarPos, 0, 1 ) == "T" )
            $nScalebarY = $nInsetWidth + $vOffset;
        else
            $nScalebarY = $map_height - $vOffset - $nScalebarHeight;

        $hOffset = ($aWidths[substr($scalebarPos,0,2)] - $nScalebarWidth) / 2;
        if ( substr( $scalebarPos, 1, 1 ) == "L" ) //left
            $nScalebarX = $nInsetWidth + $hOffset;
        elseif( substr( $scalebarPos, 1, 1 ) == "C" ) //center
            $nScalebarX = ($map_width / 2) - ($nScalebarWidth / 2);
        else
            $nScalebarX = $map_width-$nInsetWidth-$nScalebarWidth-$hOffset;

        $o_img_map = draw_scalebar( $oMap, $o_img_map, $nScalebarX, $nScalebarY, 
                                    $n_scale_value);
    }

    //prepare the legend image
    if ( $chkLegendElem == 1 )
    {
        // include the utility functions necessary to draw the legend
        include_once( "./production_draw_legend.php" );
        
        // get list of layer to draw
        $an_legend_list = getLegendList( $oMap );

        // draw legend according to resolution
        $oLegendImage = getLegendImage($oMap, $an_legend_list,8,
                                       $szFontDir."/".$selLegendFontFile, $selLegendFont,
                                       $n_scale_value);

        $nLegendHeight = $oLegendImage->height;
        $nLegendWidth = $oLegendImage->width;
        $legendPos = $selLegendPos;
        $aWidths[substr($legendPos, 0, 2)] = max($aWidths[$legendPos],
                                                 $nLegendWidth);
        //$aWidths[substr($legendPos, 1, 1)] = max($aWidths[$legendPos], 
        //                                                  $nLegendWidth);
    }
   
    //position the legend image and draw it
    if ( $chkLegendElem == 1 )
    {
        if ( substr( $legendPos, 0, 1 ) == "T" )
            $nLegendY = $nInsetWidth;
        else
            $nLegendY = $map_height - $nInsetWidth - $nLegendHeight;

        //$hOffset = ( $aWidths[substr($legendPos, 0, 2)] - $nLegendWidth ) / 2;
        $hOffset = 0;
        if ( substr( $legendPos, 1, 1 ) == "L" ) //left
            $nLegendX = $nInsetWidth + $hOffset;
        elseif( substr( $legendPos, 1, 1 ) == "C" ) //center
            $nLegendX = ($map_width / 2) - ($nLegendWidth / 2);
        else
            $nLegendX = $map_width - $nInsetWidth - $nLegendWidth - $hOffset;

        draw_legend( $oMap, $o_img_map, $oLegendImage, $nLegendX, 
                     $nLegendY );
    }    
 
    // set the map width and height
    $d_map_width = intval($txtWidthPix) + $n_pix_whitespace_left +
                                         $n_pix_whitespace_right;
    $d_map_height = intval($txtHeightPix) + $n_pix_whitespace_top -
                                           $n_pix_whitespace_bot;

    // record width and height with white spaces for the map cell
    $ng_map_width = $d_map_width + $n_pix_whitespace_left +
                    $n_pix_whitespace_right;
    $ng_map_height = $d_map_height + $n_pix_whitespace_top +
                     $n_pix_whitespace_bot;

    // set the new width of the map
    $oMap->set("width",$ng_map_width);

    // set the new height of the map
    $oMap->set("height",$ng_map_height);

    // set the background colour to white
    $oMap->imagecolor->setRGB(255,255,255);

    // draw the canvas
    $o_img_canvas = $oMap->prepareImage();

    // set back width of the map
    $oMap->set("width",$map_width);

    // set back height of the map
    $oMap->set("height",$map_height);

    // draw the title on the map if necessary
    if ( $chkTitleElem == 1 )
    {
        drawLabel( $oMap, $o_img_canvas, $ng_map_width/2, 35 * $n_scale_value,
                  $n_scale_value, $txtTitleDesc, 
                  $selTitleFont, $selFontSize, MS_UC );                                
    }
           
    // add copyright notice
    drawLabel($oMap, $o_img_canvas, $ng_map_width - (5 * $n_scale_value),
            $ng_map_height - (5 * $n_scale_value),
            $n_scale_value, ""/* Put your copyright code here, ".
                "something, something. All rights reserved"*/, 
            $selTitleFont,8, MS_UL );                

    // draw the neat line around the map if required
    if ( $chkNeatElem == 1 )
        draw_neat_line( $oMap, $o_img_canvas, $n_pix_whitespace_left, $n_pix_whitespace_top);
    $urlMainMap = $o_img_map->saveWebImage();
    
    // add bounding box coordinates
    drawBoundingCoords( $oMap, $o_img_canvas, $n_pix_whitespace_left, 
                        $n_pix_whitespace_right, $n_pix_whitespace_top, 
                        $n_pix_whitespace_bot, $ng_map_width, $ng_map_height, 
                        $n_scale_value, $selLegendFont );
                        
    // add scale
    drawScaleLabel($oMap, $o_img_canvas, $n_pix_whitespace_left, 
                        $n_pix_whitespace_right, $n_pix_whitespace_top, 
                        $n_pix_whitespace_bot, $ng_map_width, $ng_map_height, 
                        $n_scale_value, $szFontDir."/".$selLegendFont );                       

    // paste the map onto the canvas
    $o_img_canvas->pasteImage( $o_img_map, -1, $n_pix_whitespace_left,
                               $n_pix_whitespace_top);  
    
    // return image handle
    return $o_img_canvas;

// end render_map function
}

/**
 * This function will draw the map into the given map image.
 *
 * @param oMap object - Map file object.
 * @param oImage object - Image object to draw the rectangle on.
 * @return void.
 **/
function draw_neat_line($oMap,$oImage, $nPosX, $nPosY)
{
    // create temp layer
    $o_tmp_layer = ms_newLayerObj($oMap);
    $o_tmp_layer->set("name", "temp_layer");
    $o_tmp_layer->set("type", MS_LAYER_LINE);
    $o_tmp_layer->set("status", MS_OFF);
    $o_tmp_layer->set("transform", MS_FALSE);
    $o_tmp_class = ms_newClassObj($o_tmp_layer);
   
    // create style object
    $o_style = ms_newStyleObj( $o_tmp_class );
    
    // set the class colour
    $o_style->color->setRGB( 0,0,0 );

    // create new rectangle object
    $o_rect = ms_newRectObj();

    // set to full extents
    $o_rect->setExtent($nPosX-1, $nPosY-1, $oMap->width+$nPosX, $oMap->height+$nPosY);

    // draw the rectangle onto the map
    $o_rect->draw($oMap, $o_tmp_layer, $oImage, 0, "");

    // delete temp layer
    $o_tmp_layer->set("status", MS_DELETE);

// end draw_neat_line function
}
 
/**
 * This function draws the given text at the location specified.
 *
 * @param $oMap object - The current map object.
 * @param $oImage object - The image object to paste onto.
 * @param $n_x_pos integer - The x position of the label.
 * @param $n_y_pos integer - The y position of the label.
 * @param $n_scale_factor integer - The scale factor to apply to the label.
 * @param $szText string - The text to output.
 * @param $szFontName string - The font to use.
 * @param $nFontSize integer - The font sixe to use.
 * @param $nPosition integer - The label position.
 * @return boolean - True if successful, false if not.
 **/
function drawLabel( $oMap,$oImage, $n_x_pos, $n_y_pos, $n_scale_factor,
                                 $szText, $szFontName ,$nFontSize, $nPosition )
{
    // create temp layer
    $o_tmp_layer = ms_newLayerObj($oMap);
    $o_tmp_layer->set("name", "temp_layer");
    $o_tmp_layer->set("type", MS_LAYER_ANNOTATION);
    $o_tmp_layer->set("status", MS_OFF);
    $o_tmp_layer->set("transform", MS_FALSE);
    $o_tmp_layer->set("labelitem", "test_label");
    $o_tmp_layer->set("labelcache", MS_OFF);
    $o_tmp_class = ms_newClassObj($o_tmp_layer);
    
    // create style object
    $o_style = ms_newStyleObj( $o_tmp_class );

    // set the class colour
    $o_style->color->setRGB( -1,-1,-1 );
  
    // set the label properties
    $o_tmp_class->label->color->setRGB( 0,0,0 );
    $o_tmp_class->label->set("size"         , $nFontSize    );
    $o_tmp_class->label->set("font"         , $szFontName   );
    $o_tmp_class->label->set("type"         , MS_TRUETYPE   );
    $o_tmp_class->label->set("position"     , $nPosition    );
    $o_tmp_class->label->set("partials"     , MS_FALSE      );

    // create new point object
    $o_point = ms_newPointObj();

    //position
    $o_point->setXY($n_x_pos,$n_y_pos);

    // draw the point onto the map
    $o_point->draw($oMap, $o_tmp_layer, $oImage, 0, restoreChars( $szText ));

    // return success
    return true;

// end drawLabel function
}

/**
 * Draw the scalebar for the map onto an image at a given position.
 *
 * @param oMap object - The objec map.
 * @param oImage object - The image to draw the legend onto.
 * @param nX int - The left edge of the scalebar.
 * @param nY int - The top edge of the scalebar.
 * @param n_scale_factor integer - Scale factor to apply to title.
 * @param szImageType - Image output type.
 * @return mixed - The image object passed in or false if it failed.
 **/
function draw_scalebar( $oMap, $oImage, $nX, $nY, $n_scale_factor)
{
    // create scalebar object
    $oScalebar = $oMap->scalebar;

    // set the intervals
    $oScalebar->set("intervals", 5);

    // set the size of the scalebar according to scale
    $oLabel = $oScalebar->label;
    if ($n_scale_factor == 1)
    {
        //no scale
        $oLabel->set("size", MS_TINY);
    }
    else
    {
        // scale
        $oLabel->set("size", MS_GIANT);
        $oScalebar->set("width", $oScalebar->width * $n_scale_factor);
        $oScalebar->set("height", $oScalebar->height * $n_scale_factor);
    }

    // set status and transparency
    $oScalebar->set("status",MS_ON);
    $oScalebar->set("transparent",MS_TRUE);
    $oScalebar->setimagecolor(255,255,255);
    
    //ask the map to draw the legend onto an image object
    $szOldImageType = $oMap->outputformat->name;
    $oMap->selectOutputFormat("PNG");
    $oScalebarImage = $oMap->drawScaleBar();
    $oMap->selectOutputFormat($szOldImageType);

    //get the size of the map and legend for validation
    $nMapWidth = $oImage->width;
    $nMapHeight = $oImage->height;
    $nScalebarWidth = $oScalebarImage->width;
    $nScalebarHeight = $oScalebarImage->height;

    //top & left validation
    if ($nX < 0) $nX = 0;
    if ($nY < 0) $nY = 0;
    
    //bottom & right validation
    if ( ($nX + $nScalebarWidth) > $nMapWidth )
        $nX = $nMapWidth - $nScalebarWidth;
    if ( ($nY + $nScalebarHeight) > $nMapHeight )
        $nY = $nMapHeight - $nScalebarHeight;

    //paste the scalebar onto the image at the desired location
    //TODO: fix me when pasteImage is fixed (bug 463)
    $oImage->pasteImage( $oScalebarImage, 0xffffff, $nX, $nY);

    return $oImage;
}

/**
 * Postcondition:  This function formats the bounding box coordinates and 
 * pastes them onto the give image object.
 * 
 * @param $oMap object - The main map object.
 * @param $oCanvas object - the image object to paste to.
 * @param $nWsLeft integer - The size of the left whitespace margin in pixels.
 * @param $nWsRight integer - The size of the right whitespace margin in pixels.
 * @param $nWsTop integer - The size of the top whitespace margin in pixels.
 * @param $nWsBottom integer - The size of the bot whitespace margin in pixels.
 * @param $nMapWidth integer - The width of the overall canvas.
 * @param $nMapHeight integer - The height of the overall canvas.
 * @param $dScale double - The scale factor to be applied.
 * @param $szFontName string - The font to use.
 * @return void.
 **/
function drawBoundingCoords( $oMap, $oCanvas, $nWsLeft, $nWsRight, $nWsTop, 
                             $nWsBottom, $nMapWidth, $nMapHeight, $dScale,
                             $szFontName )
{
    // determine the ratio of the pixel width to extent width
    $nRatio = abs( $oMap->width / ($oMap->extent->maxx - $oMap->extent->minx) );

    // process accordingly
    if ( $nRatio > 1 )
        $nNbDecimal = log( $nRatio )/log( 10 ) + 1;
    else
        $nNbDecimal = 0;
        
    // format bounding coordinates for labels
    $dMinX = number_format($oMap->extent->minx, $nNbDecimal, ".", "");
    $dMinY = number_format($oMap->extent->miny, $nNbDecimal, ".", "");
    $dMaxX = number_format($oMap->extent->maxx, $nNbDecimal, ".", "");
    $dMaxY = number_format($oMap->extent->maxy, $nNbDecimal, ".", "");
    
    // draw the labels
    drawLabel( $oMap, $oCanvas, $nWsLeft, $nMapHeight - $nWsBottom + 6, 
               $dScale, "x: ".$dMinX, $szFontName, 8, MS_LR ); 
    drawLabel( $oMap, $oCanvas, $nWsLeft, $nMapHeight - $nWsBottom + 19, 
               $dScale, "y: ".$dMinY, $szFontName, 8, MS_LR );
    drawLabel( $oMap, $oCanvas, $nMapWidth - $nWsRight, $nWsTop - 21,
               $dScale, "x: ".$dMaxX, $szFontName, 8, MS_UL ); 
    drawLabel( $oMap, $oCanvas, $nMapWidth - $nWsRight, $nWsTop - 7,
               $dScale, "y: ".$dMaxY, $szFontName, 8, MS_UL );

// end drawCoundingCoords() function
}

/**
 * This function restores the characters that give problems when passed through
 * a URL.
 *
 * @param $szString string - The string to fix.
 * @param $bHTML boolean - Optional flag to indicate if HTML quote is needed.
 * @return string - The restored string.
 **/
function restoreChars( $szString, $bHTML = false )
{
    // check for #!# and replace with \
    $szString = str_replace( "#!#", "\\", $szString );

    // check for #!!# and replace with '
    $szString = str_replace( "#!!#", "'", $szString );

    // check for #!!!# and replace with "
    if ( $bHTML )
        $szString = str_replace( "#!!!#", "&quot;", $szString );
    else
        $szString = str_replace( "#!!!#", "\"", $szString );

    // return string
    return $szString;

// end restorChars() function
}

/**
 * Postcondition:  This function formats the scale label and 
 * pastes it onto the give image object.
 * 
 * @param $oMap object - The main map object.
 * @param $oCanvas object - the image object to paste to.
 * @param $nWsLeft integer - The size of the left whitespace margin in pixels.
 * @param $nWsRight integer - The size of the right whitespace margin in pixels.
 * @param $nWsTop integer - The size of the top whitespace margin in pixels.
 * @param $nWsBottom integer - The size of the bot whitespace margin in pixels.
 * @param $nMapWidth integer - The width of the overall canvas.
 * @param $nMapHeight integer - The height of the overall canvas.
 * @param $dScale double - The scale factor to be applied.
 * @param $szFontName string - The font to use.
 * @return void.
 **/
function drawScaleLabel( $oMap, $oCanvas, $nWsLeft, $nWsRight, $nWsTop, 
                             $nWsBottom, $nMapWidth, $nMapHeight, $dScale,
                             $szFontName )
{       
    // format scale
    $nScale = number_format($oMap->scale, 0, ".", "");
    
    // draw the label
    drawLabel( $oMap, $oCanvas, $nMapWidth - $nWsRight, 
               $nMapHeight - $nWsBottom + 6,
               $dScale, "Scale 1:".$nScale, $szFontName, 8, MS_LL ); 

// end drawScaleLabel() function
}
?>