<?php
/**
 * OWTChart Widget class
 *
 * @project     CWC2
 * @revision    $Id: 
 * @purpose     OWTChart Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");

/**
 * OWTChartWidget
 *
 * @desc Widget That build a OWTChart url with specified parameters
 */
class OWTChart extends CWCWidget
{
    var $mszBaseOWT = "/cgi-cwc/owtchart";

    var $mszSharedResourceName = "";

    var $mnWidth = 300;
    var $mnHeight = 200;
    var $mszImageType = "PNG";
    var $mszTitle = "Default Chart Name";
    var $mszBGColor = "FFFFFF";
    var $mbTransBG = false;
    var $mszLineColor = "0000FF";
    var $mbGrid = false;
    var $mszGridColor = "CCCCCC";
    var $mnJPEGQuality = 78;
    var $mszRTitle = "";
    var $mszLTitle = "";
    var $mszTitleColor = "0F0F0F";
    var $mszTitleFont = "M";
    var $mbXAxis = true;
    var $mbYAxis = true;
    var $mbYAxis2 = false;
    var $mszXTitle = "";
    var $mszXTitleColor = "0F0F0F";
    var $mszXTitleFont = "M";
    var $mszXLabelFont = "S";
    var $mszXLabelColor = "ADADAD";
    var $mszXLabelSpacing = "5";
    var $mszYLabelFont = "S";
    var $mszYLabelColor = "ADADAD";
    var $mszYLabelFmt = "";
    var $mszYLabelFmt2 = "";
    var $mszYTitle = "";
    var $mszYTitleColor = "0F0F0F";
    var $mszYTitleFont = "M";
    var $mszYTitle2 = "";
    var $mszYTitleColor2 = "0F0F0F";
    var $mszYTitleFont2 = "M";
    var $mszYScaleType = "LINEAR";
    var $mnYMin = "";
    var $mnYMax = "";
    var $mnYMin2 = "";
    var $mnYMax2 = "";
    var $mszPiePCTType = "RIGHT";
    var $mszPiePCTFmt = "";
    var $mnPieRadius = "";
    var $mszPieLabelFont = "S";
    var $mnBarWidth = "75";
    var $mbBarLabels = false;
    var $mszBarLabelFmt = "";
    var $mszLineStyles = "";
    var $mszHLCStyle = "";
    var $mnHLCCapWidth = "25";
    var $mn3DDepth = "5";
    var $mn3DAngle = "45";
    var $mszPlotColor = "0000FF";
    var $mszExtColors = "";
    var $mszVolColor = "0000FF";
    var $mszStackType = "DEPTH";
    var $mszLineColor = "999999";

    /**
     * OWTChartWidget
     *
     * Constructor method for the OWTChart widget.
     */
    function OWTChart()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
OWTChartWidget is a widget that build a OWTChart url with specified parameters.
EOT;

        // Mandatory parameters
        $this->maAttributes["SHAREDRESOURCENAME"] = new StringAttribute( "SHAREDRESOURCENAME", true);
        $this->maAttributes["CHARTTYPE"] = new StringAttribute( "CHARTTYPE", false, 
               array("LINE", "AREA", "BAR", "FLOATINGBAR", "HILOCLOSE", "PIE", "HBAR", "H2BAR"));
        $this->maAttributes["VALS"] =  new StringAttribute( "VALS", true);

        // Optional parameters
        $this->maAttributes["WIDTH"] = new IntegerAttribute("WIDTH", false);
        $this->maAttributes["HEIGHT"] = new IntegerAttribute("HEIGHT", false);
        $this->maAttributes["BGCOLOR"] =  new StringAttribute( "BGCOLOR", false);
        $this->maAttributes["TRANSBG"] =  new BooleanAttribute( "TRANSBG", false);
        $this->maAttributes["LINECOLOR"] =  new StringAttribute( "LINECOLOR", false);
        $this->maAttributes["GRID"] =  new BooleanAttribute( "GRID", false);
        $this->maAttributes["GRIDCOLOR"] =  new StringAttribute( "GRIDCOLOR", false);
        $this->maAttributes["IMAGETYPE"] =  new StringAttribute( "IMAGETYPE", false,
               array("GIF", "PNG", "JPEG", "WBMP"));
        $this->maAttributes["JPEG_QUALITY"] = new IntegerAttribute("JPEG_QUALITY", false);

        // 3d options
        $this->maAttributes["3D"] =  new BooleanAttribute( "3D", false);
        $this->maAttributes["3DDEPTH"] = new IntegerAttribute("3DDEPTH", false);
        $this->maAttributes["3DANGLE"] = new IntegerAttribute("3DANGLE", false);

        // Value colors
        $this->maAttributes["PLOTCOLOR"] =  new StringAttribute( "PLOTCOLOR", false);
        $this->maAttributes["SETCOLORS"] =  new StringAttribute( "SETCOLORS", false);
        $this->maAttributes["EXTCOLORS"] =  new StringAttribute( "EXTCOLORS", false);
        $this->maAttributes["VOLCOLOR"] =  new StringAttribute( "VOLCOLOR", false);

        // Chart title options
        $this->maAttributes["TITLE"] =  new StringAttribute( "TITLE", false);
        $this->maAttributes["RTITLE"] =  new StringAttribute( "RTITLE", false);
        $this->maAttributes["LTITLE"] =  new StringAttribute( "LTITLE", false);
        $this->maAttributes["TITLECOLOR"] =  new StringAttribute( "TITLECOLOR", false);
        $this->maAttributes["TITLEFONT"] =  new StringAttribute( "TITLEFONT", false);

        // X-Axis options
        $this->maAttributes["XAXIS"] =  new BooleanAttribute( "XAXIS", false);
        $this->maAttributes["XTITLE"] =  new StringAttribute( "XTITLE", false);
        $this->maAttributes["XTITLEFONT"] =  new StringAttribute( "XTITLEFONT", false);
        $this->maAttributes["XTITLECOLOR"] =  new StringAttribute( "XTITLECOLOR", false);
        $this->maAttributes["XLABELS"] =  new StringAttribute( "XLABELS", false);
        $this->maAttributes["XLABELFONT"] =  new StringAttribute( "XLABELFONT", false);
        $this->maAttributes["XLABELCOLOR"] =  new StringAttribute( "XLABELCOLOR", false);
        $this->maAttributes["XLABELSPACING"] =  new IntegerAttribute( "XLABELSPACING", false);

        // Y-Axis options
        $this->maAttributes["YAXIS"] =  new BooleanAttribute( "YAXIS", false);
        $this->maAttributes["YSCALETYPE"] =  new StringAttribute( "YSCALETYPE", false,
               array("LINEAR","LOG"));
        $this->maAttributes["YMIN"] =  new IntegerAttribute( "YMIN", false);
        $this->maAttributes["YMAX"] =  new IntegerAttribute( "YMAX", false);
        $this->maAttributes["YTITLE"] =  new StringAttribute( "YTITLE", false);
        $this->maAttributes["YTITLEFONT"] =  new StringAttribute( "YTITLEFONT", false);
        $this->maAttributes["YTITLECOLOR"] =  new StringAttribute( "YTITLECOLOR", false);
        $this->maAttributes["YLABELFONT"] =  new StringAttribute( "YLABELFONT", false);
        $this->maAttributes["YLABELCOLOR"] =  new StringAttribute( "YLABELCOLOR", false);
        $this->maAttributes["YAXIS2"] =  new BooleanAttribute( "YAXIS2", false);
        $this->maAttributes["YMIN2"] =  new IntegerAttribute( "YMIN2", false);
        $this->maAttributes["YMAX2"] =  new IntegerAttribute( "YMAX2", false);
        $this->maAttributes["YTITLE2"] =  new StringAttribute( "YTITLE2", false);
        $this->maAttributes["YTITLE2COLOR"] =  new StringAttribute( "YTITLE2COLOR", false);
        $this->maAttributes["YLABEL2FONT"] =  new StringAttribute( "YLABEL2FONT", false);
        $this->maAttributes["YLABELFMT"] =  new StringAttribute( "YLABELFMT", false);
        $this->maAttributes["YLABEL2FMT"] =  new StringAttribute( "YLABEL2FMT", false);

        // Pie chart specific options
        $this->maAttributes["PIEPCTTYPE"] =  new StringAttribute( "PIEPCTTYPE", false,
               array("NONE","ABOVE","BELOW","RIGHT","LEFT"));
        $this->maAttributes["PIEPCTFMT"] =  new StringAttribute( "PIEPCTFMT", false);
        $this->maAttributes["PIERADIUS"] =  new IntegerAttribute( "PIERADIUS", false);
        $this->maAttributes["PIELABELFONT"] =  new StringAttribute( "PIELABELFONT", false);

        // Bar chart specific options
        $this->maAttributes["STACKTYPE"] =  new StringAttribute( "STACKTYPE", false, 
               array("DEPTH","SUM", "BESIDE","LAYER"));
        $this->maAttributes["BARWIDTH"] =  new IntegerAttribute( "BARWIDTH", false);
        $this->maAttributes["BARLABELS"] =  new BooleanAttribute( "BARLABELS", false);
        $this->maAttributes["BARLABELFMT"] =  new StringAttribute( "BARLABELFMT", false);

        // Line chart specific options
        $this->maAttributes["LINESTYLES"] =  new StringAttribute( "LINESTYLES", false);

        // Hi lo close chart specific options
        $this->maAttributes["HLCSTYLE"] =  new StringAttribute( "HLCSTYLE", false);
        $this->maAttributes["HLCCAPWIDTH"] =  new IntegerAttribute( "HLCCAPWIDTH", false);

        $this->mnPriority = PRIORITY_LOW;
    }

    function InitDefaults()
    {
        // Mandatory parameters
        if(isset($this->maParams["SHAREDRESOURCENAME"]))
            $this->mszSharedResourceName = $this->maParams["SHAREDRESOURCENAME"];
        if(isset($this->maParams["CHARTTYPE"]))
            $this->mszChartType = $this->maParams["CHARTTYPE"];
        if(isset($this->maParams["VALS"]))
            $this->mszVals = $this->maParams["VALS"];
        if(isset($this->maParams["WIDTH"]))
            $this->mnWidth = $this->maParams["WIDTH"];
        if(isset($this->maParams["HEIGHT"]))
            $this->mnHeight = $this->maParams["HEIGHT"];
        if(isset($this->maParams["BGCOLOR"]))
            $this->mszBGColor = $this->maParams["BGCOLOR"];
        if(isset($this->maParams["TRANSBG"]))
            $this->mbTransBG = (strtoupper($this->maParams["TRANSBG"]) == "TRUE") ? true : false;
        if(isset($this->maParams["LINECOLOR"]))
            $this->mszLineColor = $this->maParams["LINECOLOR"];
        if(isset($this->maParams["GRID"]))
            $this->mbGrid = (strtoupper($this->maParams["GRID"]) == "TRUE") ? true : false;
        if(isset($this->maParams["GRIDCOLOR"]))
            $this->mszGridColor = $this->maParams["GRIDCOLOR"];
        if(isset($this->maParams["IMAGETYPE"]))
            $this->mszImageType = $this->maParams["IMAGETYPE"];
        if(isset($this->maParams["JPEG_QUALITY"]))
            $this->mnJPEGQuality = $this->maParams["JPEG_QUALITY"];
        if(isset($this->maParams["3D"]))
            $this->mb3D = (strtoupper($this->maParams["3D"]) == "TRUE") ? true : false;
        if(isset($this->maParams["3DDEPTH"]))
            $this->mn3DDepth = $this->maParams["3DDEPTH"];
        if(isset($this->maParams["3DANGLE"]))
            $this->mn3DAngle = $this->maParams["3DANGLE"];
        if(isset($this->maParams["PLOTCOLOR"]))
            $this->mszPlotColor = $this->maParams["PLOTCOLOR"];
        if(isset($this->maParams["SETCOLORS"]))
            $this->mszSetColors = $this->maParams["SETCOLORS"];
        if(isset($this->maParams["EXTCOLORS"]))
            $this->mszExtColors = $this->maParams["EXTCOLORS"];
        if(isset($this->maParams["VOLCOLOR"]))
            $this->mszVolColor = $this->maParams["VOLCOLOR"];
        if(isset($this->maParams["TITLE"]))
            $this->mszTitle = $this->maParams["TITLE"];
        if(isset($this->maParams["RTITLE"]))
            $this->mszRTitle = $this->maParams["RTITLE"];
        if(isset($this->maParams["LTITLE"]))
            $this->mszLTitle = $this->maParams["LTITLE"];
        if(isset($this->maParams["TITLECOLOR"]))
            $this->mszTitleColor = $this->maParams["TITLECOLOR"];
        if(isset($this->maParams["TITLEFONT"]))
            $this->mszTitleFont = $this->maParams["TITLEFONT"];

        // X-Axis options
        if (isset($this->maParams["XAXIS"]))
            $this->mbXAxis = (strtoupper($this->maParams["XAXIS"]) == "TRUE") ? true : false;
        if (isset($this->maParams["XTITLE"]))
            $this->mszXTitle = $this->maParams["XTITLE"];
        if (isset($this->maParams["XTITLEFONT"]))
            $this->mszXTitleFont = $this->maParams["XTITLEFONT"];
        if (isset($this->maParams["XTITLECOLOR"]))
            $this->mszXTitleColor = $this->maParams["XTITLECOLOR"];
        if (isset($this->maParams["XLABELS"]))
            $this->mszXLabels = $this->maParams["XLABELS"];
        if (isset($this->maParams["XLABELFONT"]))
            $this->mszXLabelFont = $this->maParams["XLABELFONT"];
        if (isset($this->maParams["XLABELCOLOR"]))
            $this->mszXLabelColor = $this->maParams["XLABELCOLOR"];
        if (isset($this->maParams["XLABELSPACING"]))
            $this->mnXLabelSpacing = $this->maParams["XLABELSPACING"];

        // Y-Axis options
        if (isset($this->maParams["YAXIS"]))
            $this->mbYAxis = (strtoupper($this->maParams["YAXIS"]) == "TRUE") ? true : false;
        if (isset($this->maParams["YSCALETYPE"]))
            $this->mszYScaleType = $this->maParams["YSCALETYPE"];
        if (isset($this->maParams["YMIN"]))
            $this->mnYMin = $this->maParams["YMIN"];
        if (isset($this->maParams["YMAX"]))
            $this->mnYMax = $this->maParams["YMAX"];
        if (isset($this->maParams["YTITLE"])) 
            $this->mszYTitle = $this->maParams["YTITLE"];
        if (isset($this->maParams["YTITLEFONT"])) 
            $this->mszYTitleFont = $this->maParams["YTITLEFONT"];
        if (isset($this->maParams["YTITLECOLOR"])) 
            $this->mszYTitleColor = $this->maParams["YTITLECOLOR"];
        if (isset($this->maParams["YLABELFONT"])) 
            $this->mszYLabelFont = $this->maParams["YLABELFONT"];
        if (isset($this->maParams["YLABELCOLOR"])) 
            $this->mszYLabelColor = $this->maParams["YLABELCOLOR"];
        if (isset($this->maParams["YAXIS2"])) 
            $this->mbYAxis2 = (strtoupper($this->maParams["YAXIS2"]) == "TRUE") ? true : false;
        if (isset($this->maParams["YMIN2"])) 
            $this->mnYMin2 = $this->maParams["YMIN2"];
        if (isset($this->maParams["YMAX2"])) 
            $this->mnYMax2 = $this->maParams["YMAX2"];
        if (isset($this->maParams["YTITLE2"])) 
            $this->mszYTitle2 = $this->maParams["YTITLE2"];
        if (isset($this->maParams["YTITLE2COLOR"])) 
            $this->mszYTitle2Color = $this->maParams["YTITLE2COLOR"];
        if (isset($this->maParams["YLABEL2FONT"])) 
            $this->mszYLabel2Font = $this->maParams["YLABEL2FONT"];
        if (isset($this->maParams["YLABELFMT"])) 
            $this->mszYLabelFMT = $this->maParams["YLABELFMT"];
        if (isset($this->maParams["YLABEL2FMT"])) 
            $this->mszYLabel2FMT = $this->maParams["YLABEL2FMT"];

        // Pie chart specific options
        if (isset($this->maParams["PIEPCTTYPE"])) 
            $this->mszPiePCTType = $this->maParams["PIEPCTTYPE"];
        if (isset($this->maParams["PIEPCTFMT"])) 
            $this->mszPiePCTFMT = $this->maParams["PIEPCTFMT"];
        if (isset($this->maParams["PIERADIUS"])) 
            $this->mnPieRadius = $this->maParams["PIERADIUS"];
        if (isset($this->maParams["PIELABELFONT"])) 
            $this->mszPieLabelFont = $this->maParams["PIELABELFONT"];

        // Bar chart specific options
        if (isset($this->maParams["STACKTYPE"])) 
            $this->mszStackType = $this->maParams["STACKTYPE"];
        if (isset($this->maParams["BARWIDTH"])) 
            $this->mnBarWidth = $this->maParams["BARWIDTH"];
        if(isset($this->maParams["BARLABELS"]))
            $this->mbBarLabels = (strtoupper($this->maParams["BARLABELS"]) == "TRUE") ? true : false;
        if(isset($this->maParams["BARLABELFMT"]))
            $this->mszBarLabelFmt = $this->maParams["BARLABELFMT"];

        // Line chart specific options
        if (isset($this->maParams["LINESTYLES"])) 
            $this->mszLineStyles = $this->maParams["LINESTYLES"];

        // Hi lo close chart specific options
        if (isset($this->maParams["HLCSTYLE"])) 
            $this->mszHLCStyle = $this->maParams["HLCSTYLE"];
        if (isset($this->maParams["HLCCAPWIDTH"])) 
            $this->mnHLCCapWidth = $this->maParams["HLCCAPWIDTH"];

        return parent::InitDefaults();
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        $oSR =& $this->maSharedResourceWidgets[$this->mszSharedResourceName];

        $aParam = array();
        $this->mnNumPoints = 0;
        foreach($oSR as $aRow)
        {
            foreach($aRow as $szKey => $szVal)
            {
                if (!isset($aParam[$szKey]))
                    $aParam[$szKey] = array();

                array_push($aParam[$szKey], $szVal);
            }
            $this->mnNumPoints++;
        }

        $aVals = explode("!", $this->mszVals);
        $this->mnNumSets = 0;
        foreach($aVals as $szVals)
        {
            $szVals = substr($szVals, 1, -1);
            if (isset($aParam[$szVals]))
            {
                $this->mszVals = str_replace("[".$szVals."]", implode("!", $aParam[$szVals]), $this->mszVals);
                $this->mnNumSets++;
            }
        }

        $aXLabels = explode(";", $this->mszXLabels);
        foreach($aXLabels as $szXLabels)
            if (isset($aParam[$szXLabels]))
                $this->mszXLabels = str_replace($szXLabels, implode(";", 
                                                $aParam[$szXLabels]), $this->mszXLabels);

        $szReturn = "";
        
        $szReturn = "<IMG SRC=\"";
        $szReturn.= $this->mszBaseOWT."?";
        $szReturn.= "ImageType=".urlencode($this->mszImageType)."&";
        $szReturn.= "Type=".urlencode((($this->mb3D) ? "3D" : "").$this->mszChartType)."&";
        $szReturn.= "Title=".urlencode($this->mszTitle)."&";
        $szReturn.= "RTitle=".urlencode($this->mszRTitle)."&";
        $szReturn.= "LTitle=".urlencode($this->mszLTitle)."&";
        $szReturn.= "TitleColor=".urlencode($this->mszTitleColor)."&";
        $szReturn.= "TitleFont=".urlencode($this->mszTitleFont)."&";
        $szReturn.= "W=".urlencode($this->mnWidth)."&";
        $szReturn.= "H=".urlencode($this->mnHeight)."&";
        $szReturn.= "NumPts=".urlencode($this->mnNumPoints)."&";
        $szReturn.= "NumSets=".urlencode($this->mnNumSets)."&";
        $szReturn.= "Vals=".urlencode($this->mszVals)."&";
        $szReturn.= "XAxis=".urlencode((($this->mbXAxis) ? "1" : "0"))."&";
        $szReturn.= "XLabels=".urlencode($this->mszXLabels)."&";
        $szReturn.= "XTitle=".urlencode($this->mszXTitle)."&";
        $szReturn.= "XTitleColor=".urlencode($this->mszXTitleColor)."&";
        $szReturn.= "XTitleFont=".urlencode($this->mszXTitleFont)."&";
        $szReturn.= "XLabelFont=".urlencode($this->mszXLabelFont)."&";
        $szReturn.= "XLabelColor=".urlencode($this->mszXLabelColor)."&";
        $szReturn.= "XLabelSpacing=".urlencode($this->mszXLabelSpacing)."&";
        $szReturn.= "YAxis=".urlencode((($this->mbYAxis) ? "1" : "0"))."&";
        $szReturn.= "YAxis2=".urlencode((($this->mbYAxis2) ? "1" : "0"))."&";
        $szReturn.= "YLabelFont=".urlencode($this->mszYLabelFont)."&";
        $szReturn.= "YLabelFmt=".urlencode($this->mszYLabelFmt)."&";
        $szReturn.= "YLabelFmt2=".urlencode($this->mszYLabelFmt2)."&";
        $szReturn.= "YLabelColor=".urlencode($this->mszYLabelColor)."&";
        $szReturn.= "YTitle=".urlencode($this->mszYTitle)."&";
        $szReturn.= "YTitleColor=".urlencode($this->mszYTitleColor)."&";
        $szReturn.= "YTitleFont=".urlencode($this->mszYTitleFont)."&";
        $szReturn.= "YTitle2=".urlencode($this->mszYTitle2)."&";
        $szReturn.= "YTitleColor2=".urlencode($this->mszYTitleColor2)."&";
        $szReturn.= "YTitleFont2=".urlencode($this->mszYTitleFont2)."&";
        $szReturn.= "YScaleType=".urlencode($this->mszYScaleType)."&";
        $szReturn.= "YMin=".urlencode($this->mnYMin)."&";
        $szReturn.= "YMax=".urlencode($this->mnYMax)."&";
        $szReturn.= "YMin2=".urlencode($this->mnYMin2)."&";
        $szReturn.= "YMax2=".urlencode($this->mnYMax2)."&";
        $szReturn.= "PiePCTType=".urlencode($this->mszPiePCTType)."&";
        $szReturn.= "PiePCTFmt=".urlencode($this->mszPiePCTFmt)."&";
        $szReturn.= "PieRadius=".urlencode($this->mnPieRadius)."&";
        $szReturn.= "PieLabelFont=".urlencode($this->mszPieLabelFont)."&";
        $szReturn.= "BarWidth=".urlencode($this->mnBarWidth)."&";
        $szReturn.= "BarLabels=".urlencode(($this->mbBarLabels)?"1" : "0")."&";
        $szReturn.= "BarLabelFmt=".urlencode($this->mszBarLabelFmt)."&";
        $szReturn.= "LineStyles=".urlencode($this->mszLineStyles)."&";
        $szReturn.= "HLCStyle=".urlencode($this->mszHLCStyle)."&";
        $szReturn.= "HLCCapWidth=".urlencode($this->mnHLCCapWidth)."&";
        $szReturn.= "StackType=".urlencode($this->mszStackType)."&";
        $szReturn.= "SetColors=".urlencode($this->mszSetColors)."&";
        $szReturn.= "BGColors=".urlencode($this->mszBGColor)."&";
        $szReturn.= "TransBG=".urlencode((($this->mbTransBG) ? "1" : "0"))."&";
        $szReturn.= "LineColor=".urlencode($this->mszLineColor)."&";
        $szReturn.= "Grid=".urlencode((($this->mbGrid) ? "1" : "0"))."&";
        $szReturn.= "3DDepth=".urlencode($this->mn3DDepth)."&";
        $szReturn.= "3DAngle=".urlencode($this->mn3DAngle)."&";
        $szReturn.= "PlotColor=".urlencode($this->mszPlotColor)."&";
        $szReturn.= "ExtColors=".urlencode($this->mszExtColors)."&";
        $szReturn.= "VolColor=".urlencode($this->mszVolColor)."&";
        $szReturn.= "\">";         
        return $szReturn;
    }
}
?>
