<?php
/**
 * Nav tool base class
 *
 * @project     CWC2
 * @revision    $Id: NavTool.php,v 1.38 2004/05/21 01:13:54 pspencer Exp $
 * @purpose     LegendPopup Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once("Widget.php");
include_once("Button.php");
include_once( COMMON."wrapper/map_navigator.php" );

/**
 * class NavTool is a common base class for widgets that want to navigate
 * and might be part of a toolset
 */
class NavTool extends CWCWidget
{
    var $moButton;
    var $mszCmd = "";
    var $moMapNavigator;
    var $mnAllowRectangle = 0;
    var $mbSubmitOnClick = 0;
    var $mszMapId = "DEFAULT_MAP";
    var $mszCursorType = "AUTO";

    /**
     * construct a new navtool
     */
    function NavTool()
    {
        if($this->mszLanguageResource == "")
            $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/NavTool.dbf";

        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the description for this widget
        $this->szWidgetDescription = "No description available.  Please set ".
                        "this description in the constructor of this class.";

        $this->moButton =& new CWCButton($this);
        $this->maAttributes["DEFAULT"] = new BooleanAttribute( "DEFAULT", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );
        $this->maAttributes["MAPID"] = new StringAttribute( "MAPID", false );

        $this->mnPriority = PRIORITY_LOW;
    }

    /**
     * initialize default values from tag
     */
    function InitDefaults()
    {
        parent::InitDefaults();

        if ($this->mbVisible)
        {
            $this->moButton->InitDefaults();
        }
        else
            $this->maParams["IMAGE"] = "DUMMY";

        if (isset($this->maParams["MAPID"]))
            $this->maszMapId = $this->maParams["MAPID"];

        if (isset($this->maParams["CURSORTYPE"]))
            $this->mszCursorType = $this->maParams["CURSORTYPE"];
    }


    /**
     * set the command this tool uses to navigate
     */
    function SetNavCommand($szNavCmd)
    {
        $this->mszCmd = $szNavCmd;
    }


    /**
     * set the map navigator for this nav tool
     */
    function SetMap(&$oMapSession)
    {
        $this->moMapObject =& $oMapSession;

        $this->moMapNavigator = new MapNavigator( $oMapSession );
    }


    /**
     * return javascript functions required for this tool
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptFunctions();
        else
            $aReturn = array();

        $szJsFunctionName = "NavSetActiveTool";
        $szFunction = <<<EOT
/**
 * set the active navigation tool
 */
function {$szJsFunctionName}( oButton, aVals )
{
    var nTool = aVals[0];
    var sTool = aVals[1];
    var bAllowRectangle = (aVals[2] == 0 || aVals[2] == "0") ? false : true;
    var bAutoSubmit = (aVals[3] == 0 || aVals[3] == "0") ? false : true;
    var szCursorType = aVals[4];

    {$this->mszHTMLForm}.NAV_CMD.value = sTool;
    {$this->mszHTMLForm}.NAV_ALLOW_RECTANGLE.value=bAllowRectangle;

    if ({$bCWCJSAPI})
    {
        goCWCJSAPI.NAV_CMD = sTool;
    }

    if (bAutoSubmit)
    {
        if ({$bCWCJSAPI})
        {
            goCWCJSAPI.UpdateNavTools();
        }
        else
        {
            {$this->mszHTMLForm}.submit();
        }    
    }

    if ({$this->mszHTMLForm}.CURSOR_TYPE != null)
    {
      {$this->mszHTMLForm}.CURSOR_TYPE.value = szCursorType;
    }
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
        {        
            return $this->moButton->GetJavascriptInitFunctions();
        }
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        
        return $aReturn;
    }
    
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        return $aReturn;
    }

    /**
     * handle the user using this tool as part of a toolset
     */
    function  ParseURL()
    {
        $aVals = array();
        array_push( $aVals, $this->mnId );
        array_push( $aVals, $this->mszCmd );
        array_push( $aVals, $this->mnAllowRectangle );
        array_push( $aVals, $this->mbSubmitOnClick );
        array_push( $aVals, $this->mszCursorType );

        $this->moButton->SetOnClick('NavSetActiveTool', $aVals);


        if ($this->isVarSet( strtoupper($this->mszMapId)."_X" ) &&
            $this->isVarSet( strtoupper($this->mszMapId)."_Y" ))
        {
            $this->setVar( "NAV_INPUT_COORDINATES" , 
                           $this->getVar( strtoupper($this->mszMapId)."_X" ).",".
                           $this->getVar( strtoupper($this->mszMapId)."_Y" ) );
        }
        
        $this->moButton->ParseURL();

        return true;
    }

    /**
     * return hidden variables required for this tool
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szVariable = "NAV_CMD";
        $szTool = '';
        if ($this->isVarSet( 'NAV_CMD' ))
            $szTool = $this->getVar( 'NAV_CMD' );

        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$szTool."\">";
        $aReturn[$szVariable] = $szValue;

        $szAllowRect = "";
         if ($this->isVarSet( "NAV_ALLOW_RECTANGLE" ))
          $szAllowRect = $this->getVar( "NAV_ALLOW_RECTANGLE" );

        $szVariable = "NAV_ALLOW_RECTANGLE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szAllowRect\">";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }


    /**
     * draw this widget on the page
     */
    function DrawPublish()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        if (!$this->mbVisible)
            return "<!-- NavTool hidden -->";

        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
