<?php
/**
 * MapUnits Widget class
 *
 * @project     CWC2
 * @revision    $Id: MapUnits.widget.php,v 1.3 2004/07/08 15:58:58 pspencer Exp $
 * @purpose     MapUnits Widget class
 * @author      DM Solutions Group (pspencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * MapUnits
 *
 * Display the map units as a label
 */
class MapUnits extends CWCWidget
{
    var $moLabel;
    var $mszClass = "CWCMapUnitClass";
    var $mszStyle = "";

    /**
     * construct a new map units label widget
     */
    function MapUnits()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/MapUnits.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The MapUnits widget displays the current map units as a label on the page.
EOT;

        $this->moLabel = new CWCLabel($this);
        $this->maAttributes["WIDGETCLASS"] = new StringAttribute( "WIDGETCLASS", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );

    }

    /**
     * initialize default values
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["WIDGETCLASS"]))
            $this->mszClass = strtoupper($this->maParams["WIDGETCLASS"]);
        if (isset($this->maParams["WIDGETSTYLE"]))
            $this->mszStyle = strtoupper($this->maParams["WIDGETSTYLE"]);
    }


    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- MapUnits widget hidden -->";

        $nUnits = $this->moMapObject->oMap->units;
        $szUnits = "";

        switch ($nUnits)
        {
            case MS_INCHES:
              $szUnits = trim($this->moMLT->get("0", "Inches"));
              break;

            case MS_FEET:
               $szUnits = trim($this->moMLT->get("1", "Feets"));
              break;

            case MS_MILES:
              $szUnits = trim($this->moMLT->get("2", "Miles"));
              break;

            case MS_METERS:
              $szUnits = trim($this->moMLT->get("3", "Meters"));
              break;

            case MS_KILOMETERS:
              $szUnits = trim($this->moMLT->get("4", "Kilometers"));
              break;

            case MS_DD:
              $szUnits = trim($this->moMLT->get("5", "Degrees"));
              break;

            case MS_PIXELS:
              $szUnits = trim($this->moMLT->get("6", "Pixels"));
              break;
        }

        $szClass = $this->mszClass;
        $szStyle = $this->mszStyle;
        if ( strlen($this->mszClass) > 0 )
            $szClass = " CLASS=\"$this->mszClass\"";
        if ( strlen($this->mszStyle) > 0 )
            $szClass = " STYLE=\"$this->mszStyle\"";

        //put together the result
        $szUnits = "<P$szClass$szStyle>".$szUnits."</P>";

        //and put a label next to it if necessary
        return $this->moLabel->DrawPublish( $szUnits );
    }
}

if ((function_exists( "RegisterWidget" )))
    RegisterWidget( "MapUnits", "MapUnitsWidget" );
?>
