<?php
/**
 * Base Widget class
 *
 * @project     CWC2
 * @revision    $Id: MapImageStatic.widget.php,v 1.1 2004/04/23 16:49:04 pspencer Exp $
 * @purpose     Base Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once("MapImageWidget.widget.php");

/**
 * MapImageStatic
 *
 * @desc Map image widget. Provides a single click on the map and
 * updates the NAV_INPUT_COORD parameter.
 */
class MapImageStatic extends MapImageWidget
{
    var   $msAnchorName = "mapanchor";
    var   $mnWidth;
    var   $mnHeight;

    function MapImageStatic()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the description for this widget
        $this->szWidgetDescription= "This widget display a simple non navigable map";

        $this->mnPriority = PRIORITY_HIGH;

    }

 /**
     * initialize respectable defaults for the map
     */
    function InitDefaults()
    {
        parent::InitDefaults();
    }

/**
     * DrawPublish
     *
     * Draw the map and return the HTML.
     */
    function DrawPublish()
    {

        $szReturn = parent::DrawPublish();


        return $szReturn;
    }


    /**
     * GetJavascriptOnLoadFunctions
     *
     * On load functions.
     */
    function GetJavascriptOnLoadFunctions()
    {
        $oMap = $this->moMapObject->oMap;



        return parent::GetJavascriptOnLoadFunctions();
    }

}
?>
