<?php
/**
 * Base Widget class
 *
 * @project     CWC2
 * @revision    $Id: MapDHTMLWidget.widget.php,v 1.8 2004/07/08 15:58:58 pspencer Exp $
 * @purpose     Base Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");

/**
 * MapDHTMLWidget provides a DHTML enabled mapping interface and the javascript
 * functions for doing javascript-based navigation.
 */
class MapDHTMLWidget extends CWCWidget
{
    var $msAnchorName = "mapanchor";
    var $msMapImageName = "mapimage";
    var $mszMarqueeColor = "RED";
    var $mnMarqueeWidth = 1;
    var $mszMarqueeImageHorizontal = "";
    var $mszMarqueeImageVertical = "";
    var $mszURL = "";
    var $mbAllowResize = 1;
    var $mfMinScale = 1;
    var $mfMaxScale = -1;
    var $mszWaitImage = "";
    var $mnWaitImageWidth = 0;
    var $mnWaitImageHeight = 0;
    var $mszMapOriginalExtents = "";
    var $mszMapOriginalProjection = "";

    function MapDHTMLWidget()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // init vars
        $this->mszMarqueeImageHorizontal = $_SESSION['gszCoreWebPath'].'/skins/default/images/a_pixel.gif';
        $this->mszMarqueeImageVertical = $_SESSION['gszCoreWebPath'].'/skins/default/images/a_pixel.gif';
        
        $this->mnPriority = PRIORITY_SUPER;
        $this->maAttributes["MARQUEECOLOR"] = new HexColorAttribute( "MARQUEECOLOR", false );
        $this->maAttributes["MARQUEEWIDTH"] = new IntegerAttribute( "MARQUEEWIDTH", false, 0 );
        $this->maAttributes["MARQUEEVERTICALIMAGE"] = new StringAttribute( "MARQUEEVERTICALIMAGE", false);
        $this->maAttributes["MARQUEEHORIZONTALIMAGE"] = new StringAttribute( "MARQUEEHORIZONTALIMAGE", false);
        $this->maAttributes["MINSCALE"] = new FloatAttribute( "MINSCALE", false);
        $this->maAttributes["MAXSCALE"] = new FloatAttribute( "MAXSCALE", false);
        $this->maAttributes["ALLOWRESIZE"] = new BooleanAttribute( "ALLOWRESIZE", false);
        $this->maAttributes["WIDTH"] = new IntegerAttribute( "WIDTH", true, 0 );
        $this->maAttributes["HEIGHT"] = new IntegerAttribute( "HEIGHT", true, 0 );
        $this->maAttributes["WAITIMAGE"] = new StringAttribute( "WAITIMAGE", false);
        $this->maAttributes["WAITIMAGEWIDTH"] = new IntegerAttribute( "WAITIMAGEWIDTH", false, 0 );
        $this->maAttributes["WAITIMAGEHEIGHT"] = new IntegerAttribute( "WAITIMAGEHEIGHT", false, 0 );
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The MapDHTML widget displays the actual visualization of the current context
and provides many of the mechanisms for other tools to do their job, primarily
the navigation tools.
EOT;
    }

    /**
     * initialize respectable defaults for the map
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["MARQUEECOLOR"]))
            $this->mszMarqueeColor = $this->maParams["MARQUEECOLOR"];
        if (isset($this->maParams["MARQUEEWIDTH"]))
            $this->mnMarqueeWidth = $this->maParams["MARQUEEWIDTH"];
        if (isset($this->maParams["MARQUEEHORIZONTALIMAGE"]))
            $this->mszMarqueeImageHorizontal = $this->maParams["MARQUEEHORIZONTALIMAGE"];
        if (isset($this->maParams["MARQUEEVERTICALIMAGE"]))
            $this->mszMarqueeImageVertical = $this->maParams["MARQUEEVERTICALIMAGE"];
        if (isset($this->maParams["MINSCALE"]))
            $this->mfMinScale = $this->maParams["MINSCALE"];
        if (isset($this->maParams["MAXSCALE"]))
            $this->mfMaxScale = $this->maParams["MAXSCALE"];

        //now check the widget attributes to see if it is overridden
        if (isset($this->maParams["WAITIMAGE"]))
            $this->mszWaitImage = $this->maParams["WAITIMAGE"];
        if (isset($this->maParams["WAITIMAGEWIDTH"]))
            $this->mnWaitImageWidth = $this->maParams["WAITIMAGEWIDTH"];
        if (isset($this->maParams["WAITIMAGEHEIGHT"]))
            $this->mnWaitImageHeight = $this->maParams["WAITIMAGEHEIGHT"];

        $this->mbAllowResize = true;
        $szAllowResize = "true";
        if (isset($this->maParams["ALLOWRESIZE"]))
            $szAllowResize = $this->maParams["ALLOWRESIZE"];
        if (strcasecmp( $szAllowResize , "false" ) == 0)
        {
            $this->mbAllowResize = 0;
        }
        
        $this->mszURL = $_SESSION['gszCoreWebPath']."/skins/default/images/a_pixel.gif";
    }

    /**
     * handle changes coming from the URL.  In this case, we only want
     * to verify that the map size is valid
     */
    function ParseURL()
    {
        $oMap = $this->moMapObject->oMap;

        if ($this->isVarSet( 'MAP_ORIGINAL_EXTENTS' ))
            $this->mszMapOriginalExtents = $this->getVar( 'MAP_ORIGINAL_EXTENTS' );

        if ($this->mszMapOriginalExtents == "")
        {
            $this->mszMapOriginalExtents = $oMap->extent->minx;
            $this->mszMapOriginalExtents .= ",".$oMap->extent->miny;
            $this->mszMapOriginalExtents .= ",".$oMap->extent->maxx;
            $this->mszMapOriginalExtents .= ",".$oMap->extent->maxy;
        }

        if ($this->isVarSet( 'MAP_ORIGINAL_PROJ' ))
            $this->mszMapOriginalProjection = $this->getVar( 'MAP_ORIGINAL_PROJ' );

        if ($this->mszMapOriginalProjection == "" && $oMap->getprojection() != "")
            $this->mszMapOriginalProjection = $oMap->getprojection();

        if (!$this->mbAllowResize)
        {
            if (isset($this->maParams["WIDTH"]))
                $nWidth = $this->maParams["WIDTH"];
            if (isset($this->maParams["HEIGHT"]))
                $nHeight = $this->maParams["HEIGHT"];
            $this->moMapObject->oMap->set("width", $nWidth);
            $this->moMapObject->oMap->set("height", $nHeight);
        }
        else
        {
            if ($this->isVarSet( "MAP_WIDTH" ) &&
                $this->getVar( "MAP_WIDTH" ) != "" &&
                $this->getVar( "MAP_WIDTH" ) > 0 &&
                $this->isVarSet( "MAP_HEIGHT" ) &&
                $this->getVar( "MAP_HEIGHT" ) != "" &&
                $this->getVar( "MAP_HEIGHT" ) > 0)
            {
                $this->moMapObject->oMap->set("width",
                                              $this->getVar( "MAP_WIDTH" ));
                $this->moMapObject->oMap->set("height",
                                              $this->getVar( "MAP_HEIGHT" ));
            }
        }
        if ($this->isVarSet( 'MAP_EXTENTS_MINX' ) && ($this->getVar( 'MAP_EXTENTS_MINX' ) != "") &&
            $this->isVarSet( 'MAP_EXTENTS_MINY' ) && ($this->getVar( 'MAP_EXTENTS_MINY' ) != "") &&
            $this->isVarSet( 'MAP_EXTENTS_MAXX' ) && ($this->getVar( 'MAP_EXTENTS_MAXX' ) != "") &&
            $this->isVarSet( 'MAP_EXTENTS_MAXY' ) && ($this->getVar( 'MAP_EXTENTS_MAXY' ) != "") )
        {
            $this->moMapObject->oMap->setExtent(
                                      $this->getVar( 'MAP_EXTENTS_MINX' ),
                                      $this->getVar( 'MAP_EXTENTS_MINY' ),
                                      $this->getVar( 'MAP_EXTENTS_MAXX' ),
                                      $this->getVar( 'MAP_EXTENTS_MAXY' ));
        }
        
        // return success
        return true;
    }

    /**
     * draw the map DHTML widget interface
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- Map hidden -->";

        $poMap = $this->moMapObject->oMap;

        $nWidth = $poMap->width;
        $nHeight = $poMap->height;
        if (!$this->mbAllowResize)
        {
            if (isset($this->maParams["WIDTH"]))
                $nWidth = $this->maParams["WIDTH"];
            if (isset($this->maParams["HEIGHT"]))
                $nHeight = $this->maParams["HEIGHT"];
            $poMap->set("width", $nWidth);
            $poMap->set("height", $nHeight);
        }

        $nScale = $poMap->scale;
        $bZoomScale = false;
        if ($this->mfMinScale > 0 && $nScale < $this->mfMinScale)
        {
            $nScale = $this->mfMinScale;
            $bZoomScale = true;
        }
        elseif ($this->mfMaxScale > 0 && $nScale > $this->mfMaxScale)
        {
            $nScale = $this->mfMaxScale;
            $bZoomScale = true;
        }
        if( $bZoomScale )
        {
            $oNav = new MapNavigator( $this->moMapObject );
            $oNav->zoomScale( $nScale );
        }
        
        $szAPixel = $_SESSION['gszCoreWebPath'].'/skins/default/images/a_pixel.gif';

        $szReturn = <<<EOT
<table cellpadding="0" cellspacing="0" border="0">
<tr>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1" id="mapFrameTL" name="mapFrameTL"></td>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1"></td>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1" id="mapFrameTR" name="mapFrameTR"></td>
  </tr>
  <tr>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1"></td>
    <td><a name="mapanchor" ><IMG SRC="{$this->mszURL}" WIDTH="{$nWidth}" HEIGHT="{$nHeight}" NAME="{$this->msMapImageName}" id="{$this->msMapImageName}" border="0"></a></td>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1"></td>
  </tr>
  <tr>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1" id="mapFrameBL" name="mapFrameBL"></td>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1"></td>
    <td bgcolor="000000"><img src="{$szAPixel}" width="1" height="1" id="mapFrameBR" name="mapFrameBR"></td>
  </tr>
</table>
EOT;
        return $szReturn;
    }


    /**
     * GetJavascriptOnMouseMoveFunctions
     *
     * Returns functions to be called on mouse mouve event.
     */
    function GetJavascriptOnMouseMoveFunctions()
    {
        $aReturn = array();
        $szJsFunctionName = "MapWgetMouse";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptOnMouseUpFunctions.
     *
     */
    function GetJavascriptOnMouseUpFunctions2()
    {
        $aReturn = array();
        $szJsFunctionName = "MapWchkMouseUp";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptOnMouseDownFunctions
     *
     */
    function GetJavascriptOnMouseDownFunctions2()
    {
        $aReturn = array();
        $szJsFunctionName = "MapWmapTool";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }


    /**
     * GetJavascriptOnLoadFunctions
     *
     * On load functions.
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();
        
        $aReturn['MapLayerDivImgOnLoad'] = "MapLayerDivImgOnLoad();\n";

        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
        {
             $szJsFunctionName = "MapWRegisterForEvent";
             $szFunction = "$szJsFunctionName();\n";
             $aReturn[$szJsFunctionName] = $szFunction;
        }

        $szJsFunctionName = "MapWPositionMapDHTML";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }



    /**
     * GetJavascriptInitFunctions
     *
     * Functions to be called at the end of the load.
     */
    function GetJavascriptInitFunctions()
    {
        $aReturn = array();

        $szVariable = "gMapDHTMLForm";
        $szValue = "var $szVariable = {$this->mszHTMLForm};\n";
        $aReturn[$szVariable] = $szValue;

        $szJsFunctionName = "MapWidgetInitVariables";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptIncludeFunctions
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = parent::GetJavascriptIncludeFunctions();

        $szJsIncludeName = "cwc_dhtml.js";
        $szInclude = '<script language="JavaScript" src="'.$_SESSION["gszCoreWebPath"]."/widgets/js/cwc_dhtml.js".'"></script>';
        $aReturn[$szJsIncludeName] = $szInclude;

        $szJsIncludeName = "MapDHTMLWidget.js";
        $szInclude = '<script language="JavaScript" src="'.$_SESSION["gszCoreWebPath"]."/widgets/MapDHTMLWidget/MapDHTMLWidget.js".'"></script>';
        $aReturn[$szJsIncludeName] = $szInclude;

        return $aReturn;     
    }

    /**
     * GetJavascriptVariables
     *
     * Return JS global variables and global code.
     */
    function GetJavascriptVariables()
    {
        $aReturn = array();


        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;
          
        $szVariable = "gCWCJSAPI";
        $szValue = "var $szVariable = $bCWCJSAPI;";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "gAPixel";
        $szValue = "var $szVariable = '".$_SESSION['gszCoreWebPath'].'/skins/default/images/a_pixel.gif'."';";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gMapWiWidth";
        $szValue = "var $szVariable = ".$this->moMapObject->oMap->width.";";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gMapWiHeight";
        $szValue = "var $szVariable = ".$this->moMapObject->oMap->height.";";
        $aReturn[$szVariable] = $szValue;
        
        $oApp = GetChameleonApplication();
        if ($this->mszWaitImage == "" || $this->mnWaitImageWidth == 0 || $this->mnWaitImageHeight == 0 )
        {
            if (isset($this->maSharedResourceWidgets["WaitImage"]->maszContents["WAITIMAGE"]))
            {
                foreach($this->maSharedResourceWidgets["WaitImage"]->maszContents["WAITIMAGE"] as $aWaitImage)
                {
                    if (isset($aWaitImage["LANGUAGE"]) && $aWaitImage["LANGUAGE"] == $_SESSION["gszCurrentLanguage"])
                    {
                        if (isset($aWaitImage["WAITIMAGE"]))
                        {
                            $this->mszWaitImage = $oApp->findFile($aWaitImage["WAITIMAGE"]);
                            $this->mszWaitImage = $oApp->fileSystemToURL( $this->mszWaitImage );
                        }
                        if (isset($aWaitImage["WAITIMAGEWIDTH"]))
                            $this->mnWaitImageWidth = $aWaitImage["WAITIMAGEWIDTH"];
                        if (isset($aWaitImage["WAITIMAGEHEIGHT"]))
                            $this->mnWaitImageHeight = $aWaitImage["WAITIMAGEHEIGHT"];

                    }
                }
            }
        }

        $waitImage = $this->mszWaitImage;
        if ($waitImage == "")
            $waitImage = $_SESSION['gszCoreWebPath']."/skins/default/images/a_pixel.gif";

        $waitWidth = $this->mnWaitImageWidth;
        if ($waitWidth == 0)
            $waitWidth = 1;

        $waitHeight = $this->mnWaitImageHeight;
        if ($waitHeight == 0)
            $waitHeight = 1;

        $szVariable = "gMapDHTMLWaitImage";
        $szValue = "var $szVariable = '".$waitImage."';";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "gMapDHTMLWaitImageWidth";
        $szValue = "var $szVariable = ".$waitWidth.";";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gMapDHTMLWaitImageHeight";
        $szValue = "var $szVariable = ".$waitHeight.";";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "gMapDHTMLVerticalMarquee";
        $szValue = "var $szVariable = '".$this->mszMarqueeImageVertical."';";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "gMapDHTMLHorizontalMarquee";
        $szValue = "var $szVariable = '".$this->mszMarqueeImageHorizontal."';";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "gMapDHTMLMarqueeWidth";
        $szValue = "var $szVariable = ".$this->mnMarqueeWidth.";";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "gMapDHTMLMarqueeColor";
        $szValue = "var $szVariable = '".$this->mszMarqueeColor."';";
        $aReturn[$szVariable] = $szValue;
        
        if (isset($_SESSION['gnMapSessionMode']))
        {
            $nMapSessionMode = $_SESSION['gnMapSessionMode'];
        }
        else
        {
            $nMapSessionMode = 1;
        }    
        $szFatalImage = $this->getValue("FatalErrorImage");
        if ($szFatalImage != "")
            $szFatalImage = "&szFatalErrorImage=".$szFatalImage;        
        $url = WEBCOMMON."/wrapper/drawmap.php?map_session_mode=$nMapSessionMode&run_query=0&".SID.$szFatalImage;
        if (!$bCWCJSAPI)
         $url .= "&dummy=".urlencode(microtime());
                 
        $szVariable = "gMapDHTMLURL";
        $szValue = "var $szVariable = '".$url."';";
        $aReturn[$szVariable] = $szValue;
                 
        $szVariable = "gMapDHTMLAllowResize";
        $szValue = "var $szVariable = ".$this->mbAllowResize.";";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * GetHTMLHiddenVariables
     *
     * Return HTML hidden variables.
     */
    function GetHTMLHiddenVariables()
    {
        $szVariable = "NAV_INPUT_TYPE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "NAV_INPUT_COORDINATES";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;


        $poMap = $this->moMapObject->oMap;

        $szVariable = "MAP_EXTENTS_MINX";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$poMap->extent->minx."\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_EXTENTS_MINY";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$poMap->extent->miny."\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_EXTENTS_MAXX";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$poMap->extent->maxx."\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_EXTENTS_MAXY";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$poMap->extent->maxy."\">\n";
        $aReturn[$szVariable] = $szValue;

        $nWidth = $poMap->width;
        $nHeight = $poMap->height;

        $szVariable = "MAP_WIDTH";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$nWidth\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_HEIGHT";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$nHeight\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_CURSOR_POS_X";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_CURSOR_POS_Y";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        //added NAV_CMD because it is used in the mapdhtml. It was
        //initially created only by the nav tools and could cause
        //a js error if there is no nav tool.
        $szCmd = '';
        if ($this->isVarSet('NAV_CMD'))
            $szCmd = $this->getVar('NAV_CMD');
        $szVariable = "NAV_CMD";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_ORIGINAL_EXTENTS";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$this->mszMapOriginalExtents."\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "MAP_ORIGINAL_PROJ";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"".$this->mszMapOriginalProjection."\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "CURSOR_TYPE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }
}
?>
