<?php
/**
 * Link Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     Link Popup Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * a simple widget to link to another page
 */
class Link extends CWCWidget
{
    var $moButton;
    var $mbPopup = false;
    var $mszHref = null;
    var $mszLinkType = "HREF";
    var $maszJSFunctions = array();

    /**
     * construct a new link widget
     */
    function Link()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Link widget allows the template to display a button that will open an
arbitrary URL such as a help page for an application.
EOT;

        $this->moButton = new CWCButton($this);
        $this->maAttributes["LINKTYPE"] = new StringAttribute( "LINKTYPE", true, array( "HREF", "JAVASCRIPT" ) );
        
        $this->maAttributes["JSFUNCTION"] = new StringAttribute( "JSFUNCTION", false );
        $this->maAttributes["JSPARAMS"] = new StringAttribute( "JSPARAMS", false );
        
        $this->maAttributes["HREF"] = new StringAttribute( "HREF", false );
        $this->maAttributes["APPENDGET"] = new BooleanAttribute(
                                                       "APPENDGET", false );
        $this->maAttributes["APPENDSID"] = new BooleanAttribute("APPENDSID", false );
        $this->maAttributes["TARGET"] = new StringAttribute("TARGET", false );
    }

    /**
     * initialize default values
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        $this->moButton->InitDefaults();
        if (isset($this->maParams['LINKTYPE']))
        {
            $this->mszLinkType = strtoupper($this->maParams['LINKTYPE']);
        }
        
        if ($this->mszLinkType == "HREF")
        {
            $szHref = $this->maParams["HREF"];

            $aszHrefParams = array();
            if (strpos($szHref, "?") !== false)
                $aszHrefParams = explode("&",substr(strstr($szHref, "?"), 1));

            if (isset($this->maParams["APPENDGET"]) &&
                strcasecmp($this->maParams["APPENDGET"],"true") == 0)
            {
                $szGET = "";
                foreach($GLOBALS["_GET"] as $szKey => $szVal)
                {
                    // Check all get var if it was set in user link
                    // dont overwrite it.
                    $bFound=false;
                    foreach($aszHrefParams as $szParams)
                    {
                        $aszParams = explode("=", $szParams);
                        if ($aszParams[0] == $szKey)
                            $bFound = true;
                    }

                    if (!$bFound)
                        $szGET .= "$szKey=".urlencode($szVal)."&";
                }

                if (substr($szHref, -1) == "?" ||
                    substr($szHref, -1) == "&")
                    $szHref .= $szGET;
                else
                if (strpos($szHref, "?") !== false)
                {
                    $szHref .= "&$szGET";
                }
                else
                    $szHref .= "?$szGET";
            }

            if (isset($this->maParams["APPENDSID"]) &&
                strcasecmp($this->maParams["APPENDSID"],"true") == 0)
            {
                if (substr($szHref, -1) == "?" ||
                    substr($szHref, -1) == "&")
                    $szHref .= SID;
                else
                if (strpos($szHref, "?") !== false)
                    $szHref .= "&".SID;
                else
                    $szHref .= "?".SID;
            }

            $szTarget = "";
            if (isset($this->maParams["TARGET"]))
              $szTarget = $this->maParams["TARGET"];
              
            $szJS = "var wh = window.open( '$szHref', '$szTarget' );\n";
            $szJS .= "wh.focus();\n";

            $szJSName = 'linkWidget'.$this->mnId;
            $this->maszJSFunctions[$szJSName] = <<<EOT

function {$szJSName}()
{
    {$szJS};
}
EOT;
            $this->moButton->SetOnClick( 'linkWidget'.$this->mnId );
        }
        elseif ($this->mszLinkType == "JAVASCRIPT")
        {
            if (isset($this->maParams['JSFUNCTION']))
            {
                $szJS = "void";
                $szJSParams = "0";
                if ($this->maParams["JSFUNCTION"] != "")
                {
                    $szJS = $this->maParams["JSFUNCTION"];
                    $szJSParams = "";
                }
                if (isset($this->maParams["JSPARAMS"]))
                {
                    $szJSParams = $this->maParams["JSPARAMS"];
                }
                $this->moButton->SetOnClick( $szJS, $szJSParams );
            }
        }
    }
    
    function ParseURL()
    {
        $this->moButton->ParseURL();
    }
    
    /**
     * return javascript functions
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array_merge($this->moButton->GetJavascriptFunctions(), $this->maszJSFunctions);
        return $aReturn;
    }

    /**
     * return javascript functions
     */
    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    /**
     * return javascript variables
     */
    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    /**
     * return javascript onload functions
     */
    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }
    
    /**
     * return javascript initialization funcitons
     */
    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        return $aReturn;
    }

    /**
     * draw the link widget
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- LinkWidget is hidden -->";

        
        $szReturn = $this->moButton->DrawPublish();
        
        return $szReturn;
    }
}
?>
