<?php
/**
* LayerManager2 Widget class
*
* @project     CWC2
* @revision    $Id: LayerManager2.widget.php,v 1.3 2004/07/08 17:49:07 pspencer Exp $
* @purpose     LayerManager2 Popup Widget class
* @author      DM Solutions Group (sfournier@dmsolutions.ca)
* @copyright
* <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*/
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");


/**
* a simple widget to link to another page
*/
class LayerManager2 extends CWCWidget
{
    var $moButton;
    var $moPopup;
    
    /**
    * construct a new LayerManager2 widget
    */
    function LayerManager2()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        $this->moButton = new CWCButton( $this );
        $this->moPopup = new CWCPopup( $this );

        $this->mnPriority = PRIORITY_SUPER;
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The LayerManager2 widget allows .....
EOT;
    }
    
    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick( 'clickLayerManager2' );
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."widgets/LayerManager2/LayerManager2.php?";

    }
    
    /**
     * ParseURL
     *
     * Take layers from the tmpLayerManager map in session.
     */
    function  ParseURL()
    {
        $this->moButton->ParseURL();
        if ($this->isVarSet("LAYERMANAGER2_APPLY") &&
        $this->getVar("LAYERMANAGER2_APPLY") != "")
        {
            //echo "***";
            $this->moMapObject =& $_SESSION['LAYERMANAGER2_MAP'];
        }
        
        return true;
    }
    
    function GetJavascriptFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptFunctions();
        
        $szJsFunctionName = "LayerManager2CallBack";
        $szFunction = <<<EOT
function {$szJsFunctionName}( actionId, wh )
{
    if ( actionId == 0) //Clicked OK
    {
    {$this->mszHTMLForm}.submit();

    wh.close();
    }
    else
    if ( actionId == 1) // cancel
    {
    if (!wh.closed)
        wh.close();
    }
    return;
}
EOT;
        
        $aReturn[$szJsFunctionName] = $szFunction;
        
        $szPopup = $this->moPopup->DrawPublish();
        $szJsFunctionName = "clickLayerManager2";
        $szFunction = <<<EOT
function {$szJsFunctionName}()
{
    {$szPopup}
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;
        return $aReturn;
    }
    
    /**
    * GetHTMLHiddenVariables
    *
    * Return HTML hidden variables.
    */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szVariable = "LAYERMANAGER2_APPLY";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "LAYERMANAGER2_CURRENT_STATE";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;
        
        return $aReturn;
    }
    
    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }
    
    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- LayerManager2 popup widget hidden -->";
        
        $szResult = $this->moButton->DrawPublish();

        return $szResult;
    }
}
?>
