<?php
/**
* This is a sample (framework) class definition that can
* help you to make your own chameleon application. For more
* information on building an Chameleon application, go to
* http://www.maptools.org/chameleon/index.phtml?page=docs.html
*
*/

// Include base class definition
include_once '../../chameleon.php';

/**
* This is our main chameleon class definition.
*/
class LayerManager2App extends Chameleon
{
    /**
    * Constructor
    *
    * In our example, we need a Writable mapsession object.
    * chameleon, by default, create a ReadOnly mapsession
    * object. So we will create it for the parent.
    */
    function LayerManager2App()
    {
        parent::Chameleon();
        $this->moMapSession = new MapSession_RW();
        $this->moMapSession->setTempDir(getSessionSavePath());
    }
}

$oApp = new LayerManager2App();

$oApp->CWCAddRegionalTemplate( "en-CA", $_SESSION['gszCorePath']."/widgets/LayerManager2/layermanager_template_en.html");
$oApp->CWCAddRegionalTemplate( "fr-CA", $_SESSION['gszCorePath']."/widgets/LayerManager2/layermanager_template_fr.html");

$szMapName = $_SESSION['gszMapName'];

$oApp->CWCInitialize("", $szMapName);
$oApp->setVar( "gszCoreWebPath", $_SESSION['gszCoreWebPath'] );
$oApp->CWCExecute();
?>