<?php
/**
 * LayerMetadata Widget class
 *
 * @project     EC-CISE
 * @revision    $Id: LayerMetadata.widget.php,v 1.2 2004/04/24 21:58:41 pspencer Exp $
 * @purpose     provide javascript access to metadata about a layer
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");

/**
 * LayerMetadata
 *
 * @desc LayerMetadata widget.
 */
class LayerMetadata extends CWCWidget
{
    /**
     * LayerMetadata
     *
     * Constructor. Set the default values.
     */
    function LayerMetadata()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The purpose of this widget is to provide access to metadata
coming from a layer.  This only works for WMS layers and will
return only certain key values.  Known keys are metadata_url
, data_url, abstract ...
EOT;

     }

    /**
     * GetJavascriptFunctions
     *
     * Return the Javacriptfunctions needed by the widget.
     *
     * @return Javacriptfunctions needed by the widget.
     */
    function GetJavascriptFunctions()
    {
        $oMap =& $this->moMapObject->oMap;
        $szJs = "    var szResult = '';\n";
        
        for ($i=0; $i<$oMap->numlayers; $i++)
        {
            $oLayer = $oMap->getLayer( $i );
            if ($oLayer->connectiontype == MS_WMS)
            {
                
                $szJs .= "    if (szLayerName == ";
                
                if ($oLayer->name != "")
                {
                    $szJs .= "\"".$oLayer->name;
                }
                if ($oLayer->getMetadata( "WMS_NAME" ))
                {
                    $szJs .= "\" || szLayerName == \"".$oLayer->getMetaData("WMS_NAME");
                }
                
                if ($oLayer->getMetadata( "WMS_TITLE" ))
                {
                    $szJs .= "\" || szLayerName == \"".$oLayer->getMetaData("WMS_TITLE");
                }
                
                $szJs .= "\")\n";
                
                $szJs .= "    {\n";
                $szJs .= "        if (szMetadataKey == \"metadata_url\")\n";
                $szJs .= "            szResult = \"".$oLayer->getMetadata( "wms_metadataurl_href") ."\";\n";
                $szJs .= "        if (szMetadataKey == \"data_url\")\n";
                $szJs .= "            szResult = \"".$oLayer->getMetadata( "wms_dataurl_href") ."\";\n";
                $szJs .= "        if (szMetadataKey == \"name\")\n";
                $szJs .= "            szResult = \"".$oLayer->getMetadata( "wms_name") ."\";\n";
                $szJs .= "        if (szMetadataKey == \"title\")\n";
                $szJs .= "            szResult = \"".$oLayer->getMetadata( "wms_title") ."\";\n";
                $szJs .= "        if (szMetadataKey == \"abstract\")\n";
                $szJs .= "            szResult = \"".$oLayer->getMetadata( "wms_abstract") ."\";\n";
                $szJs .= "        if (szMetadataKey == \"style\")\n";
                $szJs .= "            szResult = \"".$oLayer->getMetadata( "wms_style") ."\";\n";
                $szJs .= "        if (szMetadataKey == \"legendurl\")\n";
                $szJs .= "        szResult = \"".$oLayer->getMetadata( "wms_".$oLayer->getMetadata( "wms_style" )."_legendurl_href" )."\";\n";
                $szJs .= "    }\n";
            }
        }
        $szJs .= "    return szResult;\n";
        $szJsFunctionName = "CWCGetLayerMetadata";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to return metadata from a given layer
 * szLayerName - the wms name or title of a layer
 * szMetadataKey - the metadata to return
 * szStyle - optional, if legendurl is requested, this is the style to return for
 *           if not specified then the current style is returned.
 */
function {$szJsFunctionName}( szLayerName, szMetadataKey )
{
{$szJs}    
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }
}
?>
